/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.util.threedata;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.JSONUtils;
import net.minecraftforge.common.util.INBTSerializable;
import net.threetag.threecore.util.threedata.ThreeData;

public class ExperienceThreeData
extends ThreeData<Experience> {
    public ExperienceThreeData(String key) {
        super(key);
    }

    @Override
    public Experience parseValue(JsonObject jsonObject, Experience defaultValue) {
        if (!JSONUtils.func_151204_g((JsonObject)jsonObject, (String)this.jsonKey)) {
            return defaultValue;
        }
        JsonPrimitive primitive = jsonObject.get(this.key).getAsJsonPrimitive();
        return new Experience(primitive);
    }

    @Override
    public void writeToNBT(CompoundNBT nbt, Experience value) {
        nbt.func_218657_a(this.key, (INBT)value.serializeNBT());
    }

    @Override
    public Experience readFromNBT(CompoundNBT nbt, Experience defaultValue) {
        if (!nbt.func_74764_b(this.key)) {
            return defaultValue;
        }
        CompoundNBT tag = nbt.func_74775_l(this.key);
        return new Experience(tag.func_74767_n("Levels"), tag.func_74762_e("Value"));
    }

    @Override
    public JsonElement serializeJson(Experience value) {
        if (value.isLevels()) {
            return new JsonPrimitive(value.getValue() + "L");
        }
        return new JsonPrimitive((Number)value.getValue());
    }

    public static class Experience
    implements INBTSerializable<CompoundNBT> {
        protected boolean levels;
        protected int value;

        public Experience(boolean levels, int value) {
            this.levels = levels;
            this.value = value;
        }

        public Experience(CompoundNBT nbt) {
            this.deserializeNBT(nbt);
        }

        public Experience(JsonPrimitive primitive) {
            this.parseFromJson(primitive);
        }

        public int getValue() {
            return this.value;
        }

        public boolean isLevels() {
            return this.levels;
        }

        public boolean has(PlayerEntity entity) {
            if (this.isLevels()) {
                return entity.field_71068_ca >= this.value;
            }
            return entity.field_71067_cb >= this.value;
        }

        public void take(PlayerEntity entity) {
            if (this.isLevels()) {
                entity.func_82242_a(-this.value);
            } else {
                entity.func_195068_e(-this.value);
            }
        }

        public void parseFromJson(JsonPrimitive primitive) {
            if (primitive.isString()) {
                String s = primitive.getAsString();
                this.levels = s.endsWith("L");
                this.value = Integer.parseInt(s.replaceAll("L", ""));
            } else {
                this.levels = false;
                this.value = primitive.getAsInt();
            }
        }

        public JsonObject writeToJson() {
            JsonObject jsonObject = new JsonObject();
            if (this.levels) {
                jsonObject.addProperty("experience", this.value + "L");
            } else {
                jsonObject.addProperty("experience", (Number)this.value);
            }
            return jsonObject;
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74757_a("Levels", this.levels);
            nbt.func_74768_a("Value", this.value);
            return nbt;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.levels = nbt.func_74767_n("Levels");
            this.value = nbt.func_74762_e("Value");
        }
    }
}

