/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.pymtech.client.renderer.entity.modellayer;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.threetag.pymtech.client.renderer.entity.model.BrainHeadModel;
import net.threetag.pymtech.client.renderer.entity.model.OpenSkullModel;
import net.threetag.threecore.client.renderer.entity.modellayer.IModelLayer;
import net.threetag.threecore.client.renderer.entity.modellayer.IModelLayerContext;
import net.threetag.threecore.client.renderer.entity.modellayer.ModelLayerManager;
import net.threetag.threecore.client.renderer.entity.modellayer.predicates.IModelLayerPredicate;
import net.threetag.threecore.util.RenderUtil;

public class OpenSkullModelLayer
implements IModelLayer {
    public final List<IModelLayerPredicate> glowPredicates;
    public final List<IModelLayerPredicate> predicateList = Lists.newLinkedList();

    public OpenSkullModelLayer() {
        this.glowPredicates = Collections.emptyList();
    }

    public OpenSkullModelLayer(List<IModelLayerPredicate> glowPredicates) {
        this.glowPredicates = glowPredicates;
    }

    public void render(IModelLayerContext context, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int packedLight, @Nullable IEntityRenderer<? extends Entity, ? extends EntityModel<?>> entityRenderer, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entityRenderer != null && entityRenderer.func_217764_d() instanceof BipedModel && context.getAsEntity() instanceof AbstractClientPlayerEntity) {
            matrixStack.func_227860_a_();
            ((BipedModel)entityRenderer.func_217764_d()).field_78116_c.func_228307_a_(matrixStack);
            ResourceLocation texture = ((AbstractClientPlayerEntity)context.getAsEntity()).func_110306_p();
            OpenSkullModel.INSTANCE.func_225598_a_(matrixStack, renderTypeBuffer.getBuffer(ModelLayerManager.arePredicatesFulFilled(this.glowPredicates, (IModelLayerContext)context) ? RenderUtil.RenderTypes.getGlowing((ResourceLocation)texture) : RenderUtil.RenderTypes.func_228642_d_((ResourceLocation)texture)), packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            BrainHeadModel.INSTANCE.func_225598_a_(matrixStack, renderTypeBuffer.getBuffer(ModelLayerManager.arePredicatesFulFilled(this.glowPredicates, (IModelLayerContext)context) ? RenderUtil.RenderTypes.getGlowing((ResourceLocation)BrainHeadModel.TEXTURE) : RenderUtil.RenderTypes.func_228642_d_((ResourceLocation)BrainHeadModel.TEXTURE)), packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.func_227865_b_();
        }
    }

    public boolean isActive(IModelLayerContext context) {
        return ModelLayerManager.arePredicatesFulFilled(this.predicateList, (IModelLayerContext)context);
    }

    public OpenSkullModelLayer addPredicate(IModelLayerPredicate predicate) {
        this.predicateList.add(predicate);
        return this;
    }

    public void postRotationAnglesCallback(LivingRenderer<? extends LivingEntity, ? extends EntityModel> renderer, LivingEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        if (entityIn instanceof AbstractClientPlayerEntity) {
            ((BipedModel)renderer.func_217764_d()).field_78116_c.field_78806_j = false;
            ((BipedModel)renderer.func_217764_d()).field_178720_f.field_78806_j = false;
        }
    }

    public static OpenSkullModelLayer parse(JsonObject json) {
        LinkedList glowPredicates = Lists.newLinkedList();
        if (JSONUtils.func_151204_g((JsonObject)json, (String)"glow")) {
            JsonElement glowJson = json.get("glow");
            if (glowJson.isJsonPrimitive() && glowJson.getAsBoolean()) {
                glowPredicates.add(c -> true);
            } else {
                JsonArray predicateArray = JSONUtils.func_151214_t((JsonObject)json, (String)"glow");
                for (int i = 0; i < predicateArray.size(); ++i) {
                    IModelLayerPredicate predicate = ModelLayerManager.parsePredicate((JsonObject)predicateArray.get(i).getAsJsonObject());
                    if (predicate == null) continue;
                    glowPredicates.add(predicate);
                }
            }
        } else {
            glowPredicates.add(c -> false);
        }
        return new OpenSkullModelLayer(glowPredicates);
    }
}

