/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.pymtech.client.renderer.item;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.threetag.pymtech.PymTech;
import net.threetag.pymtech.item.ShrunkenStructureItem;
import net.threetag.pymtech.network.RequestShrunkenStructureMessage;
import net.threetag.pymtech.storage.ShrunkenStructureData;

public class ShrunkenStructureItemRenderer
extends ItemStackTileEntityRenderer {
    public static List<Integer> requested = Lists.newLinkedList();

    public void func_239207_a_(ItemStack stack, ItemCameraTransforms.TransformType transformType, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        ShrunkenStructureData shrunkenStructure = ShrunkenStructureItem.get((World)Minecraft.func_71410_x().field_71441_e, stack);
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.5, 0.0, 0.5);
        float scale = 1.0f;
        if (shrunkenStructure != null) {
            scale = 1.0f / (float)Math.max(shrunkenStructure.getSize().func_177958_n(), Math.max(shrunkenStructure.getSize().func_177956_o(), shrunkenStructure.getSize().func_177952_p()));
        }
        ShrunkenStructureItemRenderer.render(shrunkenStructure, matrixStackIn, stack.func_196082_o().func_74762_e("ShrunkenStructure"), scale);
        matrixStackIn.func_227865_b_();
    }

    public static void render(ShrunkenStructureData shrunkenStructure, MatrixStack matrixStack, int id, float scale) {
        if (shrunkenStructure != null) {
            if (!ShrunkenStructureItemRenderer.renderStructure(shrunkenStructure, matrixStack, shrunkenStructure.getSize(), scale, (World)Minecraft.func_71410_x().field_71441_e)) {
                ShrunkenStructureItemRenderer.storeAndRender(matrixStack, (World)Minecraft.func_71410_x().field_71441_e, Minecraft.func_71410_x().field_71439_g.func_233580_cy_(), shrunkenStructure, scale);
            }
        } else if (!requested.contains(id)) {
            PymTech.NETWORK_CHANNEL.sendToServer((Object)new RequestShrunkenStructureMessage(id));
            requested.add(id);
        }
    }

    public static boolean renderStructure(ShrunkenStructureData shrunkenStructureData, MatrixStack matrixStack, BlockPos size, float scale, World world) {
        if (shrunkenStructureData.renderer == null) {
            return false;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(scale, scale, scale);
        matrixStack.func_227861_a_((double)(-size.func_177958_n()) / 2.0, 0.0, (double)(-size.func_177952_p()) / 2.0);
        shrunkenStructureData.renderer.render(matrixStack, world);
        matrixStack.func_227865_b_();
        return true;
    }

    public static void storeAndRender(MatrixStack matrixStack, World world, BlockPos pos, ShrunkenStructureData shrunkenStructure, float scale) {
        if (shrunkenStructure.renderer == null) {
            shrunkenStructure.renderer = new CachedRender((ms, buffer, w, type) -> {
                BlockPos size = shrunkenStructure.getSize();
                for (int x = 0; x < size.func_177958_n(); ++x) {
                    for (int y = 0; y < size.func_177956_o(); ++y) {
                        for (int z = 0; z < size.func_177952_p(); ++z) {
                            BlockState state;
                            ShrunkenStructureData.BlockData data = shrunkenStructure.getBlockData()[x][y][z];
                            if (data == null || data.getBlockState() == null || data.getBlockState().func_185901_i() == BlockRenderType.INVISIBLE || (state = data.getBlockState()).func_185901_i() != BlockRenderType.MODEL || !RenderTypeLookup.canRenderInLayer((BlockState)state, (RenderType)type)) continue;
                            BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
                            ms.func_227860_a_();
                            ms.func_227861_a_((double)x, (double)y, (double)z);
                            BlockPos p = new BlockPos(x, y, z);
                            blockrendererdispatcher.func_175019_b().renderModel((IBlockDisplayReader)new ShrunkenStructureAccess(w, pos, shrunkenStructure), blockrendererdispatcher.func_184389_a(state), state, p, ms, (IVertexBuilder)buffer, true, new Random(), 0L, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
                            ms.func_227865_b_();
                        }
                    }
                }
            });
        } else {
            ShrunkenStructureItemRenderer.renderStructure(shrunkenStructure, matrixStack, shrunkenStructure.getSize(), scale, world);
        }
    }

    public static interface RenderInner {
        public void render(MatrixStack var1, BufferBuilder var2, World var3, RenderType var4);
    }

    public static class CachedRender {
        private final RenderInner render;
        private Map<RenderType, VertexBuffer> buffers = Maps.newHashMap();

        public CachedRender(RenderInner render) {
            this.render = render;
            this.buffers = Maps.newHashMap();
        }

        private void cache(MatrixStack matrixStack, World world) {
            this.reset();
            for (RenderType type : this.buffers.keySet()) {
                BufferBuilder builder = Tessellator.func_178181_a().func_178180_c();
                builder.func_181668_a(type.func_228664_q_(), type.func_228663_p_());
                this.render.render(new MatrixStack(), builder, world, type);
                builder.func_178977_d();
                this.buffers.get(type).func_227875_a_(builder);
            }
        }

        public void render(MatrixStack matrixStack, World world) {
            if (this.buffers.isEmpty()) {
                this.cache(matrixStack, world);
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
            for (RenderType type : this.buffers.keySet()) {
                type.func_228547_a_();
                VertexBuffer buffer = this.buffers.get(type);
                buffer.func_177359_a();
                type.func_228663_p_().func_227892_a_(0L);
                buffer.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), type.func_228664_q_());
                VertexBuffer.func_177361_b();
                type.func_228663_p_().func_227895_d_();
                type.func_228549_b_();
            }
        }

        public void reset() {
            this.buffers.forEach((renderType, vertexBuffer) -> vertexBuffer.close());
            this.buffers.clear();
            RenderType.func_228661_n_().forEach(type -> this.buffers.put((RenderType)type, new VertexBuffer(type.func_228663_p_())));
        }
    }

    public static class ShrunkenStructureAccess
    implements IBlockDisplayReader {
        protected World world;
        protected BlockPos pos;
        protected ShrunkenStructureData shrunkenStructure;
        protected int volume;

        public ShrunkenStructureAccess(World world, BlockPos pos, ShrunkenStructureData shrunkenStructure) {
            this.world = world;
            this.pos = pos;
            this.shrunkenStructure = shrunkenStructure;
            this.volume = shrunkenStructure.getSize().func_177958_n() * shrunkenStructure.getSize().func_177956_o() * shrunkenStructure.getSize().func_177952_p();
        }

        public float func_230487_a_(Direction p_230487_1_, boolean p_230487_2_) {
            return 1.0f;
        }

        public WorldLightManager func_225524_e_() {
            return this.world.func_225524_e_();
        }

        public int func_225525_a_(BlockPos blockPosIn, ColorResolver colorResolverIn) {
            return Minecraft.func_71410_x().field_71441_e.func_225525_a_(Minecraft.func_71410_x().field_71439_g.func_233580_cy_(), colorResolverIn);
        }

        public int func_226658_a_(LightType lightType, BlockPos blockPos) {
            return this.world.func_226658_a_(lightType, this.pos);
        }

        @Nullable
        public TileEntity func_175625_s(BlockPos blockPos) {
            return null;
        }

        public BlockState func_180495_p(BlockPos blockPos) {
            if (this.pos.func_177958_n() < 0 || this.pos.func_177956_o() < 0 || this.pos.func_177952_p() < 0 || this.pos.func_177958_n() > this.shrunkenStructure.getSize().func_177958_n() - 1 || this.pos.func_177956_o() > this.shrunkenStructure.getSize().func_177956_o() - 1 || this.pos.func_177952_p() > this.shrunkenStructure.getSize().func_177952_p() - 1) {
                return Blocks.field_150350_a.func_176223_P();
            }
            ShrunkenStructureData.BlockData data = this.shrunkenStructure.getBlockData()[this.pos.func_177958_n()][this.pos.func_177956_o()][this.pos.func_177952_p()];
            return data == null ? Blocks.field_150350_a.func_176223_P() : data.getBlockState();
        }

        public FluidState func_204610_c(BlockPos pos) {
            return Fluids.field_204541_a.func_207188_f();
        }
    }
}

