/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.pymtech.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Hand;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import net.threetag.pymtech.entity.PTEntityTypes;
import net.threetag.pymtech.item.PymParticleDiskItem;
import net.threetag.pymtech.sizechangetype.PTSizeChangeTypes;
import net.threetag.threecore.capability.CapabilitySizeChanging;

public class PymParticleDiskEntity
extends ProjectileItemEntity
implements IEntityAdditionalSpawnData {
    public ItemStack stack;

    public PymParticleDiskEntity(EntityType<? extends PymParticleDiskEntity> entityType, World world) {
        super(entityType, world);
        this.stack = ItemStack.field_190927_a;
    }

    public PymParticleDiskEntity(World world, LivingEntity thrower, ItemStack stack) {
        super(PTEntityTypes.PYM_PARTICLE_DISK, thrower, world);
        this.stack = stack;
    }

    public PymParticleDiskEntity(World world, ItemStack stack, double posX, double posY, double posZ) {
        super(PTEntityTypes.PYM_PARTICLE_DISK, posX, posY, posZ, world);
        this.stack = stack;
    }

    protected Item func_213885_i() {
        return this.stack.func_77973_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack func_184543_l() {
        return this.stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte type) {
        if (type == 3) {
            ItemParticleData particleData = new ItemParticleData(ParticleTypes.field_197591_B, this.stack);
            for (int i = 0; i < 8; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)particleData, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void func_70227_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            if (result.func_216346_c() == RayTraceResult.Type.ENTITY && this.stack.func_77973_b() instanceof PymParticleDiskItem) {
                Entity entity = ((EntityRayTraceResult)result).func_216348_a();
                EquipmentSlotType slot = this.getRandomSlotWithItem(entity);
                if (slot != null) {
                    entity.func_199701_a_(((LivingEntity)entity).func_184582_a(slot));
                    entity.func_184201_a(slot, ItemStack.field_190927_a);
                } else {
                    float diskSize = ((PymParticleDiskItem)this.stack.func_77973_b()).size;
                    entity.getCapability(CapabilitySizeChanging.SIZE_CHANGING).ifPresent(sizeChanging -> {
                        float newSize = sizeChanging.getScale() < 1.0f && diskSize > 1.0f || sizeChanging.getScale() > 1.0f && diskSize < 1.0f ? 1.0f : diskSize;
                        sizeChanging.startSizeChange(PTSizeChangeTypes.PYM_PARTICLES, newSize);
                    });
                }
            }
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_70106_y();
        }
    }

    public EquipmentSlotType getRandomSlotWithItem(Entity entity) {
        if (entity instanceof ArmorStandEntity) {
            return null;
        }
        if (entity instanceof LivingEntity) {
            if (((LivingEntity)entity).func_184585_cz()) {
                return ((LivingEntity)entity).func_184600_cs() == Hand.MAIN_HAND ? EquipmentSlotType.MAINHAND : EquipmentSlotType.OFFHAND;
            }
            ArrayList list = Lists.newArrayList();
            for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                if (slot.func_188453_a() != EquipmentSlotType.Group.ARMOR || ((LivingEntity)entity).func_184582_a(slot).func_190926_b()) continue;
                list.add(slot);
            }
            return list.size() <= 0 ? null : (EquipmentSlotType)list.get(new Random().nextInt(list.size()));
        }
        return null;
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_150788_a(this.stack);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.stack = additionalData.func_150791_c();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

