/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.pymtech.storage;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import net.threetag.pymtech.PymTech;
import net.threetag.pymtech.client.renderer.item.ShrunkenStructureItemRenderer;
import net.threetag.pymtech.network.NotifyShrunkenStructureUpdate;
import net.threetag.pymtech.util.BlockUtil;

public class ShrunkenStructureData
extends WorldSavedData {
    @OnlyIn(value=Dist.CLIENT)
    public static final Map<Integer, ShrunkenStructureData> shrunkenStructures = Maps.newHashMap();
    protected BlockData[][][] blockData;
    protected BlockPos size;
    protected int count;
    protected int id;
    @OnlyIn(value=Dist.CLIENT)
    public ShrunkenStructureItemRenderer.CachedRender renderer;

    public ShrunkenStructureData(String name) {
        super(name);
    }

    public ShrunkenStructureData(int id, BlockData[][][] blockData, BlockPos size) {
        super("shrunkenstructure_" + id);
        this.blockData = blockData;
        this.size = size;
        this.count = ShrunkenStructureData.countEntries(blockData, size);
        this.id = id;
    }

    public boolean isEmpty() {
        return this.blockData == null || this.size == null || this.size.func_177958_n() <= 0 || this.size.func_177956_o() <= 0 || this.size.func_177952_p() <= 0;
    }

    public BlockData[][][] getBlockData() {
        return this.blockData;
    }

    public BlockPos getSize() {
        return this.size;
    }

    public int getId() {
        return this.id;
    }

    public void placeInWorld(World world, BlockPos center, @Nullable PlayerEntity player) {
        if (world.field_72995_K || !(world instanceof ServerWorld)) {
            return;
        }
        Vector3d origin = Vector3d.func_237491_b_((Vector3i)center);
        for (int x = 0; x < this.size.func_177958_n(); ++x) {
            for (int y = 0; y < this.size.func_177956_o(); ++y) {
                for (int z = 0; z < this.size.func_177952_p(); ++z) {
                    PlayerEntity p;
                    BlockData data = this.blockData[x][y][z];
                    if (data == null || data.getBlockState().func_196958_f()) continue;
                    BlockState state = data.getBlockState();
                    CompoundNBT tileEntity = data.getTileEntityData();
                    Vector3d v = new Vector3d((double)((float)x - (float)this.size.func_177958_n() / 2.0f), (double)y, (double)((float)z - (float)this.size.func_177952_p() / 2.0f));
                    BlockPos pos = new BlockPos(origin.field_72450_a + v.field_72450_a, origin.field_72448_b + v.field_72448_b, origin.field_72449_c + v.field_72449_c);
                    BlockState current = world.func_180495_p(pos);
                    Object object = p = player == null ? new FakePlayer((ServerWorld)world, new GameProfile(null, "pymtech")) : player;
                    if (current.func_185887_b((IBlockReader)world, pos) == -1.0f || MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, pos, current, p))) {
                        Block.func_220075_c((BlockState)state, (World)world, (BlockPos)pos);
                        continue;
                    }
                    if (current.func_185887_b((IBlockReader)world, pos) > state.func_185887_b((IBlockReader)world, pos)) {
                        Block.func_220075_c((BlockState)state, (World)world, (BlockPos)pos);
                        continue;
                    }
                    world.func_175655_b(pos, true);
                    world.func_180501_a(pos, state, 2);
                    if (tileEntity == null || world.func_175625_s(pos) == null) continue;
                    tileEntity.func_74768_a("x", pos.func_177958_n());
                    tileEntity.func_74768_a("y", pos.func_177956_o());
                    tileEntity.func_74768_a("z", pos.func_177952_p());
                    world.func_175625_s(pos).func_230337_a_(state, tileEntity);
                }
            }
        }
    }

    public ShrunkenStructureData rotateCounterclockwise() {
        BlockPos newSize = new BlockPos(this.size.func_177952_p(), this.size.func_177956_o(), this.size.func_177958_n());
        BlockData[][][] newData = new BlockData[newSize.func_177958_n()][newSize.func_177956_o()][newSize.func_177952_p()];
        for (int x = 0; x < this.size.func_177958_n(); ++x) {
            for (int y = 0; y < this.size.func_177956_o(); ++y) {
                for (int z = 0; z < this.size.func_177952_p(); ++z) {
                    BlockData data = this.blockData[x][y][z];
                    if (data == null) continue;
                    newData[z][y][newSize.func_177952_p() - 1 - x] = new BlockData(data.getBlockState().func_185907_a(Rotation.COUNTERCLOCKWISE_90), new BlockPos(z, y, newSize.func_177952_p() - 1 - x), data.getTileEntityData());
                }
            }
        }
        this.size = newSize;
        this.blockData = newData;
        this.func_76185_a();
        PymTech.NETWORK_CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new NotifyShrunkenStructureUpdate(this.id));
        return this;
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.size = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("Size"));
        this.count = nbt.func_74762_e("Count");
        this.id = nbt.func_74762_e("Id");
        this.blockData = new BlockData[this.size.func_177958_n()][this.size.func_177956_o()][this.size.func_177952_p()];
        ListNBT list = nbt.func_150295_c("Blocks", 10);
        for (int i = 0; i < list.size(); ++i) {
            BlockData data;
            this.blockData[data.getPosition().func_177958_n()][data.getPosition().func_177956_o()][data.getPosition().func_177952_p()] = data = new BlockData(list.func_150305_b(i));
        }
        if (this.count <= 0) {
            ShrunkenStructureData.countEntries(this.blockData, this.size);
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        compound.func_218657_a("Size", (INBT)NBTUtil.func_186859_a((BlockPos)this.size));
        compound.func_74768_a("Count", this.count);
        compound.func_74768_a("Id", this.id);
        ListNBT list = new ListNBT();
        for (int x = 0; x < this.size.func_177958_n(); ++x) {
            for (int y = 0; y < this.size.func_177956_o(); ++y) {
                for (int z = 0; z < this.size.func_177952_p(); ++z) {
                    BlockData data = this.blockData[x][y][z];
                    if (data == null || data.getBlockState().func_196958_f()) continue;
                    list.add((Object)data.serializeNBT());
                }
            }
        }
        compound.func_218657_a("Blocks", (INBT)list);
        return compound;
    }

    public void writeToBuffer(PacketBuffer buffer) {
        buffer.func_179255_a(this.size);
        buffer.writeInt(this.count);
        buffer.writeInt(this.id);
        for (int x = 0; x < this.size.func_177958_n(); ++x) {
            for (int y = 0; y < this.size.func_177956_o(); ++y) {
                for (int z = 0; z < this.size.func_177952_p(); ++z) {
                    BlockData data = this.blockData[x][y][z];
                    if (data == null) continue;
                    buffer.func_150786_a(data.serializeNBT());
                }
            }
        }
    }

    public void readFromBuffer(PacketBuffer buffer) {
        this.size = buffer.func_179259_c();
        this.blockData = new BlockData[this.size.func_177958_n()][this.size.func_177956_o()][this.size.func_177952_p()];
        this.count = buffer.readInt();
        this.id = buffer.readInt();
        for (int i = 0; i < this.count; ++i) {
            CompoundNBT nbt = buffer.func_150793_b();
            BlockData blockData = new BlockData(null, null, null);
            blockData.deserializeNBT(nbt);
            this.blockData[blockData.getPosition().func_177958_n()][blockData.getPosition().func_177956_o()][blockData.getPosition().func_177952_p()] = blockData;
        }
    }

    public static ShrunkenStructureData get(World world, int id) {
        String name = "shrunkenstructure_" + id;
        if (world instanceof ServerWorld) {
            return (ShrunkenStructureData)world.func_73046_m().func_71218_a(World.field_234918_g_).func_217481_x().func_215753_b(() -> new ShrunkenStructureData(name), name);
        }
        ShrunkenStructureData[] data = new ShrunkenStructureData[]{null};
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            data[0] = shrunkenStructures.get(id);
        });
        return data[0];
    }

    public static boolean register(World world, ShrunkenStructureData data) {
        if (world instanceof ServerWorld) {
            world.func_73046_m().func_71218_a(World.field_234918_g_).func_217481_x().func_215757_a((WorldSavedData)data);
            data.func_76185_a();
            return true;
        }
        AtomicBoolean result = new AtomicBoolean(false);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> shrunkenStructures.put(data.getId(), data));
        return result.get();
    }

    public static int countEntries(BlockData[][][] blockData, BlockPos size) {
        int count = 0;
        for (int x = 0; x < size.func_177958_n(); ++x) {
            for (int y = 0; y < size.func_177956_o(); ++y) {
                for (int z = 0; z < size.func_177952_p(); ++z) {
                    BlockData data = blockData[x][y][z];
                    if (data == null) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    public static ShrunkenStructureData create(int id, World world, AxisAlignedBB axisAlignedBB, Predicate<BlockPos> predicate, boolean destroy) {
        axisAlignedBB = BlockUtil.eraseEmptyPlanes(world, axisAlignedBB);
        BlockPos size = new BlockPos((int)(axisAlignedBB.field_72336_d - axisAlignedBB.field_72340_a), (int)(axisAlignedBB.field_72337_e - axisAlignedBB.field_72338_b), (int)(axisAlignedBB.field_72334_f - axisAlignedBB.field_72339_c));
        BlockData[][][] blockData = new BlockData[size.func_177958_n()][size.func_177956_o()][size.func_177952_p()];
        for (int x = 0; x < size.func_177958_n(); ++x) {
            for (int y = 0; y < size.func_177956_o(); ++y) {
                for (int z = 0; z < size.func_177952_p(); ++z) {
                    BlockPos pos = new BlockPos(axisAlignedBB.field_72340_a + (double)x, axisAlignedBB.field_72338_b + (double)y, axisAlignedBB.field_72339_c + (double)z);
                    if (world.func_175623_d(pos) || !predicate.test(pos)) continue;
                    blockData[x][y][z] = world.func_175625_s(pos) != null ? new BlockData(world.func_180495_p(pos), new BlockPos(x, y, z), world.func_175625_s(pos).func_189515_b(new CompoundNBT())) : new BlockData(world.func_180495_p(pos), new BlockPos(x, y, z), null);
                    if (!destroy) continue;
                    if (world.func_175625_s(pos) != null) {
                        world.func_175713_t(pos);
                    }
                    world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                }
            }
        }
        return new ShrunkenStructureData(id, blockData, size);
    }

    public static class BlockData
    implements INBTSerializable<CompoundNBT> {
        BlockState blockState;
        BlockPos pos;
        CompoundNBT tileEntityData;

        public BlockData(BlockState blockState, BlockPos position, CompoundNBT tileEntityData) {
            this.blockState = blockState;
            this.pos = position;
            this.tileEntityData = tileEntityData;
        }

        public BlockData(CompoundNBT nbt) {
            this.deserializeNBT(nbt);
        }

        public BlockState getBlockState() {
            return this.blockState;
        }

        public BlockPos getPosition() {
            return this.pos;
        }

        public CompoundNBT getTileEntityData() {
            return this.tileEntityData;
        }

        public boolean hasTileEntity() {
            return this.tileEntityData != null;
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_218657_a("Block", (INBT)NBTUtil.func_190009_a((BlockState)this.blockState));
            nbt.func_218657_a("Position", (INBT)NBTUtil.func_186859_a((BlockPos)this.pos));
            if (this.hasTileEntity()) {
                nbt.func_218657_a("TileEntityData", (INBT)this.tileEntityData);
            }
            return nbt;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.blockState = NBTUtil.func_190008_d((CompoundNBT)nbt.func_74775_l("Block"));
            this.pos = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("Position"));
            if (nbt.func_74764_b("TileEntityData")) {
                this.tileEntityData = nbt.func_74775_l("TileEntityData");
            }
        }
    }

    @Mod.EventBusSubscriber(modid="pymtech", value={Dist.CLIENT})
    public static class ClientEventHandler {
        @SubscribeEvent
        public static void onLogin(ClientPlayerNetworkEvent.LoggedInEvent e) {
            shrunkenStructures.clear();
        }

        @SubscribeEvent
        public static void onLogout(ClientPlayerNetworkEvent.LoggedOutEvent e) {
            shrunkenStructures.clear();
        }
    }
}

