/*
 * Decompiled with CFR 0.152.
 */
package com.laton95.pyramidplunder;

import com.laton95.pyramidplunder.block.UrnBlock;
import com.laton95.pyramidplunder.client.gui.screen.inventory.UrnScreen;
import com.laton95.pyramidplunder.config.Config;
import com.laton95.pyramidplunder.inventory.container.UrnContainer;
import com.laton95.pyramidplunder.item.LootUrnItem;
import com.laton95.pyramidplunder.proxy.ClientProxy;
import com.laton95.pyramidplunder.proxy.ServerProxy;
import com.laton95.pyramidplunder.tileentity.UrnTileEntity;
import com.laton95.pyramidplunder.world.gen.feature.UrnFeature;
import com.laton95.pyramidplunder.world.gen.placement.InCaveWithChance;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="pyramidplunder")
@Mod.EventBusSubscriber(modid="pyramidplunder", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PyramidPlunder {
    public static final String MOD_ID = "pyramidplunder";
    public static ServerProxy proxy = (ServerProxy)DistExecutor.runForDist(() -> () -> new ClientProxy(), () -> ServerProxy::new);
    public static final Logger LOGGER = LogManager.getLogger((String)"pyramidplunder");
    @ObjectHolder(value="pyramidplunder:urn")
    public static final UrnBlock URN = null;
    @ObjectHolder(value="pyramidplunder:treasure_urn")
    public static final LootUrnItem TREASURE_URN = null;
    @ObjectHolder(value="pyramidplunder:snake_charm")
    public static final Item SNAKE_CHARM = null;
    @ObjectHolder(value="pyramidplunder:urn")
    public static final TileEntityType<UrnTileEntity> URN_TILE = null;
    @ObjectHolder(value="pyramidplunder:urn")
    public static final ContainerType<UrnContainer> URN_CONTAINER_TYPE = null;
    @ObjectHolder(value="pyramidplunder:urn")
    public static final Feature<NoFeatureConfig> URN_FEATURE = null;

    public PyramidPlunder() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonConfig);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.COMMON_SPEC);
    }

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a(URN_CONTAINER_TYPE, UrnScreen::new);
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().register(new UrnBlock().setRegistryName(MOD_ID, "urn"));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().register(new LootUrnItem().setRegistryName(MOD_ID, "treasure_urn"));
        event.getRegistry().register(new BlockItem((Block)URN, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName(URN.getRegistryName()));
        event.getRegistry().register(new Item(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78040_i)).setRegistryName(MOD_ID, "snake_charm"));
    }

    @SubscribeEvent
    public static void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        event.getRegistry().register(TileEntityType.Builder.func_223042_a(UrnTileEntity::new, (Block[])new Block[0]).func_206865_a(null).setRegistryName(MOD_ID, "urn"));
    }

    @SubscribeEvent
    public static void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        event.getRegistry().register(IForgeContainerType.create(UrnContainer::new).setRegistryName(MOD_ID, "urn"));
    }

    @SubscribeEvent
    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        event.getRegistry().register(new UrnFeature(NoFeatureConfig::func_214639_a).setRegistryName(MOD_ID, "urn"));
    }

    @SubscribeEvent
    public static void applyFeatures(FMLCommonSetupEvent event) {
        if (Config.generateUrns) {
            InCaveWithChance inCave = new InCaveWithChance(ChanceConfig::func_214722_a);
            for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
                if (Config.isBiomeBlacklisted(biome)) continue;
                biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, URN_FEATURE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(inCave.func_227446_a_((IPlacementConfig)new ChanceConfig((int)(1.0 / Config.urnChance)))));
            }
        }
    }

    public void commonConfig(ModConfig.ModConfigEvent event) {
        if (event.getConfig().getSpec() == Config.COMMON_SPEC) {
            Config.load();
        }
    }
}

