/*
 * Decompiled with CFR 0.152.
 */
package com.laton95.pyramidplunder.block;

import com.laton95.pyramidplunder.PyramidPlunder;
import com.laton95.pyramidplunder.advancements.ModCriteriaTriggers;
import com.laton95.pyramidplunder.tileentity.UrnTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class UrnBlock
extends ContainerBlock
implements IWaterLoggable {
    private static final VoxelShape LID = Block.func_208617_a((double)2.0, (double)15.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape TOP = Block.func_208617_a((double)1.0, (double)13.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    private static final VoxelShape NECK = Block.func_208617_a((double)3.0, (double)10.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);
    private static final VoxelShape BOTTOM = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0);
    private static final VoxelShape SHAPE = VoxelShapes.func_216384_a((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{NECK, BOTTOM});
    private static final VoxelShape SHAPE_WITH_LID = VoxelShapes.func_197872_a((VoxelShape)SHAPE, (VoxelShape)LID);
    public static final BooleanProperty OPEN = BooleanProperty.func_177716_a((String)"open");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public UrnBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(1.5f, 10.0f));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{OPEN, WATERLOGGED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return (Boolean)state.func_177229_b((IProperty)OPEN) != false ? SHAPE : SHAPE_WITH_LID;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a));
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader world) {
        return new UrnTileEntity();
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        return Container.func_178144_a((TileEntity)world.func_175625_s(pos));
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        UrnTileEntity urn = (UrnTileEntity)world.func_175625_s(pos);
        if (urn != null) {
            if (((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
                if (!player.func_213453_ef()) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)urn, buf -> buf.func_179255_a(pos));
                } else if (player.func_184586_b(hand).func_190926_b()) {
                    world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false)), 4);
                }
            } else {
                if (urn.hasSnake()) {
                    if (player.func_184586_b(hand).func_77973_b() == PyramidPlunder.SNAKE_CHARM) {
                        ModCriteriaTriggers.CHARM_SNAKE.trigger((ServerPlayerEntity)player);
                        player.func_145747_a((ITextComponent)new TranslationTextComponent(this.getCharmMessage(state), new Object[]{player.func_145748_c_()}));
                    } else {
                        ModCriteriaTriggers.SNAKE_BITE.trigger((ServerPlayerEntity)player);
                        int duration = 15;
                        player.func_195064_c(new EffectInstance(Effects.field_76436_u, duration * 20));
                        player.func_145747_a((ITextComponent)new TranslationTextComponent(this.getPoisonMessage(state), new Object[]{player.func_145748_c_()}));
                        player.func_70097_a(new DamageSource(this.getDamageType(state)), 3.0f);
                    }
                    urn.removeSnake();
                }
                if (urn.hasLoot()) {
                    ModCriteriaTriggers.LOOT_URN.trigger((ServerPlayerEntity)player);
                }
                world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(true)), 4);
            }
        } else {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 4);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_82837_s() && (tileentity = world.func_175625_s(pos)) instanceof UrnTileEntity) {
            ((UrnTileEntity)tileentity).func_213903_a(stack.func_200301_q());
        }
    }

    public void func_196243_a(BlockState oldState, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (oldState.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity instanceof UrnTileEntity) {
                PlayerEntity player;
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((UrnTileEntity)tileentity));
                world.func_175666_e(pos, (Block)this);
                if (((UrnTileEntity)tileentity).hasSnake() && (player = world.func_217365_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())) != null) {
                    ModCriteriaTriggers.SNAKE_BITE.trigger((ServerPlayerEntity)player);
                    int duration = 15;
                    player.func_195064_c(new EffectInstance(Effects.field_76436_u, duration * 20));
                    player.func_145747_a((ITextComponent)new TranslationTextComponent(this.getBrokenPoisonMessage(oldState), new Object[]{player.func_145748_c_()}));
                    player.func_70097_a(new DamageSource(this.getDamageType(oldState)), 3.0f);
                }
            }
            super.func_196243_a(oldState, world, pos, newState, isMoving);
        }
    }

    private String getCharmMessage(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? "tile.pyramidplunder.urn.charm_underwater" : "tile.pyramidplunder.urn.charm";
    }

    private String getPoisonMessage(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? "tile.pyramidplunder.urn.poison_underwater" : "tile.pyramidplunder.urn.poison";
    }

    private String getBrokenPoisonMessage(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? "tile.pyramidplunder.urn.poison_broken_underwater" : "tile.pyramidplunder.urn.poison_broken";
    }

    private String getDamageType(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? "eelbite" : "snakebite";
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }
}

