/*
 * Decompiled with CFR 0.152.
 */
package com.laton95.pyramidplunder.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final CommonConfig COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static boolean generateUrns;
    public static double urnChance;
    public static int maxHeight;
    public static int minHeight;
    public static double snakeChance;
    public static List<? extends String> dimensionBlacklist;
    public static List<? extends String> biomeBlacklist;

    public static void load() {
        generateUrns = (Boolean)Config.COMMON.generateUrns.get();
        urnChance = (Double)Config.COMMON.urnChance.get();
        maxHeight = (Integer)Config.COMMON.maxHeight.get();
        minHeight = (Integer)Config.COMMON.minHeight.get();
        snakeChance = (Double)Config.COMMON.snakeChance.get();
        dimensionBlacklist = (List)Config.COMMON.dimensionBlacklist.get();
        biomeBlacklist = (List)Config.COMMON.biomeBlacklist.get();
        if (maxHeight < minHeight) {
            throw new IllegalArgumentException(String.format("Max height cannot be larger than min height: %d > %d", minHeight, maxHeight));
        }
    }

    private static List<String> getDimensionBlacklistDefault() {
        ArrayList<String> output = new ArrayList<String>();
        output.add("minecraft:the_nether");
        output.add("minecraft:the_end");
        return output;
    }

    public static boolean isDimensionBlacklisted(IWorld world) {
        return dimensionBlacklist.contains(world.func_201675_m().func_186058_p().getRegistryName().toString());
    }

    public static boolean isBiomeBlacklisted(Biome biome) {
        return biomeBlacklist.contains(biome.getRegistryName().toString());
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (CommonConfig)specPair.getLeft();
        generateUrns = true;
        urnChance = 0.15;
        maxHeight = 40;
        minHeight = 1;
        snakeChance = 0.3;
        dimensionBlacklist = Config.getDimensionBlacklistDefault();
        biomeBlacklist = new ArrayList<String>();
    }

    public static class CommonConfig {
        public ForgeConfigSpec.BooleanValue generateUrns;
        public ForgeConfigSpec.DoubleValue urnChance;
        public ForgeConfigSpec.IntValue maxHeight;
        public ForgeConfigSpec.IntValue minHeight;
        public ForgeConfigSpec.DoubleValue snakeChance;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> dimensionBlacklist;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> biomeBlacklist;

        CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            this.generateUrns = builder.comment("Generate urns in world").translation("text.pyramidplunder.config.generate_urns").define("generate_urns", true);
            this.urnChance = builder.comment("Percentage chance to attempt to place an urn in a chunk. Actual frequency of urns will be lower as attempts are not always successful").translation("text.pyramidplunder.config.urn_chance").defineInRange("urn_chance", 0.15, 0.0, 1.0);
            this.maxHeight = builder.comment("Maximum height urns will generate").translation("text.pyramidplunder.config.max_height").defineInRange("max_height", 40, 0, 255);
            this.minHeight = builder.comment("Minimum height urns will generate").translation("text.pyramidplunder.config.min_height").defineInRange("min_height", 1, 0, 255);
            this.snakeChance = builder.comment("Chance an urn will contain a snake").translation("text.pyramidplunder.config.snake_chance").defineInRange("snake_chance", 0.3, 0.0, 1.0);
            this.dimensionBlacklist = builder.comment("Dimension ids of dimensions that urns will not generate in").translation("text.pyramidplunder.config.dimension_blacklist").defineList("dimension_blacklist", Config.getDimensionBlacklistDefault(), i -> i instanceof String);
            this.biomeBlacklist = builder.comment("Biomes to not generate urns in, in format \"mod_id:biome_id\". E.g. \"minecraft:desert\"").translation("text.pyramidplunder.config.biome_blacklist").defineList("biome_blacklist", new ArrayList(), s -> s instanceof String);
            builder.pop();
        }
    }
}

