/*
 * Decompiled with CFR 0.152.
 */
package com.laton95.pyramidplunder.tileentity;

import com.laton95.pyramidplunder.PyramidPlunder;
import com.laton95.pyramidplunder.config.Config;
import com.laton95.pyramidplunder.inventory.container.UrnContainer;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class UrnTileEntity
extends LockableLootTileEntity {
    public static final ResourceLocation URN_LOOT = new ResourceLocation("pyramidplunder", "urn");
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)10, (Object)ItemStack.field_190927_a);
    private LazyOptional<IItemHandler> inventoryHandler = LazyOptional.of(this::createInventory);
    private boolean hasSnake = false;
    private static String hasSnakeTag = "HasSnake";

    public UrnTileEntity() {
        super(PyramidPlunder.URN_TILE);
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.inventory;
    }

    protected void func_199721_a(NonNullList<ItemStack> items) {
        this.inventory = items;
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    protected Container func_213906_a(int id, PlayerInventory playerInventory) {
        this.func_184281_d(playerInventory.field_70458_d);
        return new UrnContainer(id, playerInventory, this);
    }

    public ITextComponent func_200200_C_() {
        ITextComponent customName = this.func_200201_e();
        return customName != null ? customName : this.func_213907_g();
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("pyramidplunder.container.urn", new Object[0]);
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.inventory = NonNullList.func_191197_a((int)10, (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(nbt)) {
            ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.inventory);
        }
        if (nbt.func_74764_b(hasSnakeTag)) {
            this.hasSnake = nbt.func_74767_n(hasSnakeTag);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        if (!this.func_184282_c(nbt)) {
            ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.inventory);
        }
        nbt.func_74757_a(hasSnakeTag, this.hasSnake);
        return nbt;
    }

    public boolean hasLoot() {
        return this.field_184284_m != null;
    }

    public void putSnake(Random random) {
        this.hasSnake = (double)random.nextFloat() < Config.snakeChance;
    }

    public void removeSnake() {
        this.hasSnake = false;
        this.func_70296_d();
    }

    public boolean hasSnake() {
        return this.hasSnake;
    }

    private IItemHandler createInventory() {
        return new InvWrapper((IInventory)this);
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryHandler.cast();
        }
        return super.getCapability(capability, side);
    }
}

