/*
 * Decompiled with CFR 0.152.
 */
package com.laton95.pyramidplunder.world.gen.placement;

import com.laton95.pyramidplunder.config.Config;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.Placement;

public class InCaveWithChance
extends Placement<ChanceConfig> {
    public InCaveWithChance(Function<Dynamic<?>, ? extends ChanceConfig> config) {
        super(config);
    }

    public Stream<BlockPos> getPositions(IWorld world, ChunkGenerator<? extends GenerationSettings> chunkGenerator, Random random, ChanceConfig config, BlockPos pos) {
        if (random.nextFloat() < 1.0f / (float)config.field_202477_a) {
            int x = random.nextInt(16);
            int z = random.nextInt(16);
            BlockPos blockpos = this.getLowestCave(world, new BlockPos(pos.func_177958_n() + x, 0, pos.func_177952_p() + z));
            if (blockpos != null && world.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, blockpos.func_177958_n(), blockpos.func_177952_p()) != blockpos.func_177956_o()) {
                return Stream.of(blockpos);
            }
        }
        return Stream.empty();
    }

    private BlockPos getLowestCave(IWorld world, BlockPos pos) {
        BlockPos result = new BlockPos(pos.func_177958_n(), Config.minHeight, pos.func_177952_p());
        while (world.func_180495_p(result).func_185904_a().func_76230_c() || world.func_180495_p(result).func_177230_c() == Blocks.field_150353_l) {
            if (result.func_177956_o() > Config.maxHeight || result.func_177956_o() > world.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, pos).func_177956_o()) {
                return null;
            }
            result = result.func_177984_a();
        }
        return result;
    }
}

