/*
 * Decompiled with CFR 0.152.
 */
package RCM.Models;

import RCM.Models.Model;
import RCM.Models.ModelFace;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.FloatBuffer;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;

public class ModelLoader {
    public static Model loadModel(String path, String name) throws FileNotFoundException, IOException {
        String line;
        URL url = ModelLoader.class.getResource(path);
        InputStream inputstream = url.openStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream));
        boolean flag = false;
        Model model = new Model();
        while (!((line = reader.readLine()) == null || line.startsWith("o ") && line.contains(name))) {
        }
        line = reader.readLine();
        while (line != null && !line.startsWith("e ")) {
            if (line.startsWith("v ")) {
                float x = Float.valueOf(line.split(" ")[1]).floatValue();
                float y = Float.valueOf(line.split(" ")[2]).floatValue();
                float z = Float.valueOf(line.split(" ")[3]).floatValue();
                model.getVertices().add(new Vector3f(x, y, z));
            } else if (line.startsWith("t ")) {
                float x = Float.valueOf(line.split(" ")[1]).floatValue();
                float y = -Float.valueOf(line.split(" ")[2]).floatValue();
                model.getTextureCoordinates().add(new Vector2f(x, y));
            } else if (line.startsWith("n ")) {
                float x = Float.valueOf(line.split(" ")[1]).floatValue();
                float y = Float.valueOf(line.split(" ")[2]).floatValue();
                float z = Float.valueOf(line.split(" ")[3]).floatValue();
                model.getNormals().add(new Vector3f(x, y, z));
            } else if (line.startsWith("f ")) {
                int[] vertexIndices = new int[]{Integer.valueOf(line.split(" ")[1].split("/")[0]), Integer.valueOf(line.split(" ")[2].split("/")[0]), Integer.valueOf(line.split(" ")[3].split("/")[0])};
                int[] textureCoordinateIndices = new int[]{Integer.valueOf(line.split(" ")[1].split("/")[1]), Integer.valueOf(line.split(" ")[2].split("/")[1]), Integer.valueOf(line.split(" ")[3].split("/")[1])};
                int[] normalIndices = new int[]{Integer.valueOf(line.split(" ")[1].split("/")[2]), Integer.valueOf(line.split(" ")[2].split("/")[2]), Integer.valueOf(line.split(" ")[3].split("/")[2])};
                model.getFaces().add(new ModelFace(vertexIndices, normalIndices, textureCoordinateIndices));
            }
            line = reader.readLine();
        }
        return model;
    }

    public static int[] createVBO(Model model) {
        int vboVertexHandle = GL15.glGenBuffers();
        int vboNormalHandle = GL15.glGenBuffers();
        int vboTextureHandler = GL15.glGenBuffers();
        FloatBuffer vertices = ModelLoader.reserveData(model.getFaces().size() * 9);
        FloatBuffer normals = ModelLoader.reserveData(model.getFaces().size() * 9);
        FloatBuffer textureCoordinates = ModelLoader.reserveData(model.getFaces().size() * 6);
        for (ModelFace face : model.getFaces()) {
            vertices.put(ModelLoader.asFloats(model.getVertices().get(face.getVertexIndices()[0] - 1)));
            vertices.put(ModelLoader.asFloats(model.getVertices().get(face.getVertexIndices()[1] - 1)));
            vertices.put(ModelLoader.asFloats(model.getVertices().get(face.getVertexIndices()[2] - 1)));
            normals.put(ModelLoader.asFloats(model.getNormals().get(face.getNormalIndices()[0] - 1)));
            normals.put(ModelLoader.asFloats(model.getNormals().get(face.getNormalIndices()[1] - 1)));
            normals.put(ModelLoader.asFloats(model.getNormals().get(face.getNormalIndices()[2] - 1)));
            textureCoordinates.put(ModelLoader.asFloats(model.getTextureCoordinates().get(face.getTextureCoordinateIndices()[0] - 1)));
            textureCoordinates.put(ModelLoader.asFloats(model.getTextureCoordinates().get(face.getTextureCoordinateIndices()[1] - 1)));
            textureCoordinates.put(ModelLoader.asFloats(model.getTextureCoordinates().get(face.getTextureCoordinateIndices()[2] - 1)));
        }
        vertices.flip();
        normals.flip();
        textureCoordinates.flip();
        GL15.glBindBuffer((int)34962, (int)vboVertexHandle);
        GL15.glBufferData((int)34962, (FloatBuffer)vertices, (int)35044);
        GL11.glVertexPointer((int)3, (int)5126, (int)0, (long)0L);
        GL15.glBindBuffer((int)34962, (int)vboNormalHandle);
        GL15.glBufferData((int)34962, (FloatBuffer)normals, (int)35044);
        GL11.glNormalPointer((int)5126, (int)0, (long)0L);
        GL15.glBindBuffer((int)34962, (int)vboTextureHandler);
        GL15.glBufferData((int)34962, (FloatBuffer)textureCoordinates, (int)35044);
        GL11.glTexCoordPointer((int)2, (int)5126, (int)0, (long)0L);
        GL15.glBindBuffer((int)34962, (int)0);
        return new int[]{vboVertexHandle, vboNormalHandle, vboTextureHandler};
    }

    private static FloatBuffer reserveData(int size) {
        return BufferUtils.createFloatBuffer((int)size);
    }

    private static float[] asFloats(Vector3f v) {
        return new float[]{v.x, v.y, v.z};
    }

    private static float[] asFloats(Vector2f v) {
        return new float[]{v.x, v.y};
    }
}

