/*
 * Decompiled with CFR 0.152.
 */
package RCM.Physics;

import RCM.Entities.GlobalEntity;
import RCM.Packets.MessageHandler;
import RCM.Packets.MessageSpawnWeapon;
import RCM.Physics.PhysicsHelper;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import javax.annotation.Nullable;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.entity.Entity;

public class AttachmentHandler {
    private Vector3f position;
    private boolean isEmpty;
    private GlobalEntity aentity;
    private GlobalEntity ventity;
    private PhysicsHelper helper = new PhysicsHelper();
    private int pylonNumber;
    private float deltaTime;

    public AttachmentHandler(Vector3f pos, int place, GlobalEntity gEntity) {
        this.position = pos;
        this.isEmpty = true;
        this.pylonNumber = place;
        this.ventity = gEntity;
        this.deltaTime = 0.0f;
    }

    public void setMotionState(Quat4f localQuat, Vector3f linearVelocity, Vector3f pos, float par, int ID) {
        Vector3f gPos = this.helper.rotateVector(localQuat, this.position);
        gPos.add((Tuple3f)pos);
        if (this.isEmpty && this.deltaTime <= 0.0f) {
            MessageHandler.handler.sendToServer((IMessage)new MessageSpawnWeapon(ID, this.pylonNumber, 0));
            this.deltaTime = 10.0f;
        } else if (this.isEmpty) {
            this.deltaTime -= par;
        }
        if (this.aentity != null && this.aentity.physicsWorld != null) {
            this.aentity.physicsWorld.setEntityLinearVelocity(linearVelocity);
            this.aentity.physicsWorld.setEntityMotionState(localQuat, gPos, 1.0f);
            this.isEmpty = false;
        }
    }

    public void release(@Nullable Entity lockedEntity) {
        if (this.aentity != null) {
            this.aentity.physicsWorld.setRocketMotorActive();
            this.aentity.physicsWorld.setLockedTarger(lockedEntity);
            this.isEmpty = true;
            this.aentity = null;
        }
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public void attach(GlobalEntity gEntity) {
        this.aentity = gEntity;
    }
}

