/*
 * Decompiled with CFR 0.152.
 */
package RCM.Physics;

public class MotorHandler {
    private float omega;
    private float power;
    private float torque;
    private float torqueLimit;
    private float acceleration;
    private float inertia;
    private boolean dmg;
    private int ID;
    private int controlChannel;

    public MotorHandler(int ID, float mass, float diameter, float power, float torqueLimit, int channel) {
        this.ID = ID;
        this.power = power;
        this.omega = 0.0f;
        this.torqueLimit = torqueLimit;
        this.acceleration = 0.0f;
        this.inertia = mass * diameter * diameter / 8.0f;
        this.controlChannel = channel;
    }

    public void update(float resistTrqe, float inert, float powerReq, int driving, boolean wheelConnected, float dt, float alt) {
        if (!this.dmg) {
            if (alt > 125.0f) {
                powerReq = 0.0f;
            }
            if (this.omega != 0.0f) {
                this.torque = this.power * powerReq / Math.abs(this.omega) / (float)driving;
                this.torque += resistTrqe;
            } else {
                this.torque = this.torqueLimit * powerReq / (float)driving;
                this.torque += resistTrqe;
            }
            if (this.torque > this.torqueLimit) {
                this.torque = this.torqueLimit;
            } else if (this.torque < -this.torqueLimit) {
                this.torque = -this.torqueLimit;
            }
            if (!wheelConnected) {
                if (this.power == 0.0f) {
                    this.torque -= this.torque * 0.8f;
                }
                this.acceleration = this.torque / (this.inertia + inert);
                this.omega += this.acceleration * dt;
                this.omega -= this.omega * 0.2f * dt;
            }
        }
    }

    public void setDmged(boolean dmg) {
        this.dmg = dmg;
        if (dmg) {
            this.omega = 0.0f;
            this.torque = 0.0f;
        }
    }

    public boolean isDmged() {
        return this.dmg;
    }

    public void setOmega(float omega) {
        this.omega = omega;
    }

    public float getRotationalVel() {
        return this.omega;
    }

    public float getTorque() {
        return this.torque;
    }

    public int getChannel() {
        return this.controlChannel;
    }

    public int getID() {
        return this.ID;
    }
}

