/*
 * Decompiled with CFR 0.152.
 */
package RCM.Physics;

import RCM.Entities.CameraHandler;
import RCM.Entities.EntityMissile;
import RCM.Entities.GlobalEntity;
import RCM.KeyHandler;
import RCM.Packets.MessageEntityMissle;
import RCM.Packets.MessageHandler;
import RCM.Physics.AttachmentHandler;
import RCM.Physics.AutoControlHandler;
import RCM.Physics.Force;
import RCM.Physics.MotorHandler;
import RCM.Physics.PhysicsHelper;
import RCM.Physics.RocketMotorHandler;
import RCM.Physics.RotaryWingHandler;
import RCM.Physics.VirtualReferenceHandler;
import RCM.Physics.WheelHandler;
import RCM.Physics.WingHandler;
import RCM.PropertiesLoader.PropertiesLoader;
import RCM.RCM_Main;
import com.bulletphysics.collision.shapes.CollisionShape;
import com.bulletphysics.collision.shapes.CompoundShape;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.RigidBodyConstructionInfo;
import com.bulletphysics.dynamics.vehicle.DefaultVehicleRaycaster;
import com.bulletphysics.dynamics.vehicle.RaycastVehicle;
import com.bulletphysics.dynamics.vehicle.VehicleRaycaster;
import com.bulletphysics.dynamics.vehicle.VehicleTuning;
import com.bulletphysics.dynamics.vehicle.WheelInfo;
import com.bulletphysics.linearmath.DefaultMotionState;
import com.bulletphysics.linearmath.MotionState;
import com.bulletphysics.linearmath.Transform;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.Vec3;
import net.minecraft.world.biome.BiomeGenBase;

public class PhysicsHandler {
    public List<MotorHandler> motors = new ArrayList<MotorHandler>();
    public List<WheelHandler> wheels = new ArrayList<WheelHandler>();
    public List<WingHandler> wings = new ArrayList<WingHandler>();
    public List<RotaryWingHandler> rotaryWings = new ArrayList<RotaryWingHandler>();
    public List<AutoControlHandler> sensors = new ArrayList<AutoControlHandler>();
    public List<AttachmentHandler> attachments = new ArrayList<AttachmentHandler>();
    public List<RocketMotorHandler> rocketMotors = new ArrayList<RocketMotorHandler>();
    public List<Force> forces = new ArrayList<Force>();
    public List<Vector3f> torques = new ArrayList<Vector3f>();
    public RigidBody entityBody;
    public RaycastVehicle vehicle;
    private PhysicsHelper helper;
    public VirtualReferenceHandler virtualReference;
    public List<Entity> visibleEntities = Lists.newArrayList();
    public List<Entity> inRadarEntities = Lists.newArrayList();
    public Entity lockedEntity;
    private int lockedEntityID;
    public boolean requestCollisionShapes = false;
    private boolean jump;
    private Vector3f linearVel;
    private Vector3f rotationalVel;
    private Vector3f position;
    private Vector3f frontPath;
    private Quat4f localQuat;
    private float powerReq;
    private PropertiesLoader loader;
    private float density;
    private float dragFactor;
    public float pitchAngle;
    public float rollAngle;
    public float yawAngle;
    public float cyclicAngle;
    public float prevCyclicAngle;
    private float[] controlChannels = new float[27];
    private boolean motorActive;
    public boolean weaponsMode;
    private boolean canChangeMode;
    private boolean canFireMissile;
    private boolean releaseWeapons;
    private float releaseWeaponTimer;
    private float altitude;
    private float prevDist;
    private int weaponCount;

    public PhysicsHandler(int ID, Vector3f pos, float spawnRotation, GlobalEntity rcentity) {
        this.localQuat = new Quat4f();
        this.linearVel = new Vector3f();
        this.rotationalVel = new Vector3f();
        this.position = new Vector3f(pos);
        this.frontPath = new Vector3f();
        this.virtualReference = new VirtualReferenceHandler();
        this.setEntity(ID);
        this.setCollisionModel(this.position, spawnRotation, rcentity);
        this.setMotors();
        this.setWheels();
        this.setWings();
        this.setRotaryWings();
        this.setAutoControllers();
        this.setAttachments(rcentity);
        this.setRocketMotors();
        this.helper = new PhysicsHelper();
        this.dragFactor = this.loader.getDragFactor();
        this.motorActive = true;
        this.canChangeMode = true;
        this.releaseWeaponTimer = 0.0f;
    }

    private void setEntity(int ID) {
        switch (ID) {
            case 1: {
                this.loader = RCM_Main.planeProperies;
                break;
            }
            case 2: {
                this.loader = RCM_Main.octocopterProperies;
                break;
            }
            case 3: {
                this.loader = RCM_Main.carProperies;
                break;
            }
            case 4: {
                this.loader = RCM_Main.f22Properies;
                break;
            }
            case 5: {
                this.loader = RCM_Main.heliProperies;
                break;
            }
            case 6: {
                this.loader = RCM_Main.missleProperies;
                break;
            }
        }
    }

    private void setCollisionModel(Vector3f position, float spawnRotation, GlobalEntity entity) {
        AxisAngle4f initRotate = new AxisAngle4f(0.0f, 1.0f, 0.0f, spawnRotation);
        Quat4f localQuat = new Quat4f();
        localQuat.set(initRotate);
        CompoundShape cp = this.loader.getCollisionShapes();
        DefaultMotionState motionState = new DefaultMotionState(new Transform(new Matrix4f(localQuat, position, 1.0f)));
        RigidBodyConstructionInfo entityConstructionInfo = new RigidBodyConstructionInfo(this.loader.getProperties()[0], (MotionState)motionState, (CollisionShape)cp, this.loader.getInertia());
        entityConstructionInfo.angularDamping = 0.95f;
        entityConstructionInfo.restitution = 0.0f;
        entityConstructionInfo.friction = 0.5f;
        this.entityBody = new RigidBody(entityConstructionInfo);
        if (entity instanceof EntityMissile) {
            this.entityBody.setCollisionFlags(4);
        }
        RCM_Main.physicsWorld.addRigidBody(this.entityBody);
    }

    private void setMotors() {
        if (this.loader.getProperties()[2] > 0.0f) {
            int i = 0;
            while ((float)i < this.loader.getProperties()[2]) {
                this.motors.add(new MotorHandler(this.loader.getMotorProperties().get((int)i).motorID, this.loader.getMotorProperties().get((int)i).mass, this.loader.getMotorProperties().get((int)i).diameter, this.loader.getMotorProperties().get((int)i).motorPower, this.loader.getMotorProperties().get((int)i).motorTorqueLimit, this.loader.getMotorProperties().get((int)i).controlChannel));
                ++i;
            }
        }
    }

    private void setWheels() {
        if (this.loader.getProperties()[3] > 0.0f) {
            VehicleTuning tuning = new VehicleTuning();
            DefaultVehicleRaycaster vehicleRayCaster = new DefaultVehicleRaycaster(RCM_Main.physicsWorld.getDynamicsWorld());
            this.vehicle = new RaycastVehicle(tuning, this.entityBody, (VehicleRaycaster)vehicleRayCaster);
            RCM_Main.physicsWorld.addVehicle(this.vehicle);
            this.vehicle.setCoordinateSystem(0, 1, 2);
            int i = 0;
            while ((float)i < this.loader.getProperties()[3]) {
                this.vehicle.addWheel(this.loader.getWheelProperties().get((int)i).connectionPoint, this.loader.getWheelProperties().get((int)i).wheelDirection, this.loader.getWheelProperties().get((int)i).wheelAxle, this.loader.getWheelProperties().get((int)i).suspensionRestLength, this.loader.getWheelProperties().get((int)i).radius, tuning, this.loader.getWheelProperties().get((int)i).canTurn);
                WheelInfo wheel = this.vehicle.getWheelInfo(i);
                wheel.suspensionStiffness = this.loader.getWheelProperties().get((int)i).suspensionStiffness;
                wheel.wheelsDampingRelaxation = this.loader.getWheelProperties().get((int)i).suspensionDamping;
                wheel.wheelsDampingCompression = this.loader.getWheelProperties().get((int)i).suspensionCompression;
                wheel.rollInfluence = this.loader.getWheelProperties().get((int)i).rollInfluence;
                wheel.frictionSlip = this.loader.getWheelProperties().get((int)i).frictionSlip;
                wheel.brake = this.loader.getWheelProperties().get((int)i).breakForce;
                this.wheels.add(new WheelHandler(this.loader.getWheelProperties().get((int)i).ID, this.loader.getWheelProperties().get((int)i).wheelMaxTurn, this.loader.getWheelProperties().get((int)i).canTurn, this.loader.getWheelProperties().get((int)i).offSet, this.loader.getWheelProperties().get((int)i).channel));
                ++i;
            }
        }
    }

    private void setWings() {
        if (this.loader.getProperties()[4] > 0.0f) {
            int i = 0;
            while ((float)i < this.loader.getProperties()[4]) {
                this.wings.add(new WingHandler(this.loader.getWingProperties().get((int)i).wingID, this.loader.getWingProperties().get((int)i).spanVec, this.loader.getWingProperties().get((int)i).liftVec, this.loader.getWingProperties().get((int)i).chordVec, this.loader.getWingProperties().get((int)i).position, 0.0f, this.loader.getWingProperties().get((int)i).area, this.loader.getWingProperties().get((int)i).span, this.loader.getWingProperties().get((int)i).root, this.loader.getWingProperties().get((int)i).tip, this.loader.getWingProperties().get((int)i).def, this.loader.getWingProperties().get((int)i).defOffset, this.loader.getWingProperties().get((int)i).profileType, this.loader.getWingProperties().get((int)i).controlChannel, this.loader.getWingProperties().get((int)i).sections, 1.0f, this.loader.getWingProperties().get((int)i).sensorID));
                ++i;
            }
        }
    }

    private void setRotaryWings() {
        if (this.loader.getProperties()[5] > 0.0f) {
            int i = 0;
            while ((float)i < this.loader.getProperties()[5]) {
                this.rotaryWings.add(new RotaryWingHandler(this.loader.getRotaryWingProperties().get((int)i).propID, this.loader.getRotaryWingProperties().get((int)i).mass, this.loader.getRotaryWingProperties().get((int)i).ratio, this.loader.getRotaryWingProperties().get((int)i).eqFactor, this.loader.getRotaryWingProperties().get((int)i).spanVec, this.loader.getRotaryWingProperties().get((int)i).liftVec, this.loader.getRotaryWingProperties().get((int)i).chordVec, this.loader.getRotaryWingProperties().get((int)i).position, this.loader.getRotaryWingProperties().get((int)i).hubOffset, this.loader.getRotaryWingProperties().get((int)i).area, this.loader.getRotaryWingProperties().get((int)i).span, this.loader.getRotaryWingProperties().get((int)i).root, this.loader.getRotaryWingProperties().get((int)i).tip, this.loader.getRotaryWingProperties().get((int)i).def, this.loader.getRotaryWingProperties().get((int)i).defOffset, this.loader.getRotaryWingProperties().get((int)i).profileType, this.loader.getRotaryWingProperties().get((int)i).controlChannel, this.loader.getRotaryWingProperties().get((int)i).sections, this.loader.getRotaryWingProperties().get((int)i).sensorID));
                ++i;
            }
        }
    }

    private void setAutoControllers() {
        if (this.loader.getProperties()[6] > 0.0f) {
            int i = 0;
            while ((float)i < this.loader.getProperties()[6]) {
                this.sensors.add(new AutoControlHandler(this.loader.getAutoControlProperties().get((int)i).ID, this.loader.getAutoControlProperties().get((int)i).sensorPoint, this.loader.getAutoControlProperties().get((int)i).linGain, this.loader.getAutoControlProperties().get((int)i).linLimit, this.loader.getAutoControlProperties().get((int)i).angGain, this.loader.getAutoControlProperties().get((int)i).angLimit));
                ++i;
            }
        }
    }

    private void setAttachments(GlobalEntity rcentity) {
        if (this.loader.getProperties()[7] > 0.0f) {
            int i = 0;
            while ((float)i < this.loader.getProperties()[7]) {
                Vector3f pos = new Vector3f(this.loader.getAttachments().get(i));
                this.attachments.add(new AttachmentHandler(pos, i, rcentity));
                ++i;
            }
        }
    }

    private void setRocketMotors() {
        if (this.loader.getProperties()[8] > 0.0f) {
            int i = 0;
            while ((float)i < this.loader.getProperties()[8]) {
                this.rocketMotors.add(new RocketMotorHandler(this.loader.getRocketMotors().get((int)i).thurst, this.loader.getRocketMotors().get((int)i).burnTime));
                ++i;
            }
        }
    }

    public void update(GlobalEntity entity, float deltaTime) {
        this.entityBody.getOrientation(this.localQuat);
        this.entityBody.getLinearVelocity(this.linearVel);
        this.entityBody.getAngularVelocity(this.rotationalVel);
        this.position = this.entityBody.getMotionState().getWorldTransform((Transform)new Transform()).origin;
        this.updateControls(entity, deltaTime);
        this.setDensity(entity);
        int wCount = 0;
        for (AttachmentHandler mh : this.attachments) {
            mh.setMotionState(this.localQuat, this.linearVel, this.position, deltaTime, entity.func_145782_y());
            if (this.releaseWeapons && !mh.isEmpty()) {
                mh.release(this.lockedEntity);
                this.releaseWeapons = false;
                this.releaseWeaponTimer = 0.5f;
            }
            if (mh.isEmpty()) continue;
            ++wCount;
        }
        if (this.releaseWeapons) {
            this.releaseWeapons = false;
        }
        this.weaponCount = wCount;
        if (this.releaseWeaponTimer > 0.0f) {
            this.releaseWeaponTimer -= deltaTime;
        }
        for (int i = 0; i < this.wheels.size(); ++i) {
            if (this.wheels.get(i).isSteerable() && this.vehicle != null) {
                this.vehicle.setSteeringValue(this.controlChannels[this.wheels.get(i).getChannel()] * this.wheels.get(i).getMaxSteering(), i);
            }
            if (!(((WheelInfo)this.vehicle.wheelInfo.get((int)i)).wheelsSuspensionForce <= 0.0f)) continue;
            this.jump = false;
        }
        if (this.jump) {
            Vector3f jumpVect = new Vector3f(entity.Up);
            jumpVect.scale(1300.0f);
            this.forces.add(new Force(jumpVect, new Vector3f()));
        }
        if (entity instanceof EntityMissile) {
            if (!this.getRocketMotorActive()) {
                this.frontPath = entity.Forward;
            }
            this.virtualReference.updateFlyPath(entity.Left, entity.Up, entity.Forward, this.getTragetPath(entity.func_145782_y(), this.linearVel), this.frontPath);
        } else if (this.sensors.size() > 0) {
            this.virtualReference.updateBars(entity.Left, entity.Up, entity.Forward, this.pitchAngle, this.yawAngle, this.rollAngle, deltaTime);
        }
        for (MotorHandler motor : this.motors) {
            if (entity.damaged) {
                motor.setDmged(true);
            }
            int wheelsConnected = 0;
            for (WheelHandler wheel : this.wheels) {
                if (wheel.getID() != motor.getID()) continue;
                ++wheelsConnected;
            }
            if (wheelsConnected > 0) {
                float wheelRotation = 0.0f;
                int wheelCounter = 0;
                for (int i = 0; i < this.wheels.size(); ++i) {
                    if (motor.getID() != this.wheels.get(i).getID()) continue;
                    if (entity.forwardVelocity > 0.0f && motor.getTorque() < 0.0f) {
                        this.vehicle.applyEngineForce(motor.getTorque() * 100.0f, i);
                    } else {
                        this.vehicle.applyEngineForce(motor.getTorque(), i);
                    }
                    wheelRotation += this.vehicle.getWheelInfo((int)i).deltaRotation * 60.0f;
                    ++wheelCounter;
                }
                if (wheelCounter != 0) {
                    wheelRotation /= (float)wheelCounter;
                }
                motor.setOmega(wheelRotation);
                motor.update(0.0f, 0.0f, this.controlChannels[motor.getChannel()], wheelsConnected, true, 0.0f, this.altitude);
                continue;
            }
            float totalResistanceTorque = 0.0f;
            float totalInertia = 0.0f;
            for (RotaryWingHandler rotWing : this.rotaryWings) {
                if (rotWing.getID() != motor.getID()) continue;
                float response = 0.0f;
                if (rotWing.getSensorID() != 0) {
                    for (AutoControlHandler sensor : this.sensors) {
                        if (rotWing.getSensorID() != sensor.getID()) continue;
                        sensor.update(this.localQuat, this.linearVel, this.virtualReference.getVirtualFlyBar(), this.virtualReference.getVirtualTailBar(), this.virtualReference.getVirtualFlightPath());
                        response = sensor.getResponse();
                    }
                }
                rotWing.setAngularVelocity(motor.getRotationalVel());
                rotWing.update(this.localQuat, this.linearVel, this.rotationalVel, this.density, this.controlChannels[rotWing.getChannel()] + response);
                rotWing.setRotationAngle(deltaTime);
                for (int i = 0; i < rotWing.getSections(); ++i) {
                    Vector3f forcePos = new Vector3f(rotWing.getPosition(i));
                    Vector3f forceLift = new Vector3f(rotWing.getLift(i));
                    Vector3f forceDrag = new Vector3f(rotWing.getDrag(i));
                    this.forces.add(new Force(forceLift, forcePos));
                    this.forces.add(new Force(forceDrag, forcePos));
                    this.torques.add(rotWing.getMoment(i));
                }
                totalResistanceTorque += rotWing.getTroque();
                totalInertia += rotWing.getInertia();
            }
            motor.update(totalResistanceTorque, totalInertia, this.controlChannels[motor.getChannel()], 1, false, deltaTime, this.altitude);
        }
        for (WingHandler wing : this.wings) {
            float response = 0.0f;
            if (wing.getSensorID() != 0) {
                for (AutoControlHandler sensor : this.sensors) {
                    if (wing.getSensorID() != sensor.getID()) continue;
                    sensor.update(this.localQuat, this.linearVel, this.virtualReference.getVirtualFlyBar(), this.virtualReference.getVirtualTailBar(), this.virtualReference.getVirtualFlightPath());
                    response = sensor.getResponse();
                }
            }
            wing.update(this.localQuat, this.linearVel, this.rotationalVel, this.density, this.controlChannels[wing.getChannel()] + response);
            for (int i = 0; i < wing.getSections(); ++i) {
                Vector3f forcePos = new Vector3f(wing.getPosition(i));
                Vector3f forceLift = new Vector3f(wing.getLift(i));
                Vector3f forceDrag = new Vector3f(wing.getDrag(i));
                this.forces.add(new Force(forceLift, forcePos));
                this.forces.add(new Force(forceDrag, forcePos));
                this.torques.add(wing.getMoment(i));
            }
        }
        for (RocketMotorHandler rocketMotor : this.rocketMotors) {
            Vector3f rocketThrust = rocketMotor.getThurstVect(entity.Forward, this.linearVel.length(), deltaTime);
            this.forces.add(new Force(rocketThrust, new Vector3f()));
        }
        Vector3f dragForce = entity.helper.getDrag(this.linearVel, this.dragFactor, this.density);
        this.forces.add(new Force(dragForce, new Vector3f()));
        entity.prevVeloc.sub((Tuple3f)this.linearVel);
        if (entity.prevVeloc.length() > 10.0f && !(entity instanceof EntityMissile)) {
            entity.damaged = true;
        }
        entity.prevVeloc.set((Tuple3f)this.linearVel);
        for (Force fs : this.forces) {
            this.entityBody.applyForce(fs.getForce(), fs.getPosition());
        }
        for (Vector3f ts : this.torques) {
            this.entityBody.applyTorque(ts);
        }
        this.forces.clear();
        this.torques.clear();
    }

    public void getVisibleEntities(GlobalEntity en) {
        List entityList = en.field_70170_p.field_72996_f;
        this.visibleEntities.clear();
        this.inRadarEntities.clear();
        this.lockedEntity = null;
        en.weaponLock = false;
        en.prevLockProgress = en.lockProgress;
        float nearRest = 0.0f;
        float angle = 0.0f;
        Vector3f eVec = new Vector3f();
        if (this.weaponsMode) {
            for (Object obj : entityList) {
                Entity entity = (Entity)obj;
                if (entity == en || entity == en.thePlayer || entity instanceof CameraHandler || entity instanceof EntityItem || entity instanceof EntityMissile) continue;
                Vec3 rcentityVec = Vec3.func_72443_a((double)en.field_70165_t, (double)en.field_70163_u, (double)en.field_70161_v);
                Vec3 entityVec = Vec3.func_72443_a((double)entity.field_70165_t, (double)(entity.field_70163_u + (double)(entity.func_70047_e() / 2.0f)), (double)entity.field_70161_v);
                eVec.set((float)(entity.field_70165_t - en.field_70165_t), (float)(entity.field_70163_u + (double)(entity.func_70047_e() / 2.0f) - en.field_70163_u), (float)(entity.field_70161_v - en.field_70161_v));
                angle = eVec.angle(en.Forward);
                if (angle > 1.047198f || en.field_70170_p.func_72901_a(rcentityVec, entityVec, false) != null) continue;
                this.visibleEntities.add(entity);
                if (angle > 0.43633232f) continue;
                if (this.lockedEntity == null) {
                    nearRest = angle;
                    this.lockedEntity = entity;
                    continue;
                }
                if (!(angle < nearRest)) continue;
                nearRest = angle;
                this.lockedEntity = entity;
            }
            if (this.lockedEntity != null) {
                en.weaponLock = true;
                if (this.lockedEntity.func_145782_y() != this.lockedEntityID) {
                    en.lockProgress = 0.0f;
                    en.prevLockProgress = 0.0f;
                    en.weaponLock = false;
                } else if (this.lockedEntity.func_145782_y() == this.lockedEntityID && en.lockProgress < 1.0f) {
                    en.lockProgress += 0.05f;
                }
                en.lockProgress = Math.min(1.0f, en.lockProgress);
                this.lockedEntityID = this.lockedEntity.func_145782_y();
            } else {
                en.lockProgress = 0.0f;
                en.prevLockProgress = 0.0f;
                en.weaponLock = false;
            }
        } else {
            this.lockedEntity = null;
            en.lockProgress = 0.0f;
            en.prevLockProgress = 0.0f;
            en.weaponLock = false;
        }
    }

    public Vector3f getTragetPath(int entityID, Vector3f linearMotion) {
        if (this.getRocketMotorActive() && this.lockedEntity != null && !this.lockedEntity.field_70128_L) {
            Vector3f distanceToGo = new Vector3f((float)this.lockedEntity.field_70165_t, (float)(this.lockedEntity.field_70163_u + (double)this.lockedEntity.func_70047_e()), (float)this.lockedEntity.field_70161_v);
            Vector3f motionVect = new Vector3f(linearMotion);
            Vector3f entityMotion = new Vector3f((float)this.lockedEntity.field_70159_w, (float)this.lockedEntity.field_70181_x, (float)this.lockedEntity.field_70179_y);
            Vector3f normDistToGo = new Vector3f();
            distanceToGo.sub((Tuple3f)this.position);
            entityMotion.scale(20.0f);
            Vector3f relVel = new Vector3f(motionVect);
            relVel.sub((Tuple3f)entityMotion);
            float distanceToGoMag = distanceToGo.length();
            float motionVectMag = motionVect.length();
            normDistToGo.set((Tuple3f)distanceToGo);
            if (distanceToGoMag > 0.0f) {
                normDistToGo.normalize();
            }
            if (motionVectMag > 0.0f) {
                motionVect.normalize();
            }
            float closingVel = relVel.dot(normDistToGo);
            float timeToTarget = 0.0f;
            if (closingVel != 0.0f) {
                timeToTarget = distanceToGoMag / closingVel;
            }
            if (timeToTarget > 0.0f) {
                entityMotion.scale(timeToTarget);
                distanceToGo.add((Tuple3f)entityMotion);
            }
            if (distanceToGo.length() > 0.0f) {
                distanceToGo.normalize();
            }
            float projection = distanceToGo.dot(motionVect) * 0.5f;
            motionVect.scale(projection);
            distanceToGo.sub((Tuple3f)motionVect);
            distanceToGo.scale(-1.0f);
            if (distanceToGoMag <= 1.5f && this.prevDist <= distanceToGoMag) {
                MessageHandler.handler.sendToServer((IMessage)new MessageEntityMissle(entityID, this.position.x, this.position.y, this.position.z));
            }
            this.prevDist = distanceToGoMag;
            return distanceToGo;
        }
        return null;
    }

    public void updateControls(GlobalEntity entity, float deltaTime) {
        this.prevCyclicAngle = this.cyclicAngle;
        if (entity.activated && entity.holdingremotecontrol(entity.thePlayer)) {
            if (KeyHandler.turnMovement != 0) {
                this.yawAngle -= 4.0f * (float)KeyHandler.turnMovement * deltaTime;
                if (this.yawAngle > 1.0f) {
                    this.yawAngle = 1.0f;
                }
                if (this.yawAngle < -1.0f) {
                    this.yawAngle = -1.0f;
                }
            } else if (this.yawAngle > 0.0f) {
                this.yawAngle -= 4.0f * deltaTime;
                if (this.yawAngle < 0.0f) {
                    this.yawAngle = 0.0f;
                }
            } else if (this.yawAngle < 0.0f) {
                this.yawAngle += 4.0f * deltaTime;
                if (this.yawAngle > 0.0f) {
                    this.yawAngle = 0.0f;
                }
            }
            if (KeyHandler.pitchMovement != 0) {
                this.pitchAngle -= 4.0f * (float)KeyHandler.pitchMovement * deltaTime;
                if (this.pitchAngle > 1.0f) {
                    this.pitchAngle = 1.0f;
                }
                if (this.pitchAngle < -1.0f) {
                    this.pitchAngle = -1.0f;
                }
            } else if (this.pitchAngle > 0.0f) {
                this.pitchAngle -= 4.0f * deltaTime;
                if (this.pitchAngle < 0.0f) {
                    this.pitchAngle = 0.0f;
                }
            } else if (this.pitchAngle < 0.0f) {
                this.pitchAngle += 4.0f * deltaTime;
                if (this.pitchAngle > 0.0f) {
                    this.pitchAngle = 0.0f;
                }
            }
            if (KeyHandler.rollMovement != 0) {
                this.rollAngle += 4.0f * (float)KeyHandler.rollMovement * deltaTime;
                if (this.rollAngle > 1.0f) {
                    this.rollAngle = 1.0f;
                }
                if (this.rollAngle < -1.0f) {
                    this.rollAngle = -1.0f;
                }
            } else if (this.rollAngle > 0.0f) {
                this.rollAngle -= 4.0f * deltaTime;
                if (this.rollAngle < 0.0f) {
                    this.rollAngle = 0.0f;
                }
            } else if (this.rollAngle < 0.0f) {
                this.rollAngle += 4.0f * deltaTime;
                if (this.rollAngle > 0.0f) {
                    this.rollAngle = 0.0f;
                }
            }
        }
        if (KeyHandler.forwardMovement != 0) {
            this.cyclicAngle -= 4.0f * (float)KeyHandler.forwardMovement * deltaTime;
            if (this.cyclicAngle > 1.0f) {
                this.cyclicAngle = 1.0f;
            }
            if (this.cyclicAngle < -1.0f) {
                this.cyclicAngle = -1.0f;
            }
        } else if (this.cyclicAngle > 0.0f) {
            this.cyclicAngle -= 4.0f * deltaTime;
            if (this.cyclicAngle < 0.0f) {
                this.cyclicAngle = 0.0f;
            }
        } else if (this.cyclicAngle < 0.0f) {
            this.cyclicAngle += 4.0f * deltaTime;
            if (this.cyclicAngle > 0.0f) {
                this.cyclicAngle = 0.0f;
            }
        }
        if (this.canChangeMode && KeyHandler.weaponsMode) {
            this.weaponsMode = !this.weaponsMode;
            this.canChangeMode = false;
        } else if (!this.canChangeMode && !KeyHandler.weaponsMode) {
            this.canChangeMode = true;
        }
        if (KeyHandler.secondaryFuction && this.canFireMissile && this.weaponsMode) {
            this.releaseWeapons = true;
            this.canFireMissile = false;
        } else if (this.releaseWeaponTimer <= 0.0f) {
            this.canFireMissile = true;
        }
    }

    private void setDensity(GlobalEntity entity) {
        BiomeGenBase area = entity.field_70170_p.func_72807_a((int)entity.field_70165_t, (int)entity.field_70161_v);
        float airTemperature = 25.0f * area.field_76750_F;
        this.altitude = (float)(entity.field_70163_u - entity.field_70170_p.field_73011_w.getHorizon());
        airTemperature = airTemperature - this.altitude * 0.0065f + 273.0f;
        float pressure = 101325.0f - this.altitude * 100.0f / 9.14f;
        float targetDensity = pressure / (280.34f * airTemperature);
        if (entity.func_70090_H()) {
            targetDensity = 1000.0f;
            if (this.density > targetDensity) {
                this.density = targetDensity;
            }
            if (this.density < targetDensity) {
                this.density += 1.0f;
            }
        } else {
            this.density = targetDensity;
        }
    }

    public void setControlChannel(int place, float value) {
        this.controlChannels[place] = value;
    }

    public void jump() {
        this.jump = true;
    }

    public Quat4f getLocalQuad() {
        return this.localQuat;
    }

    public Vector3f getLinearVel() {
        return this.linearVel;
    }

    public Vector3f getRotationalVel() {
        return this.rotationalVel;
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public void setEntityLinearVelocity(Vector3f vel) {
        this.entityBody.setLinearVelocity(vel);
    }

    public void setEntityMotionState(Quat4f quad, Vector3f pos, float par) {
        this.entityBody.setMotionState((MotionState)new DefaultMotionState(new Transform(new Matrix4f(quad, pos, par))));
    }

    public void getEntityAABB(Vector3f minAABB, Vector3f maxAABB) {
        this.entityBody.getAabb(minAABB, maxAABB);
    }

    public void removePhysicsEntity() {
        if (this.vehicle != null) {
            RCM_Main.physicsWorld.removeVehicle(this.vehicle);
        }
        if (this.entityBody != null) {
            RCM_Main.physicsWorld.removeRigidBody(this.entityBody);
        }
    }

    public void setRocketMotorActive() {
        for (RocketMotorHandler rmh : this.rocketMotors) {
            rmh.setActive();
        }
    }

    public boolean getRocketMotorActive() {
        Iterator<RocketMotorHandler> iterator = this.rocketMotors.iterator();
        if (iterator.hasNext()) {
            RocketMotorHandler rmh = iterator.next();
            return rmh.isActive();
        }
        return false;
    }

    public void attachWeapon(int place, GlobalEntity entity) {
        this.attachments.get(place).attach(entity);
    }

    public int getWeaponCount() {
        return this.weaponCount;
    }

    public boolean canExplode() {
        return this.motorActive;
    }

    public void setLockedTarger(@Nullable Entity lockedTarget) {
        this.lockedEntity = lockedTarget;
    }
}

