/*
 * Decompiled with CFR 0.152.
 */
package RCM.Physics;

import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class PhysicsHelper {
    public float degToRad = (float)Math.PI / 180;
    public float radToDeg = 57.295776f;

    public Vector3f getVelocityAtPoint(Vector3f linearVel, Vector3f rotationalVel, Vector3f point) {
        Vector3f velocityAtPoint = new Vector3f();
        velocityAtPoint.cross(rotationalVel, point);
        velocityAtPoint.add((Tuple3f)linearVel);
        return velocityAtPoint;
    }

    public float getAoA(Vector3f refVec1, Vector3f refVec2, Vector3f airVect) {
        float angleOfAtt = 0.0f;
        if (airVect.length() > 0.0f) {
            angleOfAtt = refVec1.angle(airVect);
        }
        if (refVec2.dot(airVect) <= 0.0f) {
            angleOfAtt *= -1.0f;
        }
        return angleOfAtt;
    }

    public Vector3f getDrag(Vector3f airflow, float dragFactor, float density) {
        Vector3f drag = new Vector3f(airflow);
        if (airflow.length() > 0.0f) {
            drag.normalize();
            drag.scale(-1.0f);
        }
        float airFlowMag = airflow.length();
        float dragForceMag = dragFactor * 0.5f * density * airFlowMag * airFlowMag;
        drag.scale(dragForceMag);
        return drag;
    }

    public Vector3f rotateVector(Quat4f LocalQuat, Vector3f vect) {
        Matrix4f quatMatrix = new Matrix4f();
        quatMatrix.set(LocalQuat);
        Vector3f vert = new Vector3f();
        vert.x = quatMatrix.m00 * vect.x + quatMatrix.m01 * vect.y + quatMatrix.m02 * vect.z;
        vert.y = quatMatrix.m10 * vect.x + quatMatrix.m11 * vect.y + quatMatrix.m12 * vect.z;
        vert.z = quatMatrix.m20 * vect.x + quatMatrix.m21 * vect.y + quatMatrix.m22 * vect.z;
        return vert;
    }
}

