/*
 * Decompiled with CFR 0.152.
 */
package RCM.Physics;

import RCM.Entities.EntityMissile;
import RCM.Entities.GlobalEntity;
import RCM.RCM_Main;
import com.bulletphysics.linearmath.Clock;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;

public class PhysicsTickHandler {
    protected Clock clock = new Clock();
    private List<GlobalEntity> entity = new ArrayList<GlobalEntity>();
    private static List<GlobalEntity> register = new ArrayList<GlobalEntity>();
    private static List<GlobalEntity> deRegister = new ArrayList<GlobalEntity>();

    @SubscribeEvent
    public void tick(TickEvent.RenderTickEvent event) {
        float deltaTime = this.getDeltaTimeMicroseconds() * 1.0E-6f;
        int maxSimSubSteps = 15;
        if (RCM_Main.proxy.getClientWorld() == null) {
            this.entity.clear();
            RCM_Main.physicsWorld.removeAll();
        }
        if (!FMLClientHandler.instance().getClient().func_147113_T()) {
            GlobalEntity rcentity;
            int i;
            for (GlobalEntity rcentity2 : register) {
                this.entity.add(rcentity2);
            }
            register.clear();
            for (GlobalEntity rcentity2 : deRegister) {
                this.entity.remove((Object)rcentity2);
            }
            deRegister.clear();
            int size = this.entity.size();
            for (i = 0; i < size; ++i) {
                rcentity = this.entity.get(i);
                if (rcentity.physicsWorld != null && rcentity.physicsWorld.requestCollisionShapes && !(this.entity instanceof EntityMissile)) {
                    RCM_Main.physicsWorld.unloadCollisionShapes(rcentity.field_70170_p, this.entity);
                    RCM_Main.physicsWorld.loadCollisionShapes(rcentity, rcentity.field_70170_p, rcentity.position);
                    rcentity.physicsWorld.requestCollisionShapes = false;
                }
                size = this.entity.size();
            }
            if (deltaTime > 0.016666668f) {
                float stepTime;
                if (deltaTime > 0.05f) {
                    deltaTime = 0.05f;
                }
                do {
                    if ((stepTime = 0.016666668f) > deltaTime) {
                        stepTime = deltaTime;
                    }
                    for (int i2 = 0; i2 < size; ++i2) {
                        GlobalEntity rcentity3 = this.entity.get(i2);
                        if (rcentity3.physicsWorld != null && rcentity3 != null && !rcentity3.field_70128_L && !Minecraft.func_71410_x().func_147113_T()) {
                            rcentity3.physicsWorld.update(rcentity3, deltaTime);
                        }
                        size = this.entity.size();
                    }
                    RCM_Main.physicsWorld.stepSimulation(stepTime, maxSimSubSteps);
                } while ((deltaTime -= stepTime) > 0.0f);
            } else {
                for (i = 0; i < size; ++i) {
                    rcentity = this.entity.get(i);
                    if (rcentity.physicsWorld != null && rcentity != null && !rcentity.field_70128_L && !Minecraft.func_71410_x().func_147113_T()) {
                        rcentity.physicsWorld.update(rcentity, deltaTime);
                    }
                    size = this.entity.size();
                }
                RCM_Main.physicsWorld.stepSimulation(deltaTime, maxSimSubSteps);
            }
        }
    }

    public void register(GlobalEntity rcentity) {
        boolean flag = false;
        for (GlobalEntity en : register) {
            if (en != rcentity) continue;
            flag = true;
        }
        if (!flag) {
            register.add(rcentity);
        }
    }

    public void deRegister(GlobalEntity rcentity) {
        boolean flag = false;
        for (GlobalEntity en : deRegister) {
            if (en != rcentity) continue;
            flag = true;
        }
        if (!flag) {
            deRegister.add(rcentity);
        }
    }

    private float getDeltaTimeMicroseconds() {
        float dt = this.clock.getTimeMicroseconds();
        this.clock.reset();
        return dt;
    }
}

