/*
 * Decompiled with CFR 0.152.
 */
package RCM.Physics;

import RCM.Entities.GlobalEntity;
import com.bulletphysics.collision.broadphase.BroadphaseInterface;
import com.bulletphysics.collision.broadphase.DbvtBroadphase;
import com.bulletphysics.collision.broadphase.Dispatcher;
import com.bulletphysics.collision.dispatch.CollisionConfiguration;
import com.bulletphysics.collision.dispatch.CollisionDispatcher;
import com.bulletphysics.collision.dispatch.DefaultCollisionConfiguration;
import com.bulletphysics.collision.shapes.BoxShape;
import com.bulletphysics.collision.shapes.CollisionShape;
import com.bulletphysics.dynamics.DiscreteDynamicsWorld;
import com.bulletphysics.dynamics.DynamicsWorld;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.RigidBodyConstructionInfo;
import com.bulletphysics.dynamics.constraintsolver.ConstraintSolver;
import com.bulletphysics.dynamics.constraintsolver.SequentialImpulseConstraintSolver;
import com.bulletphysics.dynamics.vehicle.RaycastVehicle;
import com.bulletphysics.linearmath.DefaultMotionState;
import com.bulletphysics.linearmath.MotionState;
import com.bulletphysics.linearmath.Transform;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class PhysicsWorld {
    private DynamicsWorld dynamicsWorld;
    private Set<RigidBody> collisionBlocks = new HashSet<RigidBody>();
    private Set<RigidBody> collisionEntities = new HashSet<RigidBody>();
    private Set<RigidBody> rigidbodies = new HashSet<RigidBody>();
    private Set<RaycastVehicle> vehicles = new HashSet<RaycastVehicle>();
    private Vector3f vSampleSize = new Vector3f(1.0f, 1.0f, 1.0f);
    private int sampleSize = 1;

    public PhysicsWorld() {
        float gravity = -9.81f;
        DbvtBroadphase broadphase = new DbvtBroadphase();
        DefaultCollisionConfiguration collisionConfiguration = new DefaultCollisionConfiguration();
        CollisionDispatcher dispatcher = new CollisionDispatcher((CollisionConfiguration)collisionConfiguration);
        SequentialImpulseConstraintSolver solver = new SequentialImpulseConstraintSolver();
        this.dynamicsWorld = new DiscreteDynamicsWorld((Dispatcher)dispatcher, (BroadphaseInterface)broadphase, (ConstraintSolver)solver, (CollisionConfiguration)collisionConfiguration);
        this.dynamicsWorld.setGravity(new Vector3f(0.0f, gravity, 0.0f));
    }

    public void stepSimulation(float deltaTime, int maxSubSteps) {
        this.dynamicsWorld.stepSimulation(deltaTime, maxSubSteps);
    }

    public void addRigidBody(RigidBody entityBody) {
        this.dynamicsWorld.addRigidBody(entityBody);
        this.rigidbodies.add(entityBody);
    }

    public void removeRigidBody(RigidBody entityBody) {
        this.dynamicsWorld.removeRigidBody(entityBody);
        this.rigidbodies.remove(entityBody);
    }

    public void addVehicle(RaycastVehicle vehicle) {
        this.dynamicsWorld.addVehicle(vehicle);
        this.vehicles.add(vehicle);
    }

    public void removeVehicle(RaycastVehicle vehicle) {
        this.dynamicsWorld.removeVehicle(vehicle);
        this.vehicles.remove(vehicle);
    }

    public DynamicsWorld getDynamicsWorld() {
        return this.dynamicsWorld;
    }

    public void removeAll() {
        for (RaycastVehicle rv : this.vehicles) {
            this.dynamicsWorld.removeVehicle(rv);
        }
        for (RigidBody rb : this.rigidbodies) {
            this.dynamicsWorld.removeRigidBody(rb);
        }
    }

    public void loadCollisionShapes(GlobalEntity entity, World world, Vector3f position) {
        boolean flag = false;
        Vector3f minAABB = new Vector3f(position);
        Vector3f maxAABB = new Vector3f(position);
        minAABB.sub((Tuple3f)this.vSampleSize);
        maxAABB.add((Tuple3f)this.vSampleSize);
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)minAABB.x, (double)minAABB.y, (double)minAABB.z, (double)maxAABB.x, (double)maxAABB.y, (double)maxAABB.z);
        List blocks = world.func_72945_a((Entity)entity, aabb);
        Iterator iterator = blocks.iterator();
        while (iterator.hasNext()) {
            AxisAlignedBB obj;
            AxisAlignedBB boxAABB = obj = (AxisAlignedBB)iterator.next();
            Vector3f newBoxPos = new Vector3f(((float)boxAABB.field_72336_d + (float)boxAABB.field_72340_a) / 2.0f, ((float)boxAABB.field_72337_e + (float)boxAABB.field_72338_b) / 2.0f, ((float)boxAABB.field_72334_f + (float)boxAABB.field_72339_c) / 2.0f);
            if (!this.isSideBlock(world, newBoxPos)) {
                flag = true;
            } else {
                for (RigidBody collisionBox : this.collisionBlocks) {
                    Vector3f boxPosition = collisionBox.getMotionState().getWorldTransform((Transform)new Transform()).origin;
                    if (boxPosition.x != newBoxPos.x || boxPosition.y != newBoxPos.y || boxPosition.z != newBoxPos.z) continue;
                    flag = true;
                }
            }
            if (!flag) {
                Vector3f boxSize = new Vector3f(((float)boxAABB.field_72336_d - (float)boxAABB.field_72340_a) / 2.0f, ((float)boxAABB.field_72337_e - (float)boxAABB.field_72338_b) / 2.0f, ((float)boxAABB.field_72334_f - (float)boxAABB.field_72339_c) / 2.0f);
                BoxShape groundBlock = new BoxShape(boxSize);
                Transform startTransform = new Transform();
                startTransform.setIdentity();
                startTransform.origin.set((Tuple3f)newBoxPos);
                DefaultMotionState groundMotionState = new DefaultMotionState(startTransform);
                RigidBodyConstructionInfo groundBodyConstructionInfo = new RigidBodyConstructionInfo(0.0f, (MotionState)groundMotionState, (CollisionShape)groundBlock, new Vector3f(0.0f, 0.0f, 0.0f));
                RigidBody groundRigidBody = new RigidBody(groundBodyConstructionInfo);
                this.dynamicsWorld.addRigidBody(groundRigidBody);
                this.collisionBlocks.add(groundRigidBody);
            }
            flag = false;
        }
    }

    private boolean isSideBlock(World world, Vector3f pos) {
        int i = 0;
        int j = 0;
        int k = 0;
        for (int n = 0; n < 6; ++n) {
            switch (n) {
                case 0: {
                    i = MathHelper.func_76128_c((double)(pos.x + 1.0f));
                    j = MathHelper.func_76128_c((double)pos.y);
                    k = MathHelper.func_76128_c((double)pos.z);
                    break;
                }
                case 1: {
                    i = MathHelper.func_76128_c((double)(pos.x - 1.0f));
                    j = MathHelper.func_76128_c((double)pos.y);
                    k = MathHelper.func_76128_c((double)pos.z);
                    break;
                }
                case 2: {
                    i = MathHelper.func_76128_c((double)pos.x);
                    j = MathHelper.func_76128_c((double)(pos.y + 1.0f));
                    k = MathHelper.func_76128_c((double)pos.z);
                    break;
                }
                case 3: {
                    i = MathHelper.func_76128_c((double)pos.x);
                    j = MathHelper.func_76128_c((double)(pos.y - 1.0f));
                    k = MathHelper.func_76128_c((double)pos.z);
                    break;
                }
                case 4: {
                    i = MathHelper.func_76128_c((double)pos.x);
                    j = MathHelper.func_76128_c((double)pos.y);
                    k = MathHelper.func_76128_c((double)(pos.z + 1.0f));
                    break;
                }
                case 5: {
                    i = MathHelper.func_76128_c((double)pos.x);
                    j = MathHelper.func_76128_c((double)pos.y);
                    k = MathHelper.func_76128_c((double)(pos.z - 1.0f));
                    break;
                }
            }
            Block bk = world.func_147439_a(i, j, k);
            if (bk.func_149688_o().func_76220_a()) continue;
            return true;
        }
        return false;
    }

    public void unloadCollisionShapes(World world, List<GlobalEntity> entityList) {
        HashSet<RigidBody> toRemoveColBox = new HashSet<RigidBody>();
        for (RigidBody collisionBks : this.collisionBlocks) {
            boolean flag = false;
            Vector3f boxPosition = collisionBks.getMotionState().getWorldTransform((Transform)new Transform()).origin;
            for (GlobalEntity entity : entityList) {
                int metaData;
                int k;
                int j;
                Vector3f dist = new Vector3f(entity.position);
                dist.sub((Tuple3f)boxPosition);
                if (!(dist.length() <= (float)(this.sampleSize + 1))) continue;
                flag = true;
                int i = MathHelper.func_76128_c((double)boxPosition.x);
                Block block = world.func_147439_a(i, j = MathHelper.func_76128_c((double)boxPosition.y), k = MathHelper.func_76128_c((double)boxPosition.z));
                if (block.func_149678_a(metaData = world.func_72805_g(i, j, k), flag)) continue;
                flag = false;
            }
            if (flag) continue;
            toRemoveColBox.add(collisionBks);
        }
        for (RigidBody colBox : toRemoveColBox) {
            this.dynamicsWorld.removeRigidBody(colBox);
            this.collisionBlocks.remove(colBox);
        }
        toRemoveColBox.clear();
    }
}

