/*
 * Decompiled with CFR 0.152.
 */
package RCM.Physics;

import javax.vecmath.Vector3f;

public class RocketMotorHandler {
    private float maxThrust;
    private float burnTime;
    private float speedReference;
    private boolean activated;

    public RocketMotorHandler(float mThrust, float bt) {
        this.maxThrust = mThrust;
        this.burnTime = bt;
        this.speedReference = 60.0f;
        this.activated = false;
    }

    public Vector3f getThurstVect(Vector3f forward, float velocity, float bt) {
        if (this.burnTime > 0.0f && this.activated) {
            this.burnTime -= bt;
            Vector3f thrust = new Vector3f(forward);
            thrust.scale(this.maxThrust * ((this.speedReference - velocity) / this.speedReference));
            return thrust;
        }
        return new Vector3f();
    }

    public void setActive() {
        this.activated = true;
    }

    public boolean isActive() {
        return this.burnTime > 0.0f && this.activated;
    }
}

