/*
 * Decompiled with CFR 0.152.
 */
package RCM.Physics;

import RCM.Physics.WingHandler;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class RotaryWingHandler
extends WingHandler {
    private float inertia;
    private float rotationalVel;
    private float rotationAngle;
    private float prevRotationAngle;
    private float gearRatio;

    public RotaryWingHandler(int propID2, float mass2, float ratio2, float eqFactor2, Vector3f spanVec2, Vector3f liftVec2, Vector3f chordVec2, Vector3f pos2, float spanOffset2, float wingArea2, float wingSpan2, float rootChord2, float tipChord2, float def2, float defOffset2, int profileType, int channel, int sect, int sensorID) {
        super(propID2, spanVec2, liftVec2, chordVec2, pos2, spanOffset2, wingArea2, wingSpan2, rootChord2, tipChord2, def2, defOffset2, profileType, channel, sect, eqFactor2, sensorID);
        this.inertia = mass2 * wingSpan2 * wingSpan2 / 3.0f;
        this.gearRatio = ratio2;
    }

    public float getTroque() {
        float torque = 0.0f;
        Vector3f forceSum = new Vector3f();
        Vector3f torqueVect = new Vector3f();
        Vector3f torqueDir = new Vector3f();
        torqueDir.cross(this.globalSpanVect, this.globalChordVect);
        for (int i = 0; i < this.getSections(); ++i) {
            forceSum.set((Tuple3f)this.getLift(i));
            forceSum.add((Tuple3f)this.getDrag(i));
            torqueVect.cross(forceSum, this.getPosition(i));
            torque += torqueVect.dot(torqueDir);
        }
        return torque * this.gearRatio;
    }

    public float getInertia() {
        return this.inertia * this.gearRatio * this.gearRatio * this.eqFactor;
    }

    public void setAngularVelocity(float angularVel) {
        this.angularVelocity = angularVel * this.gearRatio;
    }

    @Override
    public float getAngularVelocity() {
        return this.angularVelocity;
    }

    public void setRotationAngle(float deltaTime) {
        this.prevRotationAngle = this.rotationAngle;
        this.rotationAngle += this.angularVelocity * deltaTime * this.helper.radToDeg;
        if ((double)this.rotationAngle > 1.0E31) {
            this.rotationAngle = 0.0f;
        }
    }

    public float getRotationAngle() {
        return this.rotationAngle;
    }

    public float getPrevRotationAngle() {
        return this.prevRotationAngle;
    }
}

