/*
 * Decompiled with CFR 0.152.
 */
package RCM.Physics;

import RCM.Physics.PhysicsHelper;
import RCM.RCM_Main;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class WingHandler {
    public PhysicsHelper helper;
    public Vector3f localSpanVect;
    public Vector3f localLiftVect;
    public Vector3f localChordVect;
    public Vector3f localPositionVect;
    public Vector3f propellerVel;
    public Vector3f globalLiftVect;
    public Vector3f globalSpanVect;
    public Vector3f globalChordVect;
    public Vector3f globalPosition;
    private float lift;
    private float drag;
    private float spanOffset;
    private float span;
    private float forcePos;
    private float profileType;
    private float def;
    private float defOffset;
    private float forceLimit;
    private float bladeTorque;
    private float sectionSpan;
    private float propAngle;
    private float prevPropAngle;
    public float angularVelocity;
    public float eqFactor;
    private int sections;
    private int profile;
    private int channel;
    private int ID;
    private int sensorID;
    private float[] sectionAreas;
    private float[] sectionChord;
    private float[] sectionPos;
    private float[] sectionVel;
    private float[] sectionVelSq;
    private float[] sectionDownWash;
    private float[] sectionCoeffLift;
    private float[] sectionGeoAoA;
    private List<Vector3f> sectionVelVect = new ArrayList<Vector3f>();
    private List<Vector3f> sectionLift = new ArrayList<Vector3f>();
    private List<Vector3f> sectionDrag = new ArrayList<Vector3f>();
    private List<Vector3f> sectionMoment = new ArrayList<Vector3f>();
    private List<Vector3f> sectionPosVect = new ArrayList<Vector3f>();

    public WingHandler(int wingID2, Vector3f spanVec2, Vector3f liftVec2, Vector3f chordVec2, Vector3f pos2, float spanOffset2, float wingArea2, float wingSpan2, float rootChord2, float tipChord2, float def2, float defOffset2, int profileType, int channel2, int sect, float eqFactor2, int sensorID2) {
        this.helper = new PhysicsHelper();
        this.ID = wingID2;
        this.sections = sect;
        this.globalSpanVect = new Vector3f();
        this.globalLiftVect = new Vector3f();
        this.globalChordVect = new Vector3f();
        this.globalPosition = new Vector3f();
        this.localSpanVect = new Vector3f(spanVec2);
        this.localLiftVect = new Vector3f(liftVec2);
        this.localChordVect = new Vector3f(chordVec2);
        this.localPositionVect = new Vector3f(pos2);
        this.spanOffset = spanOffset2;
        this.span = wingSpan2;
        this.def = def2 * this.helper.degToRad;
        this.defOffset = defOffset2 * this.helper.degToRad;
        this.sectionSpan = (wingSpan2 - this.spanOffset) / (float)this.sections;
        this.sectionAreas = new float[this.sections];
        this.sectionChord = new float[this.sections];
        this.sectionPos = new float[this.sections];
        this.sectionVelSq = new float[this.sections];
        this.sectionVel = new float[this.sections];
        this.sectionDownWash = new float[this.sections];
        this.sectionCoeffLift = new float[this.sections];
        this.sectionGeoAoA = new float[this.sections];
        this.profile = profileType;
        this.channel = channel2;
        this.eqFactor = eqFactor2;
        this.sensorID = sensorID2;
        this.forceLimit = 100.0f;
        this.calculateWingSectionProperties(wingArea2, rootChord2, tipChord2);
    }

    private void calculateWingSectionProperties(float totalArea, float root, float tip) {
        int i;
        float sectionSpanPos = this.sectionSpan / 2.0f;
        float sectionChordSum = 0.0f;
        for (i = 0; i < this.sections; ++i) {
            float sectChord;
            this.sectionPos[i] = sectionSpanPos + this.spanOffset;
            this.sectionChord[i] = sectChord = root - (root - tip) * sectionSpanPos / (this.span - this.spanOffset);
            sectionChordSum += sectChord;
            sectionSpanPos += this.sectionSpan;
            this.sectionVelVect.add(new Vector3f());
            this.sectionLift.add(new Vector3f());
            this.sectionDrag.add(new Vector3f());
            this.sectionPosVect.add(new Vector3f());
            this.sectionMoment.add(new Vector3f());
        }
        for (i = 0; i < this.sections; ++i) {
            this.sectionAreas[i] = totalArea * this.sectionChord[i] / sectionChordSum;
        }
    }

    public void update(Quat4f localQuat, Vector3f linearVel, Vector3f rotationalVel, float density, float angle) {
        this.globalSpanVect.set((Tuple3f)this.helper.rotateVector(localQuat, this.localSpanVect));
        this.globalLiftVect.set((Tuple3f)this.helper.rotateVector(localQuat, this.localLiftVect));
        this.globalChordVect.set((Tuple3f)this.helper.rotateVector(localQuat, this.localChordVect));
        this.globalPosition.set((Tuple3f)this.helper.rotateVector(localQuat, this.localPositionVect));
        Quat4f deflection = new Quat4f();
        this.prevPropAngle = this.propAngle;
        this.propAngle = this.defOffset + angle * this.def;
        deflection.set(new AxisAngle4f(this.globalSpanVect, this.propAngle));
        Vector3f deflLift = new Vector3f(this.helper.rotateVector(deflection, this.globalLiftVect));
        Vector3f deflChord = new Vector3f(this.globalSpanVect);
        deflChord.cross(deflChord, deflLift);
        if (deflChord.dot(this.globalChordVect) < 0.0f) {
            deflChord.scale(-1.0f);
        }
        Vector3f downWashVect = new Vector3f();
        Vector3f liftVect = new Vector3f();
        Vector3f dragVect = new Vector3f();
        Vector3f momentVect = new Vector3f();
        for (int i = 0; i < this.sections; ++i) {
            Vector3f sectionVect = new Vector3f(this.globalSpanVect);
            sectionVect.scale(this.sectionPos[i]);
            sectionVect.add((Tuple3f)this.globalPosition);
            this.sectionPosVect.get(i).set((Tuple3f)sectionVect);
            float propRotVel = this.sectionPos[i] * -this.angularVelocity;
            this.sectionVelVect.get(i).set((Tuple3f)this.globalChordVect);
            this.sectionVelVect.get(i).scale(propRotVel);
            this.sectionVelVect.get(i).add((Tuple3f)this.helper.getVelocityAtPoint(linearVel, rotationalVel, sectionVect));
            this.sectionVelVect.get(i).scale(-1.0f);
            Vector3f spanVel = new Vector3f(this.globalSpanVect);
            float spanVelComp = this.sectionVelVect.get(i).dot(spanVel);
            spanVel.scale(spanVelComp);
            this.sectionVelVect.get(i).sub((Tuple3f)spanVel);
            this.sectionVel[i] = this.sectionVelVect.get(i).length();
            this.sectionVelSq[i] = this.sectionVel[i] * this.sectionVel[i];
            this.sectionGeoAoA[i] = this.helper.getAoA(deflChord, deflLift, this.sectionVelVect.get(i));
            float spanLoc = this.sectionPos[i] / this.span;
            float effectiveAoA = 0.0f;
            float zeroLiftOffset = 0.0f;
            if (this.profile == 3) {
                zeroLiftOffset = 5.27f * this.helper.degToRad;
            }
            float AoA = this.sectionGeoAoA[i] + zeroLiftOffset;
            float inducedAoA = 0.0f;
            if (this.sectionGeoAoA[i] > 1.570796f) {
                AoA = (float)Math.PI - this.sectionGeoAoA[i] - zeroLiftOffset;
            } else if (this.sectionGeoAoA[i] < -1.570796f) {
                AoA = (float)(-Math.PI) - this.sectionGeoAoA[i] - zeroLiftOffset;
            }
            effectiveAoA = spanLoc <= 0.4183f ? AoA * (1.0f - 0.3782f * spanLoc) : AoA * (float)Math.sqrt(0.81f - (spanLoc - 0.1f) * (spanLoc - 0.1f));
            inducedAoA = AoA - effectiveAoA;
            this.sectionDownWash[i] = this.sectionVel[i] * (float)Math.tan(inducedAoA);
            effectiveAoA -= zeroLiftOffset;
            if (this.sectionGeoAoA[i] > 1.570796f) {
                effectiveAoA = (float)Math.PI - effectiveAoA;
            } else if (this.sectionGeoAoA[i] < -1.570796f) {
                effectiveAoA = (float)(-Math.PI) - effectiveAoA;
            }
            effectiveAoA *= this.helper.radToDeg;
            if (effectiveAoA > 180.0f) {
                effectiveAoA -= 360.0f;
            }
            if (effectiveAoA < -180.0f) {
                effectiveAoA += 360.0f;
            }
            float wingLiftCoef = 0.0f;
            switch (this.profile) {
                case 1: {
                    wingLiftCoef = RCM_Main.aerofoilProperties.getThinPlateCl(effectiveAoA);
                    break;
                }
                case 2: {
                    wingLiftCoef = RCM_Main.aerofoilProperties.getNaca12Cl(effectiveAoA);
                    break;
                }
                case 3: {
                    wingLiftCoef = RCM_Main.aerofoilProperties.getClarkYCl(effectiveAoA);
                    break;
                }
            }
            float lift = 0.5f * density * this.sectionVelSq[i] * wingLiftCoef * this.sectionAreas[i];
            downWashVect.cross(this.sectionVelVect.get(i), this.globalSpanVect);
            if (downWashVect.dot(deflLift) > 0.0f) {
                downWashVect.scale(-1.0f);
            }
            if (downWashVect.length() > 0.0f) {
                downWashVect.normalize();
            }
            downWashVect.scale(this.sectionDownWash[i]);
            liftVect.set((Tuple3f)this.sectionVelVect.get(i));
            liftVect.add((Tuple3f)downWashVect);
            if (liftVect.length() > 0.0f) {
                liftVect.normalize();
            }
            this.sectionLift.get(i).cross(liftVect, this.globalSpanVect);
            if (this.sectionLift.get(i).dot(deflLift) < 0.0f) {
                this.sectionLift.get(i).scale(-1.0f);
            }
            if (this.sectionLift.get(i).length() > 0.0f) {
                this.sectionLift.get(i).normalize();
            }
            this.sectionLift.get(i).scale(lift * this.eqFactor);
            float profileDragCoef = 0.0f;
            float profileMoment = 0.0f;
            float AoA2 = this.sectionGeoAoA[i] * this.helper.radToDeg;
            switch (this.profile) {
                case 1: {
                    profileDragCoef = RCM_Main.aerofoilProperties.getThinPlateCd(AoA2);
                    profileMoment = RCM_Main.aerofoilProperties.getThinPlateCm(AoA2);
                    break;
                }
                case 2: {
                    profileDragCoef = RCM_Main.aerofoilProperties.getNaca12Cd(AoA2);
                    profileMoment = RCM_Main.aerofoilProperties.getNaca12Cm(AoA2);
                    break;
                }
                case 3: {
                    profileDragCoef = RCM_Main.aerofoilProperties.getClarkYCd(AoA2);
                    profileMoment = RCM_Main.aerofoilProperties.getClarkYCm(AoA2);
                    break;
                }
            }
            float drag = 0.5f * density * this.sectionVelSq[i] * profileDragCoef * this.sectionAreas[i];
            float moment = 0.5f * density * this.sectionVelSq[i] * profileMoment * this.sectionAreas[i];
            dragVect.set((Tuple3f)this.sectionVelVect.get(i));
            momentVect.cross(deflChord, deflLift);
            if (dragVect.length() > 0.0f) {
                dragVect.normalize();
            }
            dragVect.scale(drag * this.eqFactor);
            momentVect.scale(moment * this.eqFactor);
            this.sectionDrag.get(i).set((Tuple3f)dragVect);
            this.sectionMoment.get(i).set((Tuple3f)momentVect);
        }
    }

    public float getPropAngle() {
        return this.propAngle;
    }

    public float getPrevPropAngle() {
        return this.prevPropAngle;
    }

    public Vector3f getLift(int i) {
        return this.sectionLift.get(i);
    }

    public Vector3f getDrag(int i) {
        return this.sectionDrag.get(i);
    }

    public Vector3f getMoment(int i) {
        return this.sectionMoment.get(i);
    }

    public Vector3f getPosition(int i) {
        return this.sectionPosVect.get(i);
    }

    public float getAngularVelocity() {
        return this.angularVelocity;
    }

    public int getChannel() {
        return this.channel;
    }

    public int getSections() {
        return this.sections;
    }

    public int getID() {
        return this.ID;
    }

    public Vector3f getPosition() {
        return this.localPositionVect;
    }

    public int getSensorID() {
        return this.sensorID;
    }

    public float getTipAoA() {
        return this.sectionGeoAoA[this.sections - 1] * this.helper.radToDeg;
    }
}

