/*
 * Decompiled with CFR 0.152.
 */
package RCM.PropertiesLoader;

import RCM.PropertiesLoader.AutoControlProperties;
import RCM.PropertiesLoader.MotorProperties;
import RCM.PropertiesLoader.RocketMotorProperties;
import RCM.PropertiesLoader.RotaryWingProperties;
import RCM.PropertiesLoader.WheelProperties;
import RCM.PropertiesLoader.WingProperties;
import RCM.RCM_Main;
import com.bulletphysics.collision.shapes.BoxShape;
import com.bulletphysics.collision.shapes.CompoundShape;
import com.bulletphysics.collision.shapes.CylinderShape;
import com.bulletphysics.linearmath.Transform;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class PropertiesLoader {
    private CompoundShape entityShape;
    private float[] propteries = new float[9];
    private String fileName;
    private Vector3f inertia;
    private List<MotorProperties> motors = new ArrayList<MotorProperties>();
    private List<WheelProperties> wheels = new ArrayList<WheelProperties>();
    private List<WingProperties> wings = new ArrayList<WingProperties>();
    private List<RotaryWingProperties> rotaryWings = new ArrayList<RotaryWingProperties>();
    private List<AutoControlProperties> sensors = new ArrayList<AutoControlProperties>();
    private List<Vector3f> attachments = new ArrayList<Vector3f>();
    private List<RocketMotorProperties> RocketMotors = new ArrayList<RocketMotorProperties>();
    private float dragFactor;
    private float inertiaScaleFactor;

    public void init(String name) throws FileNotFoundException, IOException {
        String line;
        this.fileName = name;
        this.entityShape = new CompoundShape();
        this.inertia = new Vector3f();
        URL url = this.getClass().getResource(RCM_Main.propertiesFilePath + name);
        InputStream inputstream = url.openStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream));
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("Total_mass: ")) {
                this.propteries[0] = Float.valueOf(line.split(" ")[1]).floatValue();
                continue;
            }
            if (line.startsWith("Drag_factor: ")) {
                this.dragFactor = Float.valueOf(line.split(" ")[1]).floatValue();
                continue;
            }
            if (line.startsWith("Inertia_scale_factor: ")) {
                this.inertiaScaleFactor = Float.valueOf(line.split(" ")[1]).floatValue();
                continue;
            }
            if (line.startsWith("Collision_shapes: ")) {
                this.propteries[1] = Integer.valueOf(line.split(" ")[1]).intValue();
                continue;
            }
            if (line.startsWith("Motor_number: ")) {
                this.propteries[2] = Integer.valueOf(line.split(" ")[1]).intValue();
                continue;
            }
            if (line.startsWith("Wheel_number: ")) {
                this.propteries[3] = Integer.valueOf(line.split(" ")[1]).intValue();
                continue;
            }
            if (line.startsWith("Wing_number: ")) {
                this.propteries[4] = Integer.valueOf(line.split(" ")[1]).intValue();
                continue;
            }
            if (line.startsWith("Propeller_number: ")) {
                this.propteries[5] = Integer.valueOf(line.split(" ")[1]).intValue();
                continue;
            }
            if (line.startsWith("Sensor_number: ")) {
                this.propteries[6] = Integer.valueOf(line.split(" ")[1]).intValue();
                continue;
            }
            if (line.startsWith("Attachment_number: ")) {
                this.propteries[7] = Integer.valueOf(line.split(" ")[1]).intValue();
                break;
            }
            if (!line.startsWith("Rocket_motor_number: ")) continue;
            this.propteries[8] = Integer.valueOf(line.split(" ")[1]).intValue();
            break;
        }
        reader.close();
        this.loadCollisionModel();
        this.loadMotors();
        this.loadWheels();
        this.loadWings();
        this.loadRotaryWings();
        this.loadAutoControllers();
        this.loadMissiles();
        this.loadRocketMotors();
    }

    private void loadCollisionModel() throws FileNotFoundException, IOException {
        BoxShape shape = null;
        Transform shapeTrans = new Transform();
        URL url = null;
        InputStream inputstream = null;
        BufferedReader reader = null;
        int i = 1;
        while ((float)i <= this.propteries[1]) {
            String line;
            url = this.getClass().getResource(RCM_Main.propertiesFilePath + this.fileName);
            inputstream = url.openStream();
            reader = new BufferedReader(new InputStreamReader(inputstream));
            shapeTrans.setIdentity();
            while ((line = reader.readLine()) != null) {
                float z;
                float y;
                float x;
                if (line.startsWith("ShapeB_" + i + ": ")) {
                    x = Float.valueOf(line.split(" ")[1]).floatValue();
                    y = Float.valueOf(line.split(" ")[2]).floatValue();
                    z = Float.valueOf(line.split(" ")[3]).floatValue();
                    Vector3f sShape = new Vector3f(x, y, z);
                    shape = new BoxShape(sShape);
                    continue;
                }
                if (line.startsWith("ShapeC_" + i + ": ")) {
                    x = Float.valueOf(line.split(" ")[1]).floatValue();
                    y = Float.valueOf(line.split(" ")[2]).floatValue();
                    z = Float.valueOf(line.split(" ")[3]).floatValue();
                    Vector3f sShape = new Vector3f(x, y, z);
                    shape = new CylinderShape(sShape);
                    continue;
                }
                if (line.startsWith("Shape_rotation_" + i + ": ")) {
                    x = Float.valueOf(line.split(" ")[1]).floatValue();
                    y = Float.valueOf(line.split(" ")[2]).floatValue();
                    z = Float.valueOf(line.split(" ")[3]).floatValue();
                    float w = Float.valueOf(line.split(" ")[4]).floatValue();
                    shapeTrans.setRotation(new Quat4f(x, y, z, w));
                    continue;
                }
                if (!line.startsWith("Shape_position_" + i + ": ")) continue;
                x = Float.valueOf(line.split(" ")[1]).floatValue();
                y = Float.valueOf(line.split(" ")[2]).floatValue();
                z = Float.valueOf(line.split(" ")[3]).floatValue();
                Vector3f sOrigin = new Vector3f(x, y, z);
                shapeTrans.origin.set((Tuple3f)sOrigin);
                break;
            }
            reader.close();
            this.entityShape.addChildShape(shapeTrans, shape);
            ++i;
        }
        Vector3f entityInertia = new Vector3f(0.0f, 0.0f, 0.0f);
        this.entityShape.calculateLocalInertia(this.propteries[0], this.inertia);
        this.inertia.scale(this.inertiaScaleFactor);
    }

    private void loadMotors() throws FileNotFoundException, IOException {
        if (this.propteries[2] > 0.0f) {
            URL url = null;
            InputStream inputstream = null;
            BufferedReader reader = null;
            float motorMass = 0.0f;
            float motorDiameter = 0.0f;
            float motorPower = 0.0f;
            float motorTorqueLimit = 0.0f;
            int controlChannel = 0;
            int motorID = 0;
            int i = 1;
            while ((float)i <= this.propteries[2]) {
                String line;
                url = this.getClass().getResource(RCM_Main.propertiesFilePath + this.fileName);
                inputstream = url.openStream();
                reader = new BufferedReader(new InputStreamReader(inputstream));
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("Motor_ID_" + i + ": ")) {
                        motorID = Integer.valueOf(line.split(" ")[1]);
                        continue;
                    }
                    if (line.startsWith("Motor_mass_" + i + ": ")) {
                        motorMass = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Motor_diameter_" + i + ": ")) {
                        motorDiameter = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Motor_power_" + i + ": ")) {
                        motorPower = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Motor_torque_limit_" + i + ": ")) {
                        motorTorqueLimit = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (!line.startsWith("Motor_control_channel_" + i + ": ")) continue;
                    controlChannel = Integer.valueOf(line.split(" ")[1]);
                    break;
                }
                this.motors.add(new MotorProperties(motorID, motorMass, motorDiameter, motorPower, motorTorqueLimit, controlChannel));
                reader.close();
                ++i;
            }
        }
    }

    private void loadWheels() throws FileNotFoundException, IOException {
        if (this.propteries[3] > 0.0f) {
            Vector3f wheelDirection = null;
            Vector3f wheelAxle = null;
            Vector3f connectionPoint = null;
            int wheelID = 0;
            int controlChannel = 0;
            float wheelOffset = 0.0f;
            float radius = 0.0f;
            float frictionSlip = 0.0f;
            float brakeForce = 0.0f;
            boolean canTurn = false;
            float rollInfluence = 0.0f;
            float suspensionStiffness = 0.0f;
            float suspensionDamping = 0.0f;
            float suspensionCompression = 0.0f;
            float suspensionRestLength = 0.0f;
            float wheelTurn = 0.0f;
            int i = 1;
            while ((float)i <= this.propteries[3]) {
                String line;
                URL url = this.getClass().getResource(RCM_Main.propertiesFilePath + this.fileName);
                InputStream inputstream = url.openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream));
                while ((line = reader.readLine()) != null) {
                    float z;
                    float y;
                    float x;
                    if (line.startsWith("Wheel_ID_" + i + ": ")) {
                        wheelID = Integer.valueOf(line.split(" ")[1]);
                        continue;
                    }
                    if (line.startsWith("Wheel_direction_" + i + ": ")) {
                        x = Float.valueOf(line.split(" ")[1]).floatValue();
                        y = Float.valueOf(line.split(" ")[2]).floatValue();
                        z = Float.valueOf(line.split(" ")[3]).floatValue();
                        wheelDirection = new Vector3f(x, y, z);
                        continue;
                    }
                    if (line.startsWith("Wheel_axle_" + i + ": ")) {
                        x = Float.valueOf(line.split(" ")[1]).floatValue();
                        y = Float.valueOf(line.split(" ")[2]).floatValue();
                        z = Float.valueOf(line.split(" ")[3]).floatValue();
                        wheelAxle = new Vector3f(x, y, z);
                        continue;
                    }
                    if (line.startsWith("Wheel_position_" + i + ": ")) {
                        x = Float.valueOf(line.split(" ")[1]).floatValue();
                        y = Float.valueOf(line.split(" ")[2]).floatValue();
                        z = Float.valueOf(line.split(" ")[3]).floatValue();
                        connectionPoint = new Vector3f(x, y, z);
                        continue;
                    }
                    if (line.startsWith("Wheel_offset_" + i + ": ")) {
                        wheelOffset = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Wheel_radius_" + i + ": ")) {
                        radius = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Wheel_steerable_" + i + ": ")) {
                        canTurn = Boolean.valueOf(line.split(" ")[1]);
                        continue;
                    }
                    if (line.startsWith("Wheel_friction_" + i + ": ")) {
                        frictionSlip = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Wheel_brake_" + i + ": ")) {
                        brakeForce = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Wheel_roll_influence_" + i + ": ")) {
                        rollInfluence = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Wheel_suspension_stiffness_" + i + ": ")) {
                        suspensionStiffness = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Wheel_suspension_damping_" + i + ": ")) {
                        suspensionDamping = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Wheel_suspension_compression_" + i + ": ")) {
                        suspensionCompression = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Wheel_suspension_rest_length_" + i + ": ")) {
                        suspensionRestLength = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Wheel_max_turn_" + i + ": ")) {
                        wheelTurn = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (!line.startsWith("Wheel_control_channel_" + i + ": ")) continue;
                    controlChannel = Integer.valueOf(line.split(" ")[1]);
                    break;
                }
                this.wheels.add(new WheelProperties(wheelID, connectionPoint, wheelDirection, wheelAxle, wheelOffset, suspensionRestLength, radius, frictionSlip, rollInfluence, suspensionStiffness, suspensionDamping, suspensionCompression, brakeForce, canTurn, wheelTurn, controlChannel));
                reader.close();
                ++i;
            }
        }
    }

    private void loadWings() throws FileNotFoundException, IOException {
        if (this.propteries[4] > 0.0f) {
            Vector3f spanVec = null;
            Vector3f liftVec = null;
            Vector3f chordVec = null;
            Vector3f position = null;
            int wingID = 0;
            float area = 0.0f;
            float span = 0.0f;
            float root = 0.0f;
            float tip = 0.0f;
            float def = 0.0f;
            float defOffset = 0.0f;
            int profileType = 0;
            int channel = 0;
            int sensorID = 0;
            int sections = 1;
            URL url = null;
            InputStream inputstream = null;
            BufferedReader reader = null;
            int i = 1;
            while ((float)i <= this.propteries[4]) {
                String line;
                url = this.getClass().getResource(RCM_Main.propertiesFilePath + this.fileName);
                inputstream = url.openStream();
                reader = new BufferedReader(new InputStreamReader(inputstream));
                while ((line = reader.readLine()) != null) {
                    float z;
                    float y;
                    float x;
                    if (line.startsWith("Wing_ID_" + i + ": ")) {
                        wingID = Integer.valueOf(line.split(" ")[1]);
                        continue;
                    }
                    if (line.startsWith("Wing_span_vect_" + i + ": ")) {
                        x = Float.valueOf(line.split(" ")[1]).floatValue();
                        y = Float.valueOf(line.split(" ")[2]).floatValue();
                        z = Float.valueOf(line.split(" ")[3]).floatValue();
                        spanVec = new Vector3f(x, y, z);
                        continue;
                    }
                    if (line.startsWith("Wing_lift_vect_" + i + ": ")) {
                        x = Float.valueOf(line.split(" ")[1]).floatValue();
                        y = Float.valueOf(line.split(" ")[2]).floatValue();
                        z = Float.valueOf(line.split(" ")[3]).floatValue();
                        liftVec = new Vector3f(x, y, z);
                        continue;
                    }
                    if (line.startsWith("Wing_chord_vect_" + i + ": ")) {
                        x = Float.valueOf(line.split(" ")[1]).floatValue();
                        y = Float.valueOf(line.split(" ")[2]).floatValue();
                        z = Float.valueOf(line.split(" ")[3]).floatValue();
                        chordVec = new Vector3f(x, y, z);
                        continue;
                    }
                    if (line.startsWith("Wing_position_" + i + ": ")) {
                        x = Float.valueOf(line.split(" ")[1]).floatValue();
                        y = Float.valueOf(line.split(" ")[2]).floatValue();
                        z = Float.valueOf(line.split(" ")[3]).floatValue();
                        position = new Vector3f(x, y, z);
                        continue;
                    }
                    if (line.startsWith("Wing_area_" + i + ": ")) {
                        area = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Wing_span_" + i + ": ")) {
                        span = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Wing_chord_root_" + i + ": ")) {
                        root = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Wing_chord_tip_" + i + ": ")) {
                        tip = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Wing_deflection_" + i + ": ")) {
                        def = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Wing_deflection_offset_" + i + ": ")) {
                        defOffset = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Wing_profile_" + i + ": ")) {
                        profileType = Integer.valueOf(line.split(" ")[1]);
                        continue;
                    }
                    if (line.startsWith("Wing_sensor_ID_" + i + ": ")) {
                        sensorID = Integer.valueOf(line.split(" ")[1]);
                        continue;
                    }
                    if (line.startsWith("Wing_sections_" + i + ": ")) {
                        sections = Integer.valueOf(line.split(" ")[1]);
                        continue;
                    }
                    if (!line.startsWith("Wing_control_channel_" + i + ": ")) continue;
                    channel = Integer.valueOf(line.split(" ")[1]);
                    break;
                }
                this.wings.add(new WingProperties(wingID, spanVec, liftVec, chordVec, position, area, span, root, tip, def, defOffset, profileType, sensorID, sections, channel));
                reader.close();
                ++i;
            }
        }
    }

    private void loadRotaryWings() throws FileNotFoundException, IOException {
        if (this.propteries[5] > 0.0f) {
            Vector3f spanVec = null;
            Vector3f liftVec = null;
            Vector3f chordVec = null;
            Vector3f position = null;
            int propID = 0;
            float mass = 0.0f;
            float area = 0.0f;
            float span = 0.0f;
            float root = 0.0f;
            float tip = 0.0f;
            float hubOffset = 0.0f;
            float def = 0.0f;
            float defOffset = 0.0f;
            float ratio = 1.0f;
            float eqFactor = 1.0f;
            int profileType = 0;
            int channel = 0;
            int sensorID = 0;
            int sections = 1;
            URL url = null;
            InputStream inputstream = null;
            BufferedReader reader = null;
            int i = 1;
            while ((float)i <= this.propteries[5]) {
                String line;
                url = this.getClass().getResource(RCM_Main.propertiesFilePath + this.fileName);
                inputstream = url.openStream();
                reader = new BufferedReader(new InputStreamReader(inputstream));
                while ((line = reader.readLine()) != null) {
                    float z;
                    float y;
                    float x;
                    if (line.startsWith("Prop_ID_" + i + ": ")) {
                        propID = Integer.valueOf(line.split(" ")[1]);
                        continue;
                    }
                    if (line.startsWith("Prop_mass_" + i + ": ")) {
                        mass = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Prop_gear_ratio_" + i + ": ")) {
                        ratio = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Prop_Prop_equivalent_factor_" + i + ": ")) {
                        eqFactor = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Prop_span_vect_" + i + ": ")) {
                        x = Float.valueOf(line.split(" ")[1]).floatValue();
                        y = Float.valueOf(line.split(" ")[2]).floatValue();
                        z = Float.valueOf(line.split(" ")[3]).floatValue();
                        spanVec = new Vector3f(x, y, z);
                        continue;
                    }
                    if (line.startsWith("Prop_lift_vect_" + i + ": ")) {
                        x = Float.valueOf(line.split(" ")[1]).floatValue();
                        y = Float.valueOf(line.split(" ")[2]).floatValue();
                        z = Float.valueOf(line.split(" ")[3]).floatValue();
                        liftVec = new Vector3f(x, y, z);
                        continue;
                    }
                    if (line.startsWith("Prop_chord_vect_" + i + ": ")) {
                        x = Float.valueOf(line.split(" ")[1]).floatValue();
                        y = Float.valueOf(line.split(" ")[2]).floatValue();
                        z = Float.valueOf(line.split(" ")[3]).floatValue();
                        chordVec = new Vector3f(x, y, z);
                        continue;
                    }
                    if (line.startsWith("Prop_position_" + i + ": ")) {
                        x = Float.valueOf(line.split(" ")[1]).floatValue();
                        y = Float.valueOf(line.split(" ")[2]).floatValue();
                        z = Float.valueOf(line.split(" ")[3]).floatValue();
                        position = new Vector3f(x, y, z);
                        continue;
                    }
                    if (line.startsWith("Prop_offset_" + i + ": ")) {
                        hubOffset = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Prop_area_" + i + ": ")) {
                        area = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Prop_span_" + i + ": ")) {
                        span = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Prop_chord_root_" + i + ": ")) {
                        root = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Prop_chord_tip_" + i + ": ")) {
                        tip = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Prop_deflection_" + i + ": ")) {
                        def = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Prop_deflection_offset_" + i + ": ")) {
                        defOffset = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Prop_profile_" + i + ": ")) {
                        profileType = Integer.valueOf(line.split(" ")[1]);
                        continue;
                    }
                    if (line.startsWith("Prop_sensor_ID_" + i + ": ")) {
                        sensorID = Integer.valueOf(line.split(" ")[1]);
                        continue;
                    }
                    if (line.startsWith("Prop_sections_" + i + ": ")) {
                        sections = Integer.valueOf(line.split(" ")[1]);
                        continue;
                    }
                    if (!line.startsWith("Prop_control_channel_" + i + ": ")) continue;
                    channel = Integer.valueOf(line.split(" ")[1]);
                    break;
                }
                this.rotaryWings.add(new RotaryWingProperties(propID, mass, ratio, eqFactor, spanVec, liftVec, chordVec, position, hubOffset, area, span, root, tip, def, defOffset, profileType, sensorID, sections, channel));
                reader.close();
                ++i;
            }
        }
    }

    private void loadAutoControllers() throws FileNotFoundException, IOException {
        if (this.propteries[4] > 0.0f) {
            Vector3f sensorPoint = null;
            float linGain = 0.0f;
            float linLimit = 0.0f;
            float angGain = 0.0f;
            float angLimit = 0.0f;
            int sensorID = 0;
            URL url = null;
            InputStream inputstream = null;
            BufferedReader reader = null;
            int i = 1;
            while ((float)i <= this.propteries[6]) {
                String line;
                url = this.getClass().getResource(RCM_Main.propertiesFilePath + this.fileName);
                inputstream = url.openStream();
                reader = new BufferedReader(new InputStreamReader(inputstream));
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("Sensor_ID_" + i + ": ")) {
                        sensorID = Integer.valueOf(line.split(" ")[1]);
                        continue;
                    }
                    if (line.startsWith("Sensor_point_" + i + ": ")) {
                        float x = Float.valueOf(line.split(" ")[1]).floatValue();
                        float y = Float.valueOf(line.split(" ")[2]).floatValue();
                        float z = Float.valueOf(line.split(" ")[3]).floatValue();
                        sensorPoint = new Vector3f(x, y, z);
                        continue;
                    }
                    if (line.startsWith("Sensor_linear_gain_" + i + ": ")) {
                        linGain = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Sensor_linear_limit_" + i + ": ")) {
                        linLimit = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Sensor_angular_gain_" + i + ": ")) {
                        angGain = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (!line.startsWith("Sensor_angular_limit_" + i + ": ")) continue;
                    angLimit = Float.valueOf(line.split(" ")[1]).floatValue();
                    break;
                }
                this.sensors.add(new AutoControlProperties(sensorID, sensorPoint, linGain, linLimit, angGain, angLimit));
                reader.close();
                ++i;
            }
        }
    }

    private void loadMissiles() throws FileNotFoundException, IOException {
        if (this.propteries[7] > 0.0f) {
            Vector3f position = null;
            int i = 1;
            while ((float)i <= this.propteries[7]) {
                String line;
                URL url = this.getClass().getResource(RCM_Main.propertiesFilePath + this.fileName);
                InputStream inputstream = url.openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream));
                while ((line = reader.readLine()) != null) {
                    if (!line.startsWith("Attachment_position_" + i + ": ")) continue;
                    float x = Float.valueOf(line.split(" ")[1]).floatValue();
                    float y = Float.valueOf(line.split(" ")[2]).floatValue();
                    float z = Float.valueOf(line.split(" ")[3]).floatValue();
                    position = new Vector3f(x, y, z);
                    break;
                }
                this.attachments.add(position);
                reader.close();
                ++i;
            }
        }
    }

    public void loadRocketMotors() throws FileNotFoundException, IOException {
        if (this.propteries[8] > 0.0f) {
            Object position = null;
            int i = 1;
            while ((float)i <= this.propteries[8]) {
                String line;
                URL url = this.getClass().getResource(RCM_Main.propertiesFilePath + this.fileName);
                InputStream inputstream = url.openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream));
                float thrust = 0.0f;
                float burnTime = 0.0f;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("Rocket_motor_thrust_" + i + ": ")) {
                        thrust = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (!line.startsWith("Rocket_burn_time_" + i + ": ")) continue;
                    burnTime = Float.valueOf(line.split(" ")[1]).floatValue();
                    break;
                }
                this.RocketMotors.add(new RocketMotorProperties(thrust, burnTime));
                reader.close();
                ++i;
            }
        }
    }

    public float[] getProperties() {
        return this.propteries;
    }

    public CompoundShape getCollisionShapes() {
        return this.entityShape;
    }

    public Vector3f getInertia() {
        return this.inertia;
    }

    public List<MotorProperties> getMotorProperties() {
        return this.motors;
    }

    public List<WheelProperties> getWheelProperties() {
        return this.wheels;
    }

    public List<WingProperties> getWingProperties() {
        return this.wings;
    }

    public List<RotaryWingProperties> getRotaryWingProperties() {
        return this.rotaryWings;
    }

    public List<AutoControlProperties> getAutoControlProperties() {
        return this.sensors;
    }

    public List<Vector3f> getAttachments() {
        return this.attachments;
    }

    public List<RocketMotorProperties> getRocketMotors() {
        return this.RocketMotors;
    }

    public float getDragFactor() {
        return this.dragFactor;
    }
}

