/*
 * Decompiled with CFR 0.152.
 */
package RCM.Renders;

import RCM.Entities.GlobalEntity;
import RCM.Models.Model;
import RCM.Models.ModelLoader;
import RCM.RCM_Main;
import RCM.Renders.GlobalRender;
import com.bulletphysics.linearmath.DefaultMotionState;
import com.bulletphysics.linearmath.Transform;
import cpw.mods.fml.common.FMLLog;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.FloatBuffer;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class RenderCar
extends GlobalRender {
    private ResourceLocation textureLocation = new ResourceLocation("thercmod:textures/models/carskin.png");
    public Model rearWing = null;
    public Model rightWheel = null;
    public Model leftWheel = null;
    public Model suspension = null;

    public RenderCar() {
        this.field_76989_e = 0.2f;
        String filePath = RCM_Main.modelFilePath + "car.rcm";
        try {
            this.mainBody = new Model();
            this.mainBody.loadModel(filePath, "MainBody");
            this.rearWing = ModelLoader.loadModel(filePath, "RearWing");
            this.rightWheel = ModelLoader.loadModel(filePath, "LeftWheel");
            this.leftWheel = ModelLoader.loadModel(filePath, "RightWheel");
            this.suspension = ModelLoader.loadModel(filePath, "Suspension");
            this.mainBody.createVBO();
        }
        catch (FileNotFoundException e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"RC Trainer model file is missing!!", (Object[])new Object[0]);
        }
        catch (IOException e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"RC Trainer model file loaded incorrectly!!", (Object[])new Object[0]);
        }
    }

    @Override
    public void renderExtras(GlobalEntity rcentity, float timeStep) {
        if (rcentity.physicsWorld != null) {
            for (int i = 0; i < rcentity.physicsWorld.vehicle.getNumWheels(); ++i) {
                GL11.glPushMatrix();
                float stearing = 0.0f;
                Transform wTrans = new Transform();
                Transform vTrans = new Transform();
                rcentity.physicsWorld.vehicle.updateWheelTransform(i, true);
                wTrans = rcentity.physicsWorld.vehicle.getWheelInfo((int)i).worldTransform;
                DefaultMotionState motionState = (DefaultMotionState)rcentity.physicsWorld.entityBody.getMotionState();
                vTrans.set(motionState.graphicsWorldTrans);
                vTrans.inverse();
                vTrans.mul(wTrans);
                Vector3f wheelOffset = new Vector3f();
                wheelOffset.x = rcentity.physicsWorld.wheels.get(i).getOffset() * -2.0f;
                vTrans.origin.add((Tuple3f)wheelOffset);
                float[] matrix = new float[16];
                FloatBuffer transformationBuffer = BufferUtils.createFloatBuffer((int)16);
                vTrans.getOpenGLMatrix(matrix);
                transformationBuffer.clear();
                transformationBuffer.put(matrix);
                transformationBuffer.flip();
                GL11.glMultMatrix((FloatBuffer)transformationBuffer);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glBegin((int)4);
                if (i == 1 || i == 3) {
                    this.drawObject(this.rightWheel);
                } else {
                    this.drawObject(this.leftWheel);
                }
                GL11.glEnd();
                GL11.glDisable((int)3042);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                Vector3f wheelPos = new Vector3f(rcentity.physicsWorld.vehicle.getWheelInfo((int)i).chassisConnectionPointCS);
                float suspOffset = Math.abs(wheelPos.x) - 0.03f;
                wheelPos.x = wheelPos.x > 0.0f ? (wheelPos.x -= suspOffset) : (wheelPos.x += suspOffset);
                GL11.glTranslated((double)wheelPos.x, (double)-0.00616, (double)wheelPos.z);
                float suspForce = rcentity.physicsWorld.vehicle.getWheelInfo((int)i).wheelsSuspensionForce;
                float suspStiff = rcentity.physicsWorld.vehicle.getWheelInfo((int)i).suspensionStiffness;
                float travel = suspForce / suspStiff;
                float def = -((float)(Math.atan(travel / suspOffset) / Math.PI)) * 180.0f * 0.45f;
                if (i == 1 || i == 3) {
                    GL11.glRotatef((float)def, (float)0.0f, (float)0.0f, (float)1.0f);
                } else {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)def, (float)0.0f, (float)0.0f, (float)1.0f);
                }
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glBegin((int)4);
                if (i == 0 || i == 2) {
                    this.drawObject(this.suspension);
                } else {
                    this.drawObject(this.suspension);
                }
                GL11.glEnd();
                GL11.glDisable((int)3042);
                GL11.glPopMatrix();
            }
        }
    }

    @Override
    protected ResourceLocation func_110775_a(Entity entity) {
        return this.textureLocation;
    }
}

