/*
 * Decompiled with CFR 0.152.
 */
package RCM.Renders;

import RCM.Entities.EntityF22;
import RCM.Entities.GlobalEntity;
import RCM.Models.Model;
import RCM.RCM_Main;
import RCM.Renders.GlobalRender;
import RCM.TickHandler;
import com.bulletphysics.linearmath.DefaultMotionState;
import com.bulletphysics.linearmath.Transform;
import cpw.mods.fml.common.FMLLog;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.Iterator;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class RenderF22
extends GlobalRender {
    private ResourceLocation textureLocation = new ResourceLocation("thercmod:textures/models/f22skin.png");
    private ResourceLocation textureLocationRadar = new ResourceLocation("thercmod:textures/overlay/radar.png");
    private ResourceLocation textureLocationLock = new ResourceLocation("thercmod:textures/overlay/lock.png");
    public Model rightAileron = null;
    public Model leftAileron = null;
    public Model rudder = null;
    public Model elevatorLeft = null;
    public Model elevatorRight = null;
    public Model propeller = null;
    public Model propellerBlur = null;
    public Model frontGear = null;
    public Model wheel = null;
    public Model canopy = null;

    public RenderF22() {
        this.field_76989_e = 0.0f;
        String filePath = RCM_Main.modelFilePath + "f22raptor.rcm";
        try {
            this.mainBody = new Model();
            this.mainBody.loadModel(filePath, "MainBody");
            this.canopy = new Model();
            this.canopy.loadModel(filePath, "Canopy");
            this.elevatorLeft = new Model();
            this.elevatorLeft.loadModel(filePath, "Elevator Left");
            this.elevatorRight = new Model();
            this.elevatorRight.loadModel(filePath, "Elevator Right");
        }
        catch (FileNotFoundException e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"RC Trainer model file is missing!!", (Object[])new Object[0]);
        }
        catch (IOException e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"RC Trainer model file loaded incorrectly!!", (Object[])new Object[0]);
        }
    }

    @Override
    public void renderExtras(GlobalEntity rcentity, float timeStep) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.drawObject(this.canopy);
        GL11.glEnd();
        GL11.glDisable((int)3042);
        if (rcentity.physicsWorld != null) {
            for (int i = 0; i < rcentity.physicsWorld.vehicle.getNumWheels(); ++i) {
                GL11.glPushMatrix();
                float stearing = 0.0f;
                Transform wTrans = null;
                Transform vTrans = new Transform();
                if (rcentity.physicsWorld != null) {
                    rcentity.physicsWorld.vehicle.updateWheelTransform(i, true);
                    wTrans = rcentity.physicsWorld.vehicle.getWheelInfo((int)i).worldTransform;
                    DefaultMotionState motionState = (DefaultMotionState)rcentity.physicsWorld.entityBody.getMotionState();
                    vTrans.set(motionState.graphicsWorldTrans);
                    vTrans.inverse();
                    vTrans.mul(wTrans);
                    float[] matrix = new float[16];
                    FloatBuffer transformationBuffer = BufferUtils.createFloatBuffer((int)16);
                    vTrans.getOpenGLMatrix(matrix);
                    transformationBuffer.clear();
                    transformationBuffer.put(matrix);
                    transformationBuffer.flip();
                    GL11.glMultMatrix((FloatBuffer)transformationBuffer);
                }
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glBegin((int)4);
                GL11.glEnd();
                GL11.glDisable((int)3042);
                GL11.glPopMatrix();
            }
            EntityF22 f22enity = (EntityF22)rcentity;
            Vector3f localTrans = new Vector3f();
            Vector3f rotateAxis = new Vector3f();
            localTrans.set(0.0f, -0.15017f, 0.20623f);
            rotateAxis.set((Tuple3f)f22enity.helper.rotateVector(new Quat4f(-0.093f, 0.0f, 0.0f, 0.996f), new Vector3f(0.0f, 1.0f, 0.0f)));
            GL11.glPushMatrix();
            GL11.glTranslatef((float)localTrans.x, (float)localTrans.y, (float)localTrans.z);
            float stearing = 0.0f;
            if (rcentity.physicsWorld != null) {
                stearing = rcentity.physicsWorld.vehicle.getWheelInfo((int)0).steering;
            }
            GL11.glRotatef((float)(stearing * 180.0f / (float)Math.PI), (float)rotateAxis.x, (float)rotateAxis.y, (float)rotateAxis.z);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glBegin((int)4);
            GL11.glEnd();
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
            localTrans.set(-0.45133f, 0.09713f, -0.22248f);
            rotateAxis.set((Tuple3f)f22enity.helper.rotateVector(new Quat4f(0.0f, 0.0f, -0.035f, 0.999f), new Vector3f(1.0f, 0.0f, 0.0f)));
            GL11.glPushMatrix();
            GL11.glTranslatef((float)localTrans.x, (float)localTrans.y, (float)localTrans.z);
            GL11.glRotatef((float)((f22enity.prevAileronAngle + (f22enity.aileronAngle - f22enity.prevAileronAngle) * timeStep) * 180.0f / (float)Math.PI), (float)rotateAxis.x, (float)rotateAxis.y, (float)rotateAxis.z);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glBegin((int)4);
            GL11.glEnd();
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
            localTrans.set(0.45133f, 0.09713f, -0.22248f);
            rotateAxis.set((Tuple3f)f22enity.helper.rotateVector(new Quat4f(0.0f, 0.0f, 0.035f, 0.999f), new Vector3f(1.0f, 0.0f, 0.0f)));
            GL11.glPushMatrix();
            GL11.glTranslatef((float)localTrans.x, (float)localTrans.y, (float)localTrans.z);
            GL11.glRotatef((float)((-f22enity.prevAileronAngle - (f22enity.aileronAngle - f22enity.prevAileronAngle) * timeStep) * 180.0f / (float)Math.PI), (float)rotateAxis.x, (float)rotateAxis.y, (float)rotateAxis.z);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glBegin((int)4);
            GL11.glEnd();
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
            localTrans.set(0.0f, 0.08955f, -0.85616f);
            rotateAxis.set((Tuple3f)f22enity.helper.rotateVector(new Quat4f(-0.112f, 0.0f, 0.0f, 0.994f), new Vector3f(0.0f, 1.0f, 0.0f)));
            GL11.glPushMatrix();
            GL11.glTranslatef((float)localTrans.x, (float)localTrans.y, (float)localTrans.z);
            GL11.glRotatef((float)((-f22enity.prevRudderAngle - (f22enity.rudderAngle - f22enity.prevRudderAngle) * timeStep) * 180.0f / (float)Math.PI), (float)rotateAxis.x, (float)rotateAxis.y, (float)rotateAxis.z);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glBegin((int)4);
            GL11.glEnd();
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
            localTrans.set(0.15168f, 0.00683f, -0.427f);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)localTrans.x, (float)localTrans.y, (float)localTrans.z);
            GL11.glRotatef((float)((-f22enity.prevElevatorAngle[0] - (f22enity.elevatorAngle[0] - f22enity.prevElevatorAngle[0]) * timeStep) * 180.0f / (float)Math.PI), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glBegin((int)4);
            this.drawObject(this.elevatorLeft);
            GL11.glEnd();
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
            localTrans.set(-0.15168f, 0.00683f, -0.427f);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)localTrans.x, (float)localTrans.y, (float)localTrans.z);
            GL11.glRotatef((float)((-f22enity.prevElevatorAngle[1] - (f22enity.elevatorAngle[1] - f22enity.prevElevatorAngle[1]) * timeStep) * 180.0f / (float)Math.PI), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glBegin((int)4);
            this.drawObject(this.elevatorRight);
            GL11.glEnd();
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
    }

    @Override
    public void renderExtras2(GlobalEntity rcentity, double posX, double posY, double posZ, float timeStep) {
        if (rcentity.physicsWorld != null && TickHandler.rcEntity != null && TickHandler.rcEntity == rcentity && TickHandler.thirdPersonView && rcentity.weaponsMode) {
            EntityF22 f22Entity = (EntityF22)rcentity;
            Entity entity = null;
            Iterator<Entity> iterator = f22Entity.physicsWorld.visibleEntities.iterator();
            while (iterator.hasNext()) {
                Entity obj;
                entity = obj = iterator.next();
                double eyeHeight = (double)entity.func_70047_e() / 2.0;
                double lockPosX = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)timeStep - (rcentity.field_70169_q + (rcentity.field_70165_t - rcentity.field_70169_q) * (double)timeStep) + posX;
                double lockPosY = entity.field_70167_r + eyeHeight + (entity.field_70163_u + eyeHeight - (entity.field_70167_r + eyeHeight)) * (double)timeStep - (rcentity.field_70167_r + (rcentity.field_70163_u - rcentity.field_70167_r) * (double)timeStep) + posY;
                double lockPosZ = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)timeStep - (rcentity.field_70166_s + (rcentity.field_70161_v - rcentity.field_70166_s) * (double)timeStep) + posZ;
                this.renderRadarBox(rcentity, lockPosX, lockPosY, lockPosZ, this.textureLocationRadar, 1.0f, 1.0f);
            }
            if (f22Entity.physicsWorld.lockedEntity != null) {
                entity = f22Entity.physicsWorld.lockedEntity;
                double eyeHeight = (double)entity.func_70047_e() / 2.0;
                double lockPosX = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)timeStep - (rcentity.field_70169_q + (rcentity.field_70165_t - rcentity.field_70169_q) * (double)timeStep) + posX;
                double lockPosY = entity.field_70167_r + eyeHeight + (entity.field_70163_u + eyeHeight - (entity.field_70167_r + eyeHeight)) * (double)timeStep - (rcentity.field_70167_r + (rcentity.field_70163_u - rcentity.field_70167_r) * (double)timeStep) + posY;
                double lockPosZ = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)timeStep - (rcentity.field_70166_s + (rcentity.field_70161_v - rcentity.field_70166_s) * (double)timeStep) + posZ;
                float lockScale = rcentity.prevLockProgress + (rcentity.lockProgress - rcentity.prevLockProgress) * timeStep;
                this.renderRadarBox(rcentity, lockPosX, lockPosY, lockPosZ, this.textureLocationLock, lockScale, 2.0f - lockScale);
            }
        }
    }

    @Override
    protected ResourceLocation func_110775_a(Entity entity) {
        return this.textureLocation;
    }
}

