/*
 * Decompiled with CFR 0.152.
 */
package RCM.Renders;

import RCM.Entities.EntityPlane;
import RCM.Entities.GlobalEntity;
import RCM.Models.Model;
import RCM.Models.ModelLoader;
import RCM.RCM_Main;
import RCM.Renders.GlobalRender;
import com.bulletphysics.linearmath.DefaultMotionState;
import com.bulletphysics.linearmath.Transform;
import cpw.mods.fml.common.FMLLog;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.FloatBuffer;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class RenderPlane
extends GlobalRender {
    private ResourceLocation textureLocation = new ResourceLocation("thercmod:textures/models/trainerplaneskin.png");
    public Model rightAileron = null;
    public Model leftAileron = null;
    public Model rudder = null;
    public Model elevator = null;
    public Model propeller = null;
    public Model propellerBlur = null;
    public Model frontGear = null;
    public Model wheel = null;
    public Model mainGear = null;

    public RenderPlane() {
        this.field_76989_e = 0.25f;
        String filePath = RCM_Main.modelFilePath + "trainerplane.rcm";
        try {
            this.mainBody = new Model();
            this.mainBody.loadModel(filePath, "MainBody");
            this.rightAileron = ModelLoader.loadModel(filePath, "RightAileron");
            this.leftAileron = ModelLoader.loadModel(filePath, "LeftAileron");
            this.rudder = ModelLoader.loadModel(filePath, "Rudder");
            this.elevator = ModelLoader.loadModel(filePath, "Elevator");
            this.propeller = ModelLoader.loadModel(filePath, "Propeller");
            this.propellerBlur = ModelLoader.loadModel(filePath, "PropellerBlur");
            this.frontGear = ModelLoader.loadModel(filePath, "FrontGear");
            this.wheel = ModelLoader.loadModel(filePath, "Wheel");
            this.mainGear = ModelLoader.loadModel(filePath, "MainGear");
            this.mainBody.createVBO();
        }
        catch (FileNotFoundException e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"RC Trainer model file is missing!!", (Object[])new Object[0]);
        }
        catch (IOException e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"RC Trainer model file loaded incorrectly!!", (Object[])new Object[0]);
        }
    }

    @Override
    public void renderExtras(GlobalEntity rcentity, float timeStep) {
        if (rcentity.physicsWorld != null) {
            for (int i = 0; i < rcentity.physicsWorld.vehicle.getNumWheels(); ++i) {
                GL11.glPushMatrix();
                float stearing = 0.0f;
                Transform wTrans = null;
                Transform vTrans = new Transform();
                rcentity.physicsWorld.vehicle.updateWheelTransform(i, true);
                wTrans = rcentity.physicsWorld.vehicle.getWheelInfo((int)i).worldTransform;
                DefaultMotionState motionState = (DefaultMotionState)rcentity.physicsWorld.entityBody.getMotionState();
                vTrans.set(motionState.graphicsWorldTrans);
                vTrans.inverse();
                vTrans.mul(wTrans);
                float[] matrix = new float[16];
                FloatBuffer transformationBuffer = BufferUtils.createFloatBuffer((int)16);
                vTrans.getOpenGLMatrix(matrix);
                transformationBuffer.clear();
                transformationBuffer.put(matrix);
                transformationBuffer.flip();
                GL11.glMultMatrix((FloatBuffer)transformationBuffer);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glBegin((int)4);
                this.drawObject(this.wheel);
                GL11.glEnd();
                GL11.glDisable((int)3042);
                GL11.glPopMatrix();
                if (i == 0) continue;
                GL11.glPushMatrix();
                Vector3f wheelPos = new Vector3f(rcentity.physicsWorld.vehicle.getWheelInfo((int)i).chassisConnectionPointCS);
                float suspOffset = Math.abs(wheelPos.x) - 0.043f;
                wheelPos.x = wheelPos.x > 0.0f ? (wheelPos.x -= suspOffset) : (wheelPos.x += suspOffset);
                GL11.glTranslated((double)wheelPos.x, (double)-0.09052f, (double)(wheelPos.z + 0.03213f));
                float suspForce = rcentity.physicsWorld.vehicle.getWheelInfo((int)i).wheelsSuspensionForce;
                float suspStiff = rcentity.physicsWorld.vehicle.getWheelInfo((int)i).suspensionStiffness;
                float travel = suspForce / suspStiff;
                float def = -((float)(Math.atan(travel / suspOffset) / Math.PI)) * 180.0f * 0.45f;
                if (i == 2) {
                    GL11.glRotatef((float)def, (float)0.0f, (float)0.0f, (float)1.0f);
                } else if (i == 1) {
                    GL11.glScalef((float)-1.0f, (float)1.0f, (float)1.0f);
                    GL11.glRotatef((float)def, (float)0.0f, (float)0.0f, (float)1.0f);
                }
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glBegin((int)4);
                this.drawObject(this.mainGear);
                GL11.glEnd();
                GL11.glDisable((int)3042);
                GL11.glPopMatrix();
            }
            EntityPlane trainerenity = (EntityPlane)rcentity;
            Vector3f localTrans = new Vector3f();
            Vector3f rotateAxis = new Vector3f();
            localTrans.set(0.0f, -0.15517f, 0.20623f);
            rotateAxis.set((Tuple3f)trainerenity.helper.rotateVector(new Quat4f(-0.093f, 0.0f, 0.0f, 0.996f), new Vector3f(0.0f, 1.0f, 0.0f)));
            GL11.glPushMatrix();
            float suspForce = rcentity.physicsWorld.vehicle.getWheelInfo((int)0).wheelsSuspensionForce;
            float suspStiff = rcentity.physicsWorld.vehicle.getWheelInfo((int)0).suspensionStiffness;
            float travel = suspForce / suspStiff;
            GL11.glTranslatef((float)localTrans.x, (float)(localTrans.y + travel), (float)localTrans.z);
            float stearing = 0.0f;
            stearing = rcentity.physicsWorld.vehicle.getWheelInfo((int)0).steering;
            GL11.glRotatef((float)(stearing * 180.0f / (float)Math.PI), (float)rotateAxis.x, (float)rotateAxis.y, (float)rotateAxis.z);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glBegin((int)4);
            this.drawObject(this.frontGear);
            GL11.glEnd();
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
            localTrans.set((Tuple3f)rcentity.physicsWorld.rotaryWings.get(0).getPosition());
            rotateAxis = new Vector3f(0.0f, 0.0f, 1.0f);
            float rotation = rcentity.physicsWorld.rotaryWings.get(0).getRotationAngle();
            float prevRotation = rcentity.physicsWorld.rotaryWings.get(0).getPrevRotationAngle();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)localTrans.x, (float)localTrans.y, (float)localTrans.z);
            GL11.glRotatef((float)(prevRotation + (rotation - prevRotation) * timeStep), (float)rotateAxis.x, (float)rotateAxis.y, (float)rotateAxis.z);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glBegin((int)4);
            this.drawObject(this.propeller);
            GL11.glEnd();
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)localTrans.x, (float)localTrans.y, (float)localTrans.z);
            GL11.glRotatef((float)(prevRotation + (rotation - prevRotation) * timeStep), (float)rotateAxis.x, (float)rotateAxis.y, (float)rotateAxis.z);
            GL11.glEnable((int)3042);
            GL11.glDepthMask((boolean)false);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glAlphaFunc((int)516, (float)0.01f);
            GL11.glBegin((int)4);
            float visiblility = 1.0f;
            float par1 = rcentity.physicsWorld.rotaryWings.get(0).getAngularVelocity();
            if (Math.abs(par1) < 300.0f) {
                visiblility = Math.abs(par1 / 300.0f);
            }
            if (visiblility > 1.0f) {
                visiblility = 1.0f;
            } else if (visiblility < 0.0f) {
                visiblility = 0.0f;
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)visiblility);
            this.drawObject(this.propellerBlur);
            GL11.glEnd();
            GL11.glDepthMask((boolean)true);
            GL11.glDisable((int)3042);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
            localTrans.set(-0.45133f, 0.09713f, -0.22248f);
            rotateAxis.set((Tuple3f)trainerenity.helper.rotateVector(new Quat4f(0.0f, 0.0f, -0.035f, 0.999f), new Vector3f(1.0f, 0.0f, 0.0f)));
            GL11.glPushMatrix();
            GL11.glTranslatef((float)localTrans.x, (float)localTrans.y, (float)localTrans.z);
            GL11.glRotatef((float)((trainerenity.prevAileronAngle + (trainerenity.aileronAngle - trainerenity.prevAileronAngle) * timeStep) * 20.0f), (float)rotateAxis.x, (float)rotateAxis.y, (float)rotateAxis.z);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glBegin((int)4);
            this.drawObject(this.rightAileron);
            GL11.glEnd();
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
            localTrans.set(0.45133f, 0.09713f, -0.22248f);
            rotateAxis.set((Tuple3f)trainerenity.helper.rotateVector(new Quat4f(0.0f, 0.0f, 0.035f, 0.999f), new Vector3f(1.0f, 0.0f, 0.0f)));
            GL11.glPushMatrix();
            GL11.glTranslatef((float)localTrans.x, (float)localTrans.y, (float)localTrans.z);
            GL11.glRotatef((float)((-trainerenity.prevAileronAngle - (trainerenity.aileronAngle - trainerenity.prevAileronAngle) * timeStep) * 20.0f), (float)rotateAxis.x, (float)rotateAxis.y, (float)rotateAxis.z);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glBegin((int)4);
            this.drawObject(this.leftAileron);
            GL11.glEnd();
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
            localTrans.set(0.0f, 0.08955f, -0.85616f);
            rotateAxis.set((Tuple3f)trainerenity.helper.rotateVector(new Quat4f(-0.112f, 0.0f, 0.0f, 0.994f), new Vector3f(0.0f, 1.0f, 0.0f)));
            GL11.glPushMatrix();
            GL11.glTranslatef((float)localTrans.x, (float)localTrans.y, (float)localTrans.z);
            GL11.glRotatef((float)((-trainerenity.prevRudderAngle - (trainerenity.rudderAngle - trainerenity.prevRudderAngle) * timeStep) * 30.0f), (float)rotateAxis.x, (float)rotateAxis.y, (float)rotateAxis.z);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glBegin((int)4);
            this.drawObject(this.rudder);
            GL11.glEnd();
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
            localTrans.set(0.0f, -0.01398f, -0.83274f);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)localTrans.x, (float)localTrans.y, (float)localTrans.z);
            GL11.glRotatef((float)((-trainerenity.prevElevatorAngle - (trainerenity.elevatorAngle - trainerenity.prevElevatorAngle) * timeStep) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glBegin((int)4);
            this.drawObject(this.elevator);
            GL11.glEnd();
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
    }

    @Override
    protected ResourceLocation func_110775_a(Entity entity) {
        return this.textureLocation;
    }
}

