/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp;

import java.util.Hashtable;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import xbigellx.rbp.BlockUpdate;
import xbigellx.rbp.ChunkData;
import xbigellx.rbp.EnumUpdateType;
import xbigellx.rbp.Physics;
import xbigellx.rbp.PhysicsDef;
import xbigellx.rbp.entities.EntityFallingRBPBlock;
import xbigellx.rbp.events.RBPFallingBlockEvent;
import xbigellx.rbp.proxy.CommonProxy;
import xbigellx.rbp.util.BlockUtils;
import xbigellx.rbp.util.ModConfig;

@Mod(modid="rbp", name="Realistic Block Physics", version="1.2.1", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber(modid="rbp")
public class Main {
    @Mod.Instance
    public static Main instance;
    @SidedProxy(clientSide="xbigellx.rbp.proxy.ClientProxy", serverSide="xbigellx.rbp.proxy.CommonProxy")
    public static CommonProxy proxy;
    private static int ticksSkipped;
    private static int currentMovingBlocks;
    private static int blocksUpdatedThisTick;
    private static Hashtable<ChunkPos, ChunkData> chunksToUpdate;

    @Mod.EventHandler
    public static void init(FMLInitializationEvent event) {
        ModConfig.init();
    }

    @Mod.EventHandler
    public static void PreInit(FMLPreInitializationEvent event) {
    }

    @Mod.EventHandler
    public static void PostInit(FMLPostInitializationEvent event) {
    }

    @SubscribeEvent
    public static final void onChunkLoad(ChunkEvent.Load event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        ChunkData chunkData = new ChunkData();
        if (ModConfig.chunkUpdateMode == 0) {
            chunkData.setRequiresUpdateNow(true);
        }
        chunksToUpdate.putIfAbsent(event.getChunk().func_76632_l(), chunkData);
    }

    @SubscribeEvent
    public static final void onChunkUnloaded(ChunkEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        chunksToUpdate.remove(event.getChunk().func_76632_l());
    }

    @SubscribeEvent
    public static final void onBlockBroken(BlockEvent.BreakEvent event) {
        if (event.getWorld().field_72995_K || event.isCanceled()) {
            return;
        }
        ChunkPos chunkPos = event.getWorld().func_175726_f(event.getPos()).func_76632_l();
        if (!(ModConfig.chunkUpdateMode != 1 && ModConfig.chunkUpdateMode != 2 || Main.getChunkData(chunkPos).isHasUpdated())) {
            Main.getChunkData(chunkPos).setRequiresUpdateNow(true);
        }
    }

    @SubscribeEvent
    public static final void onBlockPlaced(BlockEvent.PlaceEvent event) {
        if (event.getWorld().field_72995_K || event.isCanceled()) {
            return;
        }
        PhysicsDef physicsDef = ModConfig.getPhysicsDefFor(event.getPlacedBlock().func_177230_c());
        ChunkData chunkData = Main.getChunkData(event.getWorld(), event.getPos());
        if (chunkData == null || physicsDef == null) {
            return;
        }
        if (Physics.shouldBlockSlideFromPillar(event.getWorld(), event.getPos())) {
            Main.summonFallingBlock(event.getWorld(), Physics.getRandomSlideResultFor(event.getWorld(), event.getPos(), physicsDef, 1.0f), event.getPlacedBlock(), physicsDef);
            event.getWorld().func_175698_g(event.getPos());
        } else if (physicsDef.getSlideChanceOnPlaced() > 0.0) {
            BlockPos slideResult = Physics.getRandomSlideResultFor(event.getWorld(), event.getPos(), physicsDef, (float)physicsDef.getSlideChanceOnPlaced());
            if (slideResult != null) {
                Main.summonFallingBlock(event.getWorld(), slideResult, event.getPlacedBlock(), physicsDef);
                event.getWorld().func_175698_g(event.getPos());
            }
        } else if (Physics.shouldBlockFall(event.getWorld(), event.getPos(), physicsDef)) {
            Main.summonFallingBlock(event.getWorld(), event.getPos(), event.getPlacedBlock(), physicsDef);
            event.getWorld().func_175698_g(event.getPos());
        }
    }

    @SubscribeEvent
    public static final void onEntityEnteredChunk(EntityEvent.EnteringChunk event) {
        if (event.getEntity() == null || event.getEntity().field_70170_p.field_72995_K || !(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        ChunkPos chunkPos = new ChunkPos(event.getNewChunkX(), event.getNewChunkZ());
        if (ModConfig.chunkUpdateMode == 1 && !Main.getChunkData(chunkPos).isHasUpdated()) {
            Main.getChunkData(chunkPos).setRequiresUpdateNow(true);
        }
    }

    @SubscribeEvent
    public static final void onWorldUnloaded(WorldEvent.Unload event) {
        currentMovingBlocks = 0;
        ticksSkipped = 0;
    }

    @SubscribeEvent
    public static final void onRBPFallingBlockLanded(RBPFallingBlockEvent.LandedEvent event) {
        Main.incMovingBlocks(-1);
    }

    @SubscribeEvent
    public static final void onRBPBlockDestroyed(RBPFallingBlockEvent.DestroyedEvent event) {
        Main.incMovingBlocks(-1);
    }

    @SubscribeEvent
    public static final void onExplosion(ExplosionEvent.Detonate event) {
        List affectedBlocks = event.getAffectedBlocks();
        for (BlockPos pos : affectedBlocks) {
            Main.getChunkData(event.getWorld(), pos).setRequiresUpdateNow(true);
        }
    }

    @SubscribeEvent
    public static final void onNeighbourNotify(BlockEvent.NeighborNotifyEvent event) {
        if (!event.getWorld().field_72995_K && event.getWorld().func_175623_d(event.getPos())) {
            BlockPos pos;
            World worldIn = event.getWorld();
            Chunk chunk = worldIn.func_175726_f(pos = event.getPos());
            if (!chunk.func_177410_o() || Main.getChunkData(worldIn, pos) == null || !Main.getChunkData(worldIn, pos).isHasUpdated()) {
                return;
            }
            boolean supportCheck = true;
            for (BlockPos neighbour : BlockUtils.getBlockNeighbours(worldIn, pos, 1)) {
                if (!Physics.shouldBlockFall(worldIn, neighbour, ModConfig.getPhysicsDefFor(worldIn, neighbour)) || Main.getChunkData(worldIn, neighbour) == null) continue;
                Main.getChunkData(worldIn, neighbour).getBlockUpdateQueue().add(new BlockUpdate(neighbour, EnumUpdateType.FALL));
                if (neighbour.func_177958_n() != pos.func_177958_n() || neighbour.func_177952_p() != pos.func_177952_p() || neighbour.func_177956_o() != pos.func_177956_o() + 1) continue;
                supportCheck = false;
            }
            if (!supportCheck) {
                return;
            }
            boolean gapWest = false;
            boolean gapEast = false;
            boolean gapSouth = false;
            boolean gapNorth = false;
            for (int i = 1; !(i > (ModConfig.blockUpdateRange + 1) * 16 || gapWest && gapEast && gapSouth && gapNorth); ++i) {
                BlockPos posWest = new BlockPos(pos.func_177958_n() + i, pos.func_177956_o() + 1, pos.func_177952_p());
                BlockPos posEast = new BlockPos(pos.func_177958_n() - i, pos.func_177956_o() + 1, pos.func_177952_p());
                BlockPos posSouth = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p() + i);
                BlockPos posNorth = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p() - i);
                PhysicsDef physicsWest = ModConfig.getPhysicsDefFor(worldIn, posWest);
                PhysicsDef physicsEast = ModConfig.getPhysicsDefFor(worldIn, posEast);
                PhysicsDef physicsSouth = ModConfig.getPhysicsDefFor(worldIn, posSouth);
                PhysicsDef physicsNorth = ModConfig.getPhysicsDefFor(worldIn, posNorth);
                if (physicsWest == null || physicsWest.isRequiresNeighbourUpdate()) {
                    gapWest = true;
                }
                if (!gapWest && Physics.shouldBlockFall(worldIn, posWest, physicsWest)) {
                    gapWest = true;
                    Main.getChunkData(event.getWorld(), posWest).getBlockUpdateQueue().add(new BlockUpdate(posWest, EnumUpdateType.FALL));
                }
                if (physicsEast == null || physicsEast.isRequiresNeighbourUpdate()) {
                    gapEast = true;
                }
                if (!gapEast && Physics.shouldBlockFall(worldIn, posEast, physicsEast)) {
                    gapEast = true;
                    Main.getChunkData(event.getWorld(), posEast).getBlockUpdateQueue().add(new BlockUpdate(posEast, EnumUpdateType.FALL));
                }
                if (physicsSouth == null || physicsSouth.isRequiresNeighbourUpdate()) {
                    gapSouth = true;
                }
                if (!gapSouth && Physics.shouldBlockFall(worldIn, posSouth, physicsSouth)) {
                    gapSouth = true;
                    Main.getChunkData(event.getWorld(), posSouth).getBlockUpdateQueue().add(new BlockUpdate(posSouth, EnumUpdateType.FALL));
                }
                if (physicsNorth == null || physicsNorth.isRequiresNeighbourUpdate()) {
                    gapNorth = true;
                    continue;
                }
                if (gapNorth || !Physics.shouldBlockFall(worldIn, posNorth, physicsNorth)) continue;
                gapNorth = true;
                Main.getChunkData(event.getWorld(), posNorth).getBlockUpdateQueue().add(new BlockUpdate(posNorth, EnumUpdateType.FALL));
            }
        }
    }

    @SubscribeEvent
    public static final void onUpdate(TickEvent.WorldTickEvent event) {
        if (event.world.field_72995_K) {
            return;
        }
        if (ticksSkipped < ModConfig.tickSkips) {
            ++ticksSkipped;
            return;
        }
        ticksSkipped = 0;
        List players = event.world.field_73010_i;
        blocksUpdatedThisTick = 0;
        for (EntityPlayer player : players) {
            Main.updateChunkForPlayer(event.world, player);
            if (currentMovingBlocks >= ModConfig.maxMovingBlocks || blocksUpdatedThisTick >= ModConfig.maxFallingBlocksPerUpdate) continue;
            Main.updateFallingBlocksForPlayer(event.world, player);
        }
    }

    private static final void updateChunkForPlayer(World worldIn, EntityPlayer player) {
        ChunkPos playerChunkPos = new ChunkPos(player.func_180425_c());
        for (int i = 0; i <= ModConfig.blockUpdateRange; ++i) {
            for (int x = playerChunkPos.field_77276_a - i; x <= playerChunkPos.field_77276_a + i; ++x) {
                int incZ = x == playerChunkPos.field_77276_a - i || x == playerChunkPos.field_77276_a + i ? 1 : i * 2;
                for (int z = playerChunkPos.field_77275_b - i; z <= playerChunkPos.field_77275_b + i; z += incZ) {
                    ChunkPos chunkPos = new ChunkPos(x, z);
                    ChunkData chunkData = chunksToUpdate.get(chunkPos);
                    if (chunkData == null || !chunkData.isRequiresUpdateNow() || chunkData.isHasUpdated()) continue;
                    BlockPos chunkOrigin = new BlockPos(chunkPos.field_77276_a * 16, 0, chunkPos.field_77275_b * 16);
                    Chunk chunk = worldIn.func_175726_f(chunkOrigin);
                    for (int chunkY = 0; chunkY <= 255; ++chunkY) {
                        for (int chunkX = 0; chunkX < 16; ++chunkX) {
                            for (int chunkZ = 0; chunkZ < 16; ++chunkZ) {
                                BlockPos blockPosActual;
                                IBlockState block = chunk.func_186032_a(chunkX, chunkY, chunkZ);
                                PhysicsDef physicsDef = ModConfig.getPhysicsDefFor(block.func_177230_c());
                                if (physicsDef == null || physicsDef.isRequiresNeighbourUpdate() || !Physics.shouldBlockFall(worldIn, blockPosActual = new BlockPos(chunkOrigin.func_177958_n() + chunkX, chunkY, chunkOrigin.func_177952_p() + chunkZ), physicsDef)) continue;
                                chunkData.getBlockUpdateQueue().add(new BlockUpdate(blockPosActual, EnumUpdateType.FALL));
                            }
                        }
                    }
                    chunkData.setRequiresUpdateNow(false);
                    chunkData.setHasUpdated(true);
                }
            }
        }
    }

    private static void updateFallingBlocksForPlayer(World worldIn, EntityPlayer player) {
        ChunkPos playerChunkPos = new ChunkPos(player.func_180425_c());
        for (int i = 0; i <= ModConfig.blockUpdateRange; ++i) {
            for (int x = playerChunkPos.field_77276_a - i; x <= playerChunkPos.field_77276_a + i; ++x) {
                int incZ = x == playerChunkPos.field_77276_a - i || x == playerChunkPos.field_77276_a + i ? 1 : i * 2;
                for (int z = playerChunkPos.field_77275_b - i; z <= playerChunkPos.field_77275_b + i; z += incZ) {
                    BlockUpdate update;
                    ChunkPos chunkPos = new ChunkPos(x, z);
                    ChunkData chunkData = Main.getChunkData(chunkPos);
                    if (chunkData == null) continue;
                    while ((update = (BlockUpdate)chunkData.getBlockUpdateQueue().poll()) != null) {
                        BlockPos summonPos = null;
                        PhysicsDef physicsDef = ModConfig.getPhysicsDefFor(worldIn, update.getOriginPos());
                        IBlockState blockState = worldIn.func_180495_p(update.getOriginPos());
                        if (physicsDef == null) continue;
                        if (update.getUpdateType().equals((Object)EnumUpdateType.FALL)) {
                            summonPos = update.getOriginPos();
                        } else if (update.getUpdateType().equals((Object)EnumUpdateType.SLIDE)) {
                            summonPos = Physics.getRandomSlideResultFor(worldIn, update.getOriginPos(), ModConfig.getPhysicsDefFor(worldIn, update.getOriginPos()), 1.0f);
                            worldIn.func_175698_g(update.getOriginPos());
                        }
                        if (summonPos == null) continue;
                        Main.summonFallingBlock(worldIn, summonPos, blockState, physicsDef);
                        if (++blocksUpdatedThisTick < ModConfig.maxFallingBlocksPerUpdate && currentMovingBlocks < ModConfig.maxMovingBlocks) continue;
                        return;
                    }
                }
            }
        }
    }

    public static final void summonFallingBlock(World worldIn, BlockPos pos, IBlockState blockState, PhysicsDef physicsDef) {
        worldIn.func_72838_d((Entity)new EntityFallingRBPBlock(worldIn, (float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f, blockState, physicsDef));
        worldIn.func_175698_g(pos);
        Main.incMovingBlocks(1);
    }

    public static final boolean isBlockQueuedToUpdate(World worldIn, BlockPos pos) {
        ChunkData chunkData = Main.getChunkData(worldIn, pos);
        return chunkData != null ? chunkData.getBlockUpdateQueue().contains(new BlockUpdate(pos, EnumUpdateType.NONE)) : false;
    }

    public static final ChunkData getChunkData(World worldIn, BlockPos pos) {
        return chunksToUpdate.get(worldIn.func_175726_f(pos).func_76632_l());
    }

    public static final ChunkData getChunkData(ChunkPos pos) {
        return chunksToUpdate.get(pos);
    }

    private static final synchronized void incMovingBlocks(int value) {
        currentMovingBlocks += value;
    }

    static {
        ticksSkipped = 0;
        currentMovingBlocks = 0;
        blocksUpdatedThisTick = 0;
        chunksToUpdate = new Hashtable();
    }
}

