/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xbigellx.rbp.BlockSupport;
import xbigellx.rbp.Main;
import xbigellx.rbp.PhysicsDef;
import xbigellx.rbp.util.BlockUtils;
import xbigellx.rbp.util.ModConfig;

public class Physics {
    public static boolean shouldBlockFall(World worldIn, BlockPos pos, PhysicsDef physicsDef) {
        if (physicsDef == null) {
            return false;
        }
        if (physicsDef.getDimensionsBlacklist().contains(worldIn.field_73011_w.func_186058_p().func_186065_b())) {
            return false;
        }
        if (Physics.isBlockSupportBeneath(worldIn, pos)) {
            return false;
        }
        if (Physics.shouldBlockFloatOnWater(worldIn, pos, physicsDef)) {
            return false;
        }
        return !Physics.isBlockPartOfStructure(worldIn, pos, physicsDef);
    }

    public static boolean isBlockPartOfStructure(World worldIn, BlockPos pos, PhysicsDef physicsDef) {
        if (!physicsDef.isAttachable()) {
            return false;
        }
        return Physics.getSupportingBlocks(worldIn, pos).size() > 0;
    }

    public static BlockPos getBestSupportingBlock(World worldIn, BlockPos pos) {
        List<BlockSupport> supports = Physics.getSupportingBlocks(worldIn, pos);
        BlockSupport bestSupport = null;
        for (BlockSupport support : supports) {
            if (bestSupport != null && support.getSupportValue() <= bestSupport.getSupportValue()) continue;
            bestSupport = support;
        }
        if (bestSupport != null) {
            return bestSupport.getPos();
        }
        return null;
    }

    public static final List<BlockSupport> getSupportingBlocks(World worldIn, BlockPos pos) {
        ArrayList<BlockSupport> supports = new ArrayList<BlockSupport>();
        boolean gapWest = false;
        boolean gapEast = false;
        boolean gapSouth = false;
        boolean gapNorth = false;
        for (int i = 1; !(i > (ModConfig.blockUpdateRange + 1) * 16 || gapWest && gapEast && gapSouth && gapNorth); ++i) {
            BlockPos posNorth;
            BlockPos posSouth;
            BlockPos posEast;
            BlockPos posWest;
            if (!Physics.canBlockBeConnectedTo(worldIn, new BlockPos(pos.func_177958_n() + i, pos.func_177956_o(), pos.func_177952_p()))) {
                gapWest = true;
            }
            if (!Physics.canBlockBeConnectedTo(worldIn, new BlockPos(pos.func_177958_n() - i, pos.func_177956_o(), pos.func_177952_p()))) {
                gapEast = true;
            }
            if (!Physics.canBlockBeConnectedTo(worldIn, new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + i))) {
                gapSouth = true;
            }
            if (!Physics.canBlockBeConnectedTo(worldIn, new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - i))) {
                gapNorth = true;
            }
            if (Physics.isBlockSupportBeneath(worldIn, posWest = new BlockPos(pos.func_177958_n() + i, pos.func_177956_o(), pos.func_177952_p())) && !gapWest) {
                gapWest = true;
                int support = Physics.getSupportValueFor(worldIn, posWest, pos);
                if (support > 0) {
                    supports.add(new BlockSupport(posWest, support));
                }
            }
            if (Physics.isBlockSupportBeneath(worldIn, posEast = new BlockPos(pos.func_177958_n() - i, pos.func_177956_o(), pos.func_177952_p())) && !gapEast) {
                gapEast = true;
                int support = Physics.getSupportValueFor(worldIn, posEast, pos);
                if (support > 0) {
                    supports.add(new BlockSupport(posEast, support));
                }
            }
            if (Physics.isBlockSupportBeneath(worldIn, posSouth = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + i)) && !gapSouth) {
                gapSouth = true;
                int support = Physics.getSupportValueFor(worldIn, posSouth, pos);
                if (support > 0) {
                    supports.add(new BlockSupport(posSouth, support));
                }
            }
            if (!Physics.isBlockSupportBeneath(worldIn, posNorth = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - i)) || gapNorth) continue;
            gapNorth = true;
            int support = Physics.getSupportValueFor(worldIn, posNorth, pos);
            if (support <= 0) continue;
            supports.add(new BlockSupport(posNorth, support));
        }
        return supports;
    }

    public static int getSupportValueFor(World worldIn, BlockPos support, BlockPos origin) {
        PhysicsDef physicsDef = ModConfig.getPhysicsDefFor(worldIn.func_180495_p(support).func_177230_c());
        if (physicsDef == null) {
            return 0;
        }
        int distance = BlockUtils.getBlockDistanceBetween(support, origin);
        int supportValue = physicsDef.getSupportMass();
        for (int i = 1; i <= distance; ++i) {
            int xInc;
            int n = support.func_177958_n() == origin.func_177958_n() ? 0 : (xInc = support.func_177958_n() < origin.func_177958_n() ? i : -i);
            int zInc = support.func_177952_p() == origin.func_177952_p() ? 0 : (support.func_177952_p() < origin.func_177952_p() ? i : -i);
            BlockPos pos = new BlockPos(support.func_177958_n() + xInc, support.func_177956_o(), support.func_177952_p() + zInc);
            PhysicsDef physics = ModConfig.getPhysicsDefFor(worldIn.func_180495_p(pos).func_177230_c());
            if (physics == null) {
                return 0;
            }
            if ((supportValue -= physics.getMass()) <= physics.getSupportMass()) continue;
            supportValue = physics.getSupportMass();
        }
        return supportValue;
    }

    public static final boolean canBlockBePillar(World worldIn, BlockPos pos) {
        return !worldIn.func_175623_d(pos) && !Main.isBlockQueuedToUpdate(worldIn, pos) && !BlockFalling.func_185759_i((IBlockState)worldIn.func_180495_p(pos)) && !ModConfig.crushableBlocks.contains(worldIn.func_180495_p(pos).func_177230_c().getRegistryName().toString());
    }

    public static boolean isBlockSupportBeneath(World worldIn, BlockPos pos) {
        return Physics.canBlockBePillar(worldIn, new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p()));
    }

    public static boolean isPillarSupportingBlock(World worldIn, BlockPos pos) {
        if (ModConfig.getPhysicsDefFor(worldIn, pos) == null || Physics.getRandomSlideResultFor(worldIn, pos, ModConfig.getPhysicsDefFor(worldIn, pos), 1.0f) == null) {
            return false;
        }
        int totalMass = ModConfig.getPhysicsDefFor(worldIn, pos).getMass();
        for (int i = pos.func_177956_o() - 1; i >= 0; --i) {
            BlockPos supportPos = new BlockPos(pos.func_177958_n(), i, pos.func_177952_p());
            if (!Physics.canBlockBePillar(worldIn, supportPos)) {
                return false;
            }
            List<BlockSupport> supports = Physics.getSupportingBlocks(worldIn, new BlockPos(pos.func_177958_n(), i, pos.func_177952_p()));
            boolean supporting = false;
            for (BlockSupport support : supports) {
                for (BlockSupport blockSupport : Physics.getSupportingBlocks(worldIn, support.getPos())) {
                    BlockPos blockPos = blockSupport.getPos();
                    if (blockPos == null || blockPos.func_177958_n() == pos.func_177958_n() || blockPos.func_177952_p() == pos.func_177952_p()) continue;
                    supporting = true;
                    break;
                }
                if (!supporting) continue;
                break;
            }
            PhysicsDef supportPhysicsDef = ModConfig.getPhysicsDefFor(worldIn, supportPos);
            if (!supporting && supportPhysicsDef != null && supportPhysicsDef.getPillarSupportMass() != -1) {
                if (supportPhysicsDef.getPillarSupportMass() < totalMass) {
                    return false;
                }
                totalMass += supportPhysicsDef.getMass();
                continue;
            }
            return true;
        }
        return true;
    }

    public static final boolean canBlockBeConnectedTo(World worldIn, BlockPos pos) {
        return !worldIn.func_175623_d(pos) && !Main.isBlockQueuedToUpdate(worldIn, pos) && ModConfig.getPhysicsDefFor(worldIn, pos) != null;
    }

    public static boolean shouldBlockFloatOnWater(World worldIn, BlockPos pos, PhysicsDef physicsDef) {
        return !worldIn.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p())).func_185904_a().equals(Material.field_151586_h) && worldIn.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p())).func_185904_a().equals(Material.field_151586_h) && physicsDef.isFloatsOnWater();
    }

    public static final BlockPos getFallesultFor(World worldIn, BlockPos pos) {
        PhysicsDef physicsDef = ModConfig.getPhysicsDefFor(worldIn, pos);
        if (physicsDef == null) {
            return null;
        }
        if (Physics.shouldBlockFall(worldIn, pos, physicsDef)) {
            return pos;
        }
        return null;
    }

    public static final boolean shouldBlockSlideFromPillar(World worldIn, BlockPos pos) {
        PhysicsDef physicsDef = ModConfig.getPhysicsDefFor(worldIn, pos);
        if (physicsDef == null) {
            return false;
        }
        PhysicsDef physicsDefBeneath = ModConfig.getPhysicsDefFor(worldIn, new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p()));
        boolean blockBeneath = Physics.isBlockSupportBeneath(worldIn, pos);
        boolean partOfStructure = Physics.isBlockPartOfStructure(worldIn, pos, physicsDef);
        boolean supportedByPillar = Physics.isPillarSupportingBlock(worldIn, pos);
        if (blockBeneath && !partOfStructure && !supportedByPillar) {
            return Physics.getRandomSlideResultFor(worldIn, pos, physicsDef, 1.0f) != null;
        }
        if (physicsDefBeneath != null && blockBeneath && BlockUtils.getAdjacentBlocks(worldIn, pos).size() < physicsDefBeneath.getStackability()) {
            return Physics.getRandomSlideResultFor(worldIn, pos, physicsDef, 1.0f) != null;
        }
        return false;
    }

    public static BlockPos getRandomSlideResultFor(World worldIn, BlockPos pos, PhysicsDef physicsDef, float slideChance) {
        if (Math.random() >= (double)slideChance) {
            return null;
        }
        Random rand = new Random();
        ArrayList<BlockPos> potentialResults = new ArrayList<BlockPos>();
        BlockPos posWest = new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p());
        BlockPos posEast = new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p());
        BlockPos posSouth = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1);
        BlockPos posNorth = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1);
        if (!Physics.canBlockBePillar(worldIn, posWest) && !Physics.isBlockSupportBeneath(worldIn, posWest)) {
            potentialResults.add(posWest);
        }
        if (!Physics.canBlockBePillar(worldIn, posEast) && !Physics.isBlockSupportBeneath(worldIn, posEast)) {
            potentialResults.add(posEast);
        }
        if (!Physics.canBlockBePillar(worldIn, posSouth) && !Physics.isBlockSupportBeneath(worldIn, posSouth)) {
            potentialResults.add(posSouth);
        }
        if (!Physics.canBlockBePillar(worldIn, posNorth) && !Physics.isBlockSupportBeneath(worldIn, posNorth)) {
            potentialResults.add(posNorth);
        }
        if (potentialResults.size() == 0) {
            return null;
        }
        return (BlockPos)potentialResults.get(rand.nextInt(potentialResults.size()));
    }
}

