/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.entities;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import xbigellx.rbp.Main;
import xbigellx.rbp.Physics;
import xbigellx.rbp.PhysicsDef;
import xbigellx.rbp.events.RBPFallingBlockEvent;
import xbigellx.rbp.util.ModConfig;

public class EntityFallingRBPBlock
extends EntityFallingBlock {
    private final BlockPos initialPos;
    private final PhysicsDef physics;
    private boolean shouldBeDestroyed = false;
    private double lastVelocity = 0.0;

    public EntityFallingRBPBlock(World worldIn, double x, double y, double z, IBlockState fallingBlockState, PhysicsDef physics) {
        super(worldIn, x, y, z, fallingBlockState);
        this.initialPos = new BlockPos(x, y, z);
        this.physics = physics;
        this.field_145813_c = false;
        this.field_145812_b = 1;
        if (physics.isHurtsEntities()) {
            this.func_145806_a(true);
        }
        this.func_184174_b(true);
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.lastVelocity = Math.abs(this.field_70181_x);
        super.func_70071_h_();
        if (this.field_70128_L) {
            this.onDeath();
        } else if (this.field_70122_E) {
            this.onLanded();
        }
        BlockPos pos = this.func_180425_c();
        BlockPos posUnderneath = new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p());
        IBlockState blockUnderneath = this.field_70170_p.func_180495_p(posUnderneath);
        Block block = blockUnderneath.func_177230_c();
        if (block.equals(Blocks.field_185774_da) || block.equals(Blocks.field_150458_ak)) {
            this.field_70170_p.func_175656_a(posUnderneath, Blocks.field_150346_d.func_176223_P());
        } else if (ModConfig.crushableBlocks.contains(block.getRegistryName().toString())) {
            this.field_70170_p.func_175655_b(posUnderneath, true);
        }
    }

    private final void onLanded() {
        MinecraftForge.EVENT_BUS.post((Event)new RBPFallingBlockEvent.LandedEvent(this));
        this.checkBlockBreak();
        this.checkBlockSlide();
    }

    private final void onDeath() {
        MinecraftForge.EVENT_BUS.post((Event)new RBPFallingBlockEvent.DestroyedEvent(this));
        this.checkBlockBreak();
        this.checkBlockSlide();
    }

    private final void checkBlockSlide() {
        if (this.shouldBeDestroyed) {
            return;
        }
        if (Physics.shouldBlockSlideFromPillar(this.field_70170_p, this.func_180425_c())) {
            this.field_70170_p.func_175698_g(this.func_180425_c());
            Main.summonFallingBlock(this.field_70170_p, Physics.getRandomSlideResultFor(this.field_70170_p, this.func_180425_c(), this.physics, 1.0f), this.func_175131_l(), this.physics);
        } else {
            BlockPos slideResult = Physics.getRandomSlideResultFor(this.field_70170_p, this.func_180425_c(), this.physics, (float)this.physics.getSlideChanceOnLanded());
            if (slideResult != null) {
                this.field_70170_p.func_175698_g(this.func_180425_c());
                Main.summonFallingBlock(this.field_70170_p, slideResult, this.func_175131_l(), this.physics);
            }
        }
    }

    private final void checkBlockBreak() {
        if (this.lastVelocity >= this.physics.getBreakMinVelocity()) {
            if (Math.random() < this.physics.getBreakChance()) {
                this.shouldBeDestroyed = true;
                this.field_70170_p.func_175655_b(this.func_180425_c(), true);
            }
        } else if (this.field_70170_p.func_180495_p(this.func_180425_c()) != this.func_175131_l()) {
            this.shouldBeDestroyed = true;
            this.field_70170_p.func_175655_b(this.func_180425_c(), true);
        }
    }

    public final BlockPos getInitialPos() {
        return this.initialPos;
    }
}

