/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockUtils {
    public static final int getBlockDistanceBetween(BlockPos pos1, BlockPos pos2) {
        return Math.max(Math.abs(Math.abs(pos1.func_177958_n()) - Math.abs(pos2.func_177958_n())), Math.abs(Math.abs(pos1.func_177952_p()) - Math.abs(pos2.func_177952_p())));
    }

    public static final List<BlockPos> getBlockNeighbours(World worldIn, BlockPos pos, int radius) {
        ArrayList<BlockPos> neighbours = new ArrayList<BlockPos>();
        for (int y = pos.func_177956_o() - radius; y <= pos.func_177956_o() + radius; ++y) {
            for (int x = pos.func_177958_n() - radius; x <= pos.func_177958_n() + radius; ++x) {
                for (int z = pos.func_177952_p() - radius; z <= pos.func_177952_p() + radius; ++z) {
                    BlockPos neighbour = new BlockPos(x, y, z);
                    if (neighbour.equals((Object)pos)) continue;
                    neighbours.add(neighbour);
                }
            }
        }
        return neighbours;
    }

    public static final List<BlockPos> getAttachedBlocks(World worldIn, BlockPos pos) {
        ArrayList<BlockPos> attachedBlocks = new ArrayList<BlockPos>();
        if (!worldIn.func_175623_d(new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p()))) {
            attachedBlocks.add(new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p()));
        }
        if (!worldIn.func_175623_d(new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p()))) {
            attachedBlocks.add(new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p()));
        }
        if (!worldIn.func_175623_d(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1))) {
            attachedBlocks.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1));
        }
        if (!worldIn.func_175623_d(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1))) {
            attachedBlocks.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1));
        }
        if (!worldIn.func_175623_d(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p()))) {
            attachedBlocks.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p()));
        }
        if (!worldIn.func_175623_d(new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p()))) {
            attachedBlocks.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p()));
        }
        return attachedBlocks;
    }

    public static final List<BlockPos> getAdjacentBlocks(World worldIn, BlockPos pos) {
        ArrayList<BlockPos> adjacentBlocks = new ArrayList<BlockPos>();
        if (!worldIn.func_175623_d(new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p()))) {
            adjacentBlocks.add(new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p()));
        }
        if (!worldIn.func_175623_d(new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p()))) {
            adjacentBlocks.add(new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p()));
        }
        if (!worldIn.func_175623_d(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1))) {
            adjacentBlocks.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1));
        }
        if (!worldIn.func_175623_d(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1))) {
            adjacentBlocks.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1));
        }
        return adjacentBlocks;
    }

    public static final BlockPos worldPosToChunkRelative(BlockPos pos) {
        int x = pos.func_177958_n() >= 0 ? pos.func_177958_n() % 16 : Math.abs(Math.abs(pos.func_177958_n() + 1) % 16 - 15);
        int z = pos.func_177952_p() >= 0 ? pos.func_177952_p() % 16 : Math.abs(Math.abs(pos.func_177952_p() + 1) % 16 - 15);
        return new BlockPos(x, pos.func_177956_o(), z);
    }
}

