/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.util;

import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import xbigellx.rbp.Physics;

public final class ChunkUtils {
    public static final int getMaxPopulatedLayerOfChunk(World worldIn, Chunk chunk) {
        return ChunkUtils.getMaxPopulatedLayerOfChunk(worldIn, chunk, 255);
    }

    public static final int getMaxPopulatedLayerOfChunk(World worldIn, Chunk chunk, int startY) {
        for (int y = startY; y >= 0; --y) {
            if (!ChunkUtils.chunkLayerContainsBlock(worldIn, chunk, y)) continue;
            return y;
        }
        return -1;
    }

    public static final int getMinTransparentChunkLayer(World worldIn, Chunk chunk) {
        for (int y = 0; y < 256; ++y) {
            if (!ChunkUtils.chunkLayerIsTransparent(worldIn, chunk, y)) continue;
            return y;
        }
        return 256;
    }

    public static final boolean chunkLayerContainsBlock(World worldIn, Chunk chunk, int layer) {
        ChunkPos pos = chunk.func_76632_l();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                if (worldIn.func_175623_d(new BlockPos(pos.func_180334_c() + x, layer, pos.func_180333_d() + z))) continue;
                return true;
            }
        }
        return false;
    }

    public static final boolean chunkLayerIsTransparent(World worldIn, Chunk chunk, int layer) {
        ChunkPos pos = chunk.func_76632_l();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                if (!Physics.canBlockBeConnectedTo(worldIn, new BlockPos(pos.func_180334_c() + x, layer, pos.func_180333_d() + z))) continue;
                return true;
            }
        }
        return false;
    }

    public static final int getChunkDistanceBetween(ChunkPos pos1, ChunkPos pos2) {
        return Math.max(Math.abs(Math.abs(pos1.field_77276_a) - Math.abs(pos2.field_77276_a)), Math.abs(Math.abs(pos1.field_77275_b) - Math.abs(pos2.field_77275_b)));
    }
}

