/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.util;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import xbigellx.rbp.PhysicsDef;
import xbigellx.rbp.util.ArrayConverter;

public final class ModConfig
extends Configuration {
    private static final HashMap<String, PhysicsDef> physicsDefs = new HashMap();
    public static int maxMovingBlocks;
    public static int blockUpdateRange;
    public static int chunkUpdateMode;
    public static int maxFallingBlocksPerUpdate;
    public static int tickSkips;
    public static boolean acaciaCheat;
    public static List<String> crushableBlocks;
    private static boolean existed;
    private static boolean applyDefaults;
    private static List<String> applyDefaultsBlacklist;
    private static Configuration config;

    public static final void init() {
        File file = new File("config/rbp.cfg");
        existed = file.exists();
        config = new Configuration(new File("config/rbp.cfg"));
        config.load();
        if (!existed) {
            ModConfig.writeDefaultConfig();
        }
        ModConfig.readConfig();
        physicsDefs.remove("minecraft:air");
        config.save();
    }

    private static void readConfig() {
        Set children = config.getCategory("physics_definitions").getChildren();
        ArrayConverter<String> converter = new ArrayConverter<String>();
        for (ConfigCategory child : children) {
            String[] blocks;
            for (String blockID : blocks = config.get("physics_definitions." + child.getName(), "Blocks", new String[0]).getStringList()) {
                ModConfig.applyPhysicsTo(blockID, "physics_definitions", child);
            }
        }
        blockUpdateRange = config.get("performance", "BlockUpdateRange", 4, "The range, in chunks, where block physics are updated.\n\t+ Increase this value to allow blocks to fall from further away.\n\t- Lower this value to help improve performance.\n[range: 0 --> 32] \n[default: 4]").getInt();
        chunkUpdateMode = config.get("performance", "ChunkUpdateMode", 0, "Dictates the requirements for a chunk update.\n\t0: Chunks will update instantly, as they are loaded. (worst performance)\n\t1: Chunks will only update whenever the player enters or interacts with a chunk.\n\t2: Chunks will only update whenever the player interacts with a chunk. (best performance)\n[default: 0]").getInt();
        maxFallingBlocksPerUpdate = config.get("performance", "MaxFallingBlocksPerUpdate", 10, "The maximum amount of blocks which can fall per update.\n\t+ Increase this value to allow for faster falling structures.\n\t- Lower this value to help improve performance.\n[range: 1 --> 10000] \n[default: 10]").getInt();
        maxMovingBlocks = config.get("performance", "MaxMovingBlocks", 250, "The maximum amount of falling blocks at any given time.\n\t+ Increase this value to allow for faster falling structures.\n\t- Lower this value to help improve performance.\n[range: 1 --> 10000] \n[default: 250]").getInt();
        tickSkips = config.get("performance", "TickSkips", 10, "The number of ticks that are skipped between each update. \n\t+ Increase this value to help improve performance.\n\t- Lower this value to reduce the delay between removing a support and the blocks connected to it falling.\n[range: 0 --> 100] \n[default: 10 (0.5 seconds)]").getInt();
        acaciaCheat = config.get("main", "AcaciaCheat", true, "Whether acacia trees should be prevented from falling until receiving a neighbouring block update (this will override the physics definition for 'minecraft:log2').\n[default: true]").getBoolean();
        applyDefaults = config.get("main", "ApplyDefaults", false, "Whether blocks without specified physics definitions should be given one by default (helpful for applying physics to mod blocks automatically).\n[default: false]").getBoolean();
        applyDefaultsBlacklist = converter.arrayToList(config.get("main", "ApplyDefaultsBlacklist", new String[]{"dynamictrees:oakbranch", "dynamictrees:birchbranch", "dynamictrees:sprucebranch", "dynamictrees:junglebranch", "dynamictrees:darkoakbranch", "dynamictrees:acaciabranch", "dynamictrees:leaves0"}, "A list of block IDs which will be prevented from receiving a default physics definition (Vanilla blocks are excluded by default).").getStringList());
        crushableBlocks = converter.arrayToList(config.get("main", "CrushableBlocks", new String[]{"minecraft:beetroot_seeds", "minecraft:brown_mushroom", "minecraft:comparator", "minecraft:double_plant", "minecraft:heavy_weighted_pressure_plate", "minecraft:lever", "minecraft:light_weighted_pressure_plate", "minecraft:powered_comparator", "minecraft:powered_repeater", "minecraft:pumpkin_seeds", "minecraft:redstone_torch", "minecraft:redstone_wire", "minecraft:repeater", "minecraft:sapling", "minecraft:snow_layer", "minecraft:standing_sign", "minecraft:stone_button", "minecraft:stone_pressure_plate", "minecraft:tallgrass", "minecraft:torch", "minecraft:unlit_redstone_torch", "minecraft:unpowered_comparator", "minecraft:unpowered_repeater", "minecraft:wheat", "minecraft:wheat_seeds", "minecraft:wooden_button", "minecraft:wooden_pressure_plate", "minecraft:yellow_flower"}, "A list of block IDs which falling blocks are able to crush.").getStringList());
        config.get("main.default_physics", "BreakChance", 0.1);
        config.get("main.default_physics", "BreakMinVelocity", 0.5);
        config.get("main.default_physics", "DimensionsBlacklist", new String[0]);
        config.get("main.default_physics", "FloatsOnWater", false);
        config.get("main.default_physics", "HurtsEntities", true);
        config.get("main.default_physics", "IsAttachable", true);
        config.get("main.default_physics", "Mass", 500);
        config.get("main.default_physics", "PillarSupportMass", -1);
        config.get("main.default_physics", "RequiresNeighbourUpdate", false);
        config.get("main.default_physics", "SlideChanceOnLanded", 0.6);
        config.get("main.default_physics", "SlideChanceOnPlaced", 0.0);
        config.get("main.default_physics", "SupportMass", 3000);
        config.setCategoryComment("main.default_physics", "The default physics definition to be applied to blocks without one, if 'ApplyDefaults' is enabled.");
        maxMovingBlocks = ModConfig.clampInt(maxMovingBlocks, 1, 10000);
        chunkUpdateMode = ModConfig.clampInt(chunkUpdateMode, 0, 2);
        maxFallingBlocksPerUpdate = ModConfig.clampInt(maxFallingBlocksPerUpdate, 1, 10000);
        blockUpdateRange = ModConfig.clampInt(blockUpdateRange, 0, 32);
        tickSkips = ModConfig.clampInt(tickSkips, 0, 100);
        if (acaciaCheat && physicsDefs.get("minecraft:log2") != null) {
            physicsDefs.get("minecraft:log2").setRequiresNeighbourUpdate(true);
        }
        if (applyDefaults) {
            Set registeredBlocks = Block.field_149771_c.func_148742_b();
            for (ResourceLocation location : registeredBlocks) {
                String blockID = location.toString();
                for (String blacklistedID : applyDefaultsBlacklist) {
                    if (physicsDefs.containsKey(blockID) || !blockID.startsWith(blacklistedID) || blockID.startsWith("minecraft")) continue;
                    ConfigCategory defaultPhysics = config.getCategory("main.default_physics");
                    ModConfig.applyPhysicsTo(location.toString(), "main", defaultPhysics);
                }
            }
        }
    }

    private static final void applyPhysicsTo(String blockID, String categoryName, ConfigCategory data) {
        ArrayConverter<String> converter = new ArrayConverter<String>();
        double breakChance = config.get(categoryName + "." + data.getName(), "BreakChance", 0.1).getDouble();
        double breakMinVelocity = config.get(categoryName + "." + data.getName(), "BreakMinVelocity", 0.5).getDouble();
        String[] dimensionsBlacklist = config.get(categoryName + "." + data.getName(), "DimensionsBlacklist", new String[0]).getStringList();
        boolean floatsOnWater = config.get(categoryName + "." + data.getName(), "FloatsOnWater", false).getBoolean();
        boolean hurtsEntities = config.get(categoryName + "." + data.getName(), "HurtsEntities", true).getBoolean();
        boolean isAttachable = config.get(categoryName + "." + data.getName(), "IsAttachable", true).getBoolean();
        int mass = ModConfig.clampInt(config.get(categoryName + "." + data.getName(), "Mass", 500).getInt(), 0, Integer.MAX_VALUE);
        int pillarSupportMass = ModConfig.clampInt(config.get(categoryName + "." + data.getName(), "PillarSupportMass", -1).getInt(), -1, Integer.MAX_VALUE);
        boolean requiresNeighbourUpdate = config.get(categoryName + "." + data.getName(), "RequiresNeighbourUpdate", false).getBoolean();
        double slideChanceOnLanded = ModConfig.clampDouble(config.get(categoryName + "." + data.getName(), "SlideChanceOnLanded", 0.6).getDouble(), 0.0, 1.0);
        double slideChanceOnPlaced = ModConfig.clampDouble(config.get(categoryName + "." + data.getName(), "SlideChanceOnPlaced", 0.0).getDouble(), 0.0, 1.0);
        int supportMass = ModConfig.clampInt(config.get(categoryName + "." + data.getName(), "SupportMass", 3000).getInt(), 0, Integer.MAX_VALUE);
        PhysicsDef physicsDef = new PhysicsDef().setBreakChance(breakChance).setBreakMinVelocity(breakMinVelocity).setDimensionsBlacklist(converter.arrayToList(dimensionsBlacklist)).setFloatsOnWater(floatsOnWater).setHurtsEntities(hurtsEntities).setAttachable(isAttachable).setMass(mass).setPillarSupportMass(pillarSupportMass).setRequiresNeighbourUpdate(requiresNeighbourUpdate).setSlideChanceOnLanded(slideChanceOnLanded).setSlideChanceOnPlaced(slideChanceOnPlaced).setSupportMass(supportMass);
        physicsDefs.put(blockID, physicsDef);
    }

    private static void writeDefaultConfig() {
        config.addCustomCategoryComment("physics_definitions", "Here, you can define your own block definitions to suite your gameplay.\nYou can use the default examples below to help create your own.\n\nBlocks: A list of block IDs which the definition affects\nBreakChance: The chance of the blocks within the definition will break after falling and landing, after a certain velocity has been reached.\nBreakMinVelocity: The minimum velocity the blocks within the definition must be falling at before they have a chance to break.\nDimensionsBlacklist: A list of dimensions where the blocks within the definition will not be affected by physics.\nFloatsOnWater: Whether the blocks within the definition will float if there is a water block beneath it.\nHurtsEntities: Whether the blocks in the definition will hurt entities after falling and landing on them.\nIsAttachable: Whether the blocks in the definition can attach to other blocks (a value of 'false' acts like Vanilla sand).\nMass: The mass of the blocks within the definition.\nPillarSupportMass: The maximum mass of blocks which can be stacked on top of the blocks within this definition before they slide off (a value of '-1' will disable this feature).\nRequiresNeighbourUpdate: Whether the blocks within the definition require an update from any neighbouring blocks before physics are checked.\nSlideChanceOnLanded: The chance of the blocks within the definition  sliding after falling and landing.\nSlideChanceOnPlaced: The chance of the blocks within the definition sliding after being placed.\nSupportMass: The maximum mass of blocks which can be built across from a supporting block within the definition.");
        config.get("physics_definitions.beacon", "Blocks", new String[]{"minecraft:beacon"});
        config.get("physics_definitions.beacon", "BreakChance", 0.1);
        config.get("physics_definitions.beacon", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.beacon", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.beacon", "FloatsOnWater", false);
        config.get("physics_definitions.beacon", "HurtsEntities", true);
        config.get("physics_definitions.beacon", "IsAttachable", false);
        config.get("physics_definitions.beacon", "Mass", 600);
        config.get("physics_definitions.beacon", "PillarSupportMass", 0);
        config.get("physics_definitions.beacon", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.beacon", "SlideChanceOnLanded", 0.8);
        config.get("physics_definitions.beacon", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.beacon", "SupportMass", 0);
        config.get("physics_definitions.bed", "Blocks", new String[]{"minecraft:bed"});
        config.get("physics_definitions.bed", "BreakChance", 0.8);
        config.get("physics_definitions.bed", "BreakMinVelocity", 0.4);
        config.get("physics_definitions.bed", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.bed", "FloatsOnWater", false);
        config.get("physics_definitions.bed", "HurtsEntities", true);
        config.get("physics_definitions.bed", "IsAttachable", false);
        config.get("physics_definitions.bed", "Mass", 250);
        config.get("physics_definitions.bed", "PillarSupportMass", 0);
        config.get("physics_definitions.bed", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.bed", "SlideChanceOnLanded", (double)0.65f);
        config.get("physics_definitions.bed", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.bed", "SupportMass", 0);
        config.get("physics_definitions.block_of_bone", "Blocks", new String[]{"minecraft:bone_block"});
        config.get("physics_definitions.block_of_bone", "BreakChance", 0.1);
        config.get("physics_definitions.block_of_bone", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.block_of_bone", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.block_of_bone", "FloatsOnWater", false);
        config.get("physics_definitions.block_of_bone", "HurtsEntities", true);
        config.get("physics_definitions.block_of_bone", "IsAttachable", true);
        config.get("physics_definitions.block_of_bone", "Mass", 150);
        config.get("physics_definitions.block_of_bone", "PillarSupportMass", -1);
        config.get("physics_definitions.block_of_bone", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.block_of_bone", "SlideChanceOnLanded", 0.8);
        config.get("physics_definitions.block_of_bone", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.block_of_bone", "SupportMass", 400);
        config.get("physics_definitions.block_of_coal", "Blocks", new String[]{"minecraft:coal_block"});
        config.get("physics_definitions.block_of_coal", "BreakChance", 0.1);
        config.get("physics_definitions.block_of_coal", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.block_of_coal", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.block_of_coal", "FloatsOnWater", false);
        config.get("physics_definitions.block_of_coal", "HurtsEntities", true);
        config.get("physics_definitions.block_of_coal", "IsAttachable", true);
        config.get("physics_definitions.block_of_coal", "Mass", 1000);
        config.get("physics_definitions.block_of_coal", "PillarSupportMass", -1);
        config.get("physics_definitions.block_of_coal", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.block_of_coal", "SlideChanceOnLanded", 0.8);
        config.get("physics_definitions.block_of_coal", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.block_of_coal", "SupportMass", 2000);
        config.get("physics_definitions.block_of_diamond", "Blocks", new String[]{"minecraft:diamond_block"});
        config.get("physics_definitions.block_of_diamond", "BreakChance", 0.1);
        config.get("physics_definitions.block_of_diamond", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.block_of_diamond", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.block_of_diamond", "FloatsOnWater", false);
        config.get("physics_definitions.block_of_diamond", "HurtsEntities", true);
        config.get("physics_definitions.block_of_diamond", "IsAttachable", true);
        config.get("physics_definitions.block_of_diamond", "Mass", 3500);
        config.get("physics_definitions.block_of_diamond", "PillarSupportMass", -1);
        config.get("physics_definitions.block_of_diamond", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.block_of_diamond", "SlideChanceOnLanded", 0.8);
        config.get("physics_definitions.block_of_diamond", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.block_of_diamond", "SupportMass", 2000);
        config.get("physics_definitions.block_of_emerald", "Blocks", new String[]{"minecraft:emerald_block"});
        config.get("physics_definitions.block_of_emerald", "BreakChance", 0.1);
        config.get("physics_definitions.block_of_emerald", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.block_of_emerald", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.block_of_emerald", "FloatsOnWater", false);
        config.get("physics_definitions.block_of_emerald", "HurtsEntities", true);
        config.get("physics_definitions.block_of_emerald", "IsAttachable", true);
        config.get("physics_definitions.block_of_emerald", "Mass", 2600);
        config.get("physics_definitions.block_of_emerald", "PillarSupportMass", -1);
        config.get("physics_definitions.block_of_emerald", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.block_of_emerald", "SlideChanceOnLanded", 0.8);
        config.get("physics_definitions.block_of_emerald", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.block_of_emerald", "SupportMass", 2000);
        config.get("physics_definitions.block_of_gold", "Blocks", new String[]{"minecraft:gold_block"});
        config.get("physics_definitions.block_of_gold", "BreakChance", 0.1);
        config.get("physics_definitions.block_of_gold", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.block_of_gold", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.block_of_gold", "FloatsOnWater", false);
        config.get("physics_definitions.block_of_gold", "HurtsEntities", true);
        config.get("physics_definitions.block_of_gold", "IsAttachable", true);
        config.get("physics_definitions.block_of_gold", "Mass", 15000);
        config.get("physics_definitions.block_of_gold", "PillarSupportMass", -1);
        config.get("physics_definitions.block_of_gold", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.block_of_gold", "SlideChanceOnLanded", 0.8);
        config.get("physics_definitions.block_of_gold", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.block_of_gold", "SupportMass", 2000);
        config.get("physics_definitions.block_of_iron", "Blocks", new String[]{"minecraft:iron_block"});
        config.get("physics_definitions.block_of_iron", "BreakChance", 0.1);
        config.get("physics_definitions.block_of_iron", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.block_of_iron", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.block_of_iron", "FloatsOnWater", false);
        config.get("physics_definitions.block_of_iron", "HurtsEntities", true);
        config.get("physics_definitions.block_of_iron", "IsAttachable", true);
        config.get("physics_definitions.block_of_iron", "Mass", 7800);
        config.get("physics_definitions.block_of_iron", "PillarSupportMass", -1);
        config.get("physics_definitions.block_of_iron", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.block_of_iron", "SlideChanceOnLanded", 0.8);
        config.get("physics_definitions.block_of_iron", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.block_of_iron", "SupportMass", 2000);
        config.get("physics_definitions.block_of_lapis", "Blocks", new String[]{"minecraft:lapis_block"});
        config.get("physics_definitions.block_of_lapis", "BreakChance", 0.1);
        config.get("physics_definitions.block_of_lapis", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.block_of_lapis", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.block_of_lapis", "FloatsOnWater", false);
        config.get("physics_definitions.block_of_lapis", "HurtsEntities", true);
        config.get("physics_definitions.block_of_lapis", "IsAttachable", true);
        config.get("physics_definitions.block_of_lapis", "Mass", 3000);
        config.get("physics_definitions.block_of_lapis", "PillarSupportMass", -1);
        config.get("physics_definitions.block_of_lapis", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.block_of_lapis", "SlideChanceOnLanded", 0.8);
        config.get("physics_definitions.block_of_lapis", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.block_of_lapis", "SupportMass", 2000);
        config.get("physics_definitions.block_of_quartz", "Blocks", new String[]{"minecraft:quartz_block"});
        config.get("physics_definitions.block_of_quartz", "BreakChance", 0.1);
        config.get("physics_definitions.block_of_quartz", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.block_of_quartz", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.block_of_quartz", "FloatsOnWater", false);
        config.get("physics_definitions.block_of_quartz", "HurtsEntities", true);
        config.get("physics_definitions.block_of_quartz", "IsAttachable", true);
        config.get("physics_definitions.block_of_quartz", "Mass", 2200);
        config.get("physics_definitions.block_of_quartz", "PillarSupportMass", -1);
        config.get("physics_definitions.block_of_quartz", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.block_of_quartz", "SlideChanceOnLanded", 0.8);
        config.get("physics_definitions.block_of_quartz", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.block_of_quartz", "SupportMass", 2000);
        config.get("physics_definitions.block_of_redstone", "Blocks", new String[]{"minecraft:redstone_block"});
        config.get("physics_definitions.block_of_redstone", "BreakChance", 0.1);
        config.get("physics_definitions.block_of_redstone", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.block_of_redstone", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.block_of_redstone", "FloatsOnWater", false);
        config.get("physics_definitions.block_of_redstone", "HurtsEntities", true);
        config.get("physics_definitions.block_of_redstone", "IsAttachable", true);
        config.get("physics_definitions.block_of_redstone", "Mass", 5000);
        config.get("physics_definitions.block_of_redstone", "PillarSupportMass", -1);
        config.get("physics_definitions.block_of_redstone", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.block_of_redstone", "SlideChanceOnLanded", 0.8);
        config.get("physics_definitions.block_of_redstone", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.block_of_redstone", "SupportMass", 2000);
        config.get("physics_definitions.bookshelf", "Blocks", new String[]{"minecraft:bookshelf"});
        config.get("physics_definitions.bookshelf", "BreakChance", 0.4);
        config.get("physics_definitions.bookshelf", "BreakMinVelocity", 0.4);
        config.get("physics_definitions.bookshelf", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.bookshelf", "FloatsOnWater", false);
        config.get("physics_definitions.bookshelf", "HurtsEntities", true);
        config.get("physics_definitions.bookshelf", "IsAttachable", false);
        config.get("physics_definitions.bookshelf", "Mass", 300);
        config.get("physics_definitions.bookshelf", "PillarSupportMass", -1);
        config.get("physics_definitions.bookshelf", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.bookshelf", "SlideChanceOnLanded", 0.8);
        config.get("physics_definitions.bookshelf", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.bookshelf", "SupportMass", 200);
        config.get("physics_definitions.brewing_stand", "Blocks", new String[]{"minecraft:brewing_stand"});
        config.get("physics_definitions.brewing_stand", "BreakChance", 1.0);
        config.get("physics_definitions.brewing_stand", "BreakMinVelocity", 0.4);
        config.get("physics_definitions.brewing_stand", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.brewing_stand", "FloatsOnWater", false);
        config.get("physics_definitions.brewing_stand", "HurtsEntities", true);
        config.get("physics_definitions.brewing_stand", "IsAttachable", false);
        config.get("physics_definitions.brewing_stand", "Mass", 200);
        config.get("physics_definitions.brewing_stand", "PillarSupportMass", 0);
        config.get("physics_definitions.brewing_stand", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.brewing_stand", "SlideChanceOnLanded", 0.8);
        config.get("physics_definitions.brewing_stand", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.brewing_stand", "SupportMass", 0);
        config.get("physics_definitions.bricks", "Blocks", new String[]{"minecraft:brick_block", "minecraft:nether_brick", "minecraft:end_bricks"});
        config.get("physics_definitions.bricks", "BreakChance", 0.15);
        config.get("physics_definitions.bricks", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.bricks", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.bricks", "FloatsOnWater", false);
        config.get("physics_definitions.bricks", "HurtsEntities", true);
        config.get("physics_definitions.bricks", "IsAttachable", true);
        config.get("physics_definitions.bricks", "Mass", 1800);
        config.get("physics_definitions.bricks", "PillarSupportMass", -1);
        config.get("physics_definitions.bricks", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.bricks", "SlideChanceOnLanded", 0.8);
        config.get("physics_definitions.bricks", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.bricks", "SupportMass", 8500);
        config.get("physics_definitions.cauldron", "Blocks", new String[]{"minecraft:cauldron"});
        config.get("physics_definitions.cauldron", "BreakChance", 0.3);
        config.get("physics_definitions.cauldron", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.cauldron", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.cauldron", "FloatsOnWater", false);
        config.get("physics_definitions.cauldron", "HurtsEntities", true);
        config.get("physics_definitions.cauldron", "IsAttachable", false);
        config.get("physics_definitions.cauldron", "Mass", 300);
        config.get("physics_definitions.cauldron", "PillarSupportMass", -1);
        config.get("physics_definitions.cauldron", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.cauldron", "SlideChanceOnLanded", 0.8);
        config.get("physics_definitions.cauldron", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.cauldron", "SupportMass", 0);
        config.get("physics_definitions.chest", "Blocks", new String[]{"minecraft:chest", "minecraft:trapped_chest", "minecraft:ender_chest"});
        config.get("physics_definitions.chest", "BreakChance", 0.0);
        config.get("physics_definitions.chest", "BreakMinVelocity", 0.4);
        config.get("physics_definitions.chest", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.chest", "FloatsOnWater", false);
        config.get("physics_definitions.chest", "HurtsEntities", true);
        config.get("physics_definitions.chest", "IsAttachable", false);
        config.get("physics_definitions.chest", "Mass", 550);
        config.get("physics_definitions.chest", "PillarSupportMass", 0);
        config.get("physics_definitions.chest", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.chest", "SlideChanceOnLanded", 0.65);
        config.get("physics_definitions.chest", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.chest", "SupportMass", 0);
        config.get("physics_definitions.chorus_plant", "Blocks", new String[]{"minecraft:chorus_plant"});
        config.get("physics_definitions.chorus_plant", "BreakChance", 0.6);
        config.get("physics_definitions.chorus_plant", "BreakMinVelocity", 0.4);
        config.get("physics_definitions.chorus_plant", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.chorus_plant", "FloatsOnWater", false);
        config.get("physics_definitions.chorus_plant", "HurtsEntities", true);
        config.get("physics_definitions.chorus_plant", "IsAttachable", true);
        config.get("physics_definitions.chorus_plant", "Mass", 5);
        config.get("physics_definitions.chorus_plant", "PillarSupportMass", -1);
        config.get("physics_definitions.chorus_plant", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.chorus_plant", "SlideChanceOnLanded", 0.6);
        config.get("physics_definitions.chorus_plant", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.chorus_plant", "SupportMass", 20);
        config.get("physics_definitions.clay", "Blocks", new String[]{"minecraft:clay"});
        config.get("physics_definitions.clay", "BreakChance", 0.45);
        config.get("physics_definitions.clay", "BreakMinVelocity", 0.5);
        config.get("physics_definitions.clay", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.clay", "FloatsOnWater", false);
        config.get("physics_definitions.clay", "HurtsEntities", true);
        config.get("physics_definitions.clay", "IsAttachable", true);
        config.get("physics_definitions.clay", "Mass", 600);
        config.get("physics_definitions.clay", "PillarSupportMass", -1);
        config.get("physics_definitions.clay", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.clay", "SlideChanceOnLanded", 0.8);
        config.get("physics_definitions.clay", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.clay", "SupportMass", 1200);
        config.get("physics_definitions.cobblestone", "Blocks", new String[]{"minecraft:cobblestone", "minecraft:mossy_cobblestone"});
        config.get("physics_definitions.cobblestone", "BreakChance", 0.3);
        config.get("physics_definitions.cobblestone", "BreakMinVelocity", 0.5);
        config.get("physics_definitions.cobblestone", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.cobblestone", "FloatsOnWater", false);
        config.get("physics_definitions.cobblestone", "HurtsEntities", true);
        config.get("physics_definitions.cobblestone", "IsAttachable", true);
        config.get("physics_definitions.cobblestone", "Mass", 1300);
        config.get("physics_definitions.cobblestone", "PillarSupportMass", 8000);
        config.get("physics_definitions.cobblestone", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.cobblestone", "SlideChanceOnLanded", 0.8);
        config.get("physics_definitions.cobblestone", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.cobblestone", "SupportMass", 5350);
        config.get("physics_definitions.concrete", "Blocks", new String[]{"minecraft:concrete"});
        config.get("physics_definitions.concrete", "BreakChance", 0.1);
        config.get("physics_definitions.concrete", "BreakMinVelocity", 0.8);
        config.get("physics_definitions.concrete", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.concrete", "FloatsOnWater", false);
        config.get("physics_definitions.concrete", "HurtsEntities", true);
        config.get("physics_definitions.concrete", "IsAttachable", true);
        config.get("physics_definitions.concrete", "Mass", 2500);
        config.get("physics_definitions.concrete", "PillarSupportMass", -1);
        config.get("physics_definitions.concrete", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.concrete", "SlideChanceOnLanded", 0.65);
        config.get("physics_definitions.concrete", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.concrete", "SupportMass", 12000);
        config.get("physics_definitions.crafting_table", "Blocks", new String[]{"minecraft:crafting_table"});
        config.get("physics_definitions.crafting_table", "BreakChance", 0.3);
        config.get("physics_definitions.crafting_table", "BreakMinVelocity", 0.4);
        config.get("physics_definitions.crafting_table", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.crafting_table", "FloatsOnWater", false);
        config.get("physics_definitions.crafting_table", "HurtsEntities", true);
        config.get("physics_definitions.crafting_table", "IsAttachable", false);
        config.get("physics_definitions.crafting_table", "Mass", 400);
        config.get("physics_definitions.crafting_table", "PillarSupportMass", -1);
        config.get("physics_definitions.crafting_table", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.crafting_table", "SlideChanceOnLanded", 0.65);
        config.get("physics_definitions.crafting_table", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.crafting_table", "SupportMass", 0);
        config.get("physics_definitions.daylight_detector", "Blocks", new String[]{"minecraft:daylight_detector", "minecraft:daylight_detector_inverted"});
        config.get("physics_definitions.daylight_detector", "BreakChance", 0.3);
        config.get("physics_definitions.daylight_detector", "BreakMinVelocity", 0.4);
        config.get("physics_definitions.daylight_detector", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.daylight_detector", "FloatsOnWater", false);
        config.get("physics_definitions.daylight_detector", "HurtsEntities", true);
        config.get("physics_definitions.daylight_detector", "IsAttachable", false);
        config.get("physics_definitions.daylight_detector", "Mass", 650);
        config.get("physics_definitions.daylight_detector", "PillarSupportMass", 0);
        config.get("physics_definitions.daylight_detector", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.daylight_detector", "SlideChanceOnLanded", (double)0.65f);
        config.get("physics_definitions.daylight_detector", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.daylight_detector", "SupportMass", 0);
        config.get("physics_definitions.dirt", "Blocks", new String[]{"minecraft:dirt", "minecraft:grass", "minecraft:grass_path", "minecraft:farmland", "minecraft:mycelium"});
        config.get("physics_definitions.dirt", "BreakChance", 0.25);
        config.get("physics_definitions.dirt", "BreakMinVelocity", 0.5);
        config.get("physics_definitions.dirt", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.dirt", "FloatsOnWater", false);
        config.get("physics_definitions.dirt", "HurtsEntities", true);
        config.get("physics_definitions.dirt", "IsAttachable", true);
        config.get("physics_definitions.dirt", "Mass", 650);
        config.get("physics_definitions.dirt", "PillarSupportMass", 4000);
        config.get("physics_definitions.dirt", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.dirt", "SlideChanceOnLanded", (double)0.65f);
        config.get("physics_definitions.dirt", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.dirt", "SupportMass", 1400);
        config.get("physics_definitions.dispenser", "Blocks", new String[]{"minecraft:dispenser", "minecraft:dropper"});
        config.get("physics_definitions.dispenser", "BreakChance", 0.0);
        config.get("physics_definitions.dispenser", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.dispenser", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.dispenser", "FloatsOnWater", false);
        config.get("physics_definitions.dispenser", "HurtsEntities", true);
        config.get("physics_definitions.dispenser", "IsAttachable", false);
        config.get("physics_definitions.dispenser", "Mass", 800);
        config.get("physics_definitions.dispenser", "PillarSupportMass", -1);
        config.get("physics_definitions.dispenser", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.dispenser", "SlideChanceOnLanded", 0.65);
        config.get("physics_definitions.dispenser", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.dispenser", "SupportMass", 0);
        config.get("physics_definitions.enchanting_table", "Blocks", new String[]{"minecraft:enchanting_table"});
        config.get("physics_definitions.enchanting_table", "BreakChance", 0.5);
        config.get("physics_definitions.enchanting_table", "BreakMinVelocity", 0.4);
        config.get("physics_definitions.enchanting_table", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.enchanting_table", "FloatsOnWater", false);
        config.get("physics_definitions.enchanting_table", "HurtsEntities", true);
        config.get("physics_definitions.enchanting_table", "IsAttachable", false);
        config.get("physics_definitions.enchanting_table", "Mass", 1000);
        config.get("physics_definitions.enchanting_table", "PillarSupportMass", 0);
        config.get("physics_definitions.enchanting_table", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.enchanting_table", "SlideChanceOnLanded", 0.6);
        config.get("physics_definitions.enchanting_table", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.enchanting_table", "SupportMass", 0);
        config.get("physics_definitions.end_stone", "Blocks", new String[]{"minecraft:end_stone"});
        config.get("physics_definitions.end_stone", "BreakChance", 0.1);
        config.get("physics_definitions.end_stone", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.end_stone", "DimensionsBlacklist", new String[]{"the_end"});
        config.get("physics_definitions.end_stone", "FloatsOnWater", false);
        config.get("physics_definitions.end_stone", "HurtsEntities", true);
        config.get("physics_definitions.end_stone", "IsAttachable", true);
        config.get("physics_definitions.end_stone", "Mass", 1400);
        config.get("physics_definitions.end_stone", "PillarSupportMass", -1);
        config.get("physics_definitions.end_stone", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.end_stone", "SlideChanceOnLanded", (double)0.8f);
        config.get("physics_definitions.end_stone", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.end_stone", "SupportMass", 3000);
        config.get("physics_definitions.fence", "Blocks", new String[]{"minecraft:fence", "minecraft:birch_fence", "minecraft:jungle_fence", "minecraft:spruce_fence", "minecraft:dark_oak_fence", "minecraft:acacia_fence", "minecraft:nether_brick_fence", "minecraft:fence_gate", "minecraft:birch_fence_gate", "minecraft:jungle_fence_gate", "minecraft:spruce_fence_gate", "minecraft:dark_oak_fence_gate", "minecraft:acacia_fence_gate", "minecraft:iron_bars"});
        config.get("physics_definitions.fence", "BreakChance", 0.25);
        config.get("physics_definitions.fence", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.fence", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.fence", "FloatsOnWater", false);
        config.get("physics_definitions.fence", "HurtsEntities", true);
        config.get("physics_definitions.fence", "IsAttachable", true);
        config.get("physics_definitions.fence", "Mass", 350);
        config.get("physics_definitions.fence", "PillarSupportMass", -1);
        config.get("physics_definitions.fence", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.fence", "SlideChanceOnLanded", 0.6);
        config.get("physics_definitions.fence", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.fence", "SupportMass", 1200);
        config.get("physics_definitions.furnace", "Blocks", new String[]{"minecraft:furnace", "minecraft:lit_furnace"});
        config.get("physics_definitions.furnace", "BreakChance", 0.0);
        config.get("physics_definitions.furnace", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.furnace", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.furnace", "FloatsOnWater", false);
        config.get("physics_definitions.furnace", "HurtsEntities", true);
        config.get("physics_definitions.furnace", "IsAttachable", false);
        config.get("physics_definitions.furnace", "Mass", 800);
        config.get("physics_definitions.furnace", "PillarSupportMass", -1);
        config.get("physics_definitions.furnace", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.furnace", "SlideChanceOnLanded", 0.65);
        config.get("physics_definitions.furnace", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.furnace", "SupportMass", 0);
        config.get("physics_definitions.glazed_terracotta", "Blocks", new String[]{"minecraft:white_glazed_terracotta", "minecraft:orange_glazed_terracotta", "minecraft:magenta_glazed_terracotta", "minecraft:light_blue_glazed_terracotta", "minecraft:yellow_glazed_terracotta", "minecraft:lime_glazed_terracotta", "minecraft:pink_glazed_terracotta", "minecraft:gray_glazed_terracotta", "minecraft:silver_glazed_terracotta", "minecraft:cyan_glazed_terracotta", "minecraft:purple_glazed_terracotta", "minecraft:blue_glazed_terracotta", "minecraft:brown_glazed_terracotta", "minecraft:green_glazed_terracotta", "minecraft:red_glazed_terracotta", "minecraft:black_glazed_terracotta"});
        config.get("physics_definitions.glazed_terracotta", "BreakChance", 0.1);
        config.get("physics_definitions.glazed_terracotta", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.glazed_terracotta", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.glazed_terracotta", "FloatsOnWater", false);
        config.get("physics_definitions.glazed_terracotta", "HurtsEntities", true);
        config.get("physics_definitions.glazed_terracotta", "IsAttachable", true);
        config.get("physics_definitions.glazed_terracotta", "Mass", 1400);
        config.get("physics_definitions.glazed_terracotta", "PillarSupportMass", -1);
        config.get("physics_definitions.glazed_terracotta", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.glazed_terracotta", "SlideChanceOnLanded", (double)0.8f);
        config.get("physics_definitions.glazed_terracotta", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.glazed_terracotta", "SupportMass", 3000);
        config.get("physics_definitions.glass", "Blocks", new String[]{"minecraft:glass", "minecraft:stained_glass", "minecraft:glass_pane", "minecraft:stained_glass_pane"});
        config.get("physics_definitions.glass", "BreakChance", 0.9);
        config.get("physics_definitions.glass", "BreakMinVelocity", 0.35);
        config.get("physics_definitions.glass", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.glass", "FloatsOnWater", false);
        config.get("physics_definitions.glass", "HurtsEntities", true);
        config.get("physics_definitions.glass", "IsAttachable", true);
        config.get("physics_definitions.glass", "Mass", 450);
        config.get("physics_definitions.glass", "PillarSupportMass", 2200);
        config.get("physics_definitions.glass", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.glass", "SlideChanceOnLanded", (double)0.65f);
        config.get("physics_definitions.glass", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.glass", "SupportMass", 800);
        config.get("physics_definitions.glowstone", "Blocks", new String[]{"minecraft:glowstone"});
        config.get("physics_definitions.glowstone", "BreakChance", 0.8);
        config.get("physics_definitions.glowstone", "BreakMinVelocity", 0.4);
        config.get("physics_definitions.glowstone", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.glowstone", "FloatsOnWater", false);
        config.get("physics_definitions.glowstone", "HurtsEntities", true);
        config.get("physics_definitions.glowstone", "IsAttachable", true);
        config.get("physics_definitions.glowstone", "Mass", 600);
        config.get("physics_definitions.glowstone", "PillarSupportMass", 2200);
        config.get("physics_definitions.glowstone", "RequiresNeighbourUpdate", true);
        config.get("physics_definitions.glowstone", "SlideChanceOnLanded", (double)0.8f);
        config.get("physics_definitions.glowstone", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.glowstone", "SupportMass", 1450);
        config.get("physics_definitions.hardened_clay", "Blocks", new String[]{"minecraft:hardened_clay", "minecraft:stained_hardened_clay"});
        config.get("physics_definitions.hardened_clay", "BreakChance", 0.1);
        config.get("physics_definitions.hardened_clay", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.hardened_clay", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.hardened_clay", "FloatsOnWater", false);
        config.get("physics_definitions.hardened_clay", "HurtsEntities", true);
        config.get("physics_definitions.hardened_clay", "IsAttachable", true);
        config.get("physics_definitions.hardened_clay", "Mass", 1600);
        config.get("physics_definitions.hardened_clay", "PillarSupportMass", -1);
        config.get("physics_definitions.hardened_clay", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.hardened_clay", "SlideChanceOnLanded", (double)0.8f);
        config.get("physics_definitions.hardened_clay", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.hardened_clay", "SupportMass", 3600);
        config.get("physics_definitions.hopper", "Blocks", new String[]{"minecraft:hopper"});
        config.get("physics_definitions.hopper", "BreakChance", 0.0);
        config.get("physics_definitions.hopper", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.hopper", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.hopper", "FloatsOnWater", false);
        config.get("physics_definitions.hopper", "HurtsEntities", true);
        config.get("physics_definitions.hopper", "IsAttachable", true);
        config.get("physics_definitions.hopper", "Mass", 850);
        config.get("physics_definitions.hopper", "PillarSupportMass", -1);
        config.get("physics_definitions.hopper", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.hopper", "SlideChanceOnLanded", 0.8);
        config.get("physics_definitions.hopper", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.hopper", "SupportMass", 2700);
        config.get("physics_definitions.ice", "Blocks", new String[]{"minecraft:ice", "minecraft:packed_ice"});
        config.get("physics_definitions.ice", "BreakChance", 0.85);
        config.get("physics_definitions.ice", "BreakMinVelocity", 0.45);
        config.get("physics_definitions.ice", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.ice", "FloatsOnWater", true);
        config.get("physics_definitions.ice", "HurtsEntities", true);
        config.get("physics_definitions.ice", "IsAttachable", true);
        config.get("physics_definitions.ice", "Mass", 900);
        config.get("physics_definitions.ice", "PillarSupportMass", -1);
        config.get("physics_definitions.ice", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.ice", "SlideChanceOnLanded", 0.8);
        config.get("physics_definitions.ice", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.ice", "SupportMass", 2100);
        config.get("physics_definitions.jukebox", "Blocks", new String[]{"minecraft:jukebox", "minecraft:noteblock"});
        config.get("physics_definitions.jukebox", "BreakChance", 0.6);
        config.get("physics_definitions.jukebox", "BreakMinVelocity", 0.4);
        config.get("physics_definitions.jukebox", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.jukebox", "FloatsOnWater", false);
        config.get("physics_definitions.jukebox", "HurtsEntities", true);
        config.get("physics_definitions.jukebox", "IsAttachable", false);
        config.get("physics_definitions.jukebox", "Mass", 200);
        config.get("physics_definitions.jukebox", "PillarSupportMass", -1);
        config.get("physics_definitions.jukebox", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.jukebox", "SlideChanceOnLanded", 0.65);
        config.get("physics_definitions.jukebox", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.jukebox", "SupportMass", 0);
        config.get("physics_definitions.leaves", "Blocks", new String[]{"minecraft:leaves", "minecraft:leaves2"});
        config.get("physics_definitions.leaves", "BreakChance", 0.4);
        config.get("physics_definitions.leaves", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.leaves", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.leaves", "FloatsOnWater", false);
        config.get("physics_definitions.leaves", "HurtsEntities", false);
        config.get("physics_definitions.leaves", "IsAttachable", true);
        config.get("physics_definitions.leaves", "Mass", 80);
        config.get("physics_definitions.leaves", "PillarSupportMass", 1400);
        config.get("physics_definitions.leaves", "RequiresNeighbourUpdate", true);
        config.get("physics_definitions.leaves", "SlideChanceOnLanded", 0.7);
        config.get("physics_definitions.leaves", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.leaves", "SupportMass", 380);
        config.get("physics_definitions.log", "Blocks", new String[]{"minecraft:log", "minecraft:log2"});
        config.get("physics_definitions.log", "BreakChance", 0.15);
        config.get("physics_definitions.log", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.log", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.log", "FloatsOnWater", false);
        config.get("physics_definitions.log", "HurtsEntities", true);
        config.get("physics_definitions.log", "IsAttachable", true);
        config.get("physics_definitions.log", "Mass", 750);
        config.get("physics_definitions.log", "PillarSupportMass", -1);
        config.get("physics_definitions.log", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.log", "SlideChanceOnLanded", 0.8);
        config.get("physics_definitions.log", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.log", "SupportMass", 2850);
        config.get("physics_definitions.magma", "Blocks", new String[]{"minecraft:magma"});
        config.get("physics_definitions.magma", "BreakChance", 0.1);
        config.get("physics_definitions.magma", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.magma", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.magma", "FloatsOnWater", false);
        config.get("physics_definitions.magma", "HurtsEntities", true);
        config.get("physics_definitions.magma", "IsAttachable", false);
        config.get("physics_definitions.magma", "Mass", 1200);
        config.get("physics_definitions.magma", "PillarSupportMass", -1);
        config.get("physics_definitions.magma", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.magma", "SlideChanceOnLanded", 0.8);
        config.get("physics_definitions.magma", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.magma", "SupportMass", 850);
        config.get("physics_definitions.mob_spawner", "Blocks", new String[]{"minecraft:mob_spawner"});
        config.get("physics_definitions.mob_spawner", "BreakChance", 0.0);
        config.get("physics_definitions.mob_spawner", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.mob_spawner", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.mob_spawner", "FloatsOnWater", false);
        config.get("physics_definitions.mob_spawner", "HurtsEntities", true);
        config.get("physics_definitions.mob_spawner", "IsAttachable", false);
        config.get("physics_definitions.mob_spawner", "Mass", 350);
        config.get("physics_definitions.mob_spawner", "PillarSupportMass", -1);
        config.get("physics_definitions.mob_spawner", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.mob_spawner", "SlideChanceOnLanded", 0.8);
        config.get("physics_definitions.mob_spawner", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.mob_spawner", "SupportMass", 0);
        config.get("physics_definitions.mushroom", "Blocks", new String[]{"minecraft:brown_mushroom_block", "minecraft:red_mushroom_block"});
        config.get("physics_definitions.mushroom", "BreakChance", 0.3);
        config.get("physics_definitions.mushroom", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.mushroom", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.mushroom", "FloatsOnWater", false);
        config.get("physics_definitions.mushroom", "HurtsEntities", true);
        config.get("physics_definitions.mushroom", "IsAttachable", true);
        config.get("physics_definitions.mushroom", "Mass", 400);
        config.get("physics_definitions.mushroom", "PillarSupportMass", -1);
        config.get("physics_definitions.mushroom", "RequiresNeighbourUpdate", true);
        config.get("physics_definitions.mushroom", "SlideChanceOnLanded", 0.8);
        config.get("physics_definitions.mushroom", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.mushroom", "SupportMass", 1200);
        config.get("physics_definitions.netherrack", "Blocks", new String[]{"minecraft:netherrack"});
        config.get("physics_definitions.netherrack", "BreakChance", 0.3);
        config.get("physics_definitions.netherrack", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.netherrack", "DimensionsBlacklist", new String[]{"the_nether"});
        config.get("physics_definitions.netherrack", "FloatsOnWater", false);
        config.get("physics_definitions.netherrack", "HurtsEntities", true);
        config.get("physics_definitions.netherrack", "IsAttachable", true);
        config.get("physics_definitions.netherrack", "Mass", 1000);
        config.get("physics_definitions.netherrack", "PillarSupportMass", 6500);
        config.get("physics_definitions.netherrack", "RequiresNeighbourUpdate", true);
        config.get("physics_definitions.netherrack", "SlideChanceOnLanded", 0.8);
        config.get("physics_definitions.netherrack", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.netherrack", "SupportMass", 2500);
        config.get("physics_definitions.observer", "Blocks", new String[]{"minecraft:observer"});
        config.get("physics_definitions.observer", "BreakChance", 0.0);
        config.get("physics_definitions.observer", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.observer", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.observer", "FloatsOnWater", false);
        config.get("physics_definitions.observer", "HurtsEntities", true);
        config.get("physics_definitions.observer", "IsAttachable", true);
        config.get("physics_definitions.observer", "Mass", 800);
        config.get("physics_definitions.observer", "PillarSupportMass", -1);
        config.get("physics_definitions.observer", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.observer", "SlideChanceOnLanded", 0.65);
        config.get("physics_definitions.observer", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.observer", "SupportMass", 0);
        config.get("physics_definitions.obsidian", "Blocks", new String[]{"minecraft:obsidian"});
        config.get("physics_definitions.obsidian", "BreakChance", 0.05);
        config.get("physics_definitions.obsidian", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.obsidian", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.obsidian", "FloatsOnWater", false);
        config.get("physics_definitions.obsidian", "HurtsEntities", true);
        config.get("physics_definitions.obsidian", "IsAttachable", true);
        config.get("physics_definitions.obsidian", "Mass", 2400);
        config.get("physics_definitions.obsidian", "PillarSupportMass", -1);
        config.get("physics_definitions.obsidian", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.obsidian", "SlideChanceOnLanded", 0.655);
        config.get("physics_definitions.obsidian", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.obsidian", "SupportMass", 6500);
        config.get("physics_definitions.ore", "Blocks", new String[]{"minecraft:coal_ore", "minecraft:iron_ore", "minecraft:gold_ore", "minecraft:lapis_ore", "minecraft:redstone_ore", "minecraft:lit_redstone_ore", "minecraft:diamond_ore", "minecraft:emerald_ore", "minecraft:quartz_ore"});
        config.get("physics_definitions.ore", "BreakChance", 0.3);
        config.get("physics_definitions.ore", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.ore", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.ore", "FloatsOnWater", false);
        config.get("physics_definitions.ore", "HurtsEntities", true);
        config.get("physics_definitions.ore", "IsAttachable", true);
        config.get("physics_definitions.ore", "Mass", 1250);
        config.get("physics_definitions.ore", "PillarSupportMass", -1);
        config.get("physics_definitions.ore", "RequiresNeighbourUpdate", true);
        config.get("physics_definitions.ore", "SlideChanceOnLanded", 0.655);
        config.get("physics_definitions.ore", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.ore", "SupportMass", 2500);
        config.get("physics_definitions.piston", "Blocks", new String[]{"minecraft:piston"});
        config.get("physics_definitions.piston", "BreakChance", 0.4);
        config.get("physics_definitions.piston", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.piston", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.piston", "FloatsOnWater", false);
        config.get("physics_definitions.piston", "HurtsEntities", true);
        config.get("physics_definitions.piston", "IsAttachable", false);
        config.get("physics_definitions.piston", "Mass", 400);
        config.get("physics_definitions.piston", "PillarSupportMass", -1);
        config.get("physics_definitions.piston", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.piston", "SlideChanceOnLanded", 0.6);
        config.get("physics_definitions.piston", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.piston", "SupportMass", 3000);
        config.get("physics_definitions.planks", "Blocks", new String[]{"minecraft:planks", "minecraft:double_wooden_slab"});
        config.get("physics_definitions.planks", "BreakChance", 0.3);
        config.get("physics_definitions.planks", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.planks", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.planks", "FloatsOnWater", false);
        config.get("physics_definitions.planks", "HurtsEntities", true);
        config.get("physics_definitions.planks", "IsAttachable", true);
        config.get("physics_definitions.planks", "Mass", 650);
        config.get("physics_definitions.planks", "PillarSupportMass", -1);
        config.get("physics_definitions.planks", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.planks", "SlideChanceOnLanded", 0.8);
        config.get("physics_definitions.planks", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.planks", "SupportMass", 2850);
        config.get("physics_definitions.prismarine", "Blocks", new String[]{"minecraft:prismarine"});
        config.get("physics_definitions.prismarine", "BreakChance", 0.15);
        config.get("physics_definitions.prismarine", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.prismarine", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.prismarine", "FloatsOnWater", false);
        config.get("physics_definitions.prismarine", "HurtsEntities", true);
        config.get("physics_definitions.prismarine", "IsAttachable", true);
        config.get("physics_definitions.prismarine", "Mass", 1250);
        config.get("physics_definitions.prismarine", "PillarSupportMass", -1);
        config.get("physics_definitions.prismarine", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.prismarine", "SlideChanceOnLanded", 0.8);
        config.get("physics_definitions.prismarine", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.prismarine", "SupportMass", 6000);
        config.get("physics_definitions.pumpkin", "Blocks", new String[]{"minecraft:pumpkin", "minecraft:lit_pumpkin", "minecraft:melon_block", "minecraft:hay_block", "minecraft:chorus_flower"});
        config.get("physics_definitions.pumpkin", "BreakChance", 0.65);
        config.get("physics_definitions.pumpkin", "BreakMinVelocity", 0.4);
        config.get("physics_definitions.pumpkin", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.pumpkin", "FloatsOnWater", false);
        config.get("physics_definitions.pumpkin", "HurtsEntities", true);
        config.get("physics_definitions.pumpkin", "IsAttachable", false);
        config.get("physics_definitions.pumpkin", "Mass", 50);
        config.get("physics_definitions.pumpkin", "PillarSupportMass", 1000);
        config.get("physics_definitions.pumpkin", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.pumpkin", "SlideChanceOnLanded", 0.65);
        config.get("physics_definitions.pumpkin", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.pumpkin", "SupportMass", 0);
        config.get("physics_definitions.purpur", "Blocks", new String[]{"minecraft:purpur_block", "minecraft:purpur_pillar", "minecraft:purpur_double_slab"});
        config.get("physics_definitions.purpur", "BreakChance", 0.15);
        config.get("physics_definitions.purpur", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.purpur", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.purpur", "FloatsOnWater", false);
        config.get("physics_definitions.purpur", "HurtsEntities", true);
        config.get("physics_definitions.purpur", "IsAttachable", true);
        config.get("physics_definitions.purpur", "Mass", 1600);
        config.get("physics_definitions.purpur", "PillarSupportMass", -1);
        config.get("physics_definitions.purpur", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.purpur", "SlideChanceOnLanded", 0.8);
        config.get("physics_definitions.purpur", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.purpur", "SupportMass", 5000);
        config.get("physics_definitions.redstone_lamp", "Blocks", new String[]{"minecraft:redstone_lamp", "minecraft:lit_redstone_lamp"});
        config.get("physics_definitions.redstone_lamp", "BreakChance", 0.75);
        config.get("physics_definitions.redstone_lamp", "BreakMinVelocity", 0.4);
        config.get("physics_definitions.redstone_lamp", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.redstone_lamp", "FloatsOnWater", false);
        config.get("physics_definitions.redstone_lamp", "HurtsEntities", true);
        config.get("physics_definitions.redstone_lamp", "IsAttachable", true);
        config.get("physics_definitions.redstone_lamp", "Mass", 350);
        config.get("physics_definitions.redstone_lamp", "PillarSupportMass", -1);
        config.get("physics_definitions.redstone_lamp", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.redstone_lamp", "SlideChanceOnLanded", 0.6);
        config.get("physics_definitions.redstone_lamp", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.redstone_lamp", "SupportMass", 1150);
        config.get("physics_definitions.sandstone", "Blocks", new String[]{"minecraft:sandstone", "minecraft:red_sandstone", "minecraft:double_stone_slab2"});
        config.get("physics_definitions.sandstone", "BreakChance", 0.2);
        config.get("physics_definitions.sandstone", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.sandstone", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.sandstone", "FloatsOnWater", false);
        config.get("physics_definitions.sandstone", "HurtsEntities", true);
        config.get("physics_definitions.sandstone", "IsAttachable", true);
        config.get("physics_definitions.sandstone", "Mass", 1400);
        config.get("physics_definitions.sandstone", "PillarSupportMass", -1);
        config.get("physics_definitions.sandstone", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.sandstone", "SlideChanceOnLanded", 0.8);
        config.get("physics_definitions.sandstone", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.sandstone", "SupportMass", 3800);
        config.get("physics_definitions.sea_lantern", "Blocks", new String[]{"minecraft:sea_lantern"});
        config.get("physics_definitions.sea_lantern", "BreakChance", 0.45);
        config.get("physics_definitions.sea_lantern", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.sea_lantern", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.sea_lantern", "FloatsOnWater", false);
        config.get("physics_definitions.sea_lantern", "HurtsEntities", true);
        config.get("physics_definitions.sea_lantern", "IsAttachable", true);
        config.get("physics_definitions.sea_lantern", "Mass", 450);
        config.get("physics_definitions.sea_lantern", "PillarSupportMass", -1);
        config.get("physics_definitions.sea_lantern", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.sea_lantern", "SlideChanceOnLanded", 0.8);
        config.get("physics_definitions.sea_lantern", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.sea_lantern", "SupportMass", 1150);
        config.get("physics_definitions.shulker_box", "Blocks", new String[]{"minecraft:white_shulker_box", "minecraft:orange_shulker_box", "minecraft:magenta_shulker_box", "minecraft:light_blue_shulker_box", "minecraft:yellow_shulker_box", "minecraft:lime_shulker_box", "minecraft:pink_shulker_box", "minecraft:gray_shulker_box", "minecraft:silver_shulker_box", "minecraft:cyan_shulker_box", "minecraft:purple_shulker_box", "minecraft:blue_shulker_box", "minecraft:brown_shulker_box", "minecraft:green_shulker_box", "minecraft:red_shulker_box", "minecraft:black_shulker_box"});
        config.get("physics_definitions.shulker_box", "BreakChance", 0);
        config.get("physics_definitions.shulker_box", "BreakMinVelocity", 0.4);
        config.get("physics_definitions.shulker_box", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.shulker_box", "FloatsOnWater", false);
        config.get("physics_definitions.shulker_box", "HurtsEntities", true);
        config.get("physics_definitions.shulker_box", "IsAttachable", false);
        config.get("physics_definitions.shulker_box", "Mass", 850);
        config.get("physics_definitions.shulker_box", "PillarSupportMass", -1);
        config.get("physics_definitions.shulker_box", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.shulker_box", "SlideChanceOnLanded", 0.6);
        config.get("physics_definitions.shulker_box", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.shulker_box", "SupportMass", 0);
        config.get("physics_definitions.skull", "Blocks", new String[]{"minecraft:skull"});
        config.get("physics_definitions.skull", "BreakChance", 0.6);
        config.get("physics_definitions.skull", "BreakMinVelocity", 0.4);
        config.get("physics_definitions.skull", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.skull", "FloatsOnWater", false);
        config.get("physics_definitions.skull", "HurtsEntities", true);
        config.get("physics_definitions.skull", "IsAttachable", true);
        config.get("physics_definitions.skull", "Mass", 35);
        config.get("physics_definitions.skull", "PillarSupportMass", 0);
        config.get("physics_definitions.skull", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.skull", "SlideChanceOnLanded", 0.6);
        config.get("physics_definitions.skull", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.skull", "SupportMass", 0);
        config.get("physics_definitions.slabs", "Blocks", new String[]{"minecraft:stone_slab", "minectaft:stone_slab2", "minecraft:wooden_slab", "minecraft:purpur_slab"});
        config.get("physics_definitions.slabs", "BreakChance", 0.2);
        config.get("physics_definitions.slabs", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.slabs", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.slabs", "FloatsOnWater", false);
        config.get("physics_definitions.slabs", "HurtsEntities", true);
        config.get("physics_definitions.slabs", "IsAttachable", true);
        config.get("physics_definitions.slabs", "Mass", 400);
        config.get("physics_definitions.slabs", "PillarSupportMass", 0);
        config.get("physics_definitions.slabs", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.slabs", "SlideChanceOnLanded", 0.6);
        config.get("physics_definitions.slabs", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.slabs", "SupportMass", 1650);
        config.get("physics_definitions.slime", "Blocks", new String[]{"minecraft:slime"});
        config.get("physics_definitions.slime", "BreakChance", 0.35);
        config.get("physics_definitions.slime", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.slime", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.slime", "FloatsOnWater", false);
        config.get("physics_definitions.slime", "HurtsEntities", true);
        config.get("physics_definitions.slime", "IsAttachable", true);
        config.get("physics_definitions.slime", "Mass", 400);
        config.get("physics_definitions.slime", "PillarSupportMass", -1);
        config.get("physics_definitions.slime", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.slime", "SlideChanceOnLanded", 0.9);
        config.get("physics_definitions.slime", "SlideChanceOnPlaced", 0.15);
        config.get("physics_definitions.slime", "SupportMass", 1350);
        config.get("physics_definitions.snow", "Blocks", new String[]{"minecraft:snow"});
        config.get("physics_definitions.snow", "BreakChance", 0.6);
        config.get("physics_definitions.snow", "BreakMinVelocity", 0.4);
        config.get("physics_definitions.snow", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.snow", "FloatsOnWater", false);
        config.get("physics_definitions.snow", "HurtsEntities", true);
        config.get("physics_definitions.snow", "IsAttachable", true);
        config.get("physics_definitions.snow", "Mass", 100);
        config.get("physics_definitions.snow", "PillarSupportMass", 1250);
        config.get("physics_definitions.snow", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.snow", "SlideChanceOnLanded", 0.8);
        config.get("physics_definitions.snow", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.snow", "SupportMass", 450);
        config.get("physics_definitions.soul_sand", "Blocks", new String[]{"minecraft:soul_sand"});
        config.get("physics_definitions.soul_sand", "BreakChance", 0.2);
        config.get("physics_definitions.soul_sand", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.soul_sand", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.soul_sand", "FloatsOnWater", false);
        config.get("physics_definitions.soul_sand", "HurtsEntities", true);
        config.get("physics_definitions.soul_sand", "IsAttachable", false);
        config.get("physics_definitions.soul_sand", "Mass", 550);
        config.get("physics_definitions.soul_sand", "PillarSupportMass", -1);
        config.get("physics_definitions.soul_sand", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.soul_sand", "SlideChanceOnLanded", 0.8);
        config.get("physics_definitions.soul_sand", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.soul_sand", "SupportMass", 1350);
        config.get("physics_definitions.sponge", "Blocks", new String[]{"minecraft:sponge"});
        config.get("physics_definitions.sponge", "BreakChance", 0.05);
        config.get("physics_definitions.sponge", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.sponge", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.sponge", "FloatsOnWater", false);
        config.get("physics_definitions.sponge", "HurtsEntities", false);
        config.get("physics_definitions.sponge", "IsAttachable", true);
        config.get("physics_definitions.sponge", "Mass", 10);
        config.get("physics_definitions.sponge", "PillarSupportMass", 400);
        config.get("physics_definitions.sponge", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.sponge", "SlideChanceOnLanded", 0.6);
        config.get("physics_definitions.sponge", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.sponge", "SupportMass", 35);
        config.get("physics_definitions.stairs", "Blocks", new String[]{"minecraft:oak_stairs", "minecraft:stone_stairs", "minecraft:brick_stairs", "minecraft:stone_brick_stairs", "minecraft:nether_brick_stairs", "minecraft:sandstone_stairs", "minecraft:spruce_stairs", "minecraft:birch_stairs", "minecraft:jungle_stairs", "minecraft:acacia_stairs", "minecraft:dark_oak_stairs", "minecraft:quartz_stairs", "minecraft:red_sandstone_stairs", "minecraft:purpur_stairs"});
        config.get("physics_definitions.stairs", "BreakChance", 0.35);
        config.get("physics_definitions.stairs", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.stairs", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.stairs", "FloatsOnWater", false);
        config.get("physics_definitions.stairs", "HurtsEntities", true);
        config.get("physics_definitions.stairs", "IsAttachable", true);
        config.get("physics_definitions.stairs", "Mass", 800);
        config.get("physics_definitions.stairs", "PillarSupportMass", -1);
        config.get("physics_definitions.stairs", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.stairs", "SlideChanceOnLanded", 0.65);
        config.get("physics_definitions.stairs", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.stairs", "SupportMass", 1800);
        config.get("physics_definitions.sticky_piston", "Blocks", new String[]{"minecraft:sticky_piston"});
        config.get("physics_definitions.sticky_piston", "BreakChance", 0.4);
        config.get("physics_definitions.sticky_piston", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.sticky_piston", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.sticky_piston", "FloatsOnWater", false);
        config.get("physics_definitions.sticky_piston", "HurtsEntities", true);
        config.get("physics_definitions.sticky_piston", "IsAttachable", false);
        config.get("physics_definitions.sticky_piston", "Mass", 850);
        config.get("physics_definitions.sticky_piston", "PillarSupportMass", -1);
        config.get("physics_definitions.sticky_piston", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.sticky_piston", "SlideChanceOnLanded", 0.6);
        config.get("physics_definitions.sticky_piston", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.sticky_piston", "SupportMass", 5000);
        config.get("physics_definitions.stone", "Blocks", new String[]{"minecraft:stone", "minecraft:stonebrick", "minecraft:double_stone_slab", "minecraft:monster_egg"});
        config.get("physics_definitions.stone", "BreakChance", 0.2);
        config.get("physics_definitions.stone", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.stone", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.stone", "FloatsOnWater", false);
        config.get("physics_definitions.stone", "HurtsEntities", true);
        config.get("physics_definitions.stone", "IsAttachable", true);
        config.get("physics_definitions.stone", "Mass", 1600);
        config.get("physics_definitions.stone", "PillarSupportMass", -1);
        config.get("physics_definitions.stone", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.stone", "SlideChanceOnLanded", 0.8);
        config.get("physics_definitions.stone", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.stone", "SupportMass", 6500);
        config.get("physics_definitions.tnt", "Blocks", new String[]{"minecraft:tnt"});
        config.get("physics_definitions.tnt", "BreakChance", 0.35);
        config.get("physics_definitions.tnt", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.tnt", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.tnt", "FloatsOnWater", false);
        config.get("physics_definitions.tnt", "HurtsEntities", true);
        config.get("physics_definitions.tnt", "IsAttachable", false);
        config.get("physics_definitions.tnt", "Mass", 400);
        config.get("physics_definitions.tnt", "PillarSupportMass", -1);
        config.get("physics_definitions.tnt", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.tnt", "SlideChanceOnLanded", 0.65);
        config.get("physics_definitions.tnt", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.tnt", "SupportMass", 0);
        config.get("physics_definitions.trapdoor", "Blocks", new String[]{"minecraft:trapdoor", "minecraft:iron_trapdoor"});
        config.get("physics_definitions.trapdoor", "BreakChance", 0.4);
        config.get("physics_definitions.trapdoor", "BreakMinVelocity", 0.4);
        config.get("physics_definitions.trapdoor", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.trapdoor", "FloatsOnWater", false);
        config.get("physics_definitions.trapdoor", "HurtsEntities", true);
        config.get("physics_definitions.trapdoor", "IsAttachable", true);
        config.get("physics_definitions.trapdoor", "Mass", 200);
        config.get("physics_definitions.trapdoor", "PillarSupportMass", -1);
        config.get("physics_definitions.trapdoor", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.trapdoor", "SlideChanceOnLanded", 0.65);
        config.get("physics_definitions.trapdoor", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.trapdoor", "SupportMass", 0);
        config.get("physics_definitions.wall", "Blocks", new String[]{"minecraft:cobblestone_wall"});
        config.get("physics_definitions.wall", "BreakChance", 0.25);
        config.get("physics_definitions.wall", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.wall", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.wall", "FloatsOnWater", false);
        config.get("physics_definitions.wall", "HurtsEntities", true);
        config.get("physics_definitions.wall", "IsAttachable", true);
        config.get("physics_definitions.wall", "Mass", 750);
        config.get("physics_definitions.wall", "PillarSupportMass", -1);
        config.get("physics_definitions.wall", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.wall", "SlideChanceOnLanded", 0.65);
        config.get("physics_definitions.wall", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.wall", "SupportMass", 1800);
        config.get("physics_definitions.web", "Blocks", new String[]{"minecraft:web"});
        config.get("physics_definitions.web", "BreakChance", 0.25);
        config.get("physics_definitions.web", "BreakMinVelocity", 0.4);
        config.get("physics_definitions.web", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.web", "FloatsOnWater", false);
        config.get("physics_definitions.web", "HurtsEntities", false);
        config.get("physics_definitions.web", "IsAttachable", true);
        config.get("physics_definitions.web", "Mass", 5);
        config.get("physics_definitions.web", "PillarSupportMass", 100);
        config.get("physics_definitions.web", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.web", "SlideChanceOnLanded", 0.65);
        config.get("physics_definitions.web", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.web", "SupportMass", 20);
        config.get("physics_definitions.wool", "Blocks", new String[]{"minecraft:wool"});
        config.get("physics_definitions.wool", "BreakChance", 0.3);
        config.get("physics_definitions.wool", "BreakMinVelocity", 0.6);
        config.get("physics_definitions.wool", "DimensionsBlacklist", new String[0]);
        config.get("physics_definitions.wool", "FloatsOnWater", false);
        config.get("physics_definitions.wool", "HurtsEntities", true);
        config.get("physics_definitions.wool", "IsAttachable", true);
        config.get("physics_definitions.wool", "Mass", 400);
        config.get("physics_definitions.wool", "PillarSupportMass", -1);
        config.get("physics_definitions.wool", "RequiresNeighbourUpdate", false);
        config.get("physics_definitions.wool", "SlideChanceOnLanded", 0.6);
        config.get("physics_definitions.wool", "SlideChanceOnPlaced", 0.0);
        config.get("physics_definitions.wool", "SupportMass", 1000);
    }

    public static final boolean blockHasPhysics(String blockID) {
        return physicsDefs.containsKey(blockID);
    }

    public static final boolean blockHasPhysics(Block block) {
        return physicsDefs.containsKey(block.getRegistryName().toString());
    }

    public static final PhysicsDef getPhysicsDefFor(String blockID) {
        return physicsDefs.get(blockID);
    }

    public static final PhysicsDef getPhysicsDefFor(Block block) {
        return ModConfig.getPhysicsDefFor(block.getRegistryName().toString());
    }

    public static final PhysicsDef getPhysicsDefFor(IBlockState blockState) {
        return ModConfig.getPhysicsDefFor(blockState.func_177230_c().getRegistryName().toString());
    }

    public static final PhysicsDef getPhysicsDefFor(World worldIn, BlockPos pos) {
        return ModConfig.getPhysicsDefFor(worldIn.func_180495_p(pos));
    }

    private static final int clampInt(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }

    private static final double clampDouble(double value, double min, double max) {
        return Math.max(min, Math.min(max, value));
    }
}

