/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.capability;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import ovh.corail.recycler.ModItems;
import ovh.corail.recycler.capability.RecyclerDefaultStackHandler;

public class RecyclerWorkingStackHandler
extends RecyclerDefaultStackHandler {
    public RecyclerWorkingStackHandler() {
        super(EnumSlot.values().length);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return EnumSlot.isItemValid(slot, stack) ? super.insertItem(slot, stack, simulate) : stack;
    }

    public static enum EnumSlot {
        ITEM(p -> !ModItems.diamond_disk.isValidItem((ItemStack)p)),
        DISK(ModItems.diamond_disk::isValidItem);

        public final Predicate<ItemStack> predic;

        private EnumSlot(Predicate<ItemStack> predic) {
            this.predic = predic;
        }

        public static boolean isItemValid(int slot, ItemStack stack) {
            return (slot == 0 || slot == 1) && EnumSlot.values()[slot].predic.test(stack);
        }
    }
}

