/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.core;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.ImmutablePair;
import ovh.corail.recycler.core.Helper;
import ovh.corail.recycler.core.JsonRecyclingRecipe;
import ovh.corail.recycler.core.RecyclingRecipe;
import ovh.corail.recycler.core.TranslationHelper;
import ovh.corail.recycler.handler.ConfigurationHandler;

public class RecyclingManager {
    private static final RecyclingManager instance = new RecyclingManager();
    public final List<RecyclingRecipe> recipes = Lists.newArrayList();
    private final List<ItemStack> unbalanced = Lists.newArrayList();
    private final List<ItemStack> blacklist = Lists.newArrayList();
    private final List<ImmutablePair<ItemStack, ItemStack>> grindList = Lists.newArrayList();
    private final File unbalancedFile = new File(ConfigurationHandler.getConfigDir(), "unbalanced_recipes.json");
    private final File blacklistFile = new File(ConfigurationHandler.getConfigDir(), "blacklist_recipes.json");
    private final File userDefinedFile = new File(ConfigurationHandler.getConfigDir(), "user_defined_recipes.json");
    private final File grindFile = new File(ConfigurationHandler.getConfigDir(), "grind_list.json");

    public static RecyclingManager getInstance() {
        return instance;
    }

    public void discoverRecipe(EntityPlayer player, ItemStack stack) throws Exception {
        int hasRecipe = this.getRecipeIndex(stack);
        if (hasRecipe >= 0) {
            if (this.getRecipe(hasRecipe).isAllowed()) {
                TranslationHelper.sendMessage((ICommandSender)player, TranslationHelper.LangKey.MESSAGE_ADD_RECIPE_FAILED, new Object[0]);
            } else {
                this.getRecipe(hasRecipe).setAllowed(true);
                this.saveBlacklist();
                TranslationHelper.sendMessage((ICommandSender)player, TranslationHelper.LangKey.MESSAGE_ADD_RECIPE_SUCCESS, new Object[0]);
            }
        } else {
            boolean valid = false;
            RecyclingRecipe recipe = null;
            for (IRecipe crafting_recipe : CraftingManager.field_193380_a) {
                ItemStack o = crafting_recipe.func_77571_b();
                if (!Helper.areItemEqual(o, stack) || (recipe = this.convertCraftingRecipe(crafting_recipe)).getCount() <= 0 || recipe.getItemRecipe().func_190926_b()) continue;
                valid = true;
                break;
            }
            if (valid) {
                this.addRecipe(recipe);
                TranslationHelper.sendMessage((ICommandSender)player, this.saveUserDefinedRecipes() ? TranslationHelper.LangKey.MESSAGE_ADD_RECIPE_SUCCESS : TranslationHelper.LangKey.MESSAGE_ADD_RECIPE_FAILED, new Object[0]);
            } else {
                TranslationHelper.sendMessage((ICommandSender)player, TranslationHelper.LangKey.MESSAGE_ADD_RECIPE_FAILED, new Object[0]);
            }
        }
    }

    public void loadRecipes() {
        if (ConfigurationHandler.recycle_enchanted_book) {
            this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151134_bR, 1, 0), new ItemStack[0]));
        }
        this.loadUnbalanced();
        this.loadBlacklist();
        this.loadDefaultRecipes();
        this.loadUserDefinedRecipes();
        this.loadGrindList();
    }

    private void loadUnbalanced() {
        ArrayList stringlist;
        if (!this.unbalancedFile.exists()) {
            stringlist = Lists.newArrayList((Object[])new String[]{"minecraft:stone:1:1", "minecraft:stone:1:3", "minecraft:stone:1:5", "minecraft:paper:1:0", "minecraft:sugar:1:0", "minecraft:ender_eye:1:0", "minecraft:blaze_powder:1:0", "minecraft:magma_cream:1:0", "minecraft:fire_charge:1:0", "minecraft:red_nether_brick:1:0", "minecraft:magma:1:0"});
            this.saveAsJson(this.unbalancedFile, stringlist);
        } else {
            stringlist = RecyclingManager.loadAsJson(this.unbalancedFile, String.class);
        }
        for (String currentString : stringlist) {
            ItemStack currentStack = this.StringToItemStack(currentString);
            if (currentStack.func_190926_b()) continue;
            this.unbalanced.add(currentStack);
        }
    }

    private void loadBlacklist() {
        ArrayList stringlist;
        if (!this.blacklistFile.exists()) {
            stringlist = Lists.newArrayList((Object[])new String[]{"recycler:recycler:1:0"});
            this.saveAsJson(this.blacklistFile, stringlist);
        } else {
            stringlist = RecyclingManager.loadAsJson(this.blacklistFile, String.class);
        }
        for (String currentString : stringlist) {
            ItemStack currentStack = this.StringToItemStack(currentString);
            if (currentStack == null || currentStack.func_190926_b()) continue;
            this.blacklist.add(currentStack);
        }
    }

    public void saveBlacklist() {
        ArrayList blacklistItems = Lists.newArrayList();
        this.recipes.stream().filter(p -> !p.isAllowed()).forEach(c -> blacklistItems.add(this.ItemStackToString(c.getItemRecipe())));
        this.saveAsJson(this.blacklistFile, blacklistItems);
    }

    public RecyclingRecipe getRecipe(int index) {
        return this.recipes.get(index);
    }

    public void addRecipe(RecyclingRecipe recipe) {
        this.recipes.add(recipe);
    }

    public boolean removeRecipe(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        int index = this.getRecipeIndex(stack);
        if (index < 0) {
            return false;
        }
        if (this.recipes.get(index).isUserDefined()) {
            this.recipes.remove(index);
            this.saveUserDefinedRecipes();
        } else {
            this.recipes.get(index).setAllowed(false);
            this.saveBlacklist();
        }
        return true;
    }

    public List<RecyclingRecipe> getPage(int pageNum, String searchText) {
        return this.recipes.stream().filter(p -> !(!p.isAllowed() || !ConfigurationHandler.unbalanced_recipes && p.isUnbalanced() || !searchText.isEmpty() && !p.getItemRecipe().func_82833_r().toLowerCase().contains(searchText))).skip(pageNum * 4).limit(4L).collect(Collectors.toList());
    }

    public int getPageCount(String searchText) {
        return (int)this.recipes.stream().filter(p -> !(!p.isAllowed() || !ConfigurationHandler.unbalanced_recipes && p.isUnbalanced() || !searchText.isEmpty() && !p.getItemRecipe().func_82833_r().toLowerCase().contains(searchText))).count();
    }

    @Nullable
    public RecyclingRecipe getRecipe(ItemStack stack) {
        int recipeId = this.hasRecipe(stack);
        return recipeId >= 0 ? this.recipes.get(recipeId) : null;
    }

    public int hasRecipe(ItemStack stack) {
        if (stack.func_190926_b() || stack.func_77973_b() == Items.field_151134_bR && ItemEnchantedBook.func_92110_g((ItemStack)stack).func_74745_c() < 2) {
            return -1;
        }
        int recipeId = this.getRecipeIndex(stack);
        if (recipeId < 0) {
            return -1;
        }
        RecyclingRecipe recipe = this.recipes.get(recipeId);
        if (!ConfigurationHandler.unbalanced_recipes && recipe.isUnbalanced()) {
            return -1;
        }
        if (ConfigurationHandler.only_user_recipes && !recipe.isUserDefined()) {
            return -1;
        }
        if (!recipe.isAllowed()) {
            return -1;
        }
        return recipeId;
    }

    public int getRecipeIndex(ItemStack stack) {
        if (stack.func_190926_b()) {
            return -1;
        }
        for (int slotId = 0; slotId < this.recipes.size(); ++slotId) {
            if (!Helper.areItemEqual(stack, this.recipes.get(slotId).getItemRecipe())) continue;
            return slotId;
        }
        return -1;
    }

    public List<ItemStack> getResultStack(ItemStack stack, int nb_input) {
        return this.getResultStack(stack, nb_input, false);
    }

    public List<ItemStack> getResultStack(ItemStack stack, int nb_input, boolean half) {
        ArrayList itemsList = Lists.newArrayList();
        int num_recipe = this.hasRecipe(stack);
        if (num_recipe < 0) {
            return itemsList;
        }
        RecyclingRecipe currentRecipe = this.recipes.get(num_recipe);
        boolean isDamagedStack = stack.func_77958_k() > 0 && stack.func_77952_i() > 0;
        for (int i = 0; i < currentRecipe.getCount(); ++i) {
            int leftStackCount;
            int currentSize;
            ItemStack currentStack;
            ItemStack grind;
            ItemStack itemStack = grind = isDamagedStack || half ? this.getGrind(currentRecipe.getStack(i)) : ItemStack.field_190927_a;
            if (grind.func_190926_b()) {
                currentStack = currentRecipe.getStack(i).func_77946_l();
                currentSize = currentStack.func_190916_E();
            } else {
                currentStack = grind;
                currentSize = currentRecipe.getStack(i).func_190916_E() * grind.func_190916_E();
            }
            float modifiedSize = currentSize;
            if (isDamagedStack) {
                modifiedSize = modifiedSize * (float)(stack.func_77958_k() - stack.func_77952_i()) / (float)stack.func_77958_k();
            }
            if (half) {
                modifiedSize /= 2.0f;
            }
            currentStack.func_190920_e(currentStack.func_77976_d());
            for (leftStackCount = currentSize = (int)(ConfigurationHandler.recycle_round_down ? Math.floor(modifiedSize) : (double)Math.round(modifiedSize)) * nb_input; leftStackCount >= currentStack.func_77976_d(); leftStackCount -= currentStack.func_77976_d()) {
                itemsList.add(currentStack.func_77946_l());
            }
            if (leftStackCount <= 0) continue;
            currentStack.func_190920_e(leftStackCount);
            itemsList.add(currentStack.func_77946_l());
        }
        if (ConfigurationHandler.recycle_enchanted_book) {
            itemsList.addAll(this.getEnchantedBooks(stack));
        }
        return itemsList;
    }

    private List<ItemStack> getEnchantedBooks(ItemStack stack) {
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)stack);
        ArrayList books = Lists.newArrayList();
        if (!enchants.isEmpty()) {
            if (stack.func_77973_b() == Items.field_151134_bR) {
                if (enchants.size() < 2) {
                    return books;
                }
                for (Map.Entry entry : enchants.entrySet()) {
                    ItemStack currentBook = new ItemStack(Items.field_151134_bR);
                    ItemEnchantedBook.func_92115_a((ItemStack)currentBook, (EnchantmentData)new EnchantmentData((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue()));
                    books.add(currentBook);
                }
            } else {
                ItemStack currentBook = new ItemStack(Items.field_151134_bR);
                for (Map.Entry entry : enchants.entrySet()) {
                    ItemEnchantedBook.func_92115_a((ItemStack)currentBook, (EnchantmentData)new EnchantmentData((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue()));
                }
                books.add(currentBook);
            }
        }
        return books;
    }

    private void loadGrindList() {
        ArrayList jsonStringList;
        if (!this.grindFile.exists()) {
            jsonStringList = Lists.newArrayList((Object[])new ImmutablePair[]{new ImmutablePair((Object)"minecraft:diamond:1:0", (Object)"recycler:diamond_shard:9:0"), new ImmutablePair((Object)"minecraft:iron_ingot:1:0", (Object)"minecraft:iron_nugget:9:0"), new ImmutablePair((Object)"minecraft:gold_ingot:1:0", (Object)"minecraft:gold_nugget:9:0"), new ImmutablePair((Object)"minecraft:leather:1:0", (Object)"minecraft:rabbit_hide:4:0"), new ImmutablePair((Object)"minecraft:planks:1:32767", (Object)"minecraft:stick:4:0")});
            this.saveAsJson(this.grindFile, jsonStringList);
        } else {
            Type token = new TypeToken<List<ImmutablePair<String, String>>>(){}.getType();
            jsonStringList = this.loadAsJson(this.grindFile, token);
        }
        for (ImmutablePair pair : jsonStringList) {
            ItemStack input = this.StringToItemStack((String)pair.getLeft());
            ItemStack output = this.StringToItemStack((String)pair.getRight());
            if (input.func_190926_b() || output.func_190926_b()) continue;
            this.grindList.add((ImmutablePair<ItemStack, ItemStack>)new ImmutablePair((Object)input, (Object)output));
        }
    }

    public ItemStack getGrind(ItemStack stack) {
        for (ImmutablePair<ItemStack, ItemStack> grind : this.grindList) {
            if (!Helper.areItemEqual((ItemStack)grind.getLeft(), stack)) continue;
            return ((ItemStack)grind.getRight()).func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    private RecyclingManager() {
    }

    public boolean saveUserDefinedRecipes() {
        ArrayList jRecipes = Lists.newArrayList();
        for (RecyclingRecipe recipe : this.recipes) {
            if (!recipe.isUserDefined()) continue;
            jRecipes.add(this.convertRecipeToJson(recipe));
        }
        return this.saveAsJson(this.userDefinedFile, jRecipes);
    }

    public boolean saveAsJson(File file, List<?> list) {
        if (file.exists()) {
            file.delete();
        }
        try {
            if (file.createNewFile()) {
                FileWriter fw = new FileWriter(file);
                fw.write(new GsonBuilder().setPrettyPrinting().create().toJson(list));
                fw.close();
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    private List<?> loadAsJson(File file, Type token) {
        List list = null;
        try {
            list = (List)new Gson().fromJson((Reader)new BufferedReader(new FileReader(file)), token);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static <T> List<T> loadAsJson(File file, Class<T> type) {
        ArrayList list = Lists.newArrayList();
        try {
            JsonArray arrayDatas = new JsonParser().parse((Reader)new BufferedReader(new FileReader(file))).getAsJsonArray();
            for (JsonElement elem : arrayDatas) {
                list.add(new Gson().fromJson(elem, type));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    private void loadUserDefinedRecipes() {
        ArrayList jsonRecipesList;
        if (!this.userDefinedFile.exists()) {
            jsonRecipesList = Lists.newArrayList((Object[])new JsonRecyclingRecipe[]{new JsonRecyclingRecipe("recycler:recycler:1:0", new String[]{"minecraft:planks:4:0", "minecraft:iron_ingot:4:0", "minecraft:chest"})});
            this.saveAsJson(this.userDefinedFile, jsonRecipesList);
        } else {
            jsonRecipesList = RecyclingManager.loadAsJson(this.userDefinedFile, JsonRecyclingRecipe.class);
        }
        for (JsonRecyclingRecipe aJsonRecipesList : jsonRecipesList) {
            RecyclingRecipe recipe = this.convertJsonRecipe(aJsonRecipesList);
            if (recipe != null && recipe.getCount() > 0) {
                int foundRecipe = this.getRecipeIndex(recipe.getItemRecipe());
                recipe.setUserDefined(true);
                recipe.setAllowed(this.blacklist.stream().noneMatch(p -> Helper.areItemEqual(p, recipe.getItemRecipe())));
                if (foundRecipe == -1) {
                    this.recipes.add(recipe);
                    continue;
                }
                this.recipes.set(foundRecipe, recipe);
                continue;
            }
            TranslationHelper.sendLog("Error while reading json recipe : " + aJsonRecipesList.inputItem);
        }
    }

    private RecyclingRecipe convertJsonRecipe(JsonRecyclingRecipe jRecipe) {
        ItemStack inputItem = this.StringToItemStack(jRecipe.inputItem);
        if (inputItem.func_190926_b()) {
            return null;
        }
        RecyclingRecipe recipe = new RecyclingRecipe(inputItem);
        for (int i = 0; i < jRecipe.outputItems.length; ++i) {
            ItemStack outputItem = this.StringToItemStack(jRecipe.outputItems[i]);
            if (outputItem.func_190926_b()) continue;
            recipe.addStack(outputItem);
        }
        recipe.setUnbalanced(this.unbalanced.stream().anyMatch(p -> Helper.areItemEqual(p, recipe.getItemRecipe())));
        return recipe;
    }

    public JsonRecyclingRecipe convertRecipeToJson(RecyclingRecipe recipe) {
        String inputItem = this.ItemStackToString(recipe.getItemRecipe());
        if (inputItem.isEmpty()) {
            return null;
        }
        String[] outputItems = new String[recipe.getCount().intValue()];
        for (int i = 0; i < recipe.getCount(); ++i) {
            String outputItem;
            outputItems[i] = outputItem = this.ItemStackToString(recipe.getStack(i));
        }
        return new JsonRecyclingRecipe(inputItem, outputItems);
    }

    private String ItemStackToString(ItemStack stack) {
        return stack.func_77973_b().getRegistryName().toString() + ":" + stack.func_190916_E() + ":" + stack.func_77960_j();
    }

    private ItemStack StringToItemStack(String stringStack) {
        Item item;
        String[] parts = stringStack.split(":");
        if (parts.length >= 2 && parts.length <= 4 && (item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(parts[0], parts[1]))) != null) {
            return new ItemStack(item, parts.length > 2 ? Integer.valueOf(parts[2]) : 1, parts.length == 4 ? Integer.valueOf(parts[3]) : 0);
        }
        return ItemStack.field_190927_a;
    }

    public <T extends IRecipe> RecyclingRecipe convertCraftingRecipe(T iRecipe) {
        RecyclingRecipe recipe = new RecyclingRecipe(iRecipe.func_77571_b(), Helper.mergeStackInList(iRecipe.func_192400_c().stream().filter(p -> p.func_193365_a().length > 0 && !p.func_193365_a()[0].func_190926_b()).map(m -> m.func_193365_a()[0]).collect(Collectors.toList())));
        recipe.setUnbalanced(false);
        recipe.setUserDefined(true);
        recipe.setAllowed(true);
        return recipe;
    }

    private void loadDefaultRecipes() {
        int i;
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150348_b, 1, 1), new ItemStack[]{new ItemStack(Blocks.field_150348_b, 1, 3), new ItemStack(Items.field_151128_bU, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150348_b, 1, 3), new ItemStack[]{new ItemStack(Blocks.field_150347_e, 1, 0), new ItemStack(Items.field_151128_bU, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150348_b, 2, 5), new ItemStack[]{new ItemStack(Blocks.field_150347_e, 1, 0), new ItemStack(Blocks.field_150348_b, 1, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151121_aF, 1, 0), new ItemStack[]{new ItemStack(Items.field_151120_aE, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151102_aT, 1, 0), new ItemStack[]{new ItemStack(Items.field_151120_aE, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151061_bv, 1, 0), new ItemStack[]{new ItemStack(Items.field_151079_bi, 1, 0), new ItemStack(Items.field_151065_br, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151065_br, 2, 0), new ItemStack[]{new ItemStack(Items.field_151072_bj, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151064_bs, 1, 0), new ItemStack[]{new ItemStack(Items.field_151065_br, 1, 0), new ItemStack(Items.field_151123_aH, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151059_bz, 3, 0), new ItemStack[]{new ItemStack(Items.field_151065_br, 1, 0), new ItemStack(Items.field_151016_H, 1, 0), new ItemStack(Items.field_151044_h, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Block)Blocks.field_185771_cX, 2, 0), new ItemStack[]{new ItemStack(Blocks.field_185767_cT, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_185772_cY, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150377_bs, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_185769_cV, 1, 0), new ItemStack[]{new ItemStack((Block)Blocks.field_185771_cX, 3, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_185767_cT, 1, 0), new ItemStack[]{new ItemStack(Items.field_185162_cT, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_185768_cU, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_185767_cT, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_185764_cQ, 4, 0), new ItemStack[]{new ItemStack(Items.field_151072_bj, 1, 0), new ItemStack(Items.field_185162_cT, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_185159_cQ, 1, 0), new ItemStack[]{new ItemStack(Items.field_151042_j, 1, 0), new ItemStack(Blocks.field_150344_f, 6, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150348_b, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150347_e, 1, 0)}));
        for (i = 1; i <= 3; ++i) {
            this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150348_b, 1, 2 * i), new ItemStack[]{new ItemStack(Blocks.field_150348_b, 1, 2 * i - 1)}));
        }
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150346_d, 2, 1), new ItemStack[]{new ItemStack(Blocks.field_150346_d, 1, 0), new ItemStack(Blocks.field_150351_n, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150435_aG, 1, 0), new ItemStack[]{new ItemStack(Items.field_151119_aD, 4, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150405_ch, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150435_aG, 1, 0)}));
        for (i = 0; i < 16; ++i) {
            this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150406_ce, 1, i), new ItemStack[]{new ItemStack(Blocks.field_150435_aG, 1, 0)}));
        }
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150341_Y, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150347_e, 1, 0), new ItemStack(Blocks.field_150395_bd, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150359_w, 1, 0), new ItemStack[]{new ItemStack((Block)Blocks.field_150354_m, 1, 0)}));
        for (i = 0; i < 16; ++i) {
            this.recipes.add(new RecyclingRecipe(new ItemStack((Block)Blocks.field_150399_cn, 1, i), new ItemStack[]{new ItemStack(Blocks.field_150359_w, 1, 0)}));
        }
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150410_aZ, 8, 0), new ItemStack[]{new ItemStack(Blocks.field_150359_w, 3, 0)}));
        for (i = 0; i < 16; ++i) {
            this.recipes.add(new RecyclingRecipe(new ItemStack((Block)Blocks.field_150397_co, 8, i), new ItemStack[]{new ItemStack((Block)Blocks.field_150399_cn, 3, i)}));
        }
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150322_A, 1, 0), new ItemStack[]{new ItemStack((Block)Blocks.field_150354_m, 4, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_180395_cM, 1, 0), new ItemStack[]{new ItemStack((Block)Blocks.field_150354_m, 4, 1)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150322_A, 1, 1), new ItemStack[]{new ItemStack(Blocks.field_150322_A, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150322_A, 1, 2), new ItemStack[]{new ItemStack(Blocks.field_150322_A, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_180395_cM, 1, 1), new ItemStack[]{new ItemStack(Blocks.field_180395_cM, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_180395_cM, 1, 2), new ItemStack[]{new ItemStack(Blocks.field_180395_cM, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150417_aV, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150347_e, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150417_aV, 1, 1), new ItemStack[]{new ItemStack(Blocks.field_150417_aV, 1, 0), new ItemStack(Blocks.field_150395_bd, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150417_aV, 1, 2), new ItemStack[]{new ItemStack(Blocks.field_150417_aV, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150417_aV, 1, 3), new ItemStack[]{new ItemStack(Blocks.field_150417_aV, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150336_V, 1, 0), new ItemStack[]{new ItemStack(Items.field_151118_aC, 4, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150426_aN, 1, 0), new ItemStack[]{new ItemStack(Items.field_151114_aO, 4, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_180397_cI, 1, 0), new ItemStack[]{new ItemStack(Items.field_179562_cC, 4, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_180397_cI, 1, 1), new ItemStack[]{new ItemStack(Items.field_179562_cC, 9, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_180397_cI, 1, 2), new ItemStack[]{new ItemStack(Items.field_179562_cC, 8, 0), new ItemStack(Items.field_151100_aR, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_180398_cJ, 1, 0), new ItemStack[]{new ItemStack(Items.field_179563_cD, 5, 0), new ItemStack(Items.field_179562_cC, 4, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150371_ca, 1, 0), new ItemStack[]{new ItemStack(Items.field_151128_bU, 4, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150371_ca, 1, 1), new ItemStack[]{new ItemStack(Blocks.field_150371_ca, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150371_ca, 1, 2), new ItemStack[]{new ItemStack(Blocks.field_150371_ca, 1, 0)}));
        for (i = 0; i < 4; ++i) {
            this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150344_f, 4, i), new ItemStack[]{new ItemStack(Blocks.field_150364_r, 1, i)}));
        }
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150344_f, 4, 4), new ItemStack[]{new ItemStack(Blocks.field_150363_s, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150344_f, 4, 5), new ItemStack[]{new ItemStack(Blocks.field_150363_s, 1, 1)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151118_aC, 1, 0), new ItemStack[]{new ItemStack(Items.field_151119_aD, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150433_aE, 1, 0), new ItemStack[]{new ItemStack(Items.field_151126_ay, 4, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150431_aC, 2, 0), new ItemStack[]{new ItemStack(Blocks.field_150433_aE, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150367_z, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150347_e, 7, 0), new ItemStack(Items.field_151137_ax, 1, 0), new ItemStack((Item)Items.field_151031_f, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150323_B, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 8, 0), new ItemStack(Items.field_151137_ax, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Block)Blocks.field_150486_ae, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 8, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150477_bB, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150343_Z, 8, 0), new ItemStack(Items.field_151061_bv, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150447_bR, 1, 0), new ItemStack[]{new ItemStack((Block)Blocks.field_150486_ae, 1, 0), new ItemStack((Block)Blocks.field_150479_bC, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150462_ai, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 4, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150460_al, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150347_e, 8, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150421_aI, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 8, 0), new ItemStack(Items.field_151045_i, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150381_bn, 1, 0), new ItemStack[]{new ItemStack(Items.field_151045_i, 2, 0), new ItemStack(Blocks.field_150343_Z, 4, 0), new ItemStack(Items.field_151122_aG, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Block)Blocks.field_150461_bJ, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150343_Z, 3, 0), new ItemStack(Items.field_151156_bN, 1, 0), new ItemStack(Blocks.field_150359_w, 5, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150467_bQ, 1, 0), new ItemStack[]{new ItemStack(Items.field_151042_j, 31, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150467_bQ, 1, 1), new ItemStack[]{new ItemStack(Items.field_151042_j, 20, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150467_bQ, 1, 2), new ItemStack[]{new ItemStack(Items.field_151042_j, 10, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Block)Blocks.field_150453_bW, 1, 0), new ItemStack[]{new ItemStack((Block)Blocks.field_150376_bx, 3, 0), new ItemStack(Blocks.field_150359_w, 3, 0), new ItemStack(Items.field_151128_bU, 3, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Block)Blocks.field_150438_bZ, 1, 0), new ItemStack[]{new ItemStack(Items.field_151042_j, 5, 0), new ItemStack((Block)Blocks.field_150486_ae, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150409_cd, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150347_e, 7, 0), new ItemStack(Items.field_151137_ax, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150448_aq, 16, 0), new ItemStack[]{new ItemStack(Items.field_151042_j, 6, 0), new ItemStack(Items.field_151055_y, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150319_E, 6, 0), new ItemStack[]{new ItemStack(Items.field_151042_j, 6, 0), new ItemStack(Items.field_151137_ax, 1, 0), new ItemStack(Blocks.field_150456_au, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150318_D, 6, 0), new ItemStack[]{new ItemStack(Items.field_151043_k, 6, 0), new ItemStack(Items.field_151137_ax, 1, 0), new ItemStack(Items.field_151055_y, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150408_cc, 6, 0), new ItemStack[]{new ItemStack(Items.field_151042_j, 6, 0), new ItemStack(Items.field_151137_ax, 1, 0), new ItemStack(Items.field_151055_y, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Block)Blocks.field_150320_F, 1, 0), new ItemStack[]{new ItemStack(Items.field_151123_aH, 1, 0), new ItemStack((Block)Blocks.field_150331_J, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Block)Blocks.field_150331_J, 1, 0), new ItemStack[]{new ItemStack(Items.field_151042_j, 1, 0), new ItemStack(Blocks.field_150347_e, 4, 0), new ItemStack(Items.field_151137_ax, 1, 0), new ItemStack(Blocks.field_150344_f, 3, 0)}));
        for (i = 0; i < 16; ++i) {
            this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150325_L, 1, i), new ItemStack[]{new ItemStack(Items.field_151007_F, 4, 0)}));
        }
        for (i = 0; i <= 5; ++i) {
            this.recipes.add(new RecyclingRecipe(new ItemStack((Block)Blocks.field_150376_bx, 2, i), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 1, i)}));
        }
        this.recipes.add(new RecyclingRecipe(new ItemStack((Block)Blocks.field_150333_U, 2, 0), new ItemStack[]{new ItemStack(Blocks.field_150348_b, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Block)Blocks.field_150333_U, 2, 1), new ItemStack[]{new ItemStack(Blocks.field_150322_A, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Block)Blocks.field_150333_U, 2, 3), new ItemStack[]{new ItemStack(Blocks.field_150347_e, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Block)Blocks.field_150333_U, 2, 4), new ItemStack[]{new ItemStack(Blocks.field_150336_V, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Block)Blocks.field_150333_U, 2, 5), new ItemStack[]{new ItemStack(Blocks.field_150417_aV, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Block)Blocks.field_150333_U, 2, 6), new ItemStack[]{new ItemStack(Blocks.field_150385_bj, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Block)Blocks.field_150333_U, 2, 7), new ItemStack[]{new ItemStack(Blocks.field_150371_ca, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Block)Blocks.field_180389_cP, 2, 0), new ItemStack[]{new ItemStack(Blocks.field_180395_cM, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150335_W, 1, 0), new ItemStack[]{new ItemStack((Block)Blocks.field_150354_m, 4, 0), new ItemStack(Items.field_151016_H, 5, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150342_X, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 6, 0), new ItemStack(Items.field_151122_aG, 3, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150478_aa, 4, 0), new ItemStack[]{new ItemStack(Items.field_151044_h, 1, 0), new ItemStack(Items.field_151055_y, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150476_ad, 1, 0), new ItemStack[]{new ItemStack((Block)Blocks.field_150376_bx, 3, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150485_bF, 1, 0), new ItemStack[]{new ItemStack((Block)Blocks.field_150376_bx, 3, 1)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150487_bG, 1, 0), new ItemStack[]{new ItemStack((Block)Blocks.field_150376_bx, 3, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150481_bH, 1, 0), new ItemStack[]{new ItemStack((Block)Blocks.field_150376_bx, 3, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150400_ck, 1, 0), new ItemStack[]{new ItemStack((Block)Blocks.field_150376_bx, 3, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150401_cl, 1, 0), new ItemStack[]{new ItemStack((Block)Blocks.field_150376_bx, 3, 5)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150372_bz, 1, 0), new ItemStack[]{new ItemStack((Block)Blocks.field_150333_U, 3, 1)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150446_ar, 1, 0), new ItemStack[]{new ItemStack((Block)Blocks.field_150333_U, 3, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150389_bf, 1, 0), new ItemStack[]{new ItemStack((Block)Blocks.field_150333_U, 3, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150390_bg, 1, 0), new ItemStack[]{new ItemStack((Block)Blocks.field_150333_U, 3, 5)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150387_bl, 1, 0), new ItemStack[]{new ItemStack((Block)Blocks.field_150333_U, 3, 6)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150370_cb, 1, 0), new ItemStack[]{new ItemStack((Block)Blocks.field_150333_U, 3, 7)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_180396_cN, 1, 0), new ItemStack[]{new ItemStack((Block)Blocks.field_180389_cP, 3, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150468_ap, 3, 0), new ItemStack[]{new ItemStack(Items.field_151055_y, 7, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150442_at, 1, 0), new ItemStack[]{new ItemStack(Items.field_151055_y, 1, 0), new ItemStack(Blocks.field_150347_e, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150452_aw, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150456_au, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150348_b, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150443_bT, 1, 0), new ItemStack[]{new ItemStack(Items.field_151042_j, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150445_bS, 1, 0), new ItemStack[]{new ItemStack(Items.field_151043_k, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150429_aA, 1, 0), new ItemStack[]{new ItemStack(Items.field_151137_ax, 1, 0), new ItemStack(Items.field_151055_y, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150471_bO, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150430_aB, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150348_b, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_180407_aO, 3, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 4, 0), new ItemStack(Items.field_151055_y, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_180408_aP, 3, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 4, 1), new ItemStack(Items.field_151055_y, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_180404_aQ, 3, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 4, 2), new ItemStack(Items.field_151055_y, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_180403_aR, 3, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 4, 3), new ItemStack(Items.field_151055_y, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_180405_aT, 3, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 4, 4), new ItemStack(Items.field_151055_y, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_180406_aS, 3, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 4, 5), new ItemStack(Items.field_151055_y, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150386_bk, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150385_bj, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_180390_bo, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 2, 0), new ItemStack(Items.field_151055_y, 4, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_180391_bp, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 2, 1), new ItemStack(Items.field_151055_y, 4, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_180392_bq, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 2, 2), new ItemStack(Items.field_151055_y, 4, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_180386_br, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 2, 3), new ItemStack(Items.field_151055_y, 4, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_180387_bt, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 2, 4), new ItemStack(Items.field_151055_y, 4, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_180385_bs, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 2, 5), new ItemStack(Items.field_151055_y, 4, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150428_aP, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150423_aK, 1, 0), new ItemStack(Blocks.field_150478_aa, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150415_aT, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 3, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_180400_cw, 1, 0), new ItemStack[]{new ItemStack(Items.field_151042_j, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150411_aY, 1, 0), new ItemStack[]{new ItemStack(Items.field_191525_da, 3, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150379_bu, 1, 0), new ItemStack[]{new ItemStack(Items.field_151137_ax, 4, 0), new ItemStack(Blocks.field_150426_aN, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Block)Blocks.field_150479_bC, 2, 0), new ItemStack[]{new ItemStack(Items.field_151055_y, 1, 0), new ItemStack(Blocks.field_150344_f, 1, 0), new ItemStack(Items.field_151042_j, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150463_bK, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150347_e, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150463_bK, 1, 1), new ItemStack[]{new ItemStack(Blocks.field_150341_Y, 1, 0)}));
        for (i = 0; i < 16; ++i) {
            this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_150404_cg, 3, i), new ItemStack[]{new ItemStack(Blocks.field_150325_L, 2, i)}));
        }
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151033_d, 1, 0), new ItemStack[]{new ItemStack(Items.field_151042_j, 1, 0), new ItemStack(Items.field_151145_ak, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151055_y, 2, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151054_z, 4, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 3, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_179570_aq, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_179569_ar, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 2, 1)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_179568_as, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 2, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_179567_at, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 2, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_179572_au, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 2, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_179571_av, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 2, 5)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151139_aw, 1, 0), new ItemStack[]{new ItemStack(Items.field_151042_j, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151159_an, 1, 0), new ItemStack[]{new ItemStack(Items.field_151055_y, 8, 0), new ItemStack(Blocks.field_150325_L, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151155_ap, 3, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 6, 0), new ItemStack(Items.field_151055_y, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151133_ar, 1, 0), new ItemStack[]{new ItemStack(Items.field_151042_j, 3, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151143_au, 1, 0), new ItemStack[]{new ItemStack(Items.field_151042_j, 5, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151140_bW, 1, 0), new ItemStack[]{new ItemStack(Items.field_151143_au, 1, 0), new ItemStack((Block)Blocks.field_150438_bZ, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151142_bV, 1, 0), new ItemStack[]{new ItemStack(Items.field_151143_au, 1, 0), new ItemStack(Blocks.field_150335_W, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151109_aJ, 1, 0), new ItemStack[]{new ItemStack(Items.field_151143_au, 1, 0), new ItemStack(Blocks.field_150460_al, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151108_aI, 1, 0), new ItemStack[]{new ItemStack(Items.field_151143_au, 1, 0), new ItemStack((Block)Blocks.field_150486_ae, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151124_az, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 5, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_185150_aH, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 5, 1)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_185151_aI, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 5, 2)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_185152_aJ, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 5, 3)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_185153_aK, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 5, 4)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_185154_aL, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 5, 5)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151122_aG, 1, 0), new ItemStack[]{new ItemStack(Items.field_151121_aF, 3, 0), new ItemStack(Items.field_151116_aA, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151111_aL, 1, 0), new ItemStack[]{new ItemStack(Items.field_151137_ax, 1, 0), new ItemStack(Items.field_151042_j, 4, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Item)Items.field_151112_aM, 1, 0), new ItemStack[]{new ItemStack(Items.field_151007_F, 2, 0), new ItemStack(Items.field_151055_y, 3, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151113_aN, 1, 0), new ItemStack[]{new ItemStack(Items.field_151043_k, 4, 0), new ItemStack(Items.field_151137_ax, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151107_aW, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150348_b, 3, 0), new ItemStack(Blocks.field_150429_aA, 2, 0), new ItemStack(Items.field_151137_ax, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151132_bS, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150348_b, 3, 0), new ItemStack(Blocks.field_150429_aA, 3, 0), new ItemStack(Items.field_151128_bU, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151069_bo, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150359_w, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151067_bt, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150347_e, 3, 0), new ItemStack(Items.field_151072_bj, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151066_bu, 1, 0), new ItemStack[]{new ItemStack(Items.field_151042_j, 7, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151160_bD, 1, 0), new ItemStack[]{new ItemStack(Items.field_151055_y, 8, 0), new ItemStack(Items.field_151116_aA, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151162_bE, 1, 0), new ItemStack[]{new ItemStack(Items.field_151118_aC, 3, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151146_bM, 1, 0), new ItemStack[]{new ItemStack(Items.field_151172_bF, 1, 0), new ItemStack((Item)Items.field_151112_aM, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Item)Items.field_179565_cj, 1, 0), new ItemStack[]{new ItemStack(Items.field_151055_y, 6, 0), new ItemStack((Block)Blocks.field_150333_U, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151058_ca, 2, 0), new ItemStack[]{new ItemStack(Items.field_151007_F, 4, 0), new ItemStack(Items.field_151123_aH, 1, 0)}));
        for (i = 0; i < 16; ++i) {
            this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_179564_cE, 1, i), new ItemStack[]{new ItemStack(Blocks.field_150325_L, 6, 0), new ItemStack(Items.field_151055_y, 1, 0)}));
        }
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_185158_cP, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150359_w, 7, 0), new ItemStack(Items.field_151061_bv, 1, 0), new ItemStack(Items.field_151073_bk, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Item)Items.field_151148_bJ, 1, 0), new ItemStack[]{new ItemStack(Items.field_151111_aL, 1, 0), new ItemStack(Items.field_151121_aF, 8, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Item)Items.field_151097_aZ, 1, 0), new ItemStack[]{new ItemStack(Items.field_151042_j, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151039_o, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 3, 0), new ItemStack(Items.field_151055_y, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151050_s, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150347_e, 3, 0), new ItemStack(Items.field_151055_y, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151035_b, 1, 0), new ItemStack[]{new ItemStack(Items.field_151042_j, 3, 0), new ItemStack(Items.field_151055_y, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151005_D, 1, 0), new ItemStack[]{new ItemStack(Items.field_151043_k, 3, 0), new ItemStack(Items.field_151055_y, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151046_w, 1, 0), new ItemStack[]{new ItemStack(Items.field_151045_i, 3, 0), new ItemStack(Items.field_151055_y, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151053_p, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 3, 0), new ItemStack(Items.field_151055_y, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151049_t, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150347_e, 3, 0), new ItemStack(Items.field_151055_y, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151036_c, 1, 0), new ItemStack[]{new ItemStack(Items.field_151042_j, 3, 0), new ItemStack(Items.field_151055_y, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151006_E, 1, 0), new ItemStack[]{new ItemStack(Items.field_151043_k, 3, 0), new ItemStack(Items.field_151055_y, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151056_x, 1, 0), new ItemStack[]{new ItemStack(Items.field_151045_i, 3, 0), new ItemStack(Items.field_151055_y, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151038_n, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 1, 0), new ItemStack(Items.field_151055_y, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151051_r, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150347_e, 1, 0), new ItemStack(Items.field_151055_y, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151037_a, 1, 0), new ItemStack[]{new ItemStack(Items.field_151042_j, 1, 0), new ItemStack(Items.field_151055_y, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151011_C, 1, 0), new ItemStack[]{new ItemStack(Items.field_151043_k, 1, 0), new ItemStack(Items.field_151055_y, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151047_v, 1, 0), new ItemStack[]{new ItemStack(Items.field_151045_i, 1, 0), new ItemStack(Items.field_151055_y, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151041_m, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 2, 0), new ItemStack(Items.field_151055_y, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151052_q, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150347_e, 2, 0), new ItemStack(Items.field_151055_y, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151040_l, 1, 0), new ItemStack[]{new ItemStack(Items.field_151042_j, 2, 0), new ItemStack(Items.field_151055_y, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151010_B, 1, 0), new ItemStack[]{new ItemStack(Items.field_151043_k, 2, 0), new ItemStack(Items.field_151055_y, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151048_u, 1, 0), new ItemStack[]{new ItemStack(Items.field_151045_i, 2, 0), new ItemStack(Items.field_151055_y, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151017_I, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 2, 0), new ItemStack(Items.field_151055_y, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151018_J, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150347_e, 2, 0), new ItemStack(Items.field_151055_y, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151019_K, 1, 0), new ItemStack[]{new ItemStack(Items.field_151042_j, 2, 0), new ItemStack(Items.field_151055_y, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151013_M, 1, 0), new ItemStack[]{new ItemStack(Items.field_151043_k, 2, 0), new ItemStack(Items.field_151055_y, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151012_L, 1, 0), new ItemStack[]{new ItemStack(Items.field_151045_i, 2, 0), new ItemStack(Items.field_151055_y, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Item)Items.field_151031_f, 1, 0), new ItemStack[]{new ItemStack(Items.field_151007_F, 3, 0), new ItemStack(Items.field_151055_y, 3, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151032_g, 1, 0), new ItemStack[]{new ItemStack(Items.field_151008_G, 1, 0), new ItemStack(Items.field_151055_y, 1, 0), new ItemStack(Items.field_151145_ak, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_185166_h, 2, 0), new ItemStack[]{new ItemStack(Items.field_151114_aO, 4, 0), new ItemStack(Items.field_151032_g, 1, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Item)Items.field_151021_T, 1, 0), new ItemStack[]{new ItemStack(Items.field_151116_aA, 4, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Item)Items.field_151024_Q, 1, 0), new ItemStack[]{new ItemStack(Items.field_151116_aA, 5, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Item)Items.field_151027_R, 1, 0), new ItemStack[]{new ItemStack(Items.field_151116_aA, 8, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Item)Items.field_151026_S, 1, 0), new ItemStack[]{new ItemStack(Items.field_151116_aA, 7, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Item)Items.field_151167_ab, 1, 0), new ItemStack[]{new ItemStack(Items.field_151042_j, 4, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Item)Items.field_151028_Y, 1, 0), new ItemStack[]{new ItemStack(Items.field_151042_j, 5, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Item)Items.field_151030_Z, 1, 0), new ItemStack[]{new ItemStack(Items.field_151042_j, 8, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Item)Items.field_151165_aa, 1, 0), new ItemStack[]{new ItemStack(Items.field_151042_j, 7, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Item)Items.field_151151_aj, 1, 0), new ItemStack[]{new ItemStack(Items.field_151043_k, 4, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Item)Items.field_151169_ag, 1, 0), new ItemStack[]{new ItemStack(Items.field_151043_k, 5, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Item)Items.field_151171_ah, 1, 0), new ItemStack[]{new ItemStack(Items.field_151043_k, 8, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Item)Items.field_151149_ai, 1, 0), new ItemStack[]{new ItemStack(Items.field_151043_k, 7, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Item)Items.field_151175_af, 1, 0), new ItemStack[]{new ItemStack(Items.field_151045_i, 4, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Item)Items.field_151161_ac, 1, 0), new ItemStack[]{new ItemStack(Items.field_151045_i, 5, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Item)Items.field_151163_ad, 1, 0), new ItemStack[]{new ItemStack(Items.field_151045_i, 8, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack((Item)Items.field_151173_ae, 1, 0), new ItemStack[]{new ItemStack(Items.field_151045_i, 7, 0)}));
        for (i = 0; i < 16; ++i) {
            this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_192444_dS, 8, i), new ItemStack[]{new ItemStack(Items.field_151100_aR, 1, 15 - i), new ItemStack((Block)Blocks.field_150354_m, 4, 0), new ItemStack(Blocks.field_150351_n, 4, 0)}));
        }
        for (i = 0; i < 16; ++i) {
            this.recipes.add(new RecyclingRecipe(new ItemStack(Items.field_151104_aV, 1, i), new ItemStack[]{new ItemStack(Blocks.field_150325_L, 3, i), new ItemStack(Blocks.field_150344_f, 3, 0)}));
        }
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_189879_dh, 1, 0), new ItemStack[]{new ItemStack(Items.field_151130_bT, 2, 0), new ItemStack(Items.field_151075_bm, 2, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_189877_df, 1, 0), new ItemStack[]{new ItemStack(Items.field_151064_bs, 4, 0)}));
        this.recipes.add(new RecyclingRecipe(new ItemStack(Blocks.field_190976_dk, 1, 0), new ItemStack[]{new ItemStack(Blocks.field_150347_e, 6, 0), new ItemStack(Items.field_151137_ax, 2, 0), new ItemStack(Items.field_151128_bU, 1, 0)}));
    }
}

