/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.core;

import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.server.command.TextComponentHelper;
import org.apache.logging.log4j.Level;
import ovh.corail.recycler.ModRecycler;

public class TranslationHelper {
    public static void sendMessage(ICommandSender sender, LangKey langKey, Object ... params) {
        if (sender == null || sender.func_130014_f_().field_72995_K) {
            return;
        }
        if (sender instanceof EntityPlayerMP) {
            sender.func_145747_a((ITextComponent)TextComponentHelper.createComponentTranslation((ICommandSender)sender, (String)langKey.getKey(), (Object[])params));
        }
    }

    public static void sendLog(LangKey langKey, Object ... params) {
        String content = I18n.func_74837_a((String)langKey.getKey(), (Object[])params);
        TranslationHelper.sendLog(content);
    }

    public static void sendLog(String content) {
        if (ModRecycler.logger != null) {
            ModRecycler.logger.log(Level.INFO, content);
        } else {
            System.out.println(content);
        }
    }

    public static ITextComponent createComponentTranslation(ICommandSender sender, LangKey langKey, Object ... params) {
        return TranslationHelper.createComponentTranslation(sender, langKey.getKey(), params);
    }

    public static ITextComponent createComponentTranslation(ICommandSender sender, String message, Object ... params) {
        return TextComponentHelper.createComponentTranslation((ICommandSender)sender, (String)message, (Object[])params);
    }

    public static ITextComponent createComponentTranslationWithStyle(ICommandSender sender, StyleType styleType, LangKey langKey, Object ... params) {
        return TranslationHelper.createComponentTranslationWithStyle(sender, styleType, langKey.getKey(), params);
    }

    public static ITextComponent createComponentTranslationWithStyle(ICommandSender sender, StyleType styleType, String message, Object ... params) {
        return TextComponentHelper.createComponentTranslation((ICommandSender)sender, (String)message, (Object[])params).func_150255_a(styleType.getStyle());
    }

    public static String getLocaleTranslationWithStyle(StyleType styleType, LangKey langKey, Object ... params) {
        return TranslationHelper.getLocaleTranslationWithStyle(styleType, langKey.getKey(), params);
    }

    public static String getLocaleTranslationWithStyle(StyleType styleType, String message, Object ... params) {
        return styleType.getStyleString() + TranslationHelper.getLocaleTranslation(message, params);
    }

    public static String getLocaleTranslation(LangKey langKey, Object ... params) {
        return TranslationHelper.getLocaleTranslation(langKey.getKey(), params);
    }

    public static String getLocaleTranslation(String message, Object ... params) {
        return I18n.func_74837_a((String)message, (Object[])params);
    }

    public static enum LangKey {
        MESSAGE_ADD_RECIPE_SUCCESS("message.add_recipe_success"),
        MESSAGE_ADD_RECIPE_FAILED("message.add_recipe_failed"),
        MESSAGE_EXPORT_SUCCESS("message.export_success"),
        MESSAGE_EXPORT_FAILED("message.export_failed"),
        MESSAGE_REMOVE_RECIPE_SUCCESS("message.remove_recipe_success"),
        MESSAGE_REMOVE_RECIPE_FAILED("message.remove_recipe_failed"),
        MESSAGE_FOUND_RECIPES("message.found_recipes"),
        MESSAGE_RECYCLING_BOOK("message.recycling_book"),
        MESSAGE_NOT_ENOUGH_OUTPUT_SLOTS("message.not_enough_output_slots"),
        MESSAGE_LOSS("message.loss"),
        MESSAGE_BROKEN_DISK("message.broken_disk"),
        BUTTON_RECYLE("button.recycle"),
        BUTTON_AUTO("button.auto"),
        BUTTON_TAKE_ALL("button.takeAll"),
        BUTTON_DISCOVER_RECIPE("button.discoverRecipe"),
        BUTTON_REMOVE_RECIPE("button.removeRecipe");

        private final String key;

        private LangKey(String key) {
            this.key = key;
        }

        public String getKey() {
            return "recycler." + this.key;
        }
    }

    public static enum StyleType {
        MESSAGE_NORMAL(TextFormatting.WHITE, false, false),
        MESSAGE_SPECIAL(TextFormatting.GOLD, false, false),
        TOOLTIP_DESC(TextFormatting.GRAY, true, false);

        private String name;
        private final TextFormatting color;
        private final boolean isItalic;
        private final boolean isBold;
        private final Style style;

        private StyleType(TextFormatting color, boolean isItalic, boolean isBold) {
            this.color = color;
            this.isItalic = isItalic;
            this.isBold = isBold;
            this.style = new Style().func_150238_a(color).func_150217_b(Boolean.valueOf(isItalic)).func_150227_a(Boolean.valueOf(isBold));
        }

        public Style getStyle() {
            return this.style;
        }

        public String getStyleString() {
            return this.color.toString() + (this.isItalic ? TextFormatting.ITALIC.toString() : "") + (this.isBold ? TextFormatting.BOLD.toString() : "");
        }
    }
}

