/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.gui;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.wrapper.InvWrapper;
import ovh.corail.recycler.capability.RecyclerDefaultStackHandler;
import ovh.corail.recycler.capability.RecyclerWorkingStackHandler;
import ovh.corail.recycler.gui.SlotRecycler;
import ovh.corail.recycler.gui.SlotWorking;
import ovh.corail.recycler.tileentity.TileEntityRecycler;

public class ContainerRecycler
extends Container {
    private final TileEntityRecycler recycler;
    private boolean working = false;
    private int progress = 0;
    private int inputMax = 0;
    private boolean hasRecipe = false;

    public ContainerRecycler(EntityPlayer player, TileEntityRecycler recycler) {
        int x;
        int y;
        this.recycler = recycler;
        this.func_75146_a((Slot)new SlotWorking(recycler, 0, 81, 69, RecyclerWorkingStackHandler.EnumSlot.ITEM.predic));
        this.func_75146_a((Slot)new SlotWorking(recycler, 1, 81, 91, RecyclerWorkingStackHandler.EnumSlot.DISK.predic));
        for (y = 0; y < 6; ++y) {
            for (x = 0; x < 3; ++x) {
                this.func_75146_a((Slot)new SlotRecycler<RecyclerDefaultStackHandler>(recycler.getInventoryInput(), x + y * 3, x * 18 + 7, y * 18 + 8));
            }
        }
        for (y = 0; y < 6; ++y) {
            for (x = 0; x < 3; ++x) {
                this.func_75146_a((Slot)new SlotRecycler<RecyclerDefaultStackHandler>(recycler.getInventoryOutput(), x + y * 3, x * 18 + 173, y * 18 + 8));
            }
        }
        InvWrapper inventPlayer = new InvWrapper((IInventory)player.field_71071_by);
        for (y = 0; y < 4; ++y) {
            for (x = 0; x < 9; ++x) {
                this.func_75146_a((Slot)new SlotRecycler<InvWrapper>(inventPlayer, x + y * 9, x * 18 + 7, y == 0 ? 178 : y * 18 + 102));
            }
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 3; ++x) {
                this.func_75146_a((Slot)new SlotRecycler<RecyclerDefaultStackHandler>(recycler.getInventoryVisual(), x + y * 3, x * 18 + 115, y * 18 + 8, p -> false, false));
            }
        }
        recycler.updateRecyclingRecipe();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int value) {
        if (id == 0) {
            this.recycler.updateWorking(value == 1);
        } else if (id == 1) {
            this.recycler.setProgress(value);
        } else if (id == 2) {
            this.recycler.setInputMax(value);
        } else if (id == 3) {
            this.recycler.setProcessingRecipe(value == 1);
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (IContainerListener listener : this.field_75149_d) {
            if (this.working != this.recycler.isWorking()) {
                listener.func_71112_a((Container)this, 0, this.recycler.isWorking() ? 1 : 0);
            }
            if (this.progress != this.recycler.getProgress()) {
                listener.func_71112_a((Container)this, 1, this.recycler.getProgress());
            }
            if (this.inputMax != this.recycler.getInputMax()) {
                listener.func_71112_a((Container)this, 2, this.recycler.getInputMax());
            }
            if (!(this.hasRecipe ^ this.recycler.isProcessingRecipe())) continue;
            listener.func_71112_a((Container)this, 3, this.recycler.isProcessingRecipe() ? 1 : 0);
        }
        this.working = this.recycler.isWorking();
        this.progress = this.recycler.getProgress();
        this.inputMax = this.recycler.getInputMax();
        this.hasRecipe = this.recycler.isProcessingRecipe();
    }

    public ItemStack func_184996_a(int slot, int dragType, ClickType clickType, EntityPlayer player) {
        ItemStack stack = super.func_184996_a(slot, dragType, clickType, player);
        if ((slot == 0 || slot == 1) && this.recycler.isWorking()) {
            this.recycler.updateWorking(false);
        }
        return stack;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < 38 ? !this.func_75135_a(itemstack1, 38, 73, true) : index < 74 && !this.func_75135_a(itemstack1, 2, 19, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
        }
        return itemstack;
    }
}

