/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.handler;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import ovh.corail.recycler.core.JsonRecyclingRecipe;
import ovh.corail.recycler.core.RecyclingManager;
import ovh.corail.recycler.core.TranslationHelper;
import ovh.corail.recycler.handler.ConfigurationHandler;

public class CommandHandler
extends CommandBase {
    private final String name = "recycler";
    private final List<String> commands = Lists.newArrayList();

    public CommandHandler() {
        this.commands.add("exportCraftingRecipes");
        this.commands.add("addRecipe");
        this.commands.add("removeRecipe");
    }

    public String func_71517_b() {
        return "recycler";
    }

    public String func_71518_a(ICommandSender sender) {
        return "recycler <command>\nexportCraftingRecipes - save the list of all crafting recipes in \"recycling\" format in the config directoryaddRecipe - add the recycling recipe of the crafting result of the item hold in main hand\nremoveRecipe - remove the recycling recipe of the item hold in main hand";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!(sender instanceof EntityPlayerMP)) {
            throw new WrongUsageException("message.command.onlyInGame", new Object[0]);
        }
        EntityPlayerMP player = (EntityPlayerMP)sender;
        WorldServer world = player.func_71121_q();
        if (args.length != 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        switch (args[0]) {
            case "exportCraftingRecipes": {
                this.processExportCraftingRecipes(player);
                break;
            }
            case "addRecipe": {
                this.processAddRecipe(player);
                break;
            }
            case "removeRecipe": {
                this.processRemoveRecipe(player);
                break;
            }
            default: {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        return args.length == 1 ? this.commands : Collections.emptyList();
    }

    private void processExportCraftingRecipes(EntityPlayerMP player) {
        try {
            RecyclingManager rm = RecyclingManager.getInstance();
            ArrayList list = Lists.newArrayList();
            for (IRecipe crafting_recipe : CraftingManager.field_193380_a) {
                JsonRecyclingRecipe res;
                if (crafting_recipe.func_77571_b().func_190926_b() || rm.hasRecipe(crafting_recipe.func_77571_b()) != -1 || (res = rm.convertRecipeToJson(rm.convertCraftingRecipe(crafting_recipe))) == null) continue;
                list.add(res);
            }
            File exportFile = new File(ConfigurationHandler.getConfigDir(), "export_crafting_recipes.json");
            TranslationHelper.sendMessage((ICommandSender)player, TranslationHelper.LangKey.MESSAGE_FOUND_RECIPES, list.size());
            boolean success = rm.saveAsJson(exportFile, list);
            TranslationHelper.sendMessage((ICommandSender)player, success ? TranslationHelper.LangKey.MESSAGE_EXPORT_SUCCESS : TranslationHelper.LangKey.MESSAGE_EXPORT_FAILED, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processAddRecipe(EntityPlayerMP player) {
        try {
            RecyclingManager.getInstance().discoverRecipe((EntityPlayer)player, player.func_184614_ca());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processRemoveRecipe(EntityPlayerMP player) {
        TranslationHelper.sendMessage((ICommandSender)player, RecyclingManager.getInstance().removeRecipe(player.func_184614_ca()) ? TranslationHelper.LangKey.MESSAGE_REMOVE_RECIPE_SUCCESS : TranslationHelper.LangKey.MESSAGE_REMOVE_RECIPE_FAILED, new Object[0]);
    }
}

