/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.handler;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import ovh.corail.recycler.core.TranslationHelper;

public class ConfigurationHandler {
    public static Configuration config;
    private static File configDir;
    public static boolean unbalanced_recipes;
    public static boolean only_user_recipes;
    public static boolean recycle_magic_item;
    public static boolean recycle_enchanted_book;
    public static boolean allow_sound;
    public static boolean recycle_round_down;
    public static int chance_loss;
    public static int time_to_recycle;

    private ConfigurationHandler() {
    }

    public static void loadConfig(File configDir) {
        ConfigurationHandler.configDir = configDir;
        if (!configDir.exists()) {
            configDir.mkdir();
        }
        config = new Configuration(new File(configDir, "recycler.cfg"), "3.2.0");
        config.load();
        ConfigurationHandler.refreshConfig();
    }

    public static void refreshConfig() {
        unbalanced_recipes = config.getBoolean("unbalanced_recipes", "general", false, ConfigurationHandler.getLocal("unbalanced_recipes"));
        only_user_recipes = config.getBoolean("only_user_recipes", "general", false, ConfigurationHandler.getLocal("only_user_recipes"));
        recycle_magic_item = config.getBoolean("recycle_magic_item", "general", true, ConfigurationHandler.getLocal("recycle_magic_item"));
        recycle_enchanted_book = config.getBoolean("recycle_enchanted_book", "general", true, ConfigurationHandler.getLocal("recycle_enchanted_book"));
        chance_loss = config.getInt("chance_loss", "general", 0, 0, 100, ConfigurationHandler.getLocal("chance_loss"));
        allow_sound = config.getBoolean("allow_sound", "general", true, ConfigurationHandler.getLocal("allow_sound"));
        time_to_recycle = config.getInt("time_to_recycle", "general", 100, 0, 1000, ConfigurationHandler.getLocal("time_to_recycle"));
        recycle_round_down = config.getBoolean("recycle_round_down", "general", false, ConfigurationHandler.getLocal("recycle_round_down"));
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static File getConfigDir() {
        return configDir;
    }

    public static String getLocal(String key) {
        return TranslationHelper.getLocaleTranslation("recycler.config." + key, new Object[0]);
    }
}

