/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.handler;

import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import ovh.corail.recycler.handler.ConfigurationHandler;

public class SoundHandler {
    public static void registerSounds() {
        SoundType.values();
    }

    private static SoundEvent registerSound(SoundType soundType) {
        ResourceLocation soundLoc = new ResourceLocation("recycler", soundType.func_176610_l());
        SoundEvent sound = (SoundEvent)new SoundEvent(soundLoc).setRegistryName(soundLoc);
        ForgeRegistries.SOUND_EVENTS.register((IForgeRegistryEntry)sound);
        return sound;
    }

    public static boolean playSoundAllAround(SoundType soundType, World world, BlockPos pos) {
        return SoundHandler.playSoundAllAround(soundType.sound, soundType.cat, world, pos);
    }

    public static boolean playSoundAllAround(SoundEvent sound, SoundCategory cat, World world, BlockPos pos) {
        if (!ConfigurationHandler.allow_sound || world.field_72995_K || sound == null) {
            return false;
        }
        world.func_184133_a(null, pos, sound, cat, 1.0f, 1.0f);
        return true;
    }

    public static enum SoundType implements IStringSerializable
    {
        RECYCLER(SoundCategory.BLOCKS),
        RECYCLER_WORKING(SoundCategory.BLOCKS);

        private final SoundEvent sound;
        private final SoundCategory cat;

        private SoundType(SoundCategory cat) {
            this.cat = cat;
            this.sound = SoundHandler.registerSound(this);
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

