/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.tileentity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorldNameable;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.recycler.ModItems;
import ovh.corail.recycler.block.BlockRecycler;
import ovh.corail.recycler.capability.RecyclerDefaultStackHandler;
import ovh.corail.recycler.capability.RecyclerWorkingStackHandler;
import ovh.corail.recycler.core.Helper;
import ovh.corail.recycler.core.RecyclingManager;
import ovh.corail.recycler.core.RecyclingRecipe;
import ovh.corail.recycler.core.TranslationHelper;
import ovh.corail.recycler.handler.ConfigurationHandler;
import ovh.corail.recycler.handler.SoundHandler;

public class TileEntityRecycler
extends TileEntity
implements ITickable,
IWorldNameable {
    protected String customName;
    protected final RecyclerDefaultStackHandler inventInput = new RecyclerDefaultStackHandler(18);
    protected final RecyclerWorkingStackHandler inventWorking = new RecyclerWorkingStackHandler();
    protected final RecyclerDefaultStackHandler inventOutput = new RecyclerDefaultStackHandler(18);
    protected final RecyclerDefaultStackHandler inventVisual = new RecyclerDefaultStackHandler(9);
    protected final RecyclerDefaultStackHandler inventRecyclingBook = new RecyclerDefaultStackHandler(40);
    private final int maxTicks = ConfigurationHandler.time_to_recycle;
    private int countTicks = 0;
    private boolean isWorking = false;
    private int progress = 0;
    private int inputMax = 0;
    private int cantRecycleTicks = 0;
    private int pageNum = 0;
    private int pageMax = 0;
    private String searchText = "";
    private boolean isProcessing;

    public RecyclerDefaultStackHandler getInventoryInput() {
        return this.inventInput;
    }

    public RecyclerWorkingStackHandler getInventoryWorking() {
        return this.inventWorking;
    }

    public RecyclerDefaultStackHandler getInventoryOutput() {
        return this.inventOutput;
    }

    public RecyclerDefaultStackHandler getInventoryVisual() {
        return this.inventVisual;
    }

    public RecyclerDefaultStackHandler getInventoryRecyclingBook() {
        return this.inventRecyclingBook;
    }

    public int getRecyclingBookPageNum() {
        return this.pageNum;
    }

    public void setRecyclingBookPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public int getRecyclingBookPageMax() {
        return this.pageMax;
    }

    public void setRecyclingBookPageMax(int pageMax) {
        this.pageMax = pageMax;
    }

    public void initRecyclingBook() {
        this.searchText = "";
        this.pageNum = 0;
        this.updateRecyclingBookSlots(RecyclingManager.getInstance().getPage(this.pageNum, this.searchText));
        this.pageMax = RecyclingManager.getInstance().getPageCount(this.searchText) / 4;
    }

    public void updateRecyclingBook(int pageNum) {
        this.updateRecyclingBookSlots(RecyclingManager.getInstance().getPage(pageNum, this.searchText));
        this.pageNum = pageNum;
    }

    public void updateRecyclingBook(String searchText) {
        this.updateRecyclingBookSlots(RecyclingManager.getInstance().getPage(0, searchText));
        this.searchText = searchText;
        this.pageNum = 0;
        this.pageMax = RecyclingManager.getInstance().getPageCount(searchText) / 4;
    }

    private void updateRecyclingBookSlots(List<RecyclingRecipe> recipes) {
        int slotId = 0;
        for (RecyclingRecipe recipe : recipes) {
            this.inventRecyclingBook.setStackInSlot(slotId++, recipe.getItemRecipe());
            for (int i = 0; i < 9; ++i) {
                this.inventRecyclingBook.setStackInSlot(slotId++, i < recipe.getCount() ? recipe.getStack(i) : ItemStack.field_190927_a);
            }
        }
        while (slotId < 40) {
            this.inventRecyclingBook.setStackInSlot(slotId++, ItemStack.field_190927_a);
        }
    }

    public boolean isOutputEmpty() {
        return this.inventOutput.stream().noneMatch(p -> p != ItemStack.field_190927_a);
    }

    public int getEmptySlotInOutPut() {
        for (int slot = 0; slot < this.inventOutput.getSlots(); ++slot) {
            if (!this.inventOutput.getStackInSlot(slot).func_190926_b()) continue;
            return slot;
        }
        return -1;
    }

    private boolean transferSlotWorking() {
        return ItemHandlerHelper.insertItemStacked((IItemHandler)this.inventOutput, (ItemStack)this.inventWorking.extractItem(0, this.inventWorking.getStackInSlot(0).func_190916_E(), false), (boolean)false).func_190926_b();
    }

    public boolean hasSpaceInInventory(List<ItemStack> itemsList, boolean simulate) {
        int emptySlot;
        ArrayList emptySlots = Lists.newArrayList();
        for (int slot = 0; slot < this.inventOutput.getSlots(); ++slot) {
            if (!this.inventOutput.getStackInSlot(slot).func_190926_b()) continue;
            emptySlots.add(slot);
        }
        List<ItemStack> resultList = this.inventOutput.getInventoryList();
        if (simulate && emptySlots.size() >= itemsList.size()) {
            return true;
        }
        int minCount = simulate ? itemsList.size() - emptySlots.size() : 0;
        for (int i = 0; i < itemsList.size(); ++i) {
            ItemStack stackIn = itemsList.get(i);
            if (stackIn.func_190926_b()) {
                if (!simulate) continue;
                --minCount;
                continue;
            }
            if (stackIn.func_190916_E() == stackIn.func_77976_d()) continue;
            int left = stackIn.func_190916_E();
            int maxSize = stackIn.func_77976_d();
            for (ItemStack aResultList : resultList) {
                int space;
                int add;
                ItemStack stackOut = aResultList;
                if (stackOut.func_190926_b() || stackOut.func_190916_E() == stackOut.func_77976_d() || !Helper.areItemEqual(stackIn, stackOut) || (add = Math.min(space = maxSize - stackOut.func_190916_E(), left)) <= 0) continue;
                stackOut.func_190917_f(add);
                if ((left -= add) > 0) continue;
                break;
            }
            if (left <= 0 && simulate) {
                --minCount;
            }
            if (left > 0) {
                if (emptySlots.size() > 0) {
                    emptySlot = (Integer)emptySlots.get(0);
                    emptySlots.remove(0);
                    ItemStack stackCopy = stackIn.func_77946_l();
                    stackCopy.func_190920_e(left);
                    resultList.set(emptySlot, stackCopy);
                    if (simulate) {
                        ++minCount;
                    }
                } else {
                    return false;
                }
            }
            if (simulate && minCount <= 0) {
                return true;
            }
            itemsList.set(i, ItemStack.field_190927_a);
        }
        for (ItemStack stack : itemsList) {
            if (stack.func_190926_b() || emptySlots.size() <= 0) continue;
            emptySlot = (Integer)emptySlots.get(0);
            emptySlots.remove(0);
            resultList.set(emptySlot, stack.func_77946_l());
        }
        if (!simulate) {
            for (int slot = 0; slot < this.inventOutput.getSlots(); ++slot) {
                this.inventOutput.setStackInSlot(slot, resultList.get(slot));
            }
        }
        return true;
    }

    public boolean recycle(@Nullable EntityPlayer player) {
        List<ItemStack> itemsList;
        int maxDiskUse;
        RecyclingManager recyclingManager = RecyclingManager.getInstance();
        ItemStack workingStack = this.inventWorking.getStackInSlot(0);
        ItemStack diskStack = this.inventWorking.getStackInSlot(1);
        if (workingStack.func_190926_b() || diskStack.func_190926_b()) {
            return false;
        }
        RecyclingRecipe recipe = recyclingManager.getRecipe(workingStack);
        if (recipe == null) {
            this.transferSlotWorking();
            return false;
        }
        int nb_input = workingStack.func_190916_E() / recipe.getItemRecipe().func_190916_E();
        if (nb_input == 0) {
            return false;
        }
        if (this.isWorking) {
            nb_input = 1;
        }
        if ((maxDiskUse = (diskStack.func_77958_k() - diskStack.func_77952_i()) / 10) < nb_input) {
            nb_input = maxDiskUse;
        }
        if (!this.hasSpaceInInventory(itemsList = recyclingManager.getResultStack(workingStack, nb_input), true)) {
            TranslationHelper.sendMessage((ICommandSender)player, TranslationHelper.LangKey.MESSAGE_NOT_ENOUGH_OUTPUT_SLOTS, new Object[0]);
            return false;
        }
        int loss = 0;
        if (ConfigurationHandler.chance_loss > 0) {
            for (int i = 0; i < nb_input; ++i) {
                if (Helper.getRandom(1, 100) > ConfigurationHandler.chance_loss) continue;
                ++loss;
            }
            if (loss > 0) {
                TranslationHelper.sendMessage((ICommandSender)player, TranslationHelper.LangKey.MESSAGE_LOSS, new Object[0]);
            }
        }
        List<Object> stackList = nb_input - loss > 0 ? recyclingManager.getResultStack(workingStack, nb_input - loss) : Lists.newArrayList();
        if (loss > 0) {
            List<ItemStack> halfstackList = recyclingManager.getResultStack(workingStack, loss, true);
            stackList.addAll(halfstackList);
        }
        this.hasSpaceInInventory((List<ItemStack>)stackList, false);
        this.inventWorking.getStackInSlot(0).func_190918_g(nb_input * recipe.getItemRecipe().func_190916_E());
        int diskDamage = 10 * nb_input;
        if (diskStack.func_77952_i() + diskDamage >= diskStack.func_77958_k()) {
            TranslationHelper.sendMessage((ICommandSender)player, TranslationHelper.LangKey.MESSAGE_BROKEN_DISK, new Object[0]);
            this.inventWorking.setStackInSlot(1, ItemStack.field_190927_a);
        } else {
            this.inventWorking.getStackInSlot(1).func_77964_b(diskStack.func_77952_i() + diskDamage);
        }
        SoundHandler.playSoundAllAround(SoundHandler.SoundType.RECYCLER, this.field_145850_b, this.field_174879_c);
        return true;
    }

    public boolean isProcessingRecipe() {
        return this.isProcessing;
    }

    public void setProcessingRecipe(boolean state) {
        this.isProcessing = state;
    }

    public void func_73660_a() {
        RecyclingRecipe baseRecipe;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.field_145850_b.func_72820_D() % 10L == 0L) {
            int slotId;
            if (this.inventWorking.getStackInSlot(0).func_190926_b()) {
                for (slotId = 0; slotId < this.inventInput.getSlots(); ++slotId) {
                    if (this.inventInput.getStackInSlot(slotId).func_190926_b() || ModItems.diamond_disk.isValidItem(this.inventInput.getStackInSlot(slotId))) continue;
                    this.inventWorking.insertItem(0, this.inventInput.extractItem(slotId, this.inventInput.getStackInSlot(slotId).func_190916_E(), false), false);
                    this.updateRecyclingRecipe();
                    break;
                }
            } else if (this.inventWorking.getStackInSlot(0).func_77985_e() && this.inventWorking.getStackInSlot(0).func_190916_E() < this.inventWorking.getStackInSlot(0).func_77976_d()) {
                for (slotId = 0; slotId < this.inventInput.getSlots(); ++slotId) {
                    if (!Helper.areItemEqual(this.inventWorking.getStackInSlot(0), this.inventInput.getStackInSlot(slotId))) continue;
                    this.inventWorking.insertItem(0, this.inventInput.extractItem(slotId, 1, false), false);
                    this.updateRecyclingRecipe();
                    break;
                }
            }
            if (this.inventWorking.getStackInSlot(1).func_190926_b()) {
                for (slotId = 0; slotId < this.inventInput.getSlots(); ++slotId) {
                    if (!ModItems.diamond_disk.isValidItem(this.inventInput.getStackInSlot(slotId))) continue;
                    this.inventWorking.insertItem(1, this.inventInput.extractItem(slotId, 1, false), false);
                    break;
                }
            }
        }
        int n = this.inputMax = (baseRecipe = RecyclingManager.getInstance().getRecipe(this.inventWorking.getStackInSlot(0))) != null ? this.inventWorking.getStackInSlot(0).func_190916_E() / baseRecipe.getItemRecipe().func_190916_E() : 0;
        if (this.inputMax > 0) {
            this.inputMax = Math.min(this.inputMax, (this.inventWorking.getStackInSlot(1).func_77958_k() - this.inventWorking.getStackInSlot(1).func_77952_i()) / 10);
        }
        this.setProcessingRecipe(this.inputMax > 0);
        if (!this.isWorking) {
            return;
        }
        --this.countTicks;
        if (!this.isProcessingRecipe()) {
            ++this.cantRecycleTicks;
            this.countTicks = this.maxTicks;
        }
        if (this.cantRecycleTicks > 40) {
            if (!this.inventWorking.getStackInSlot(0).func_190926_b()) {
                this.transferSlotWorking();
            }
            this.updateWorking(false);
            this.cantRecycleTicks = 0;
            this.countTicks = this.maxTicks;
        }
        if (this.countTicks <= 0) {
            if (!this.recycle(null)) {
                ++this.cantRecycleTicks;
            }
            this.countTicks = this.maxTicks;
        } else if (this.cantRecycleTicks <= 1 && this.countTicks % 15 == 0) {
            SoundHandler.playSoundAllAround(SoundHandler.SoundType.RECYCLER_WORKING, this.field_145850_b, this.field_174879_c);
            for (int i = 0; i < 4; ++i) {
                this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)this.field_174879_c.func_177958_n() + Helper.random.nextDouble(), (double)this.field_174879_c.func_177956_o() + Helper.random.nextDouble(), (double)this.field_174879_c.func_177952_p() + Helper.random.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
            }
        }
        this.progress = (this.maxTicks - this.countTicks) * 100 / this.maxTicks;
    }

    public void updateRecyclingRecipe() {
        int slotId;
        boolean hasRecipe = RecyclingManager.getInstance().hasRecipe(this.getInventoryWorking().getStackInSlot(0)) >= 0;
        ArrayList currentRecipe = hasRecipe ? RecyclingManager.getInstance().getResultStack(this.getInventoryWorking().getStackInSlot(0), 1) : Lists.newArrayList();
        if (hasRecipe) {
            for (slotId = 0; slotId < currentRecipe.size(); ++slotId) {
                if (Helper.areItemEqual((ItemStack)currentRecipe.get(slotId), this.inventVisual.getStackInSlot(slotId))) continue;
                this.inventVisual.setStackInSlot(slotId, (ItemStack)currentRecipe.get(slotId));
            }
        }
        while (slotId < this.inventVisual.getSlots()) {
            if (!this.inventVisual.getStackInSlot(slotId).func_190926_b()) {
                this.inventVisual.setStackInSlot(slotId, ItemStack.field_190927_a);
            }
            ++slotId;
        }
    }

    public boolean isWorking() {
        return this.isWorking;
    }

    public void updateWorking(boolean isWorking) {
        this.setProgress(0);
        this.isWorking = isWorking;
        this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockRecycler.ENABLED, (Comparable)Boolean.valueOf(isWorking)));
    }

    public void setProgress(int progress) {
        if (progress == 0) {
            this.countTicks = this.maxTicks;
        }
        this.progress = progress;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setInputMax(int inputMax) {
        this.inputMax = inputMax;
    }

    public int getInputMax() {
        return this.inputMax;
    }

    public String func_70005_c_() {
        return "recyclerblock.recycler.name";
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public ITextComponent func_145748_c_() {
        return TranslationHelper.createComponentTranslation(null, this.func_145818_k_() ? this.customName : this.func_70005_c_(), new Object[0]);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.inventOutput;
            }
            return (T)this.inventInput;
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("invent_input", (NBTBase)this.inventInput.serializeNBT());
        compound.func_74782_a("invent_working", (NBTBase)this.inventWorking.serializeNBT());
        compound.func_74782_a("invent_output", (NBTBase)this.inventOutput.serializeNBT());
        if (this.func_145818_k_()) {
            compound.func_74778_a("custom_name", this.customName);
        }
        compound.func_74768_a("countTicks", this.countTicks);
        compound.func_74757_a("isWorking", this.isWorking);
        compound.func_74768_a("progress", this.progress);
        compound.func_74768_a("cantRecycleTicks", this.cantRecycleTicks);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventInput.deserializeNBT(compound.func_74775_l("invent_input"));
        this.inventWorking.deserializeNBT(compound.func_74775_l("invent_working"));
        this.inventOutput.deserializeNBT(compound.func_74775_l("invent_output"));
        if (compound.func_150297_b("custom_name", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
        this.countTicks = compound.func_74762_e("countTicks");
        this.isWorking = compound.func_74767_n("isWorking");
        this.progress = compound.func_74762_e("progress");
        this.cantRecycleTicks = compound.func_74762_e("cantRecycleTicks");
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.serializeNBT());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }
}

