/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="rediscovered", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RediscoveredConfig {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final ClientConfig CLIENT;
    public static final ServerConfig SERVER;
    public static boolean stevesAnimated;
    public static boolean skyPanorama;
    public static boolean daytimeDreamPillow;
    public static boolean tameableRedDragon;
    public static boolean redDragonNoClip;
    public static boolean mobsAttackScarecrow;
    public static boolean steveHostile;
    public static boolean blackSteveHostile;
    public static boolean beastBoyHostile;
    public static boolean disableBedTeleportation;
    public static boolean disableGiantAppleDrops;
    public static boolean cowsAndPigsInSky;
    public static int chanceHostilesSpawnWithPlateArmor;
    public static boolean zombieHorsesInSiege;

    private static String translate(String key) {
        return new String("rediscovered.config." + key + ".name");
    }

    @SubscribeEvent
    public static void onLoadConfig(ModConfig.ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == CLIENT_SPEC) {
            ConfigBakery.bakeClient(config);
        } else if (config.getSpec() == SERVER_SPEC) {
            ConfigBakery.bakeServer(config);
        }
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT = (ClientConfig)pair.getLeft();
        CLIENT_SPEC = (ForgeConfigSpec)pair.getRight();
        pair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER = (ServerConfig)pair.getLeft();
        SERVER_SPEC = (ForgeConfigSpec)pair.getRight();
    }

    private static class ConfigBakery {
        private static ModConfig clientConfig;
        private static ModConfig serverConfig;

        private ConfigBakery() {
        }

        public static void bakeClient(ModConfig config) {
            clientConfig = config;
            stevesAnimated = (Boolean)RediscoveredConfig.CLIENT.stevesAnimated.get();
            skyPanorama = (Boolean)RediscoveredConfig.CLIENT.skyPanorama.get();
        }

        public static void bakeServer(ModConfig config) {
            serverConfig = config;
            daytimeDreamPillow = (Boolean)RediscoveredConfig.SERVER.daytimeDreamPillow.get();
            tameableRedDragon = (Boolean)RediscoveredConfig.SERVER.tameableRedDragon.get();
            redDragonNoClip = (Boolean)RediscoveredConfig.SERVER.redDragonNoClip.get();
            mobsAttackScarecrow = (Boolean)RediscoveredConfig.SERVER.mobsAttackScarecrow.get();
            steveHostile = (Boolean)RediscoveredConfig.SERVER.steveHostile.get();
            blackSteveHostile = (Boolean)RediscoveredConfig.SERVER.blackSteveHostile.get();
            beastBoyHostile = (Boolean)RediscoveredConfig.SERVER.beastBoyHostile.get();
            disableBedTeleportation = (Boolean)RediscoveredConfig.SERVER.disableBedTeleportation.get();
            disableGiantAppleDrops = (Boolean)RediscoveredConfig.SERVER.disableGiantAppleDrops.get();
            cowsAndPigsInSky = (Boolean)RediscoveredConfig.SERVER.cowsAndPigsInSky.get();
            chanceHostilesSpawnWithPlateArmor = (Integer)RediscoveredConfig.SERVER.chanceHostilesSpawnWithPlateArmor.get();
            zombieHorsesInSiege = (Boolean)RediscoveredConfig.SERVER.zombieHorsesInSieges.get();
        }
    }

    private static class ServerConfig {
        public final ForgeConfigSpec.ConfigValue<Boolean> daytimeDreamPillow;
        public final ForgeConfigSpec.ConfigValue<Boolean> tameableRedDragon;
        public final ForgeConfigSpec.ConfigValue<Boolean> redDragonNoClip;
        public final ForgeConfigSpec.ConfigValue<Boolean> mobsAttackScarecrow;
        public final ForgeConfigSpec.ConfigValue<Boolean> steveHostile;
        public final ForgeConfigSpec.ConfigValue<Boolean> blackSteveHostile;
        public final ForgeConfigSpec.ConfigValue<Boolean> beastBoyHostile;
        public final ForgeConfigSpec.ConfigValue<Boolean> disableBedTeleportation;
        public final ForgeConfigSpec.ConfigValue<Boolean> disableGiantAppleDrops;
        public final ForgeConfigSpec.ConfigValue<Boolean> cowsAndPigsInSky;
        public final ForgeConfigSpec.ConfigValue<Integer> chanceHostilesSpawnWithPlateArmor;
        public final ForgeConfigSpec.ConfigValue<Boolean> zombieHorsesInSieges;

        public ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Server and Client side changes.").push("common");
            this.daytimeDreamPillow = builder.translation(RediscoveredConfig.translate("daytimeDreamPillow")).comment("Allow the use of the Dream Pillow during the daytime.").define("daytimeDreamPillow", false);
            this.tameableRedDragon = builder.translation(RediscoveredConfig.translate("tameableRedDragon")).comment("Allow taming of Red Dragons.").define("tameableRedDragon", true);
            this.redDragonNoClip = builder.translation(RediscoveredConfig.translate("redDragonNoClip")).comment("Allow the Red Dragon to noclip, similarly to the Ender Dragon.").define("redDragonNoClip", false);
            this.mobsAttackScarecrow = builder.translation(RediscoveredConfig.translate("mobsAttackScarecrow")).comment("If enabled, hostiles will attack scarecrows, if disabled, they will run from them.").define("mobsAttackScarecrow", true);
            this.steveHostile = builder.translation(RediscoveredConfig.translate("steveHostile")).comment("Allows Steve to be hostile.").define("steveHostile", true);
            this.blackSteveHostile = builder.translation(RediscoveredConfig.translate("blackSteveHostile")).comment("Allows Black Steve to be hostile.").define("blackSteveHostile", true);
            this.beastBoyHostile = builder.translation(RediscoveredConfig.translate("beastBoyHostile")).comment("Allows Beast Boy to be hostile.").define("beastBoyHostile", true);
            this.disableBedTeleportation = builder.translation(RediscoveredConfig.translate("disableBedTeleportation")).comment("Disables randomly teleporting to the Sky Dimension when sleeping.").define("disableBedTeleportation", false);
            this.disableGiantAppleDrops = builder.translation(RediscoveredConfig.translate("disableGiantAppleDrops")).comment("Disables Giants dropping Golden Apples.").define("disableGiantAppleDrops", false);
            this.cowsAndPigsInSky = builder.translation(RediscoveredConfig.translate("cowsAndPigsInSky")).comment("Allows pigs and cows to spawn in the sky dimension, this is not how it used to be originally, but it's here for a bit more atmosphere.").define("cowsAndPigsInSky", false);
            this.chanceHostilesSpawnWithPlateArmor = builder.translation(RediscoveredConfig.translate("chanceHostilesSpawnWithPlateArmor")).comment("Chance Zombies, and Skeletons will spawn with plate armor (default 1/20, set to 0 for none.)").define("chanceHostilesSpawnWithPlateArmor", (Object)20);
            this.zombieHorsesInSieges = builder.translation(RediscoveredConfig.translate("zombieHorsesInSieges")).comment("Allows Zombies in village sieges to spawn mounting a tamed Zombie Horse.").define("zombieHorsesInSieges", true);
            builder.pop();
        }
    }

    private static class ClientConfig {
        public final ForgeConfigSpec.ConfigValue<Boolean> stevesAnimated;
        public final ForgeConfigSpec.ConfigValue<Boolean> skyPanorama;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Client side changes.").push("client");
            this.stevesAnimated = builder.translation(RediscoveredConfig.translate("stevesAnimated")).comment("Allows Steve mobs to be animated.").define("stevesAnimated", true);
            this.skyPanorama = builder.translation(RediscoveredConfig.translate("skyPanorama")).comment("Enables a custom panorama of the Sky Dimension on the main menu. (This can cause incompatibilities when enabled with other menu mods, enable at your own risk.)").define("skyPanorama", false);
            builder.pop();
        }
    }
}

