/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.block;

import com.legacy.rediscovered.registry.RediscoveredBlocks;
import com.legacy.rediscovered.tile_entity.GearTileEntity;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class RotationalConverterBlock
extends DirectionalBlock {
    public static final EnumProperty<Mode> MODE = EnumProperty.func_177709_a((String)"mode", Mode.class);
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    public RotationalConverterBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a(MODE, (Comparable)((Object)Mode.GEAR_TO_REDSTONE))).func_206870_a((Property)DirectionalBlock.field_176387_N, (Comparable)Direction.NORTH));
    }

    public boolean func_220074_n(BlockState state) {
        return false;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)field_176387_N, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)field_176387_N)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)field_176387_N)));
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (!worldIn.field_72995_K) {
            Direction facing = (Direction)state.func_177229_b((Property)field_176387_N);
            if (state.func_177229_b(MODE) == Mode.GEAR_TO_REDSTONE) {
                if (worldIn.func_175625_s(pos.func_177972_a(facing)) instanceof GearTileEntity) {
                    GearTileEntity gear = (GearTileEntity)worldIn.func_175625_s(pos.func_177972_a(facing));
                    worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(gear.isPowered(facing.func_176734_d()))), 3);
                } else {
                    worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
                }
                this.updateNeighborsOnFaces((World)worldIn, pos, state);
            } else {
                if (worldIn.func_175625_s(pos.func_177972_a(facing)) instanceof GearTileEntity) {
                    GearTileEntity gear = (GearTileEntity)worldIn.func_175625_s(pos.func_177972_a(facing));
                    int redstoneStrength = worldIn.func_175651_c(pos.func_177972_a(facing.func_176734_d()), facing.func_176734_d());
                    int gearPower = Math.abs(gear.getPower(facing.func_176734_d()));
                    if (redstoneStrength > 0 && gearPower > 0 && redstoneStrength != gearPower) {
                        gear.setPower(facing.func_176734_d(), redstoneStrength);
                        gear.updateConnectedGears(pos, facing.func_176734_d(), redstoneStrength, false);
                    }
                }
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(worldIn.func_175709_b(pos.func_177972_a(facing.func_176734_d()), facing.func_176734_d()))));
            }
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.func_201670_d()) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 2);
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return stateIn;
    }

    public boolean func_149744_f(BlockState state) {
        return state.func_177229_b(MODE) == Mode.GEAR_TO_REDSTONE;
    }

    public int func_176211_b(BlockState state, IBlockReader access, BlockPos pos, Direction side) {
        return state.func_185911_a(access, pos, side);
    }

    public int func_180656_a(BlockState state, IBlockReader access, BlockPos pos, Direction side) {
        if (state.func_177229_b(MODE) == Mode.GEAR_TO_REDSTONE && ((Boolean)state.func_177229_b((Property)POWERED)).booleanValue() && state.func_177229_b((Property)field_176387_N) == side) {
            if (access.func_175625_s(pos.func_177972_a(side)) instanceof GearTileEntity) {
                return Math.abs(((GearTileEntity)access.func_175625_s(pos.func_177972_a(side))).getPower(side.func_176734_d()));
            }
            return 0;
        }
        return 0;
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return side == ((Direction)state.func_177229_b((Property)field_176387_N)).func_176734_d() && state.func_177229_b(MODE) == Mode.REDSTONE_TO_GEAR;
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (state.func_177230_c() != oldState.func_177230_c() && !worldIn.func_201670_d() && ((Boolean)state.func_177229_b((Property)POWERED)).booleanValue() && !worldIn.func_205220_G_().func_205359_a(pos, (Object)this)) {
            BlockState blockstate = (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false));
            worldIn.func_180501_a(pos, blockstate, 18);
            this.updateNeighborsOnFaces(worldIn, pos, blockstate);
        }
        state.func_235734_a_((IWorld)worldIn, pos, 3);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c() && !worldIn.field_72995_K && ((Boolean)state.func_177229_b((Property)POWERED)).booleanValue() && worldIn.func_205220_G_().func_205359_a(pos, (Object)this)) {
            this.updateNeighborsOnFaces(worldIn, pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        }
        state.func_235734_a_((IWorld)worldIn, pos, 3);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (player.func_184586_b(handIn).func_77973_b() == RediscoveredBlocks.gear.func_199767_j() && state.func_177229_b((Property)field_176387_N) == hit.func_216354_b()) {
            return ActionResultType.FAIL;
        }
        if (!worldIn.func_201670_d()) {
            worldIn.func_175656_a(pos, (BlockState)state.func_235896_a_(MODE));
            float f = (Boolean)state.func_177229_b((Property)POWERED) != false ? 0.6f : 0.5f;
            worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, f);
            this.updateNeighbors(state, worldIn, pos);
        }
        return ActionResultType.SUCCESS;
    }

    protected void updateNeighborsOnFaces(World worldIn, BlockPos pos, BlockState state) {
        for (Direction direction : new Direction[]{(Direction)state.func_177229_b((Property)field_176387_N), ((Direction)state.func_177229_b((Property)field_176387_N)).func_176734_d()}) {
            BlockPos blockpos = pos.func_177972_a(direction.func_176734_d());
            worldIn.func_190524_a(blockpos, (Block)this, pos);
            worldIn.func_175695_a(blockpos, (Block)this, direction);
        }
    }

    private void updateNeighbors(BlockState state, World worldIn, BlockPos pos) {
        worldIn.func_195593_d(pos, (Block)this);
        worldIn.func_195593_d(pos.func_177972_a((Direction)state.func_177229_b((Property)DirectionalBlock.field_176387_N)), (Block)this);
        worldIn.func_195593_d(pos.func_177972_a(((Direction)state.func_177229_b((Property)DirectionalBlock.field_176387_N)).func_176734_d()), (Block)this);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)field_176387_N, (Comparable)context.func_196010_d().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{MODE, POWERED, DirectionalBlock.field_176387_N});
    }

    public static enum Mode implements IStringSerializable
    {
        GEAR_TO_REDSTONE,
        REDSTONE_TO_GEAR;


        public String func_176610_l() {
            return this.toString().toLowerCase();
        }
    }
}

