/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.capability;

import com.legacy.rediscovered.capability.IRediscoveredPigman;
import com.legacy.rediscovered.entity.pigman.PigmanEntity;
import com.legacy.rediscovered.registry.RediscoveredEntityTypes;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;

public class RediscoveredPigmanCapability
implements IRediscoveredPigman {
    @CapabilityInject(value=IRediscoveredPigman.class)
    public static Capability<IRediscoveredPigman> REDISCOVERED_PIGMAN = null;
    private boolean converting;
    private ZombifiedPiglinEntity zombiePigman;
    private int conversionTime;
    private UUID converstionStarter;

    public RediscoveredPigmanCapability() {
    }

    public RediscoveredPigmanCapability(ZombifiedPiglinEntity zombiePigman) {
        this.zombiePigman = zombiePigman;
    }

    public static IRediscoveredPigman get(ZombifiedPiglinEntity pigman) {
        return (IRediscoveredPigman)pigman.getCapability(REDISCOVERED_PIGMAN).orElse(null);
    }

    @Override
    public void writeAdditional(CompoundNBT compound) {
        compound.func_74757_a("Converting", this.isConverting());
        compound.func_74768_a("ConversionTime", this.isConverting() ? this.conversionTime : -1);
        if (this.converstionStarter != null) {
            compound.func_186854_a("ConversionPlayer", this.converstionStarter);
        }
    }

    @Override
    public void read(CompoundNBT compound) {
        compound.func_74767_n("Converting");
        if (compound.func_150297_b("ConversionTime", 99) && compound.func_74762_e("ConversionTime") > -1) {
            this.startConverting(compound.func_186855_b("ConversionPlayer") ? compound.func_186857_a("ConversionPlayer") : null, compound.func_74762_e("ConversionTime"));
        }
    }

    @Override
    public void tick() {
        if (!this.zombiePigman.field_70170_p.field_72995_K && this.zombiePigman.func_70089_S() && this.isConverting() && this.zombiePigman.field_70170_p instanceof ServerWorld) {
            int i = this.getConversionProgress();
            this.conversionTime -= i;
            if (this.conversionTime <= 0) {
                PigmanEntity pigman = (PigmanEntity)RediscoveredEntityTypes.PIGMAN.func_200721_a(this.zombiePigman.field_70170_p);
                this.finishZombiePigmanConversion(this.zombiePigman, pigman, (ServerWorld)this.zombiePigman.field_70170_p);
            }
        }
    }

    @Override
    public boolean isConverting() {
        return this.converting;
    }

    @Override
    public int getConversionTime() {
        return this.conversionTime;
    }

    @Override
    public boolean setConverting(boolean converting) {
        this.converting = converting;
        return this.converting;
    }

    @Override
    public int getConversionProgress() {
        int i = 1;
        if (this.zombiePigman.field_70170_p.field_73012_v.nextFloat() < 0.01f) {
            int j = 0;
            BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable();
            for (int k = (int)this.zombiePigman.func_226277_ct_() - 4; k < (int)this.zombiePigman.func_226277_ct_() + 4 && j < 14; ++k) {
                for (int l = (int)this.zombiePigman.func_226278_cu_() - 4; l < (int)this.zombiePigman.func_226278_cu_() + 4 && j < 14; ++l) {
                    for (int i1 = (int)this.zombiePigman.func_226281_cx_() - 4; i1 < (int)this.zombiePigman.func_226281_cx_() + 4 && j < 14; ++i1) {
                        Block block = this.zombiePigman.field_70170_p.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(k, l, i1)).func_177230_c();
                        if (block != Blocks.field_150411_aY && !(block instanceof BedBlock)) continue;
                        if (this.zombiePigman.field_70170_p.field_73012_v.nextFloat() < 0.3f) {
                            ++i;
                        }
                        ++j;
                    }
                }
            }
        }
        return i;
    }

    @Override
    public void startConverting(@Nullable UUID conversionStarterIn, int conversionTimeIn) {
        this.converstionStarter = conversionStarterIn;
        this.conversionTime = conversionTimeIn;
        this.setConverting(true);
        this.zombiePigman.func_195063_d(Effects.field_76437_t);
        this.zombiePigman.func_195064_c(new EffectInstance(Effects.field_76420_g, conversionTimeIn, Math.min(this.zombiePigman.field_70170_p.func_175659_aa().func_151525_a() - 1, 0)));
    }

    private void finishZombiePigmanConversion(ZombifiedPiglinEntity zombiePigman, PigmanEntity pigman, ServerWorld world) {
        pigman.func_82149_j((Entity)zombiePigman);
        pigman.func_213386_a((IServerWorld)world, world.func_175649_E(pigman.func_233580_cy_()), SpawnReason.CONVERSION, null, null);
        if (zombiePigman.func_70631_g_()) {
            pigman.func_70873_a(-24000);
        }
        zombiePigman.func_70106_y();
        pigman.func_94061_f(zombiePigman.func_175446_cd());
        if (zombiePigman.func_145818_k_()) {
            pigman.func_200203_b(zombiePigman.func_200201_e());
            pigman.func_174805_g(zombiePigman.func_174833_aM());
        }
        pigman.func_195064_c(new EffectInstance(Effects.field_76431_k, 200, 0));
        if (!zombiePigman.func_174814_R()) {
            zombiePigman.field_70170_p.func_184134_a(zombiePigman.func_226277_ct_() + 0.5, zombiePigman.func_226278_cu_() + 0.5, zombiePigman.func_226281_cx_() + 0.5, SoundEvents.field_187942_hp, zombiePigman.func_184176_by(), 1.0f + zombiePigman.field_70170_p.field_73012_v.nextFloat(), zombiePigman.field_70170_p.field_73012_v.nextFloat() * 0.7f + 0.3f, false);
        }
        world.func_217376_c((Entity)pigman);
        world.func_217378_a((PlayerEntity)null, 1027, zombiePigman.func_233580_cy_(), 0);
    }
}

