/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.render.entity;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.client.render.model.ScarecrowModel;
import com.legacy.rediscovered.entity.ScarecrowEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ScarecrowRenderer
extends LivingRenderer<ScarecrowEntity, ScarecrowModel<ScarecrowEntity>> {
    public static final ResourceLocation TEXTURE = RediscoveredMod.locate("textures/entity/scarecrow.png");

    public ScarecrowRenderer(EntityRendererManager manager) {
        super(manager, new ScarecrowModel(), 0.0f);
    }

    public ResourceLocation getEntityTexture(ScarecrowEntity entity) {
        return TEXTURE;
    }

    protected void applyRotations(ScarecrowEntity entityLiving, MatrixStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - rotationYaw));
        float f = (float)(entityLiving.field_70170_p.func_82737_E() - entityLiving.punchCooldown) + partialTicks;
        if (f < 5.0f) {
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(MathHelper.func_76126_a((float)(f / 1.5f * (float)Math.PI)) * 3.0f));
        }
    }

    protected boolean canRenderName(ScarecrowEntity entity) {
        double d0 = this.field_76990_c.func_229099_b_((Entity)entity);
        float f = entity.func_213453_ef() ? 32.0f : 64.0f;
        return d0 >= (double)(f * f) ? false : entity.func_174833_aM();
    }

    @Nullable
    protected RenderType func_230496_a_(ScarecrowEntity entityIn, boolean p_230496_2_, boolean p_230496_3_, boolean p_230496_4_) {
        if (!entityIn.hasMarker()) {
            return super.func_230496_a_((LivingEntity)entityIn, p_230496_2_, p_230496_3_, p_230496_4_);
        }
        ResourceLocation resourcelocation = this.getEntityTexture(entityIn);
        if (p_230496_3_) {
            return RenderType.func_230168_b_((ResourceLocation)resourcelocation, (boolean)false);
        }
        return p_230496_2_ ? RenderType.func_230167_a_((ResourceLocation)resourcelocation, (boolean)false) : null;
    }
}

