/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.render.md3;

import com.legacy.rediscovered.client.render.md3.MD3Model;
import com.legacy.rediscovered.client.render.md3.MD3Surface;
import com.legacy.rediscovered.client.render.md3.MD3Tag;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL11;

public final class MD3Renderer {
    private MD3Model model;
    private int displayList;
    private boolean useAnimation;

    public MD3Renderer(MD3Model var1, boolean anim) {
        this.model = var1;
        this.displayList = 0;
        this.useAnimation = anim;
    }

    public final int getAnimFrames() {
        return this.model.animFrames;
    }

    public final void render(int frame1, int frame2, float var3) {
        if (this.displayList == 0 || this.useAnimation) {
            if (!this.useAnimation) {
                this.displayList = GL11.glGenLists((int)1);
            }
            GL11.glEnableClientState((int)32884);
            GL11.glEnableClientState((int)32888);
            GL11.glEnableClientState((int)32885);
            if (!this.useAnimation) {
                GL11.glNewList((int)this.displayList, (int)4864);
            }
            for (int i = 0; i < this.model.surfaces.length; ++i) {
                MD3Surface surface = this.model.surfaces[i];
                if (this.useAnimation) {
                    surface.setFrame(frame1, frame2, var3);
                } else {
                    surface.setFrame(0, 0, 0.0f);
                }
                surface.triangles.position(0);
                surface.d.position(0);
                GL11.glVertexPointer((int)3, (int)5126, (int)0, (FloatBuffer)surface.vertices);
                GL11.glNormalPointer((int)5126, (int)0, (FloatBuffer)surface.normals);
                GL11.glTexCoordPointer((int)2, (int)5126, (int)0, (FloatBuffer)surface.d);
                GL11.glDrawElements((int)4, (IntBuffer)surface.triangles);
            }
            if (!this.useAnimation) {
                GL11.glEndList();
            }
            GL11.glDisableClientState((int)32884);
            GL11.glDisableClientState((int)32888);
            GL11.glDisableClientState((int)32885);
        }
        if (!this.useAnimation) {
            GL11.glCallList((int)this.displayList);
        }
    }

    public void renderTag(String tagName, MD3Renderer renderer, int var1, int var2, float var3, int var4, int var5, float var6) {
        MD3Tag tag = (MD3Tag)this.model.tags.get(tagName);
        if (tag == null) {
            System.out.println(tagName + ": no such tag!");
            return;
        }
        double x = tag.coords[var1].func_82615_a() + (tag.coords[var2].func_82615_a() - tag.coords[var1].func_82615_a()) * (double)var3;
        double y = tag.coords[var1].func_82617_b() + (tag.coords[var2].func_82617_b() - tag.coords[var1].func_82617_b()) * (double)var3;
        double z = tag.coords[var1].func_82616_c() + (tag.coords[var2].func_82616_c() - tag.coords[var1].func_82616_c()) * (double)var3;
        GL11.glTranslated((double)x, (double)y, (double)z);
        renderer.render(var4, var5, var6);
    }
}

