/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.registry;

import com.google.common.collect.ImmutableMap;
import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.registry.RediscoveredBiomes;
import com.legacy.rediscovered.registry.RediscoveredStructures;
import com.legacy.rediscovered.world.biome.feature.structure.SmallPigmanVillageStructure;
import com.legacy.rediscovered.world.dimension.BetaSkyChunkGenerator;
import com.mojang.serialization.Lifecycle;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.Dimension;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.FuzzedBiomeMagnifier;
import net.minecraft.world.biome.IBiomeMagnifier;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.SingleBiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.NoiseSettings;
import net.minecraft.world.gen.settings.ScalingSettings;
import net.minecraft.world.gen.settings.SlideSettings;

public class RediscoveredDimensions {
    public static final RegistryKey<World> SKYLANDS = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)RediscoveredMod.locate("skylands"));
    public static final RegistryKey<DimensionSettings> SKYLANDS_NOISE_SETTINGS = RegistryKey.func_240903_a_((RegistryKey)Registry.field_243549_ar, (ResourceLocation)RediscoveredMod.locate("skylands"));
    public static final RegistryKey<DimensionType> SKYLANDS_TYPE = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239698_ad_, (ResourceLocation)RediscoveredMod.locate("skylands"));
    public static final RegistryKey<Dimension> SKYLANDS_DIM = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239700_af_, (ResourceLocation)RediscoveredMod.locate("skylands"));
    private static final DimensionStructuresSettings SKY_STRUCTURE_SETTINGS = new DimensionStructuresSettings(Optional.empty(), (Map)ImmutableMap.of(RediscoveredStructures.SMALL_PIGMAN_VILLAGE, (Object)SmallPigmanVillageStructure.getSeparationSettings()));

    public static void init(SimpleRegistry<Dimension> simpleRegistry, MutableRegistry<DimensionType> mutableRegistry, MutableRegistry<Biome> biomeRegistry, MutableRegistry<DimensionSettings> dimSettingsRegistry, long seed) {
        Function<RegistryKey, DimensionSettings> skylandsSettings = noiseSettings -> (DimensionSettings)WorldGenRegistries.field_243658_j.func_243576_d(SKYLANDS_NOISE_SETTINGS);
        Function<DimensionSettings, ChunkGenerator> skylandsGenerator = s -> RediscoveredDimensions.createSkyChunkGenerator((Registry<Biome>)biomeRegistry, (Registry<DimensionSettings>)dimSettingsRegistry, seed);
        Supplier<DimensionType> skylandsDimensionType = () -> RediscoveredDimensions.createDimSettings(OptionalLong.of(6000L), false, false);
        Dimension skylandsDim = new Dimension(skylandsDimensionType, skylandsGenerator.apply(skylandsSettings.apply(SKYLANDS_NOISE_SETTINGS)));
        simpleRegistry.func_218381_a(SKYLANDS_DIM, (Object)skylandsDim, Lifecycle.stable());
    }

    public static RegistryKey<World> skylandsKey() {
        return SKYLANDS;
    }

    public static void initNoiseSettings() {
        RediscoveredDimensions.registerNoiseSettings(SKYLANDS_NOISE_SETTINGS, RediscoveredDimensions.createNoiseSettings(SKY_STRUCTURE_SETTINGS, false, Blocks.field_150348_b.func_176223_P(), Blocks.field_150350_a.func_176223_P(), SKYLANDS_NOISE_SETTINGS.func_240901_a_()));
    }

    public static DimensionSettings createNoiseSettings(DimensionStructuresSettings structureSettingsIn, boolean flag1, BlockState fillerBlockIn, BlockState fluidBlockIn, ResourceLocation settingsLocationIn) {
        try {
            Constructor constructor = DimensionSettings.class.getDeclaredConstructor(DimensionStructuresSettings.class, NoiseSettings.class, BlockState.class, BlockState.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
            constructor.setAccessible(true);
            return (DimensionSettings)constructor.newInstance(structureSettingsIn, new NoiseSettings(256, new ScalingSettings(0.9999999814507745, 0.9999999814507745, 80.0, 160.0), new SlideSettings(-10, 3, 0), new SlideSettings(-30, 0, 0), 1, 2, 1.0, -0.46875, true, true, false, flag1), fillerBlockIn, fluidBlockIn, -10, 0, 63, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static DimensionSettings registerNoiseSettings(RegistryKey<DimensionSettings> settingsKeyIn, DimensionSettings dimSettingsIn) {
        WorldGenRegistries.func_243664_a((Registry)WorldGenRegistries.field_243658_j, (ResourceLocation)settingsKeyIn.func_240901_a_(), (Object)dimSettingsIn);
        return dimSettingsIn;
    }

    private static ChunkGenerator createSkyChunkGenerator(Registry<Biome> biomeRegistry, Registry<DimensionSettings> dimSettingsRegistry, long seed) {
        return new BetaSkyChunkGenerator((BiomeProvider)new SingleBiomeProvider((Biome)biomeRegistry.func_243576_d(RediscoveredBiomes.SKYLANDS_KEY)), seed, () -> (DimensionSettings)dimSettingsRegistry.func_243576_d(SKYLANDS_NOISE_SETTINGS));
    }

    private static DimensionType createDimSettings(OptionalLong time, boolean ultrawarm, boolean piglinSafe) {
        return new DimensionType(time, true, false, ultrawarm, true, 1.0, false, piglinSafe, true, false, false, 256, (IBiomeMagnifier)FuzzedBiomeMagnifier.INSTANCE, BlockTags.field_241277_aC_.func_230234_a_(), DimensionType.field_242710_a, 0.0f){};
    }
}

