/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.tile_entity;

import com.legacy.rediscovered.block.GearBlock;
import com.legacy.rediscovered.block.RotationalConverterBlock;
import com.legacy.rediscovered.registry.RediscoveredBlocks;
import com.legacy.rediscovered.registry.RediscoveredTileEntities;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;

public class GearTileEntity
extends TileEntity
implements ITickableTileEntity {
    private int[] powers = new int[]{0, 0, 0, 0, 0, 0};
    private int[] angles = new int[]{0, 0, 0, 0, 0, 0};
    private Source[] sources = Source.arrayOf(6, new Source(BlockPos.field_177992_a, -1));

    public GearTileEntity() {
        super(RediscoveredTileEntities.gear);
    }

    public GearTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public void func_73660_a() {
        for (int i = 0; i < 6; ++i) {
            if (this.powers[i] == 0) continue;
            this.addAngle(i, this.powers[i] / 2 + (this.powers[i] > 0 ? 1 : -1));
        }
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == RediscoveredBlocks.gear && !this.field_145850_b.field_72995_K) {
            BlockState gear = this.field_145850_b.func_180495_p(this.field_174879_c);
            for (GearBlock.EnumFaces enumFace : GearBlock.EnumFaces.values()) {
                if (!((GearBlock.GearStates)((Object)gear.func_177229_b(enumFace.face))).exists()) continue;
                Direction direction = enumFace.direction;
                BlockState offsetState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(direction));
                int redstoneStrength = this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(direction).func_177972_a(direction), direction);
                if (this.isConverterPowered(offsetState, direction) && !this.isPowered(direction)) {
                    this.setPower(direction, redstoneStrength);
                    this.updateConnectedGears(this.field_174879_c, direction, redstoneStrength, false);
                }
                if (this.isConverterPowered(offsetState, direction) || this.isSourcePowered(direction) || !this.isPowered(direction)) continue;
                this.setPower(direction, 0);
                this.updateConnectedGears(this.field_174879_c, direction, 0, true);
            }
        }
    }

    public boolean isConverterPowered(BlockState state, Direction direction) {
        return state.func_177230_c() == RediscoveredBlocks.rotational_converter && state.func_177229_b((Property)RotationalConverterBlock.field_176387_N) == direction.func_176734_d() && state.func_177229_b(RotationalConverterBlock.MODE) == RotationalConverterBlock.Mode.REDSTONE_TO_GEAR && (Boolean)state.func_177229_b((Property)RotationalConverterBlock.POWERED) == true;
    }

    public boolean isSourcePowered(Direction direction) {
        Direction sourceDirection;
        TileEntity sourceTile = this.field_145850_b.func_175625_s(this.getSource(direction).pos);
        if (sourceTile != null && sourceTile instanceof GearTileEntity && (sourceDirection = this.getSource(direction).getDirection()) != null) {
            return ((GearTileEntity)sourceTile).isPowered(sourceDirection);
        }
        return false;
    }

    public void updateConnectedGears(BlockPos fromPos, Direction fromDirection, int power, boolean clearSource) {
        power = -power;
        for (Direction direction : Direction.values()) {
            Source source;
            if (direction.func_176740_k() == fromDirection.func_176740_k()) continue;
            Source source2 = source = clearSource ? new Source() : new Source(fromPos, fromDirection);
            if (((GearBlock.GearStates)((Object)this.func_195044_w().func_177229_b(GearBlock.EnumFaces.get((Direction)direction).face))).exists() && Math.abs(this.getPower(direction)) != Math.abs(power)) {
                this.setPowerAndSource(direction, power, source);
                this.updateConnectedGears(this.field_174879_c, direction, power, clearSource);
            }
            BlockPos offset = this.field_174879_c.func_177972_a(fromDirection).func_177972_a(direction);
            TileEntity tile = this.field_145850_b.func_175625_s(offset);
            BlockState state = this.field_145850_b.func_180495_p(offset);
            if (tile instanceof GearTileEntity && state.func_177230_c() == RediscoveredBlocks.gear && ((GearBlock.GearStates)((Object)state.func_177229_b(GearBlock.EnumFaces.get((Direction)direction.func_176734_d()).face))).exists() && Math.abs(((GearTileEntity)tile).getPower(direction.func_176734_d())) != Math.abs(power)) {
                ((GearTileEntity)tile).setPowerAndSource(direction.func_176734_d(), power, source);
                ((GearTileEntity)tile).updateConnectedGears(offset, direction.func_176734_d(), power, clearSource);
            }
            offset = this.field_174879_c.func_177972_a(direction);
            tile = this.field_145850_b.func_175625_s(offset);
            state = this.field_145850_b.func_180495_p(offset);
            if (!(tile instanceof GearTileEntity) || state.func_177230_c() != RediscoveredBlocks.gear || !((GearBlock.GearStates)((Object)state.func_177229_b(GearBlock.EnumFaces.get((Direction)fromDirection).face))).exists() || Math.abs(((GearTileEntity)tile).getPower(fromDirection)) == Math.abs(power)) continue;
            ((GearTileEntity)tile).setPowerAndSource(fromDirection, power, source);
            ((GearTileEntity)tile).updateConnectedGears(offset, fromDirection, power, clearSource);
        }
    }

    public void updateConverter(Direction direction) {
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(direction));
        if (!this.field_145850_b.field_72995_K && state.func_177230_c() == RediscoveredBlocks.rotational_converter) {
            this.field_145850_b.func_205220_G_().func_205360_a(this.field_174879_c.func_177972_a(direction), (Object)state.func_177230_c(), 2);
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.powers = compound.func_74759_k("Powers");
        this.angles = compound.func_74759_k("Angles");
        CompoundNBT sourcesNBT = compound.func_74775_l("Sources");
        for (int i = 0; i < Direction.values().length; ++i) {
            this.sources[i] = new Source(sourcesNBT.func_74759_k(Direction.values()[i].toString()));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74783_a("Powers", this.powers);
        compound.func_74783_a("Angles", this.angles);
        CompoundNBT sourcesNBT = new CompoundNBT();
        for (int i = 0; i < Direction.values().length; ++i) {
            sourcesNBT.func_74783_a(Direction.values()[i].toString(), new int[]{this.sources[i].pos.func_177958_n(), this.sources[i].pos.func_177956_o(), this.sources[i].pos.func_177952_p(), this.sources[i].directionIndex});
        }
        compound.func_218657_a("Sources", (INBT)sourcesNBT);
        return compound;
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.getTileEntity().func_230337_a_(state, tag);
    }

    public final SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, -999, this.serializeNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_230337_a_(this.field_145850_b.func_180495_p(this.func_174877_v()), packet.func_148857_g());
    }

    public int[] getPowers() {
        return this.powers;
    }

    public int getPower(Direction direction) {
        return this.powers[direction.func_176745_a()];
    }

    public boolean isPowered(Direction direction) {
        return this.getPower(direction) != 0;
    }

    public void setPower(Direction direction, int power) {
        if (power < -15) {
            power = -15;
        }
        if (power > 15) {
            power = 15;
        }
        if (Math.abs(this.getPower(direction)) != Math.abs(power)) {
            this.updateConverter(direction);
        }
        this.powers[direction.func_176745_a()] = power;
    }

    public int[] getAngles() {
        return this.angles;
    }

    public int getAngle(Direction direction) {
        return this.angles[direction.func_176745_a()];
    }

    public void setAngle(Direction direction, int angle) {
        if (angle < 0) {
            angle = 0;
        }
        if (angle > 359) {
            angle = 359;
        }
        this.angles[direction.func_176745_a()] = angle;
    }

    public void addAngle(int direction, int amount) {
        int n = direction;
        this.angles[n] = this.angles[n] + amount % 360;
        if (this.angles[direction] > 359) {
            int n2 = direction;
            this.angles[n2] = this.angles[n2] - 360;
        }
        if (this.angles[direction] < 0) {
            int n3 = direction;
            this.angles[n3] = this.angles[n3] + 360;
        }
    }

    public void addAngle(Direction direction, int amount) {
        this.addAngle(direction.func_176745_a(), amount);
    }

    public Source[] getSources() {
        return this.sources;
    }

    public Source getSource(Direction direction) {
        return this.sources[direction.func_176745_a()];
    }

    public void setSource(Direction direction, Source source) {
        this.sources[direction.func_176745_a()] = source;
    }

    public void setPowerAndSource(Direction direction, int power, Source source) {
        this.setPower(direction, power);
        this.setSource(direction, source);
    }

    public static class Source {
        private final BlockPos pos;
        private final int directionIndex;

        public Source(BlockPos pos, int directionIndex) {
            this.pos = new BlockPos((Vector3i)pos);
            this.directionIndex = directionIndex;
        }

        public Source(BlockPos pos, Direction direction) {
            this(pos, direction.func_176745_a());
        }

        public Source(int[] array) {
            this(new BlockPos(array[0], array[1], array[2]), array[3]);
        }

        public Source() {
            this(BlockPos.field_177992_a, -1);
        }

        public BlockPos getPos() {
            return this.pos;
        }

        @Nullable
        public Direction getDirection() {
            if (this.directionIndex >= 0 && this.directionIndex <= 5) {
                return Direction.func_82600_a((int)this.directionIndex);
            }
            return null;
        }

        public static Source[] arrayOf(int size, Source source) {
            ArrayList<Source> list = new ArrayList<Source>();
            for (int i = 0; i < size; ++i) {
                list.add(source);
            }
            return list.toArray(new Source[0]);
        }
    }
}

