/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.entity;

import com.legacy.rediscovered.RediscoveredConfig;
import com.legacy.rediscovered.entity.util.RedDragonEntityPart;
import com.legacy.rediscovered.registry.RediscoveredBlocks;
import com.legacy.rediscovered.registry.RediscoveredEntityTypes;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class RedDragonEntity
extends TameableEntity
implements IMob {
    public double targetX;
    public double targetY;
    public double targetZ;
    public double[][] ringBuffer = new double[64][3];
    public int ringBufferIndex = -1;
    public int interactTime;
    public final RedDragonEntityPart[] dragonParts;
    public final RedDragonEntityPart dragonPartHead = new RedDragonEntityPart(this, "head", 1.0f, 1.0f);
    public final RedDragonEntityPart dragonPartNeck = new RedDragonEntityPart(this, "neck", 3.0f, 3.0f);
    public final RedDragonEntityPart dragonPartBody = new RedDragonEntityPart(this, "body", 5.0f, 3.0f);
    public final RedDragonEntityPart dragonPartTail1 = new RedDragonEntityPart(this, "tail", 2.0f, 2.0f);
    public final RedDragonEntityPart dragonPartTail2 = new RedDragonEntityPart(this, "tail", 2.0f, 2.0f);
    public final RedDragonEntityPart dragonPartTail3 = new RedDragonEntityPart(this, "tail", 2.0f, 2.0f);
    public final RedDragonEntityPart dragonPartRightWing = new RedDragonEntityPart(this, "wing", 4.0f, 2.0f);
    public final RedDragonEntityPart dragonPartLeftWing = new RedDragonEntityPart(this, "wing", 4.0f, 2.0f);
    public float prevAnimTime = 0.0f;
    public float animTime = 0.0f;
    public boolean forceNewTarget = false;
    public boolean angry = false;
    public boolean renderTailSpike = false;
    public int health = 100;
    public boolean slowed = false;
    private Entity target;
    public int deathTicks = 0;
    public float randomYawVelocity = 0.0f;

    public RedDragonEntity(EntityType<? extends RedDragonEntity> type, World worldIn) {
        super(RediscoveredEntityTypes.RED_DRAGON, worldIn);
        this.dragonParts = new RedDragonEntityPart[]{this.dragonPartHead, this.dragonPartNeck, this.dragonPartBody, this.dragonPartTail1, this.dragonPartTail2, this.dragonPartTail3, this.dragonPartRightWing, this.dragonPartLeftWing};
        this.func_70606_j(this.func_110138_aP());
        this.field_70145_X = RediscoveredConfig.redDragonNoClip;
        this.targetY = 100.0;
        this.field_70158_ak = true;
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 100.0);
    }

    protected void func_184651_r() {
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public double[] getMovementOffsets(int par1, float par2) {
        if (this.func_110138_aP() <= 0.0f) {
            par2 = 0.0f;
        }
        par2 = 1.0f - par2;
        int var3 = this.ringBufferIndex - par1 * 1 & 0x3F;
        int var4 = this.ringBufferIndex - par1 * 1 - 1 & 0x3F;
        double[] var5 = new double[3];
        double var6 = this.ringBuffer[var3][0];
        double var8 = MathHelper.func_76138_g((double)(this.ringBuffer[var4][0] - var6));
        var5[0] = var6 + var8 * (double)par2;
        var6 = this.ringBuffer[var3][1];
        var8 = this.ringBuffer[var4][1] - var6;
        var5[1] = var6 + var8 * (double)par2;
        var5[2] = this.ringBuffer[var3][2] + (this.ringBuffer[var4][2] - this.ringBuffer[var3][2]) * (double)par2;
        return var5;
    }

    public void func_70636_d() {
        float f1;
        float f;
        if (this.interactTime > 0) {
            --this.interactTime;
        }
        if (this.field_70170_p.field_72995_K) {
            f = MathHelper.func_76134_b((float)(this.animTime * (float)Math.PI * 2.0f));
            f1 = MathHelper.func_76134_b((float)(this.prevAnimTime * (float)Math.PI * 2.0f));
            if (f1 <= -0.3f && f >= -0.3f) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187524_aN, this.func_184176_by(), 5.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.3f, false);
            }
        }
        this.prevAnimTime = this.animTime;
        if (this.func_110143_aJ() <= 0.0f) {
            f = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.func_226277_ct_() + (double)f, this.func_226278_cu_() + 2.0 + (double)f1, this.func_226281_cx_() + (double)f2, 0.0, 0.0, 0.0);
        } else {
            Vector3d vec3d4 = this.func_213322_ci();
            float f12 = 0.2f / (MathHelper.func_76133_a((double)RedDragonEntity.func_213296_b((Vector3d)vec3d4)) * 10.0f + 1.0f);
            this.animTime = this.slowed ? (this.animTime += f12 * 0.5f) : (this.animTime += (f12 *= (float)Math.pow(2.0, vec3d4.field_72448_b)));
            this.field_70177_z = MathHelper.func_76142_g((float)this.field_70177_z);
            if (this.func_175446_cd()) {
                this.animTime = 0.5f;
            } else {
                if (this.ringBufferIndex < 0) {
                    for (int i = 0; i < this.ringBuffer.length; ++i) {
                        this.ringBuffer[i][0] = this.field_70177_z;
                        this.ringBuffer[i][1] = this.func_226278_cu_();
                    }
                }
                if (++this.ringBufferIndex == this.ringBuffer.length) {
                    this.ringBufferIndex = 0;
                }
                this.ringBuffer[this.ringBufferIndex][0] = this.field_70177_z;
                this.ringBuffer[this.ringBufferIndex][1] = this.func_226278_cu_();
                if (this.field_70170_p.field_72995_K) {
                    if (this.field_70716_bi > 0) {
                        double d7 = this.func_226277_ct_() + (this.field_184623_bh - this.func_226277_ct_()) / (double)this.field_70716_bi;
                        double d0 = this.func_226278_cu_() + (this.field_184624_bi - this.func_226278_cu_()) / (double)this.field_70716_bi;
                        double d1 = this.func_226281_cx_() + (this.field_184625_bj - this.func_226281_cx_()) / (double)this.field_70716_bi;
                        double d2 = MathHelper.func_76138_g((double)(this.field_184626_bk - (double)this.field_70177_z));
                        this.field_70177_z = (float)((double)this.field_70177_z + d2 / (double)this.field_70716_bi);
                        this.field_70125_A = (float)((double)this.field_70125_A + (this.field_70709_bj - (double)this.field_70125_A) / (double)this.field_70716_bi);
                        --this.field_70716_bi;
                        this.func_70107_b(d7, d0, d1);
                        this.func_70101_b(this.field_70177_z, this.field_70125_A);
                    }
                } else {
                    Vector3d vec3d = new Vector3d(this.targetX, this.targetY, this.targetZ);
                    double d8 = vec3d.field_72450_a - this.func_226277_ct_();
                    double d9 = vec3d.field_72448_b - this.func_226278_cu_();
                    double d10 = vec3d.field_72449_c - this.func_226281_cx_();
                    double d3 = d8 * d8 + d9 * d9 + d10 * d10;
                    float f5 = 10.0f;
                    double d4 = MathHelper.func_76133_a((double)(d8 * d8 + d10 * d10));
                    if (d4 > 0.0) {
                        d9 = MathHelper.func_151237_a((double)(d9 / d4), (double)(-f5), (double)f5);
                    }
                    this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, d9 * 0.01, 0.0));
                    this.field_70177_z = MathHelper.func_76142_g((float)this.field_70177_z);
                    double d5 = MathHelper.func_151237_a((double)MathHelper.func_76138_g((double)(180.0 - MathHelper.func_181159_b((double)d8, (double)d10) * 57.2957763671875 - (double)this.field_70177_z)), (double)-50.0, (double)50.0);
                    Vector3d vec3d1 = vec3d.func_178786_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()).func_72432_b();
                    Vector3d vec3d2 = new Vector3d((double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), this.func_213322_ci().field_72448_b, (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))))).func_72432_b();
                    float f8 = Math.max(((float)vec3d2.func_72430_b(vec3d1) + 0.5f) / 1.5f, 0.0f);
                    if (this.func_70909_n() && !this.func_184188_bt().isEmpty()) {
                        this.randomYawVelocity = 0.0f;
                        this.randomYawVelocity = 0.0f;
                    } else {
                        this.randomYawVelocity *= 0.8f;
                        this.randomYawVelocity = (float)((double)this.randomYawVelocity + d5);
                    }
                    this.field_70177_z += this.randomYawVelocity * 0.1f;
                    float f9 = (float)(2.0 / (d3 + 1.0));
                    this.func_213309_a(0.06f * (f8 * f9 + (1.0f - f9)), new Vector3d(0.0, 0.0, -1.0));
                    if (this.slowed) {
                        this.func_213315_a(MoverType.SELF, this.func_213322_ci().func_186678_a((double)0.8f));
                    } else {
                        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                    }
                    Vector3d vec3d3 = this.func_213322_ci().func_72432_b();
                    double d6 = 0.8 + 0.15 * (vec3d3.func_72430_b(vec3d2) + 1.0) / 2.0;
                    this.func_213317_d(this.func_213322_ci().func_216372_d(d6, (double)0.91f, d6));
                    if (this.func_184188_bt().isEmpty()) {
                        if (this.getDragonTarget() != null) {
                            double d51;
                            this.targetX = this.getDragonTarget().func_226277_ct_();
                            this.targetZ = this.getDragonTarget().func_226281_cx_();
                            double d31 = this.targetX - this.func_226277_ct_();
                            double d7 = Math.sqrt(d31 * d31 + (d51 = this.targetZ - this.func_226281_cx_()) * d51);
                            double d81 = (double)0.4f + d7 / 80.0 - 1.0;
                            if (d81 > 10.0) {
                                d81 = 10.0;
                            }
                            this.targetY = this.getDragonTarget().func_174813_aQ().field_72338_b + d81;
                        } else {
                            this.targetX += this.field_70146_Z.nextGaussian() * 2.0;
                            this.targetZ += this.field_70146_Z.nextGaussian() * 2.0;
                        }
                    }
                    double d101 = this.targetX - this.func_226277_ct_();
                    double d0 = this.targetY - this.func_226278_cu_();
                    double d1 = this.targetZ - this.func_226281_cx_();
                    double d2 = d101 * d101 + d0 * d0 + d1 * d1;
                    if (this.forceNewTarget || d2 < 100.0 || d2 > 22500.0 || this.field_70123_F || this.field_70124_G) {
                        this.setNewTarget();
                    }
                }
                this.field_70761_aq = this.field_70177_z;
                Vector3d[] avec3d = new Vector3d[this.dragonParts.length];
                for (int j = 0; j < this.dragonParts.length; ++j) {
                    avec3d[j] = new Vector3d(this.dragonParts[j].func_226277_ct_(), this.dragonParts[j].func_226278_cu_(), this.dragonParts[j].func_226281_cx_());
                }
                float f15 = (float)(this.getMovementOffsets(5, 1.0f)[1] - this.getMovementOffsets(10, 1.0f)[1]) * 10.0f * ((float)Math.PI / 180);
                float f16 = MathHelper.func_76134_b((float)f15);
                float f21 = MathHelper.func_76126_a((float)f15);
                float f17 = this.field_70177_z * ((float)Math.PI / 180);
                float f3 = MathHelper.func_76126_a((float)f17);
                float f18 = MathHelper.func_76134_b((float)f17);
                this.dragonPartBody.func_70071_h_();
                this.dragonPartBody.func_70012_b(this.func_226277_ct_() + (double)(f3 * 0.5f), this.func_226278_cu_(), this.func_226281_cx_() - (double)(f18 * 0.5f), 0.0f, 0.0f);
                this.dragonPartRightWing.func_70071_h_();
                this.dragonPartRightWing.func_70012_b(this.func_226277_ct_() + (double)(f18 * 4.5f), this.func_226278_cu_() + 2.0, this.func_226281_cx_() + (double)(f3 * 4.5f), 0.0f, 0.0f);
                this.dragonPartLeftWing.func_70071_h_();
                this.dragonPartLeftWing.func_70012_b(this.func_226277_ct_() - (double)(f18 * 4.5f), this.func_226278_cu_() + 2.0, this.func_226281_cx_() - (double)(f3 * 4.5f), 0.0f, 0.0f);
                if (!this.field_70170_p.field_72995_K && this.field_70737_aN == 0) {
                    this.collideWithEntities(this.field_70170_p.func_175674_a((Entity)this, this.dragonPartRightWing.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0).func_72317_d(0.0, -2.0, 0.0), EntityPredicates.field_188444_d));
                    this.collideWithEntities(this.field_70170_p.func_175674_a((Entity)this, this.dragonPartLeftWing.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0).func_72317_d(0.0, -2.0, 0.0), EntityPredicates.field_188444_d));
                    this.attackEntitiesInList(this.field_70170_p.func_175674_a((Entity)this, this.dragonPartHead.func_174813_aQ().func_186662_g(1.0), EntityPredicates.field_188444_d));
                }
                double[] adouble = this.getMovementOffsets(5, 1.0f);
                float f19 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180) - this.randomYawVelocity * 0.01f));
                float f4 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180) - this.randomYawVelocity * 0.01f));
                this.dragonPartHead.func_70071_h_();
                float f20 = 0.0f;
                this.dragonPartHead.func_70012_b(this.func_226277_ct_() + (double)(f19 * 6.5f * f16), this.func_226278_cu_() + (double)f20 + (double)(f21 * 6.5f), this.func_226281_cx_() - (double)(f4 * 6.5f * f16), 0.0f, 0.0f);
                for (int k = 0; k < 3; ++k) {
                    RedDragonEntityPart RedDragonEntityPart2 = null;
                    if (k == 0) {
                        RedDragonEntityPart2 = this.dragonPartTail1;
                    }
                    if (k == 1) {
                        RedDragonEntityPart2 = this.dragonPartTail2;
                    }
                    if (k == 2) {
                        RedDragonEntityPart2 = this.dragonPartTail3;
                    }
                    double[] adouble1 = this.getMovementOffsets(12 + k * 2, 1.0f);
                    float f6 = MathHelper.func_76126_a((float)f21);
                    float f22 = MathHelper.func_76134_b((float)f21);
                    float f23 = (float)(k + 1) * 2.0f;
                    RedDragonEntityPart2.func_70071_h_();
                    RedDragonEntityPart2.func_70012_b(this.func_226277_ct_() - (double)((f3 * 1.5f + f6 * f23) * f16), this.func_226278_cu_() + (adouble1[1] - adouble[1]) - (double)((f23 + 1.5f) * f21) + 1.5, this.func_226281_cx_() + (double)((f18 * 1.5f + f22 * f23) * f16), 0.0f, 0.0f);
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.slowed = this.destroyBlocksInAABB(this.dragonPartHead.func_174813_aQ()) | this.destroyBlocksInAABB(this.dragonPartBody.func_174813_aQ());
                }
                for (int l = 0; l < this.dragonParts.length; ++l) {
                    this.dragonParts[l].field_70169_q = avec3d[l].field_72450_a;
                    this.dragonParts[l].field_70167_r = avec3d[l].field_72448_b;
                    this.dragonParts[l].field_70166_s = avec3d[l].field_72449_c;
                }
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_184207_aI() && this.func_70909_n()) {
            this.field_70177_z = ((Entity)this.func_184188_bt().get(0)).func_70079_am() - 180.0f;
            boolean jumping = (Boolean)ObfuscationReflectionHelper.getPrivateValue(LivingEntity.class, (Object)((PlayerEntity)this.func_184188_bt().get(0)), (String)"field_70703_bu");
            if (jumping) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.05, 0.0));
            }
            if (((Entity)this.func_184188_bt().get(0)).func_225608_bj_()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.05, 0.0));
            }
            if (this.getDragonTarget() != null) {
                this.setNewTarget();
            }
        } else if (!this.func_184207_aI() && this.func_70909_n() && this.func_70902_q() != null && (double)this.func_70032_d((Entity)this.func_70902_q()) <= 10.0 && this.func_70902_q().func_184614_ca().func_77973_b() == Items.field_151103_aS && !this.field_70170_p.field_72995_K && (!this.func_70902_q().func_233570_aj_() || this.func_70902_q().func_225608_bj_())) {
            if (!this.field_70170_p.field_72995_K) {
                this.mount((PlayerEntity)this.func_70902_q());
            }
            if (this.func_70902_q().func_225608_bj_()) {
                this.func_70902_q().func_226284_e_(false);
            }
            this.func_184185_a(SoundEvents.field_187706_dO, 1.0f, 1.0f);
            ((PlayerEntity)this.func_70902_q()).func_146105_b((ITextComponent)new TranslationTextComponent("Right Click dragon to dismount"), true);
        }
    }

    public double func_70042_X() {
        double offset = this.func_213322_ci().func_82617_b() < 0.0 ? this.func_213322_ci().func_82617_b() - this.func_213322_ci().func_82617_b() * 2.0 : this.func_213322_ci().func_82617_b();
        return Math.min(3.3, 3.0 + offset);
    }

    private void collideWithEntities(List<?> list) {
        double var2 = (this.dragonPartBody.func_174813_aQ().field_72340_a + this.dragonPartBody.func_174813_aQ().field_72336_d) / 2.0;
        double var4 = (this.dragonPartBody.func_174813_aQ().field_72339_c + this.dragonPartBody.func_174813_aQ().field_72334_f) / 2.0;
        for (Entity var7 : list) {
            if (!(var7 instanceof LivingEntity) || var7 == this.func_70902_q()) continue;
            double var8 = var7.func_226277_ct_() - var2;
            double var10 = var7.func_226281_cx_() - var4;
            double var12 = var8 * var8 + var10 * var10;
            var7.func_70024_g(var8 / var12 * 4.0, (double)0.2f, var10 / var12 * 4.0);
        }
    }

    private void attackEntitiesInList(List<?> list) {
        if (this.angry) {
            for (int var2 = 0; var2 < list.size(); ++var2) {
                Entity var3 = (Entity)list.get(var2);
                if (!(var3 instanceof LivingEntity)) continue;
                var3.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 10.0f);
            }
        }
    }

    private void setNewTarget() {
        this.forceNewTarget = false;
        if (this.func_70909_n() && !this.func_184188_bt().isEmpty()) {
            Vector3d vec3d1 = ((Entity)this.func_184188_bt().get(0)).func_70676_i(1.0f);
            this.targetX = vec3d1.field_72450_a;
            this.targetY = this.func_226278_cu_();
            this.targetZ = vec3d1.field_72449_c;
            this.setDragonTarget(null);
        } else if (this.func_70909_n() && this.func_70902_q() != null && this.func_70902_q().field_70170_p.func_234923_W_() == this.field_70170_p.func_234923_W_() && this.getDragonTarget() == null) {
            if (this.func_70902_q().func_184614_ca().func_77973_b() == Items.field_151103_aS && this.func_70902_q().func_225608_bj_()) {
                this.setDragonTarget((Entity)this.func_70902_q());
            } else {
                double d2;
                double d1;
                double d0;
                boolean flag = false;
                do {
                    double baseY = this.func_70902_q().func_226278_cu_() > (double)this.field_70170_p.func_181545_F() ? this.func_70902_q().func_226278_cu_() : (double)this.field_70170_p.func_181545_F();
                    this.targetY = baseY + 20.0 + (double)(this.field_70146_Z.nextFloat() * 50.0f);
                    this.targetX = this.func_70902_q().field_70142_S + (double)(this.field_70146_Z.nextFloat() * 80.0f - 40.0f);
                    this.targetZ = this.func_70902_q().field_70136_U + (double)(this.field_70146_Z.nextFloat() * 80.0f - 40.0f);
                } while (!(flag = (d0 = this.func_226277_ct_() - this.targetX) * d0 + (d1 = this.func_226278_cu_() - this.targetY) * d1 + (d2 = this.func_226281_cx_() - this.targetZ) * d2 > 100.0));
                this.setDragonTarget(null);
            }
        } else if (this.field_70146_Z.nextInt(3) == 0 && !this.field_70170_p.func_217369_A().isEmpty()) {
            this.setDragonTarget((Entity)this.field_70170_p.func_217369_A().get(this.field_70146_Z.nextInt(this.field_70170_p.func_217369_A().size())));
        } else {
            double d2;
            double d1;
            double d0;
            boolean flag = false;
            do {
                this.targetY = 70.0f + this.field_70146_Z.nextFloat() * 50.0f;
                this.targetX += (double)(this.field_70146_Z.nextFloat() * 120.0f - 60.0f);
                this.targetZ += (double)(this.field_70146_Z.nextFloat() * 120.0f - 60.0f);
            } while (!(flag = (d0 = this.func_226277_ct_() - this.targetX) * d0 + (d1 = this.func_226278_cu_() - this.targetY) * d1 + (d2 = this.func_226281_cx_() - this.targetZ) * d2 > 100.0));
            this.setDragonTarget(null);
        }
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184614_ca();
        if (!this.func_70909_n() && itemstack != null && itemstack.func_77973_b() == Items.field_151103_aS && RediscoveredConfig.tameableRedDragon) {
            if (!player.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            if (itemstack.func_190916_E() <= 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(3) == 0) {
                    player.func_146105_b((ITextComponent)new StringTextComponent("The Red Dragon is now docile"), true);
                    this.func_70903_f(true);
                    this.field_70699_by.func_75499_g();
                    this.func_70624_b(null);
                    this.func_184754_b(player.func_110124_au());
                    this.func_70908_e(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.func_70908_e(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return ActionResultType.SUCCESS;
        }
        if (!this.func_184188_bt().isEmpty() && ((Entity)this.func_184188_bt().get(0)).func_184187_bx() == this && this.interactTime <= 0 && player.func_184614_ca() == ItemStack.field_190927_a) {
            this.interactTime = 20;
            player.func_184210_p();
        } else if (this.func_184188_bt().isEmpty() && this.func_70909_n() && this.interactTime <= 0) {
            this.interactTime = 20;
            this.mount(player);
            ((PlayerEntity)this.func_70902_q()).func_146105_b((ITextComponent)new StringTextComponent("Right Click dragon to dismount"), true);
        }
        return super.func_230254_b_(player, hand);
    }

    public boolean mount(PlayerEntity player) {
        player.func_226284_e_(false);
        player.field_70177_z = this.field_70177_z;
        player.field_70125_A = this.field_70125_A;
        if (!this.field_70170_p.field_72995_K) {
            player.func_184220_m((Entity)this);
        }
        player.func_146105_b((ITextComponent)new StringTextComponent("Right Click dragon to dismount"), true);
        return true;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            passenger.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + this.func_70042_X() + passenger.func_70033_W(), this.func_226281_cx_());
        }
    }

    private boolean destroyBlocksInAABB(AxisAlignedBB bounds) {
        boolean flag = false;
        boolean flag1 = false;
        if (flag1) {
            double d1 = bounds.field_72340_a + (bounds.field_72336_d - bounds.field_72340_a) * (double)this.field_70146_Z.nextFloat();
            double d2 = bounds.field_72338_b + (bounds.field_72337_e - bounds.field_72338_b) * (double)this.field_70146_Z.nextFloat();
            double d0 = bounds.field_72339_c + (bounds.field_72334_f - bounds.field_72339_c) * (double)this.field_70146_Z.nextFloat();
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, d1, d2, d0, 0.0, 0.0, 0.0);
        }
        return flag;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.func_184188_bt().isEmpty() && this.func_184188_bt().contains(source.func_76346_g())) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_70609_aI() {
        ++this.deathTicks;
        if (this.deathTicks >= 180 && this.deathTicks <= 200) {
            float var1 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            float var2 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            float var3 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.func_226277_ct_() + (double)var1, this.func_226278_cu_() + 2.0 + (double)var2, this.func_226281_cx_() + (double)var3, 0.0, 0.0, 0.0);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.deathTicks > 150 && this.deathTicks % 5 == 0) {
                int var4;
                int n = var4 = !this.func_70909_n() ? 100 : 0;
                while (var4 > 0) {
                    int var5 = ExperienceOrbEntity.func_70527_a((int)var4);
                    var4 -= var5;
                    this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), var5));
                }
            }
            if (this.deathTicks == 1) {
                this.func_184185_a(SoundEvents.field_187522_aL, this.func_70599_aP(), 1.0f);
            }
        }
        this.func_213315_a(MoverType.SELF, new Vector3d(0.0, (double)0.1f, 0.0));
        this.field_70761_aq = this.field_70177_z += 20.0f;
        if (this.deathTicks == 200 && !this.field_70170_p.field_72995_K) {
            int var4;
            int n = var4 = !this.func_70909_n() ? 100 : 0;
            while (var4 > 0) {
                int var5 = ExperienceOrbEntity.func_70527_a((int)var4);
                var4 -= var5;
                this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), var5));
            }
            if (!this.func_70909_n()) {
                this.placeDeathStructure(new BlockPos(this.func_226277_ct_(), 64.0, this.func_226281_cx_()));
            }
            this.func_70106_y();
        }
        if (!this.func_184188_bt().isEmpty()) {
            ((Entity)this.func_184188_bt().get(0)).func_184210_p();
        }
    }

    private void placeDeathStructure(BlockPos pos) {
        for (int i = -1; i <= 32; ++i) {
            for (int j = -4; j <= 4; ++j) {
                for (int k = -4; k <= 4; ++k) {
                    double d2 = j * j + k * k;
                    if (!(d2 <= 12.25)) continue;
                    BlockPos blockpos1 = pos.func_177982_a(j, i, k);
                    if (i < 0) {
                        if (!(d2 <= 6.25)) continue;
                        this.field_70170_p.func_175656_a(blockpos1, RediscoveredBlocks.ancient_crying_obsidian.func_176223_P());
                        continue;
                    }
                    if (i > 0) {
                        this.field_70170_p.func_175656_a(blockpos1, Blocks.field_150350_a.func_176223_P());
                        continue;
                    }
                    if (d2 > 6.25) {
                        this.field_70170_p.func_175656_a(blockpos1, RediscoveredBlocks.ancient_crying_obsidian.func_176223_P());
                        continue;
                    }
                    this.field_70170_p.func_175656_a(blockpos1, Blocks.field_150480_ab.func_176223_P());
                }
            }
        }
        this.field_70170_p.func_175656_a(pos, RediscoveredBlocks.ancient_crying_obsidian.func_176223_P());
        this.field_70170_p.func_175656_a(pos.func_177984_a(), RediscoveredBlocks.ancient_crying_obsidian.func_176223_P());
        BlockPos blockpos2 = pos.func_177981_b(2);
        this.field_70170_p.func_175656_a(blockpos2, RediscoveredBlocks.ancient_crying_obsidian.func_176223_P());
        this.field_70170_p.func_175656_a(blockpos2.func_177976_e(), (BlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.WEST));
        this.field_70170_p.func_175656_a(blockpos2.func_177974_f(), (BlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.EAST));
        this.field_70170_p.func_175656_a(blockpos2.func_177978_c(), (BlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.NORTH));
        this.field_70170_p.func_175656_a(blockpos2.func_177968_d(), (BlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.SOUTH));
        this.field_70170_p.func_175656_a(pos.func_177981_b(3), RediscoveredBlocks.ancient_crying_obsidian.func_176223_P());
        this.field_70170_p.func_175656_a(pos.func_177981_b(4), RediscoveredBlocks.red_dragon_egg.func_176223_P());
    }

    protected boolean canDespawn() {
        return !this.func_70909_n();
    }

    public Entity[] getParts() {
        return this.dragonParts;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean getCanSpawnHere() {
        return true;
    }

    public float func_180484_a(BlockPos pos) {
        return (float)this.field_70170_p.func_201696_r(pos) - 0.5f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getDragonHealth() {
        return this.func_110143_aJ();
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187521_aK;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187526_aP;
    }

    protected float func_70599_aP() {
        return 5.0f;
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity ageable) {
        return null;
    }

    public Entity getDragonTarget() {
        return this.target;
    }

    public void setDragonTarget(Entity target) {
        this.target = target;
    }

    public void func_174812_G() {
        this.func_70106_y();
    }
}

