/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.registry;

import com.legacy.rediscovered.RediscoveredConfig;
import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.registry.RediscoveredBlocks;
import com.legacy.rediscovered.registry.RediscoveredDimensions;
import com.legacy.rediscovered.registry.RediscoveredEntityTypes;
import com.legacy.rediscovered.registry.RediscoveredFeatures;
import com.legacy.rediscovered.registry.RediscoveredRegistry;
import com.legacy.rediscovered.registry.RediscoveredStructures;
import com.legacy.rediscovered.world.biome.feature.structure.SmallPigmanVillageConfig;
import com.legacy.rediscovered.world.dimension.BetaSkyChunkGenerator;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;
import net.minecraft.world.gen.feature.AbstractFeatureSizeType;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.TwoLayerFeature;
import net.minecraft.world.gen.foliageplacer.BlobFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilders;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.StraightTrunkPlacer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;

public class RediscoveredBiomes {
    public static final Biome SKYLANDS = Builders.createSkylandsBiome();
    public static final RegistryKey<Biome> SKYLANDS_KEY = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)RediscoveredMod.locate("skylands"));

    public static void init(RegistryEvent.Register<Biome> event) {
        RediscoveredBiomes.register((IForgeRegistry<Biome>)event.getRegistry(), "skylands", SKYLANDS);
        RediscoveredDimensions.initNoiseSettings();
        Registry.func_218325_a((Registry)Registry.field_239690_aB_, (String)"beta_skylands", BetaSkyChunkGenerator.providerCodec);
    }

    public static void register(IForgeRegistry<Biome> registry, String key, Biome biome) {
        RediscoveredRegistry.register(registry, key, biome);
    }

    public static class Builders {
        public static final BlockClusterFeatureConfig CLASSIC_FLOWER_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(RediscoveredBlocks.rose.func_176223_P(), 2).func_227407_a_(Blocks.field_196605_bc.func_176223_P(), 1), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
        public static final BaseTreeFeatureConfig CHERRY_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(RediscoveredBlocks.cherry_log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(RediscoveredBlocks.cherry_leaves.func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0), 3), (AbstractTrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_();

        public static Biome createSkylandsBiome() {
            MobSpawnInfo.Builder spawns = new MobSpawnInfo.Builder();
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200795_i, 150, 2, 4));
            if (RediscoveredConfig.cowsAndPigsInSky) {
                spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200796_j, 110, 2, 4));
                spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200784_X, 130, 2, 4));
            }
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(RediscoveredEntityTypes.VANILLA_SPAWNER, 1, 1, 1));
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(RediscoveredEntityTypes.RED_DRAGON, 15, 1, 1));
            spawns.func_242575_a(EntityClassification.WATER_CREATURE, new MobSpawnInfo.Spawners(RediscoveredEntityTypes.FISH, 1, 2, 2));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.field_244178_j);
            builder.func_242516_a(RediscoveredStructures.SMALL_PIGMAN_VILLAGE.func_236391_a_((IFeatureConfig)new SmallPigmanVillageConfig(0.1)));
            builder.func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, RediscoveredFeatures.SKY_SPAWN.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_236291_c_.func_225566_b_((IFeatureConfig)CHERRY_TREE_CONFIG).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.7f, 1))));
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)Features.Configs.field_243977_a).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(5));
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)Feature.field_227247_y_.func_225566_b_((IFeatureConfig)CLASSIC_FLOWER_CONFIG).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(3));
            builder.func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, RediscoveredFeatures.SKY_SNOW.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
            DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)builder);
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Features.field_243892_bl);
            DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)builder);
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, RediscoveredFeatures.RUBY_ORE);
            return new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.NONE).func_205421_a(0.1f).func_205420_b(0.2f).func_205414_c(0.5f).func_205417_d(0.4f).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(4159204).func_235248_c_(329011).func_235239_a_(12502254).func_242539_d(Builders.ambienceChance(0.5f)).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_242539_d(12502254).func_235238_a_()).func_242458_a(spawns.func_242577_b()).func_242457_a(builder.func_242508_a()).func_242455_a();
        }

        private static int ambienceChance(float p_244206_0_) {
            float lvt_1_1_ = p_244206_0_ / 3.0f;
            lvt_1_1_ = MathHelper.func_76131_a((float)lvt_1_1_, (float)-1.0f, (float)1.0f);
            return MathHelper.func_181758_c((float)(0.62222224f - lvt_1_1_ * 0.05f), (float)(0.5f + lvt_1_1_ * 0.1f), (float)1.0f);
        }
    }
}

