/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.world;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.legacy.rediscovered.registry.RediscoveredItems;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnvilRecipeManager
extends JsonReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogManager.getLogger();
    private Map<Item, AnvilRecipe> chestplateMap = ImmutableMap.of();

    public AnvilRecipeManager() {
        super(GSON, "quiver_recipes");
    }

    protected void apply(Map<ResourceLocation, JsonElement> splashList, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry<ResourceLocation, JsonElement> entry : splashList.entrySet()) {
            ResourceLocation resourcelocation = entry.getKey();
            try {
                Pair<Item, AnvilRecipe> recipe = this.parseJson(entry.getValue());
                map.put(recipe.getFirst(), recipe.getSecond());
            }
            catch (Exception e) {
                LOGGER.error("Parsing error loading quiver recipe {}", (Object)resourcelocation, (Object)e);
            }
        }
        this.chestplateMap = (Map)map.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        LOGGER.info("Loaded {} quiver recipes", (Object)map.size());
    }

    public Pair<Item, AnvilRecipe> parseJson(JsonElement json) {
        String chestS = JSONUtils.func_151219_a((JsonObject)json.getAsJsonObject(), (String)"chestplate", (String)Items.field_151030_Z.getRegistryName().toString());
        String quiverChestS = JSONUtils.func_151219_a((JsonObject)json.getAsJsonObject(), (String)"quiver", (String)RediscoveredItems.iron_quiver.getRegistryName().toString());
        if (ForgeRegistries.ITEMS.containsKey(new ResourceLocation(chestS)) && ForgeRegistries.ITEMS.containsKey(new ResourceLocation(quiverChestS))) {
            Item chestplate = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(chestS));
            Item quiverChest = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(quiverChestS));
            int cost = JSONUtils.func_151208_a((JsonObject)json.getAsJsonObject(), (String)"cost", (int)5);
            return Pair.of((Object)chestplate, (Object)new AnvilRecipe(quiverChest, cost));
        }
        throw new IllegalArgumentException();
    }

    public Map<Item, AnvilRecipe> getRecipes() {
        return this.chestplateMap;
    }

    public static class AnvilRecipe {
        public final Item outputItem;
        public final int cost;

        public AnvilRecipe(Item outputItem, int cost) {
            this.outputItem = outputItem;
            this.cost = cost;
        }
    }
}

