/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.world;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;

public class GenUtil {
    public static boolean doesBiomeMatch(Biome biomeIn, RegistryKey<Biome> wantedBiomeIn) {
        return biomeIn.toString().matches(wantedBiomeIn.func_240901_a_().toString());
    }

    public static <C extends IFeatureConfig, PC extends IPlacementConfig> void addFeature(Biome biome, GenerationStage.Decoration stage, ConfiguredFeature<?, ?> feature) {
        if (GenUtil.getGenSettings((Biome)biome).field_242484_f instanceof ImmutableList) {
            GenUtil.getGenSettings((Biome)biome).field_242484_f = GenUtil.makeListMutable(GenUtil.getGenSettings((Biome)biome).field_242484_f, GenUtil::makeListMutable);
        }
        while (GenUtil.getGenSettings((Biome)biome).field_242484_f.size() <= stage.ordinal()) {
            GenUtil.getGenSettings((Biome)biome).field_242484_f.add(Lists.newArrayList());
        }
        ((List)GenUtil.getGenSettings((Biome)biome).field_242484_f.get(stage.ordinal())).add(() -> feature);
    }

    public static BiomeGenerationSettings getGenSettings(Biome biome) {
        return biome.func_242440_e();
    }

    public static <T> List<T> makeListMutable(List<T> list) {
        return list.stream().collect(Collectors.toList());
    }

    public static <T> List<T> makeListMutable(List<T> list, Function<T, T> listFunction) {
        return list.stream().map(listFunction).collect(Collectors.toList());
    }
}

