/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.world.biome.feature.structure;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.world.biome.feature.structure.SmallPigmanVillageConfig;
import com.legacy.rediscovered.world.biome.feature.structure.SmallPigmanVillagePieces;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.StructureSeparationSettings;

public class SmallPigmanVillageStructure
extends Structure<SmallPigmanVillageConfig> {
    private static int offset = 5;
    private static int spacing = 13;
    private static int seed = 2039123892;

    public SmallPigmanVillageStructure(Codec<SmallPigmanVillageConfig> config) {
        super(config);
    }

    public ChunkPos func_236392_a_(StructureSeparationSettings settings, long seed, SharedSeedRandom sharedSeedRand, int x, int z) {
        int spacing = SmallPigmanVillageStructure.spacing;
        int gridX = x / spacing * spacing;
        int gridZ = z / spacing * spacing;
        int offset = SmallPigmanVillageStructure.offset + 1;
        sharedSeedRand.func_202427_a(seed, gridX, gridZ, SmallPigmanVillageStructure.seed);
        int offsetX = sharedSeedRand.nextInt(offset);
        int offsetZ = sharedSeedRand.nextInt(offset);
        int gridOffsetX = gridX + offsetX;
        int gridOffsetZ = gridZ + offsetZ;
        return new ChunkPos(gridOffsetX, gridOffsetZ);
    }

    protected boolean func_230363_a_(ChunkGenerator generatorIn, BiomeProvider biomeProvider, long seed, SharedSeedRandom sharedSeedRand, int chunkPosX, int chunkPosZ, Biome biomeIn, ChunkPos chunkPos, SmallPigmanVillageConfig config) {
        sharedSeedRand.func_202427_a(seed, chunkPosX, chunkPosZ, SmallPigmanVillageStructure.seed);
        if (chunkPosX == chunkPos.field_77276_a && chunkPosZ == chunkPos.field_77275_b) {
            int y = SmallPigmanVillageStructure.getYValue(generatorIn, chunkPos.field_77276_a, chunkPos.field_77275_b);
            return sharedSeedRand.nextDouble() < 0.5 && y >= 50;
        }
        return false;
    }

    public Structure.IStartFactory<SmallPigmanVillageConfig> func_214557_a() {
        return Start::new;
    }

    public static StructureSeparationSettings getSeparationSettings() {
        return new StructureSeparationSettings(spacing, offset, seed);
    }

    public String func_143025_a() {
        return RediscoveredMod.locate("small_pigman_village").toString();
    }

    public static int getYValue(ChunkGenerator chunkGen, int chunkX, int chunkZ) {
        Random random = new Random();
        return 100 + random.nextInt(50);
    }

    public static class Start
    extends StructureStart<SmallPigmanVillageConfig> {
        public Start(Structure<SmallPigmanVillageConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox boundsIn, int referenceIn, long seed) {
            super(structureIn, chunkX, chunkZ, boundsIn, referenceIn, seed);
        }

        public void func_230364_a_(DynamicRegistries registry, ChunkGenerator chunkGen, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn, SmallPigmanVillageConfig config) {
            Rotation rotation = Rotation.NONE;
            int i = SmallPigmanVillageStructure.getYValue(chunkGen, chunkX, chunkZ);
            BlockPos blockpos = new BlockPos(chunkX * 16 + 8, i, chunkZ * 16 + 8);
            SmallPigmanVillagePieces.init(templateManagerIn, blockpos, rotation, this.field_75075_a, (Random)this.field_214631_d);
            this.func_202500_a();
        }
    }
}

